///////////////////////////////////////////////////////////
//  VolumeStatusData.cpp
//  Implementation of the Class VolumeStatusData
//  Created on:      10-Nov-2012 09:15:09
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#include "VolumeStatusData.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_VOLUME
#include "trcGenProj/Header/VolumeStatusData.cpp.trc.h"
#endif

tVoid VolumeStatusData::copyData(const VolumeStatusData& DataToBeCopied)
{
   m_Resource = DataToBeCopied.m_Resource;
   m_Channel = DataToBeCopied.m_Channel;
   m_Volume = DataToBeCopied.m_Volume;
   m_VolumeMode = DataToBeCopied.m_VolumeMode;
   m_Source = DataToBeCopied.m_Source;
}

tVoid VolumeStatusData::vSetToDefault()
{
   m_Resource = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_NOT_DEF;
   m_Channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_NOT_DEF;
   m_Volume = 0;
   m_VolumeMode = midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_NOT_DEF;
   m_Source = midw_fi_tcl_e8_AudSource::FI_EN_NONE;
}

VolumeStatusData::VolumeStatusData()
{
   vSetToDefault();
}

VolumeStatusData::VolumeStatusData(const VolumeStatusData& DataToBeCopied)
{
   copyData(DataToBeCopied);
}

tVoid VolumeStatusData::printData() const
{
      ETG_TRACE_USR4(("VolumeStatusData: Data: Resource: %d, Channel: %d, VolumeMode: %d, Source: %d, Volume: %d\n",
                  ETG_CENUM(midw_fi_tcl_e8_ResourceNo::tenType, m_Resource),
                  ETG_CENUM(midw_fi_tcl_e8_AudioChannel::tenType, m_Channel),
                  ETG_CENUM(midw_fi_tcl_e8_VolumeMode::tenType, m_VolumeMode),
                  ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType, m_Source),
                  m_Volume
            ));
}

VolumeStatusData& VolumeStatusData::operator=(const VolumeStatusData& rhs)
{
   // protection again copy on itself
   if( &rhs == this)
   {
      ETG_TRACE_USR4(("VolumeStatusData: self compare!"));
      NORMAL_M_ASSERT_ALWAYS();
   }

   copyData(rhs);
   return (*this);
}


