///////////////////////////////////////////////////////////
//  VolumeModeStatusData.cpp
//  Implementation of the Class VolumeModeStatusData
//  Created on:      10-Nov-2012 15:01:15
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#include "VolumeModeStatusData.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_VOLUME
#include "trcGenProj/Header/VolumeModeStatusData.cpp.trc.h"
#endif

tVoid VolumeModeStatusData::vSetToDefault()
{
   m_Resource = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_NOT_DEF;
   m_Channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_NOT_DEF;
   m_VolumeMode = midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_NOT_DEF;
}

VolumeModeStatusData::VolumeModeStatusData()
{
   vSetToDefault();
}

VolumeModeStatusData::VolumeModeStatusData(const VolumeModeStatusData& DataToBeCopied)
{
   copyData(DataToBeCopied);
}

tVoid VolumeModeStatusData::setData(VolumeModeStatusData DataToBeCopied)
{
   m_Resource = DataToBeCopied.m_Resource;
   m_Channel = DataToBeCopied.m_Channel;
   m_VolumeMode = DataToBeCopied.m_VolumeMode;
}

tVoid VolumeModeStatusData::printData() const
{
      ETG_TRACE_USR4(("VolumeModeStatusData: Data: Resource: %d, Channel: %d, VolumeMode: %d\n",
                  ETG_CENUM(midw_fi_tcl_e8_ResourceNo::tenType, m_Resource),
                  ETG_CENUM(midw_fi_tcl_e8_AudioChannel::tenType, m_Channel),
                  ETG_CENUM(midw_fi_tcl_e8_VolumeMode::tenType, m_VolumeMode)
            ));
}

VolumeModeStatusData& VolumeModeStatusData::operator=(const VolumeModeStatusData& rhs)
{
   // protection again copy on itself
   if( &rhs == this)
   {
      ETG_TRACE_USR4(("VolumeModeStatusData: self compare!"));
      NORMAL_M_ASSERT_ALWAYS();
   }

   copyData(rhs);
   return *this;
}

tVoid VolumeModeStatusData::copyData(const VolumeModeStatusData& data)
{
   m_Resource = data.m_Resource;
   m_Channel = data.m_Channel;
   m_VolumeMode = data.m_VolumeMode;
}
