/**
 * Volume.cpp
 *
 *  Created on: Jul 21, 2012
 *      Author: mor2hi
 */

#include "VolumeData.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_VOLUME
#include "trcGenProj/Header/VolumeData.cpp.trc.h"
#endif

VolumeData::VolumeData()
{
  VolumeData::vSetToDefault();
}

VolumeData::VolumeData(const VolumeData& DataToBeCopied)
{
   copyData(DataToBeCopied);
}

VolumeData::~VolumeData()
{
   // TODO Auto-generated destructor stub
}

VolumeData& VolumeData::operator=(const VolumeData& rhs)
{
   // protection again copy on itself
   if( &rhs == this)
   {
      ETG_TRACE_USR4(("VolumeData: self compare!"));
      NORMAL_M_ASSERT_ALWAYS();
   }


   copyData(rhs);
   return (*this);
}

tVoid VolumeData::vSetToDefault()
{
   m_Resource.vSetToDefault();
//   m_Volume.vSetToDefault();
   m_VolumeType.vSetToDefault();
   m_VolumeGroup = EN_VOLTYPE_NONE;
   m_Channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_NOT_DEF;
   m_VolumeGain = 0;
   m_Volume = 0;
}

tU8 VolumeData::getVolume()const
{
   return (m_Volume);
}

midw_fi_tcl_e8_AudioVolumeType::tenType VolumeData::getVolumeType()const
{
   return (m_VolumeType.getVolumeType());
}

midw_fi_tcl_e8_ResourceNo::tenType VolumeData::getResource()const
{
   return (m_Resource.getResource());
}

tS16 VolumeData::getVolumeGain()const
{
   return (m_VolumeGain);
}

tVoid VolumeData::setVolume(tU8 Volume)
{
   m_Volume = Volume;
}

tVoid VolumeData::setVolumeType(midw_fi_tcl_e8_AudioVolumeType::tenType volumetype)
{
   m_VolumeType.setVolumeType(volumetype);
}

tVoid VolumeData::setResource(midw_fi_tcl_e8_ResourceNo::tenType Resource)
{
   m_Resource.setResource(Resource);
}

tVoid VolumeData::setVolumeGain(tS16 Gain)
{
   m_VolumeGain = Gain;
}

tVoid VolumeData::printData() const
{
   ETG_TRACE_USR4(("VolumeData: Data: Resource: %d, Channel: %d, VolumeType: %d, Steps: %d, VolumeGain: %d, VolumeGroup : %d\n",
               ETG_CENUM(midw_fi_tcl_e8_ResourceNo::tenType, m_Resource.getResource()),
               ETG_CENUM(midw_fi_tcl_e8_AudioChannel::tenType, m_Channel),
               ETG_CENUM(midw_fi_tcl_e8_AudioVolumeType::tenType, m_VolumeType.getVolumeType()),
               m_Volume,
               m_VolumeGain,
               m_VolumeGroup
         ));
}

tVoid VolumeData::copyData(const VolumeData& data)
{
   setResource(data.m_Resource.getResource());
   setVolume(data.m_Volume);
   setVolumeType(data.m_VolumeType.getVolumeType());
   setVolumeGain(data.m_VolumeGain);
   m_Channel = data.m_Channel;
   m_VolumeGroup = data.m_VolumeGroup;
}

