/************************************************************************FA*
 *File          :  Fading.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  9/17/2012    Anu Sebastian       Initial version
 Modified by : 10/12/2013   Ravindra Kumar Rajendran
 ************************************************************************/

#if !defined(FADING_H_)
#define FADING_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "Fading_IF.h"
#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../InternalComponentCommunication/Messages/Source/IDSetSource.h"
#include "../InternalComponentCommunication/Messages/Fading/IDCCAStartSetMuteRamp.h"
#include "../InternalComponentCommunication/Messages/mute/IDCCAStartMute.h"
#include "../InternalComponentCommunication/Messages/mute/IDSetMute.h"
#include "../InternalComponentCommunication/Messages/mute/IDNotifyMute.h"

#include "../InternalComponentCommunication/DataTypes/TypeDefines/Fading_Actions.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/Fading_RampType.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/Fading_Reason.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/Fading_States.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/ADR3SourceType.h"

#include "midw_fi_if.h"
#include "../ExternItf/CCA/FI_Message/FI_Includes.h"

#include "../fc_audiomanager_main.h"
#include "Macro.h"


#define AUD_STREAM_COUNT 8
#define AUD_VOLRAMP_IN_DIAG_MODE 0
#define AUD_MUTERAMP_IN_DIAG_MODE 0

/*******************************************************************************
 *
 * CLASS: RampTypeValue
 *
 *******************************************************************************/
class RampTypeValues
{
public:
  RampTypeValues(tU8 rampType, tU16 lin, tU16 DB, tU8 ramptype_fi, tU8 internRamp):RampType(rampType), Lin(lin), dB(DB),Ramptype_Fi(ramptype_fi), InternRampType(internRamp)
  {

  }
  tU8 RampType;
  tU16 Lin;
  tU16 dB;
  tU8 Ramptype_Fi;
    tU8 InternRampType;
  RampTypeValues()
  {
    RampType = 0;
    Lin = 0;
    dB = 0;
    Ramptype_Fi = 0;
    InternRampType = 0;
  }
};

/*******************************************************************************
 *
 * CLASS: Fading
 *
 *******************************************************************************/
class Fading: public Fading_IF , public IF_MessageObserver<PO_MessageConfig::enID>
{
protected:

  vector<RampTypeValues*> RampTypeValueList;
    map<tenRampType, tenInternalRampType> RampTypeMap;
  tU16 enSourceType;
  tU16 m_u16PrevSource;
  tU16 m_u16CurAudioSource;
  tenActions enAction;
  tenMuteAction  enState;
  tU32 enReason;
  tenStream enStream;
  tU16 m_u16Sink; //daw2hi addded
  tenActions enprevaction;
  tenFadingReason enprevreason;
  tenStream enprevstream;
    tU8 aud_ubMuteSpeed[AUD_STREAM_COUNT];
    tU8 aud_ubFadingActive[AUD_STREAM_COUNT];
    tU8 aud_fading_aubMuteActive[AUD_STREAM_COUNT];
    tU8 aud_fading_ubVolumeModeSlow;
  tU8 aud_fading_ubVolumeActive;
  tU8 aud_fading_ubSoftOnActive;
  tU8 m_u8RampType;
  tU32 m_u8RampRunningConter;  //gen4 [-wcoversion] compiler warning fix
  tBool m_bConfigEntryFoundFlag;
  tU16 m_u16Rampdb;
  tU16 m_u16RampLin;
    tF32 m_f32RampLindbRatio;
  tU8 m_u8ActiveRampType;

public:
  Fading();
    virtual ~Fading()
    {
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
    }
  static Fading* getInstance()
  {
    static Fading fd;
    return &fd;
  }

  void Fading_addobserver(void);
    virtual tU16 fading_getRampLin(tenActions enactionln,tenFadingReason enreasonln,tenStream enstreamln);
    virtual tU16 fading_getRampdB(tenActions enactiondb,tenFadingReason enreasondb,tenStream enstreamdb);
    virtual tU16 getSink();
    virtual void MessageNotification(PO_MessageConfig::enID MsgId);
  tBool bSourceSwitchFlag;
  private :
  tBool bFirstDemute;

protected:
  tU8 Fading_GetRampType(tenActions enaction,tenFadingReason enreason,tenStream enstream);
    tBool bIsAnyRampActive() const;
    tVoid u8UpdateLowerRampLinDbValue(tU16 *ramplin,tU16 *rampdb) const;
    tU8 u8ReturnLowerRampType(tU8 ramptype);
    tVoid vCheckConfigForEntry(tU16 lin,tU16 db);
    tU16 u16ReturnRampDbBasedonRampType(tU8 ramptype);
    tU16 u16ReturnRampLinBasedonRampType(tU8 ramptype);
    tVoid vUpdateRampType(tU8 ramptype);
    tVoid vUpdateLinDbValues(tU16 lin, tU16 db);
    tVoid vSetActionBasedonMuteState(tenMuteAction state);
    tVoid vPOMessageNotificationHandler(PO_MessageConfig::enID MsgId);
    tVoid vUpdateParametersBasedonAction(tenActions Action);
    tU8 u8ReturnRampTypeBasedonSrcType(tU16 srctype,tU32 reason,tenActions action);
    tU8 u8ReturnRampTypeBasedonStream(tenStream stream, tU8 ramptype) const;
    tU8 u8CheckRampActiveandReturnLowestRamp(tU8 ramptype);
    tU8 u8SetRampTypeBasedonVolParam(tU8 ramptype);
    tU8 u8SetRampTypeBasedonMuteReason(tU8 ramptype, tU32 reason,tenStream stream);
    tVoid vResetFadingvariablesOnDemuteNotification(tenStream stream, tenMuteResult result);
    tVoid vSetConfigEntryFlag();
    tVoid vClearConfigEntryFlag();
    tU8 u8CCAtoInternalRamptypeConverter(tU8 ramptype);
    tU8 u8InternaltoCCARamptypeConverter(tU8 ramptype);
    tU8 u8GetKey(tU8 value);
    tU8 u8GetValue(tU8 key);
  tU8 u8GetActiveRamp();
  bool u8HandlePrevRampRequest(tenActions enaction,tenFadingReason enreason,tenStream enstream);
    tU8 u8HandleRampBasedOnPrevSource(tU8 Ramp)const;
    tBool bIsSPISource(tU16 m_u16CurAudioSource)const;

};

#endif
