/************************************************************************FA*
 *File         :  Fading.cpp
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  9/17/2012     Anu Sebastian       Initial version
 Modified by : 10/12/2013   Ravindra Kumar Rajendran
 ************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../fc_audiomanager_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_FC_AUDIOMANAGER_FADING
#include "trcGenProj/Header/Fading.cpp.trc.h"
#endif

#include "../../PostOffice/PostOffice.hpp"
#include "../util/Macro.h"
#include "Fading.h"
#include "../fc_audiomanager_main.h"


/*******************************************************************************
 *
 * FUNCTION: Fading::Fading()
 *
 * DESCRIPTION: Constructor
 *
 * PARAMETER:None
 *
 * RETURN TYPE : None
 *
 *******************************************************************************/
Fading::Fading():IF_MessageObserver<PO_MessageConfig::enID>("Fading Observer to the requesters")
{
  ETG_TRACE_USR4(("Fading Observer constructor"));

    memset(aud_ubMuteSpeed , 0, sizeof(aud_ubMuteSpeed)) ;
  memset(aud_ubFadingActive, EN_AUDIO_FADING_NOFADING, sizeof(aud_ubFadingActive)) ;
    memset(aud_fading_aubMuteActive, 1, sizeof(aud_fading_aubMuteActive));

    aud_fading_ubVolumeModeSlow = 0;
  aud_fading_ubVolumeActive = 0;
  aud_fading_ubSoftOnActive = 0;
  m_u8RampType = EN_AUDIO_FADING_NOFADING;
  m_u8RampRunningConter = 0;
  m_bConfigEntryFoundFlag = FALSE;;
  m_f32RampLindbRatio = 0.0;
  m_u16Rampdb = RAMPTYPE_DEFAULT_DB;
  m_u16RampLin = RAMPTYPE_DEFAULT_LIN;
  m_u16Sink = 1;
    enSourceType =0;
    enAction = EN_AUDIO_FADING_ACTION_DEMUTE;
    enState = EN_AUDIO_MUTE_MUTEACTION_Off;
  enReason = 0x00;
    enStream = EN_AUDIO_SOURCE_STREAM_MAIN;
    m_u16PrevSource = 0;
    m_u16CurAudioSource = 0;
    Fading_addobserver();
    bSourceSwitchFlag = false ;
    bFirstDemute = false;
  m_u8ActiveRampType = EN_AUDIO_FADING_NOFADING;
  enStream= EN_AUDIO_SOURCE_STREAM_DEFAULT; //coverity warning fix
  enprevaction = EN_AUDIO_FADING_ACTION_NONE;
  enprevreason = EN_AUDIO_FADING_RES_NONE;
  enprevstream = EN_AUDIO_SOURCE_STREAM_DEFAULT;

    #define FADINGRAMPTYPE
    #define RampTypeValue(a,b,c,d,e) RampTypeValueList.push_back(new RampTypeValues(a,b,c,d,e));
      #include "FadingRampType.conf"
    #undef RampTypeValue
  #undef FADINGRAMPTYPE

#define FADINGRAMPTYPE
  #define RampTypeValue(a,b,c,d,e) RampTypeMap.insert(pair<tenRampType, tenInternalRampType>(a,e));
    #include "FadingRampType.conf"
  #undef RampTypeValue
#undef FADINGRAMPTYPE
}

/*******************************************************************************
 *
 * FUNCTION: Fading::Fading_addobserver(void)
 *
 * DESCRIPTION: This function adds Fading as an observer to ID_CCAStart_Mute,ID_SetSource,ID_CCAStart_SetMuteRamp
 *
 * PARAMETER:None
 *
 * RETURN TYPE : None
 *
 *******************************************************************************/
void Fading::Fading_addobserver(void)
{
  ETG_TRACE_USR4(("Fading: addObserver"));

    InternalCommunicationAdapter* pPO;
    pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);

    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAStart_Mute);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetSource);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAStart_SetMuteRamp);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyMute);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetMute);
}

tU8 Fading::u8GetActiveRamp()
{
  return m_u8ActiveRampType;
}

bool Fading::u8HandlePrevRampRequest(tenActions enaction,tenFadingReason enreason,tenStream enstream)
{
  if(enaction == enprevaction && enreason == enprevreason && enstream == enprevstream)
    return false;
  else
    return true;
}

/*******************************************************************************
 *
 * FUNCTION: Fading::Fading_GetRampType(tenActions enAction,tenFadingReason enReason,tenStream enStream)
 *
 * DESCRIPTION: This function decides ramp type ramptype
 *
 * PARAMETER:enAction,enReason,enStream
 *
 * RETURN TYPE : tU8
 *
 *******************************************************************************/
tU8 Fading::Fading_GetRampType(tenActions enaction,tenFadingReason enreason,tenStream enstream)
{
  ETG_TRACE_USR4(("Fading_GetRampType function entered act=%d,reas=%d,stream=%d",
      (tU16)enaction,(tU16)enreason,(tU16)enstream));

  tU8 RampType = EN_AUDIO_FADING_NOFADING;
  if(u8HandlePrevRampRequest(enaction,enreason,enstream))
  {
  switch(enaction)
  {

  case EN_AUDIO_FADING_ACTION_MUTE:
  {
        RampType = u8SetRampTypeBasedonMuteReason(RampType, enreason, enstream);
    break;
  }

  case EN_AUDIO_FADING_ACTION_SEND_VOL:
  {
        if(bIsSPISource(m_u16CurAudioSource))
             return EN_AUDIO_FADING_VERY_FAST_MUTE;
        else
             return u8ReturnRampTypeBasedonSrcType(enSourceType, enreason, enaction);
  }

  default:
  {
        RampType = u8ReturnRampTypeBasedonSrcType(enSourceType, enreason, enaction);
    break;
    }
  }

    if( bIsSPISource(m_u16CurAudioSource) )
    {
      ETG_TRACE_USR4(("Fading_GetRampType no additional changes for SPI sources"));
    }
    else
    {
    RampType = u8ReturnRampTypeBasedonStream(enstream,RampType);
//  RampType = u8CheckRampActiveandReturnLowestRamp(RampType);
    }
  aud_ubFadingActive[enstream]=RampType;

  ETG_TRACE_USR4(("RampType set to %x", RampType));
  m_u8ActiveRampType = RampType;
  enprevaction = enaction ;
  enprevreason = enreason ;
  enprevstream = enstream;
  }
  else
    m_u8ActiveRampType = u8GetActiveRamp();
  return m_u8ActiveRampType;
}

/*******************************************************************************
 *
 * FUNCTION: Fading::MessageNotification(PO_MessageConfig::enID MsgId)
 *
 * DESCRIPTION: This function is called when any of the post office messages addressed to fading is posted
 *
 * PARAMETER:PO_MessageConfig::enID MsgId
 *
 * RETURN TYPE : void
 *
 *******************************************************************************/
 void Fading::MessageNotification(PO_MessageConfig::enID MsgId)
{
   vPOMessageNotificationHandler(MsgId);
   vSetActionBasedonMuteState(enState);
}

/*****************************************************************************************
 *
 * FUNCTION:  Fading::fading_getRampLin(tenActions enAction,tenFadingReason enReason,
 *                                      tenStream enStream)
 *
 * DESCRIPTION: This function calculates the lin value of the selected ramptype
 *
 * PARAMETER:tenActions enAction,tenFadingReason enReason,tenStream enStream
 *
 * RETURN TYPE : tU16
 *
 ******************************************************************************************/
 tU16 Fading::fading_getRampLin(tenActions enactionln,tenFadingReason enreasonln,
                            tenStream enstreamln)
{
  tU8 RampType = Fading_GetRampType(enactionln,enreasonln,enstreamln);

  tU16 RampValLin = u16ReturnRampLinBasedonRampType(RampType);
  tU16 RampValDb = u16ReturnRampDbBasedonRampType(RampType);

  if(bIsAnyRampActive() && !m_bConfigEntryFoundFlag)
  {
       u8UpdateLowerRampLinDbValue(&RampValLin, &RampValDb);
  }

  ETG_TRACE_USR4(("RampLin : %x", RampValLin));

  return RampValLin;
}

 tU16 Fading::getSink()
 {
   return m_u16Sink;
 }
/*****************************************************************************************
 *
 * FUNCTION:  Fading::fading_getRampdB(tenActions enAction,tenFadingReason enReason,
 *                                     tenStream enStream)
 *
 * DESCRIPTION: This function calculates the dB value of the selected ramptype
 *
 * PARAMETER:tenActions enAction,tenFadingReason enReason,tenStream enStream
 *
 * RETURN TYPE : tU16
 *
 ****************************************************************************************/
 tU16 Fading::fading_getRampdB(tenActions enactiondb,tenFadingReason enreasondb,tenStream enstreamdb)
{
  tU8 RampType= Fading_GetRampType(enactiondb,enreasondb,enstreamdb);

  tU16 RampValdB = u16ReturnRampDbBasedonRampType(RampType);
  tU16 RampValLin = u16ReturnRampLinBasedonRampType(RampType);

  if(bIsAnyRampActive() && !m_bConfigEntryFoundFlag)
  {
     u8UpdateLowerRampLinDbValue(&RampValLin, &RampValdB);
  }

  ETG_TRACE_USR4(("RampDB : %x", RampValdB));

  return RampValdB;
}

 /**************************************************************************************
  *
  * FUNCTION:  Fading::bIsRampActive() const
  *
  * DESCRIPTION: This function returns True if any of the Ramps are Running.
  *
  * PARAMETER: None.
  *
  * RETURN TYPE : tBool
  *
  ***************************************************************************************/
 tBool Fading::bIsAnyRampActive() const
 {
   if(m_u8RampRunningConter != 0)
   {
     ETG_TRACE_USR4(("bIsAnyRampActive ,returns : TRUE"));
     return TRUE;
   }
   else
   {
     ETG_TRACE_USR4(("bIsAnyRampActive ,returns : FALSE"));

     return FALSE;
   }
 }

 /*************************************************************************************
  *
  * FUNCTION:  Fading::u8ReturnLowerRampLin(tU16 ramplin, tU16 rampdb) const
  *
  * DESCRIPTION: This function returns the Lowest Lin value based on the ratio
  *
  * PARAMETER: tU8.
  *
  * RETURN TYPE : tU8.
  *
  *************************************************************************************/
 tVoid Fading::u8UpdateLowerRampLinDbValue(tU16 *ramplin, tU16 *rampdb) const
 {
   tF32 LinDbRatio = 0.0;
   if((*ramplin)==0) //coverity warning fix
   {
  return;
   }
   else
   {
   LinDbRatio = (tF32)(*rampdb)/(*ramplin);

   if(m_f32RampLindbRatio < LinDbRatio)
   {
     *ramplin = m_u16RampLin;
     *rampdb = m_u16Rampdb;
   }
   }
 }

 /**************************************************************************************
  *
  * FUNCTION:  Fading::vCheckConfigForEntry(tU16 ramp_db, tU16 ramp_lin)
  *
  * DESCRIPTION: Checks whether the RampLin and RampDb values are present in the
  *              configuration or not.
  *
  * PARAMETER: tU8.
  *
  * RETURN TYPE : tU8.
  *
  **************************************************************************************/
 tVoid Fading::vCheckConfigForEntry(tU16 ramp_db, tU16 ramp_lin)
 {
    vector<RampTypeValues*>::iterator Iterator;

  for(Iterator = RampTypeValueList.begin();Iterator != RampTypeValueList.end();Iterator++)
      {
      if( ( (*Iterator) != OSAL_NULL ) && (ramp_db == (*Iterator)->dB) && (ramp_lin == (*Iterator)->Lin))
      {
         vUpdateRampType((*Iterator)->RampType);
         vSetConfigEntryFlag();
         break;
       }
       else
        {
         vUpdateLinDbValues(ramp_lin,ramp_db);
         vClearConfigEntryFlag();
         m_f32RampLindbRatio =  (tF32) m_u16Rampdb/m_u16RampLin;
      }
      }
 }

 /****************************************************************************************
  *
  * FUNCTION:  Fading::u8ReturnLowerRamp(tU8 ramptype) const
  *
  * DESCRIPTION: This function compares and returns the Slower RampType.
  *
  * PARAMETER: tU8.
  *
  * RETURN TYPE : tU8.
  *
  ****************************************************************************************/
tU8 Fading::u8ReturnLowerRampType(tU8 inramptype)
{
  tU8 ReturnValue = 0;
  tU8 ActiveRampType = u8CCAtoInternalRamptypeConverter(m_u8RampType);

  inramptype = u8CCAtoInternalRamptypeConverter(inramptype);

  if(ActiveRampType > inramptype)
  {
      ReturnValue = u8InternaltoCCARamptypeConverter(ActiveRampType);
  }
  else
  {
    ReturnValue = u8InternaltoCCARamptypeConverter(inramptype);
  }

  ETG_TRACE_USR4(("u8ReturnLowerRampType  ,returns : %x" , ReturnValue));
    return ReturnValue;
}

/*****************************************************************************************
 *
 * FUNCTION:  Fading::u16ReturnRampDbBasedonRampType(tU8 Ramptype)
 *
 * DESCRIPTION: This function returns the DB value based on the Ramp.
 *
 * PARAMETER: tU8 Ramptype.
 *
 * RETURN TYPE : tU16
 *
 ****************************************************************************************/
tU16 Fading::u16ReturnRampDbBasedonRampType(tU8 Ramptype)
{
  tU16 u16DBVal = 0x320; //NoFading DB Value
  vector<RampTypeValues*>::iterator RampTypeInterator;

  for(RampTypeInterator = RampTypeValueList.begin();
           RampTypeInterator != RampTypeValueList.end();
           ++RampTypeInterator)
    {
      if( (*RampTypeInterator) != OSAL_NULL && (Ramptype == (*RampTypeInterator)->RampType) )
       {
      u16DBVal = (*RampTypeInterator)->dB;
      break;
       }
    }

  ETG_TRACE_USR4(("u16ReturnRampDbBasedonRampType ,RampdB set to  %x", u16DBVal));
  return u16DBVal;
}

/****************************************************************************************
 *
 * FUNCTION:  Fading::u16ReturnRampLinBasedonRampType(tU8 Ramptype)
 *
 * DESCRIPTION: This function returns the Lin value based on the Ramp.
 *
 * PARAMETER: tU8 Ramptype.
 *
 * RETURN TYPE : tU16
 *
 ****************************************************************************************/
tU16 Fading::u16ReturnRampLinBasedonRampType(tU8 Ramptype)
{
  tU16 u16LinVal = 0; // NoFading Lin Value
  vector<RampTypeValues*>::iterator RampTypeInterator;

  for(RampTypeInterator = RampTypeValueList.begin();
           RampTypeInterator != RampTypeValueList.end();
           ++RampTypeInterator)
    {
      if( (*RampTypeInterator) != OSAL_NULL && (Ramptype == (*RampTypeInterator)->RampType) )
       {
      u16LinVal = (*RampTypeInterator)->Lin;
      break;
       }
    }

  ETG_TRACE_USR4(("u16ReturnRampLinBasedonRampType,RampLin set to  %x", u16LinVal));
  return u16LinVal;
}

/****************************************************************************************
 *
 * FUNCTION:  Fading::vUpdateRampTypeandSetConfigEntryFlag(tU8 Ramptype)
 *
 * DESCRIPTION: This function updates the RampType MV and Sets Config Entry Flag.
 *
 * PARAMETER: tU8 Ramptype.
 *
 * RETURN TYPE : None.
 *
 ****************************************************************************************/
tVoid Fading::vUpdateRampType(tU8 Ramptype)
{
   m_u8RampType = Ramptype;
}

/****************************************************************************************
 *
 * FUNCTION:  Fading::vUpdateLinDbValuesandClearConfigEntryFlag(tU16 lin, tU16 db)
 *
 * DESCRIPTION: This function updates the RampLin,RampDb MVs and Clearss Config Entry Flag
 *
 * PARAMETER: tU16 lin, tU16 db
 *
 * RETURN TYPE : None.
 *
 ******************************************************************************************/
tVoid Fading::vUpdateLinDbValues(tU16 lin, tU16 db)
{
   m_u16Rampdb = lin;
   m_u16RampLin = db;
}

/****************************************************************************************
 *
 * FUNCTION:  Fading::vSetActionBasedonMuteState(tenMuteAction state)
 *
 * DESCRIPTION: This function Action based on the MuteState.
 *
 * PARAMETER: tenMuteAction state
 *
 * RETURN TYPE : None.
 *
 ******************************************************************************************/
tVoid Fading::vSetActionBasedonMuteState(tenMuteAction state)
{
    if (state==EN_AUDIO_MUTE_MUTEACTION_On)
    {
      enAction= EN_AUDIO_FADING_ACTION_MUTE;
    }
    else if (state==EN_AUDIO_MUTE_MUTEACTION_Off)
    {
      enAction= EN_AUDIO_FADING_ACTION_DEMUTE;
    }
    else
    {
      //do nothing....
    }
}

/****************************************************************************************
 *
 * FUNCTION: Fading::vPOMessageNotificationHandler(PO_MessageConfig::enID MsgId)
 *
 * DESCRIPTION: This function handles the PostOffice Message Notifications Received.
 *
 * PARAMETER: PO_MessageConfig::enID MsgId
 *
 * RETURN TYPE : None.
 *
 ******************************************************************************************/
tVoid Fading::vPOMessageNotificationHandler(PO_MessageConfig::enID MsgId)
{
  InternalCommunicationAdapter* pPO;
    pPO = InternalCommunicationAdapter::getInstance();

  switch(MsgId)
   {
   case(PO_MessageConfig::ID_CCAStart_Mute):
       {
       const ID_CCAStart_Mute* pMsgFading = pPO->POMessages->QueryMessage<ID_CCAStart_Mute>(MsgId);
       enState = pMsgFading->State;
       enReason = pMsgFading->Reason;
       m_u16Sink = pMsgFading->Sink; //daw2hi added
       ETG_TRACE_USR4(("Fading::vPOMessageNotificationHandler got ID_CCAStart_Mute for Sink %d",m_u16Sink));
       break;
       }
   case(PO_MessageConfig::ID_SetSource):
      {
      m_u16PrevSource = enSourceType;
      const MSG_SetSource* pMsgSourceType = pPO->POMessages->QueryMessage<MSG_SetSource>(MsgId);
      enSourceType= pMsgSourceType->enSourceType;
      ETG_TRACE_USR4(("ID_SetSource on stream %d for AudioSource %d and Sink %d",
         pMsgSourceType->enStream,pMsgSourceType->audioSource,pMsgSourceType->sink));
      m_u16CurAudioSource = pMsgSourceType->audioSource;
      enStream = pMsgSourceType->enStream;
      m_u16Sink = pMsgSourceType->sink;
      break;
      }

   case(PO_MessageConfig::ID_CCAStart_SetMuteRamp):
     {
      const ID_CCAStart_SetMuteRamp* pMsgCCAStartSetMuteRamp = pPO->POMessages->QueryMessage<ID_CCAStart_SetMuteRamp>(MsgId);
      aud_ubMuteSpeed[pMsgCCAStartSetMuteRamp->Channel]= (tU8)(pMsgCCAStartSetMuteRamp->State); //gen4 prio3 compiler warning fix
    m_u16Sink = pMsgCCAStartSetMuteRamp->Resource;
      ETG_TRACE_USR4(("MuteRamp Received, Channel : %d, MuteSpeed : %d",pMsgCCAStartSetMuteRamp->Channel,aud_ubMuteSpeed[pMsgCCAStartSetMuteRamp->Channel]));
      if(pMsgCCAStartSetMuteRamp->State >= (EN_AUDIO_FADING_INVALID))
        {
         aud_ubMuteSpeed[pMsgCCAStartSetMuteRamp->Channel]= EN_AUDIO_FADING_MEDIUM_MUTE;
         ETG_TRACE_USR4(("state is greater than the ramptype array,RampType Set to Medium mute"));
        }
    ETG_TRACE_USR4(("Fading::vPOMessageNotificationHandler got ID_CCAStart_SetMuteRamp for Sink %d",pMsgCCAStartSetMuteRamp->Resource));
      break;
     }

   case(PO_MessageConfig::ID_SetMute):
      {
        const ID_SetMute* pMsgSetMute = pPO->POMessages->QueryMessage<ID_SetMute>(MsgId);
        m_u8RampRunningConter += 1;
        vCheckConfigForEntry(pMsgSetMute->u16RampdB, pMsgSetMute->u16RampLin);
        m_u16Sink = pMsgSetMute->u16Sink;
       ETG_TRACE_USR4(("Fading::vPOMessageNotificationHandler got ID_SetMute for Sink %d with action %d",pMsgSetMute->u16Sink,pMsgSetMute->enMuteAction));
        break;
      }

   case(PO_MessageConfig::ID_NotifyMute):
      {
      const ID_NotifyMute* pMsgNotifyMute = pPO->POMessages->QueryMessage<ID_NotifyMute>(MsgId);

      if(pMsgNotifyMute->enMuteResult == EN_AUDIO_MUTE_MUTERESULT_DEMUTE || pMsgNotifyMute->enMuteResult == EN_AUDIO_MUTE_MUTERESULT_MUTE)
      m_u8RampRunningConter =0;
      vResetFadingvariablesOnDemuteNotification(pMsgNotifyMute->enStream, pMsgNotifyMute->enMuteResult);
      break;
      }

   default:
    break;
     }

    if ( aud_fading_aubMuteActive[enStream] == 0 && aud_fading_ubVolumeActive == 0)
  {
    aud_ubFadingActive[enStream]=EN_AUDIO_FADING_NOFADING;
    }
}

/****************************************************************************************
 *
 * FUNCTION: Fading::u8ReturnRampTypeBasedonSrcType(tU16 srctype, tU32 enreason,
 *                                                           tenActions enaction) const
 *
 * DESCRIPTION: This function returns the RampType based on SourceType
 *
 * PARAMETER:   tU16 srctype, tU32 enreason, tenActions enaction
 *
 * RETURN TYPE : tU8.
 *
 ******************************************************************************************/
tU8 Fading::u8ReturnRampTypeBasedonSrcType(tU16 srctype, tU32 enreason, tenActions enaction)
{
  tU8 RampType = EN_AUDIO_FADING_NOFADING;
    switch(srctype)
  {
  case EN_AUDIO_SOURCE_SOURCETYPE_CDA:
  #if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)
  case EN_AUDIO_SOURCE_SOURCETYPE_BT_AUDIO:
  case EN_AUDIO_SOURCE_SOURCETYPE_MEDIA:
  #endif
  {
    RampType = EN_AUDIO_FADING_SLOW_MUTE;

    if(((enreason == EN_AUDIO_FADING_RES_NEWTITEL)
        #if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)
        //To handle below timing related use case on startup (NCG3D-15670)
        || (enreason == EN_AUDIO_FADING_RES_BOOSTER)
        #endif
       ) && (enaction ==EN_AUDIO_FADING_ACTION_DEMUTE))
    {
      RampType = EN_AUDIO_FADING_FAST_MUTE;
      ETG_TRACE_USR4(("Ramptype set to Fast mute"));
    }
    break;
   }
  case EN_AUDIO_SOURCE_SOURCETYPE_PHONENARROWBAND:
  case EN_AUDIO_SOURCE_SOURCETYPE_PHONEBROADBAND:
   {
    RampType = EN_AUDIO_FADING_FAST_MUTE;
    break;
   }
  case EN_AUDIO_SOURCE_SOURCETYPE_NAVI:
  {
       RampType = EN_AUDIO_FADING_VERY_FAST_MUTE;
       break;
  }
  case EN_AUDIO_SOURCE_SOURCETYPE_FM_TA:
  case EN_AUDIO_SOURCE_SOURCETYPE_DAB_TA:
  case EN_AUDIO_SOURCE_SOURCETYPE_CUE:
   {
    RampType = EN_AUDIO_FADING_MEDIUM_MUTE;
    break;
   }
  default:
   {
  RampType = EN_AUDIO_FADING_SLOW_MUTE;
  if(enreason == EN_AUDIO_FADING_RES_OTHER)
  {
    RampType = EN_AUDIO_FADING_VERY_FAST_MUTE;
  }
  if(enreason == EN_AUDIO_FADING_RES_BEEP)
  {
    RampType = EN_AUDIO_FADING_VERY_FAST_MUTE;
  }
  break;
   }
  }

  if(enaction == EN_AUDIO_FADING_ACTION_DEMUTE)
  {
    if(!bFirstDemute)
    {
      RampType = EN_AUDIO_FADING_FAST_MUTE;
      bFirstDemute = true;
      ETG_TRACE_USR4(("Ramp type set to fast, for the first demute"));
    }
       if( bIsSPISource(m_u16CurAudioSource) )
        {
          RampType = EN_AUDIO_FADING_VERY_FAST_MUTE;
          ETG_TRACE_USR4(("All SPI sources Demute RampType set to very fast"));
        }

        if((enreason == EN_AUDIO_FADING_RES_ARKAMYS) && !bSourceSwitchFlag )
        {
          RampType = EN_AUDIO_FADING_FAST_MUTE;
          ETG_TRACE_USR4(("Arkamys Demute RampType set to  fast"));
        }
        else
           bSourceSwitchFlag = false;
    }

     ETG_TRACE_USR4(("u8ReturnRampTypeBasedonSrcType ,Ramp set to  %x", RampType));
   return RampType;
}

/****************************************************************************************
 *
 * FUNCTION: Fading::u8ReturnRampTypeBasedonStream(tenStream stream, tU8 ramptype) const
 *
 * DESCRIPTION: This function returns the RampType based on Stream received.
 *
 * PARAMETER:   tenStream stream, tU8 ramptype
 *
 * RETURN TYPE : tU8.
 *
 ******************************************************************************************/
tU8 Fading::u8ReturnRampTypeBasedonStream(tenStream stream, tU8 ramptype) const
{
  if (stream == EN_AUDIO_SOURCE_STREAM_MIX2)
  {
    ramptype =   EN_AUDIO_FADING_FAST_MUTE;
  }
  if (stream == EN_AUDIO_SOURCE_STREAM_MIX1)
  {
    ramptype = EN_AUDIO_FADING_MEDIUM_MUTE;
  }
  if (stream == EN_AUDIO_SOURCE_STREAM_MIX3)
  {
    ramptype = EN_AUDIO_FADING_FAST_MUTE;
  }

  ETG_TRACE_USR4(("u8ReturnRampTypeBasedonStream ,Ramp set to  %x", ramptype));
  return ramptype;
}

/****************************************************************************************
 *
 * FUNCTION: Fading::u8CheckRampActiveandReturnLowestRamp(tU8 ramptype) const
 *
 * DESCRIPTION: This function checks for any RunningRamps and returns the lowest Ramp.
 *
 * PARAMETER:   tU8 ramptype
 *
 * RETURN TYPE : tU8.
 *
 ******************************************************************************************/
tU8 Fading::u8CheckRampActiveandReturnLowestRamp(tU8 ramptype)
{
  if((bIsAnyRampActive()) && (m_bConfigEntryFoundFlag == TRUE))
  {
    ramptype = u8ReturnLowerRampType(ramptype);
  }

  ETG_TRACE_USR4(("u8CheckRampActiveandReturnLowestRamp ,Ramp set to  %x", ramptype));
  return ramptype;
}

/****************************************************************************************
 *
 * FUNCTION: Fading:u8SetRampTypeBasedonVolParam(tU8 ramptype)
 *
 * DESCRIPTION: This function sets the RampType based on Volume parameters Received.
 *
 * PARAMETER:   tU8 ramptype
 *
 * RETURN TYPE : tU8.
 *
 ******************************************************************************************/
tU8 Fading::u8SetRampTypeBasedonVolParam(tU8 ramptype)
{
  aud_fading_ubVolumeActive =1;

  if (aud_fading_aubMuteActive[enStream] != 0)
  {
    ramptype =aud_ubFadingActive[enStream];
  }
  else
  {
    if (aud_fading_ubVolumeModeSlow == 2 || aud_fading_ubSoftOnActive == 1)
    {
      ramptype =  EN_AUDIO_FADING_SLOW_MUTE ;
    }
    else if (aud_fading_ubVolumeModeSlow == 1)
    {
      ramptype = EN_AUDIO_FADING_MEDIUM_MUTE ;
    }
    else
    {
      ramptype = EN_AUDIO_FADING_FAST_MUTE;
    }
  }

  ETG_TRACE_USR4(("u8SetRampTypeBasedonVolParam ,Ramp set to  %x", ramptype));
  return ramptype;
}

/****************************************************************************************
 *
 * FUNCTION: Fading::u8SetRampTypeBasedonMuteReason(tU8 ramptype, tU32 reason,
 *                                                                tenStream stream)
 *
 * DESCRIPTION: This function sets the RampType based on MuteReason received
 *
 * PARAMETER:   tU8 ramptype, tU32 reason, tenStream stream
 *
 * RETURN TYPE : tU8.
 *
 ******************************************************************************************/
tU8 Fading::u8SetRampTypeBasedonMuteReason(tU8 ramptype, tU32 reason, tenStream stream)
{
  aud_fading_aubMuteActive[stream] = 1;

  if(((reason == EN_AUDIO_FADING_RES_SOURCESEL) || (reason == EN_AUDIO_FADING_RES_NEWTITEL)) && (stream == EN_AUDIO_SOURCE_STREAM_MAIN))
  {
    ramptype =aud_ubMuteSpeed[stream];
    ramptype = u8HandleRampBasedOnPrevSource(ramptype);
    bSourceSwitchFlag = true;

  }
  else if(reason == EN_AUDIO_FADING_RES_BOOSTER)
  {
    ramptype = EN_AUDIO_FADING_NOFADING;
  }
  else if(reason == EN_AUDIO_FADING_RES_OTHER)
  {
    ramptype = EN_AUDIO_FADING_FAST_MUTE;
  }
  else if(reason == EN_AUDIO_FADING_RES_ARKAMYS)
  {
    ramptype = EN_AUDIO_FADING_VERY_FAST_MUTE;
  }
  else {}

  ETG_TRACE_USR4(("u8SetRampTypeBasedonMuteReason ,RampType %x", ramptype));
  return ramptype;
}

/****************************************************************************************
 *
 * FUNCTION: Fading::vResetFadingvariablesOnDemuteNotification(tenStream stream,
 *                                                             tenMuteResult result)
 *
 * DESCRIPTION: This function resets the fading variables on Demute Notification.
 *
 * PARAMETER :  tenStream stream, tenMuteResult result
 *
 * RETURN TYPE : tU8.
 *
 ******************************************************************************************/
tVoid Fading::vResetFadingvariablesOnDemuteNotification(tenStream stream, tenMuteResult result)
{
  if(result == EN_AUDIO_MUTE_MUTERESULT_DEMUTE)
  {
    aud_fading_ubSoftOnActive = 0;
    aud_fading_aubMuteActive[stream] = 0;
  }
}

/****************************************************************************************
 *
 * FUNCTION: Fading::u8GetKey(tU8 value)
 *
 * DESCRIPTION: This function returns the key based on the mapped value.
 *
 * PARAMETER : tU8 value
 *
 * RETURN TYPE : tU8.
 *
 ******************************************************************************************/
tU8 Fading::u8GetKey(tU8 value)
{
  tU8 MapKey = 0;

  map<tenRampType, tenInternalRampType>::iterator mapiterator;

  for(mapiterator = RampTypeMap.begin(); mapiterator != RampTypeMap.end(); ++mapiterator)
  {
    if(value == (*mapiterator).second)
    {
      MapKey = (*mapiterator).first;
    }
  }

  return MapKey;
}

/****************************************************************************************
 *
 * FUNCTION: Fading::u8GetValue(tU8 key)
 *
 * DESCRIPTION: This function returns the value based on the key
 *
 * PARAMETER : tU8 key
 *
 * RETURN TYPE : tU8.
 *
 ******************************************************************************************/
tU8 Fading::u8GetValue(tU8 key)
{
  tU8 MapValue = 0;

  map<tenRampType, tenInternalRampType>::iterator mapiterator;

  for(mapiterator = RampTypeMap.begin(); mapiterator != RampTypeMap.end(); ++mapiterator)
  {
    if(key == (*mapiterator).first)
    {
      MapValue = (*mapiterator).second;
    }
  }

  return MapValue;
}

/****************************************************************************************
 *
 * FUNCTION: Fading::u8CCAtoInternalRamptypeConverter(tU8 ramptype)
 *
 * DESCRIPTION: This function converts the CCA defined Ramp value to Internal Type.
 *
 * PARAMETER : tU8 key
 *
 * RETURN TYPE : tU8.
 *
 ******************************************************************************************/
tU8 Fading::u8CCAtoInternalRamptypeConverter(tU8 ramptype)
{
  return u8GetValue(ramptype);
}

/****************************************************************************************
 *
 * FUNCTION: Fading::u8CCAtoInternalRamptypeConverter(tU8 ramptype)
 *
 * DESCRIPTION: This function converts the internal defined Ramp value to CCA Type.
 *
 * PARAMETER : tU8 key
 *
 * RETURN TYPE : tU8.
 *
 ******************************************************************************************/
tU8 Fading::u8InternaltoCCARamptypeConverter(tU8 ramptype)
{
  return u8GetKey(ramptype);
}

/****************************************************************************************
 *
 * FUNCTION: Fading::vSetConfigEntryFlag()
 *
 * DESCRIPTION: This function sets the m_bConfigEntryFoundFlag
 *
 * PARAMETER : None
 *
 * RETURN TYPE : None
 *
 ******************************************************************************************/
tVoid Fading::vSetConfigEntryFlag()
{
  m_bConfigEntryFoundFlag = TRUE;
}

/****************************************************************************************
 *
 * FUNCTION: Fading::vClearConfigEntryFlag()
 *
 * DESCRIPTION: This function clears the m_bConfigEntryFoundFlag
 *
 * PARAMETER : None
 *
 * RETURN TYPE : None
 *
 ******************************************************************************************/
tVoid Fading::vClearConfigEntryFlag()
{
  m_bConfigEntryFoundFlag = FALSE;
}



/*********************************************************************
 *
 ********************************************************************/
tU8 Fading::u8HandleRampBasedOnPrevSource(tU8 Ramp)const
{

 if( (m_u16PrevSource == EN_AUDIO_SOURCE_SOURCETYPE_PHONENARROWBAND || m_u16PrevSource == EN_AUDIO_SOURCE_SOURCETYPE_PHONEBROADBAND))
 {
   switch(enSourceType)
   {
   case  EN_AUDIO_SOURCE_SOURCETYPE_FM:
   case  EN_AUDIO_SOURCE_SOURCETYPE_AM:
   case  EN_AUDIO_SOURCE_SOURCETYPE_MEDIA:
   case EN_AUDIO_SOURCE_SOURCETYPE_CDA:
   case EN_AUDIO_SOURCE_SOURCETYPE_AUX:
   case  EN_AUDIO_SOURCE_SOURCETYPE_DAB:
   case EN_AUDIO_SOURCE_SOURCETYPE_AUX2:
   case EN_AUDIO_SOURCE_SOURCETYPE_BT_AUDIO:
   case  EN_AUDIO_SOURCE_SOURCETYPE_FM_WB:

   Ramp = EN_AUDIO_FADING_VERY_FAST_MUTE;
     break;

   default:
     break;
   }
 }

 return Ramp;
}
/*********************************************************************
 *   bIsSPISource(tU16 m_u16CurAudioSource)const
 ********************************************************************/
 tBool Fading::bIsSPISource(tU16 m_u16CurAudioSource)const
 {
     tBool ReturnVal = false;
   switch(m_u16CurAudioSource)
   {
     case midw_fi_tcl_e8_AudSource::FI_EN_SPI_MAIN:
     case midw_fi_tcl_e8_AudSource::FI_EN_SPI_PHONE:
     case midw_fi_tcl_e8_AudSource::FI_EN_SPI_VR:
     case midw_fi_tcl_e8_AudSource::FI_EN_SPI_MIX:
     case midw_fi_tcl_e8_AudSource::FI_EN_SPI_ALERT:
     case midw_fi_tcl_e8_AudSource::FI_EN_SPI_ML_INFO:
     case midw_fi_tcl_e8_AudSource::FI_EN_SPI_VR_STEREO:
     {
        ReturnVal = true;
        break;
     }
     default:
     break;
   }
   return ReturnVal;
 }
