/************************************************************************
* FILE:         fc_audio_msgtypes.h
* PROJECT:      Ford H/L RNS
* SW-COMPONENT: Audio server
*----------------------------------------------------------------------
*
* DESCRIPTION: Audio Server interface to HMI
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2004 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                       | Modification
* 18.11.04  | CM-DI/ESA2 Mamone            | Initial version .
*
*************************************************************************/

#ifndef _AUD_MSG_TYPES_H_
#define _AUD_MSG_TYPES_H_

// Project switches are defied in the following header file. Please do not remove
// This define. Otherwise, Project specific MIX-MAX values will contain incorrect values.
//#include "config/aud_ProjectSpecificConfiguration.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#ifndef _AUD_EXCLUDE_FKTID_DEFINES_H_
/******************************************************
**           Function Ids (Most Like)                 *
*******************************************************/
#define AUDIO_C_U16_FKTID_SOURCE_ACTIVITY           0x0103 // According to MOST
#define AUDIO_C_U16_FKTID_SOURCE_ACTIVITY_STATUS    0x0C08
#define AUDIO_C_U16_FKTID_MUTE                      0x0113 // According to MOST
#define AUDIO_C_U16_FKTID_MUTE_STATUS               0x0C07
#define AUDIO_C_U16_FKTID_LATEST_ENTERTMTSRC_STATUS 0x0C10

#define AUDIO_C_U16_FKTID_VOLUMEMODE_STATUS         0x0C00
#define AUDIO_C_U16_FKTID_VOLUMEMODE                0x0C01
#define AUDIO_C_U16_FKTID_VOLUME                    0x0400 // According to MOST
#define AUDIO_C_U16_FKTID_VOLUME_STATUS             0x0C02
#define AUDIO_C_U16_FKTID_BEEP_STATUS               0x0C03
#define AUDIO_C_U16_FKTID_BEEP                      0x0C04
#define AUDIO_C_U16_FKTID_GALA_STATUS               0x0C05
#define AUDIO_C_U16_FKTID_GALA                      0x0C06
#define AUDIO_C_U16_FKTID_BALANCE_STATUS            0x0C09
#define AUDIO_C_U16_FKTID_BALANCE                   0x0200 // According to MOST
#define AUDIO_C_U16_FKTID_LOUDNESS_STATUS           0x0C0A
#define AUDIO_C_U16_FKTID_LOUDNESS                  0x0201 // According to MOST
#define AUDIO_C_U16_FKTID_BASS_STATUS               0x0C0B
#define AUDIO_C_U16_FKTID_BASS                      0x0202 // According to MOST
#define AUDIO_C_U16_FKTID_TREBLE_STATUS             0x0C0C
#define AUDIO_C_U16_FKTID_TREBLE                    0x0203 // According to MOST
#define AUDIO_C_U16_FKTID_FADER_STATUS              0x0C0D
#define AUDIO_C_U16_FKTID_FADER                     0x0204 // According to MOST
#define AUDIO_C_U16_FKTID_MEMSOUND_STATUS           0x0C0E
#define AUDIO_C_U16_FKTID_MEMSOUND                  0x046A // According to MOST
#define AUDIO_C_U16_FKTID_FADER_DEACTIVATION_STATUS 0x0C0F
#define AUDIO_C_U16_FKTID_DYN_COMPRESSION           0x0C11
#define AUDIO_C_U16_FKTID_DYN_COMPRESSION_STATUS    0x0C12
#define AUDIO_C_U16_FKTID_OPTIMIZATION              0x0C13
#define AUDIO_C_U16_FKTID_OPTIMIZATION_STATUS       0x0C14
#define AUDIO_C_U16_FKTID_EQU_PRESETS               0x0C15
#define AUDIO_C_U16_FKTID_EQU_PRESETS_STATUS        0x0C16
#define AUDIO_C_U16_FKTID_AUD_DIAG_MODE             0x0C17
#define AUDIO_C_U16_FKTID_AUD_DIAG_MODE_STATUS      0x0C18
#define AUDIO_C_U16_FKTID_AUX_IN_LEVEL              0x0C19 // Added by ATI2HI
#define AUDIO_C_U16_FKTID_AUX_IN_LEVEL_STATUS       0x0C1A // Added by ATI2HI
#define AUDIO_C_U16_FKTID_MID_RANGE                 0x0465 // Added by ATI2HI According to MOST
#define AUDIO_C_U16_FKTID_MID_RANGE_STATUS          0x0C1F // Added by ATI2HI
#define AUDIO_C_U16_FKTID_PDCATTENUATION                0x0C1B // Added by VO82HI
#define AUDIO_C_U16_FKTID_PDCATTENUATION_STATUS         0x0C1D // Added by VO82HI
#define AUDIO_C_U16_FKTID_PDCATTENUATION_LEVEL          0x0C1C // Added by VO82HI
#define AUDIO_C_U16_FKTID_PDCATTENUATION_LEVEL_STATUS   0x0C1E // Added by VO82HI
#define AUDIO_C_U16_FKTID_AUDIOSOURCE               0x0E00
#define AUDIO_C_U16_FKTID_AMPDEVICEAUDIOROUTE       0x0E01

#define AUDIO_C_U16_FKTID_DIAG_PERFORM_TEST              0x0C30
#define AUDIO_C_U16_FKTID_DIAG_PERFORM_TEST_STATUS       0x0C31
#define AUDIO_C_U16_FKTID_DIAG_COMPCTRL_TESTTONE         0x0C32
#define AUDIO_C_U16_FKTID_DIAG_COMPCTRL_TESTTONE_STATUS  0xC3A
#define AUDIO_C_U16_FKTID_SIGNAL_TONE_VOLUME_STATUS     0x0C3B

#define AUDIO_C_U16_FKTID_LSVALUES_STATUS           0x0C20 // Added by VO82HI

#endif // _AUD_EXCLUDE_FKTID_DEFINES_H_
/*******************************************************************************
********************************************************************************
**                      Defines for client use                                **
********************************************************************************
*******************************************************************************/
#ifndef _AUD_EXCLUDE_TYPES_DEFINES_H_
/******************************************************************************/
/******************************************************
**           Type T_e8_AudioSinkGeometry              *
*******************************************************/
enum T_e8_AudioSinkGeometry
{
  AUDIO_SINK_LF = 1,    // left front
  AUDIO_SINK_RF,        // right front
  AUDIO_SINK_LR,        // left rear
  AUDIO_SINK_RR,        // right rear
  AUDIO_SINK_NOT_DEF = 0xFF   // default and to force errors in test suite
};
/******************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************
**           Type T_e8_SourceActivity                 *
*******************************************************/
enum T_e8_SourceActivity
{
  AUDIO_SRC_OFF = 0,
  AUDIO_SRC_PAUSE,
  AUDIO_SRC_ON,
  AUDIO_SRC_DEMUTE_RAMP_RUNNING,
  AUDIO_SRC_PLAY_ATTENUATED,
  AUDIO_SRC_PRESET = 7UL,
  AUDIO_NOT_DEF = 0xFF // default and to force errors in test suite
};
/******************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************
**           Type T_e8_AudioDataStreamFormat          *
*******************************************************/
enum T_e8_AudioDataStreamFormat
{
  AUDIO_DATA_STREAM_FORMAT_PCM = 0,
  AUDIO_DATA_STREAM_FORMAT_AMR,
  AUDIO_DATA_STREAM_FORMAT_MP3,
  AUDIO_DATA_STREAM_FORMAT_WMA,
  AUDIO_DATA_STREAM_FORMAT_BIN,
  AUDIO_DATA_STREAM_FORMAT_MPEG2,
  AUDIO_DATA_STREAM_FORMAT_DEFAULT = 0xFF // default and to force errors in
                                          // test suite
};
/******************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************
**           Type T_e8_MuteSwitch                     *
*******************************************************/
enum T_e8_MuteSwitch
{
  AUDIO_MUTE_OFF = 0,
  AUDIO_MUTE_ON,
  AUDIO_MUTE_NOT_DEF = 0xFF // default and to force errors in test suite
};
/******************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************
**           Type T_e8_ResourceNo                     *
*******************************************************/
enum T_e8_ResourceNo
{
  AUDIO_RESOURCE_NOT_DEF = 0, // default and to force errors in test suite
  AUDIO_RESOURCE_LS,
  AUDIO_RESOURCE_HP
};
/******************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************
**           Type T_e8_Audio_CCAError                 *
*******************************************************/
enum T_e8_Audio_CCAError
{
  AUDIO_INVALID_OPCODE = 0,
  AUDIO_OPCODE_NOT_SUPPORTED,
  AUDIO_UPREG_FAILURE,
  AUDIO_RELUPREG_FAILURE,
  AUDIO_WRONG_PARAMETERS,
  AUDIO_STRING_PARAMETER_OVERSIZE,
  AUDIO_PARAMETER_LIMITED,
  AUDIO_UNKNOWN_MSG,
  AUDIO_PREVIOUS_REQUEST_PENDING
};
/******************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************
**           Type T_e8_AudioServiceStatus             *
*******************************************************/
// Reply from server for UpReg (Status) / Method Start(Method Result)
enum T_e8_AudioServiceStatus
{
   AUDIO_STATUS_MSG_REJECTED = 0,
   AUDIO_STATUS_MSG_RECEIVED = 1,
   AUDIO_STATUS_MSG_PREVIOUS_REQUEST_PENDING = 2,
   AUDIO_STATUS_MSG_PROCESSED = 3,
   AUDIO_STATUS_MSG_ABORT = 4
};
/******************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************
**           Type T_e8_GalaLevel                      *
*******************************************************/
enum T_e8_GalaLevel
{
  AUDIO_GALA_OFF = 0,
  AUDIO_GALA_LEVEL_1,
  AUDIO_GALA_LEVEL_2,
  AUDIO_GALA_LEVEL_3,
  AUDIO_GALA_LEVEL_4,
  AUDIO_GALA_LEVEL_5,
  AUDIO_GALA_LEVEL_6,
  AUDIO_GALA_LEVEL_7,
  AUDIO_GALA_NOT_DEF = 0xFF // default and to force errors in test suite
};
/******************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************
**           Type T_e8_AudioChannel                   *
*******************************************************/
enum T_e8_AudioChannel
{
  AUDIO_CHANNEL_EXC = 1,
  AUDIO_CHANNEL_MIX,
  AUDIO_CHANNEL_NOT_DEF = 0xFF // default and to force errors in test suite
};
/******************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************
**           Type T_e8_AudioVolumeType                *
*******************************************************/
enum T_e8_AudioVolumeType
{
  AUDIO_VAL_TYPE_ABS = 1,
  AUDIO_VAL_TYPE_INC,
  AUDIO_VAL_TYPE_DEC,
  AUDIO_VAL_TYPE_NOT_DEF = 0xFF // default and to force errors in test suite
};
/******************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************
**           Type T_e8_AudioSoundType                *
*******************************************************/
enum T_e8_AudioSoundType
{
  AUDIO_SND_TYPE_ABS = 1,
  AUDIO_SND_TYPE_INC,
  AUDIO_SND_TYPE_DEC,
  AUDIO_SND_TYPE_NOT_DEF = 0xFF // default and to force errors in test suite
};
/******************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************
**           Type T_e8_AudioBeepType                  *
*******************************************************/
/*
 *
 enum T_e8_AudioBeepType
{
  AUDIO_BEEP_ERROR = 1,
  AUDIO_BEEP_ROGER,
  AUDIO_BEEP_WARN,
  AUDIO_BEEP_CLICK,
  AUDIO_BEEP_POI,
  AUDIO_BEEP_SDS_END,
  AUDIO_BEEP_SMS_INCOMING,
  AUDIO_BEEP_SMS_SEND,
  AUDIO_BEEP_URGENT,
  AUDIO_BEEP_SPEED_WARN,
  AUDIO_BEEP_CURVE_WARN,
  AUDIO_BEEP_AVM_OPERATION,
  AUDIO_BEEP_AVM_ERROR,
  AUDIO_BEEP_WARN_NOT_DEF = 0xFF // default and to force errors in test suite
};
*/
/******************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************
**           Type T_e8_AudioBeepStatus                *
*******************************************************/
enum T_e8_AudioBeepStatus
{
  AUDIO_BEEP_STATUS_ON = 1,
  AUDIO_BEEP_STATUS_OFF,
  AUDIO_BEEP_STATUS_NOT_DEF = 0xFF // default and to force errors in
                                   // test suite
};
/******************************************************/

/******************************************************************************/
/******************************************************
**           Type T_e8_VolumeMode                     *
*******************************************************/
/*
enum T_e8_VolumeMode
{
  AUDIO_VOLMODE_NORMAL = 0,
  AUDIO_VOLMODE_SETUP_ONVOL,
  AUDIO_VOLMODE_SETUP_TEL,
  AUDIO_VOLMODE_SETUP_TIM,
  AUDIO_VOLMODE_SETUP_TA,
  AUDIO_VOLMODE_SETUP_BEEPVOL,
  AUDIO_VOLMODE_SETUP_DIAGVOL,
  AUDIO_VOLMODE_NAV_ANNOUCEMENT,
  AUDIO_VOLMODE_SETUP_NAV_VOL,
  AUDIO_VOLMODE_SETUP_NAV_ANNOUNCEMENT_VOL,
  AUDIO_VOLMODE_NOT_DEF = 0xFF // default and to force errors in test suite
};
*/
/******************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************
**           Type T_e8_SourceNo                       *
*******************************************************/
enum T_e8_SourceNo
{
  AUDIO_SRC_FM = 1,
  AUDIO_SRC_AM,
  AUDIO_SRC_CD,
  AUDIO_SRC_CDC,
  AUDIO_SRC_CC,
  AUDIO_SRC_AUX,
  AUDIO_SRC_TEL,
  AUDIO_SRC_MD,
  AUDIO_SRC_MP3,
  AUDIO_SRC_TA, //No. 10
  AUDIO_SRC_TV,
  AUDIO_SRC_TIM,
  AUDIO_SRC_NAVI,
  AUDIO_SRC_NO,
  AUDIO_SRC_FM2,
  AUDIO_SRC_AM2,
  AUDIO_SRC_TA2,
  AUDIO_SRC_DAB,
  AUDIO_SRC_DAB_TA,
  AUDIO_SRC_CDC2,//No. 20
  AUDIO_SRC_GSM,
  AUDIO_SRC_VRU,
  AUDIO_SRC_MICROPHONE,
  AUDIO_SRC_AUX2,   // For AUX2
  AUDIO_SRC_VR2,//No. 25
  AUDIO_SRC_AUX_FAKRA,
  AUDIO_SRC_XMTUN,
  AUDIO_SRC_IPOD,
  AUDIO_SRC_DOV,
  AUDIO_SRC_DOV_TEST, //No. 30
  AUDIO_SRC_DAB_SF,
  AUDIO_SRC_PANDORA,
  AUDIO_SRC_SMS,
  AUDIO_SRC_NOT_DEF = 0xFF // default and to force errors in test suite

};
/******************************************************/
/******************************************************************************/


/******************************************************************************/
/******************************************************
**           Type T_e8_SinkNo                         *
*******************************************************/
enum T_e8_SinkNo
{
  AUDIO_SNK_ALL = 0,
  AUDIO_SNK_TUN,
  AUDIO_SNK_CD,
  AUDIO_SNK_CDC,
  AUDIO_SNK_CC,
  AUDIO_SNK_AUX,
  AUDIO_SNK_TEL,
  AUDIO_SNK_MD,
  AUDIO_SNK_MP3,
  AUDIO_SNK_TV,
  AUDIO_SNK_TIM,  //No.10
  AUDIO_SNK_NAV,
  AUDIO_SNK_USR,
  AUDIO_SNK_EXC,
  AUDIO_SNK_FM2,
  AUDIO_SNK_AM2,
  AUDIO_SNK_TA2,
  AUDIO_SNK_DAB,
  AUDIO_SNK_DAB_TA,
  AUDIO_SNK_CDC2,
  AUDIO_SNK_GSM,  //No.20
  AUDIO_SNK_VRU,
  AUDIO_SNK_AUX2,
  AUDIO_SNK_VR2,
  AUDIO_SNK_XMTUN,
  AUDIO_SNK_IPOD, //No.25
  AUDIO_SNK_DOV,
  AUDIO_SNK_DOV_TEST,
  AUDIO_SNK_PANDORA,
  AUDIO_SNK_DAB_SF,
  AUDIO_SNK_SMS, //No.30
  AUDIO_SNK_NOT_DEF = 0xFF // default and to force errors in test suite
};

/******************************************************************************/
/******************************************************
**           Type T_e8_Sound                         *
*******************************************************/
enum T_e8_Sound
{
  AUDIO_SOUND_VOLUME = 0,
  AUDIO_SOUND_BASS,
  AUDIO_SOUND_TREBLE,
  AUDIO_SOUND_BALANCE,
  AUDIO_SOUND_FADER,
  AUDIO_SOUND_LOUDNESS,
  AUDIO_SOUND_SUBW,
  AUDIO_SOUND_MID,
  AUDIO_SOUND_HPAS,
  AUDIO_SOUND_GALA,
  AUDIO_SOUND_AUDPILOT,
  AUDIO_SOUND_VOLOFFSET,
  AUDIO_SOUND_DYNCOMP,
  AUDIO_SOUND_OPTIMIZATION,
  AUDIO_SOUND_PDC_ATTENUATION_LEVEL,
  AUDIO_SOUND_EQ_PRESET,
  AUDIO_SOUND_NOT_DEF = 0xFF // default and to force errors in test suite
};

/******************************************************************************/
/******************************************************
**           Type T_e8_MemStatus                      *
*******************************************************/
enum T_e8_MemStatus
{
  AUDIO_MEMSTATUS_SUCCESS = 0,
  AUDIO_MEMSTATUS_FAIL,
  AUDIO_MEMSTATUS_NOT_DEF = 0xFF // default and to force errors in test suite
};

/******************************************************************************/
/******************************************************
**           Type T_e8_FaderStatus                    *
*******************************************************/
enum T_e8_FaderStatus
{
  AUDIO_FADERSTATUS_INACTIVE = 0,
  AUDIO_FADERSTATUS_ACTIVE,
  AUDIO_FADERSTATUS_NOT_DEF = 0xFF // default and to force errors in
                                   // test suite
};

/******************************************************************************/
/******************************************************
**           Type T_e8_DynCompression                 *
*******************************************************/
enum T_e8_DynCompression
{
  AUDIO_DYN_COMPRESSION_OFF = 0,
  AUDIO_DYN_COMPRESSION_ON,
  AUDIO_DYN_COMPRESSION_NOT_DEF = 0xFF // default and to force errors in
                                       // test suite
};

/******************************************************************************/
/******************************************************
**           Type T_e8_Optimization                   *
*******************************************************/
enum T_e8_Optimization
{
  AUDIO_OPTIMIZATION_OFF = 0,
  AUDIO_OPTIMIZATION_LEFT ,
  AUDIO_OPTIMIZATION_RIGHT ,
  AUDIO_OPTIMIZATION_ALL,
  AUDIO_OPTIMIZATION_DRIVER,
  AUDIO_OPTIMIZATION_FRONT_PASSENGER,
  AUDIO_OPTIMIZATION_NOT_DEF = 0xFF   // default and to force errors in
                                      // test suite
};

/******************************************************************************/
/******************************************************
**           Type T_e8_EquPresets                     *
*******************************************************/
enum T_e8_EquPresets
{
  AUDIO_EQU_PRESET_0 = 0,
  AUDIO_EQU_PRESET_1,
  AUDIO_EQU_PRESET_2,
  AUDIO_EQU_PRESET_3,
  AUDIO_EQU_PRESET_4,
  AUDIO_EQU_PRESET_5,
  AUDIO_EQU_PRESET_NOT_DEF = 0xFF   // default and to force errors in
                                    // test suite
};

/******************************************************************************/
/******************************************************
**           Type T_e8_DiagAudMode                    *
*******************************************************/
enum T_e8_DiagAudMode
{
  AUDIO_DIAG_AUD_MODE_LINEAR_OFF = 0,
  AUDIO_DIAG_AUD_MODE_LINEAR_ON,
  AUDIO_DIAG_AUD_MODE_NOT_DEF = 0xFF   // default and to force errors in
                                       // test suite
};
/******************************************************
**           Type T_e8_DiagAudMode                    *
*******************************************************/
enum T_e8_GenericDiagAudMode
{
  AUDIO_DIAG_AUD_MODE_OFF = 0,
  AUDIO_DIAG_AUD_MODE_ON,
  AUDIO_DIAG_AUD_MODE_NV = 0xFF   // to indicate NOT VALID
                                       // test suite
};
#endif //_AUD_EXCLUDE_TYPES_DEFINES_H_
#ifndef _AUD_EXCLUDE_BOUNDARY_DEFINES_H_
/******************************************************/
/******************************************************************************/
#define DEVICE_NAME_DEFAULT                    "No Device Name"
#define DEVICE_NAME_MAX_LENGTH                 100

/******************************************************************************/
// Sound max and min values
#ifndef USE_VW_SOUND_LIMITS

   #define AUDIO_SOUND_BASS_MAX          0x07
   #define AUDIO_SOUND_BASS_MIN          (-0x07)

   #define AUDIO_SOUND_TREBLE_MAX        0x07
   #define AUDIO_SOUND_TREBLE_MIN        (-0x07)

   #define AUDIO_SOUND_FADER_MAX         0x07
   #define AUDIO_SOUND_FADER_MIN         (-0x07)

   #define AUDIO_SOUND_BALANCE_MAX       0x07
   #define AUDIO_SOUND_BALANCE_MIN       (-0x07)
#else
   #define AUDIO_SOUND_BASS_MAX          0x09
   #define AUDIO_SOUND_BASS_MIN          (-0x09)

   #define AUDIO_SOUND_TREBLE_MAX        0x09
   #define AUDIO_SOUND_TREBLE_MIN        (-0x09)

   #define AUDIO_SOUND_FADER_MAX         0x09
   #define AUDIO_SOUND_FADER_MIN         (-0x09)

   #define AUDIO_SOUND_BALANCE_MAX       0x09
   #define AUDIO_SOUND_BALANCE_MIN       (-0x09)
#endif
#define AUDIO_SOUND_MID_RANGE_MAX     0x09
#define AUDIO_SOUND_MID_RANGE_MIN     (-0x09)

#define AUDIO_SOUND_LOUDNESS_MAX      0x07
#define AUDIO_SOUND_LOUDNESS_MIN      0x00

#define AUDIO_SOUND_VOLUME_MAX        0x1E
#define AUDIO_SOUND_VOLUME_MIN        0x00

// Default volume should be 30% of the Maximum volume
#define AUDIO_SOUND_VOLUME_REMOTE_CTRL_DEFAULT (AUDIO_SOUND_VOLUME_MAX*0.3)

// Setup volumes max and min values

#define AUDIO_VOLUME_NAVI_SETUP_MAX   0x06
#define AUDIO_VOLUME_NAVI_SETUP_MIN   0x00

#define AUDIO_VOLUME_TA_SETUP_MAX     0x13
#define AUDIO_VOLUME_TA_SETUP_MIN     0x05 // CRQ237 : changed lower limit to 5

#define AUDIO_VOLUME_ONVOL_SETUP_MAX     0x5
#define AUDIO_VOLUME_ONVOL_SETUP_MIN     0x14



/******************************************************************************/
#endif //_AUD_EXCLUDE_BOUNDARY_DEFINES_H_
#endif // _AUD_MSG_TYPES_H_

