///////////////////////////////////////////////////////////
//  PowerStateHandler.h
//  Implementation of the Class PowerStateHandler
//  Created on:      27.12.12
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#if !defined(PowerStateHandler__INCLUDED_)
#define PowerStateHandler__INCLUDED_


#include "../../../InternalComponentCommunication/DataTypes/MessageDataTypes/ApplicationStateData.h"
#include "CCA/aud_CCAMsg.h"
#include "../../general/TypeConverterMap.h"

class fc_audiomanager_tclApp;
class fc_audiomanager_tclService_Audio_Function;


class PowerStateHandler
{

public:
   tVoid addObserver()const;

   PowerStateHandler(fc_audiomanager_tclApp* _poMainAppl, fc_audiomanager_tclService_Audio_Function* poService);

   tVoid handleNewApplicationState(tU32 OldState, tU32 State)const;
   tVoid handleNewVoltageState(tU32 State)const;
   tVoid handleNewCoproState(tU32 State)const;
   tVoid deliverTTFisMessage (tU32 size, tPCUChar pData)const;
   tVoid deliverMessage (ApplicationStateData* pData)const;
private:
   ApplicationStateData m_ApplicationStateDataSet;
   fc_audiomanager_tclApp* m_pCCAMainApplication;
   fc_audiomanager_tclService_Audio_Function* m_pCCAServiceFunc;
};

#endif
