///////////////////////////////////////////////////////////
//  PhoneTypeHandler.h
//  Implementation of the Class PhoneTypeHandler
//  Created on:      20-Jul-2012 12:51:56
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#if !defined(PhoneTypeHandler__INCLUDED_)
#define PhoneTypeHandler__INCLUDED_
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#include "CCA/FI_Message/FI_Includes.h"

#include "CCA/CCA_MASCF_Message_Dispatcher.h"

#include "../../../InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeSourceData.h"

class fc_audiomanager_tclApp;

class PhoneTypeHandler
{
private:
   /**
    * this member configure this object for a specific resource. This must be done, because the incoming status message is used as a source,
    * but don't have any information with it about for which resource it's set.
    * We assume that any phone source is on LS.
    * This can be changed later if necessary  (the constructor must be changed in that case)
    */
   midw_fi_tcl_e8_ResourceNo::tenType m_Resource;
   /**
    * this member configure this object for a specific channel. This must be done, because the incoming status message is used as a source,
    * but don't have any information with it about for which channel it's set.
    * We assume that any phone source is on Exclusive channel.
    * This can be changed later if necessary (the constructor must be changed in that case)
    */
   midw_fi_tcl_e8_AudioChannel::tenType m_Channel;

   tVoid deliverMessage(VolumeSourceData Data)const;
public:
   PhoneTypeHandler(fc_audiomanager_tclApp* _poMainAppl);

   tVoid vHandle_ActivePhoneDeviceStatus(tU8 PhoneType);
   tVoid deliverTTFisMessage(tU32 size, tPCUChar pData)const;
};
#endif
