///////////////////////////////////////////////////////////
//  PhoneTypeHandler.cpp
//  Implementation of the Class PhoneTypeHandler
//  Created on:      20-Jul-2012 12:51:56
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#include "PhoneTypeHandler.h"
#include "InternalCommunicationAdapter.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../../fc_audiomanager_trace.h"
#include "../../../fc_audiomanager_trace_macros.h"
#include "../../../fc_audiomanager_main.h"

#include "../../../InternalComponentCommunication/Messages/Source/IDIntSourceType.h"
#include "../../../InternalComponentCommunication/DataTypes/TypeConverter/SourceTypeConverter.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/PhoneTypeHandler.cpp.trc.h"
#endif

PhoneTypeHandler::PhoneTypeHandler(fc_audiomanager_tclApp* _poMainAppl) :
      m_Resource(midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS), m_Channel(midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC)
{
  (tVoid)_poMainAppl;
}

tVoid PhoneTypeHandler::deliverMessage(VolumeSourceData Data)const
{
   ETG_TRACE_USR4(("PhoneTypeHandler: deliverMessage:"));
   Data.printData();

   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance());
   IDIntSourceType VolumeSourcePOMessage(Data);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&VolumeSourcePOMessage);
}

/*
tVoid PhoneTypeHandler::vOnPhoneTypeStatus(amt_tclServiceData* poMessage)
{
   // dispatch message and send data to registered observer
   CCA_Msg_PhoneTypeStatus Status(*poMessage);
   ETG_TRACE_USR3(("PhoneTypeHandler: Status message incoming: CCA Phone Source: %d",
         ETG_CENUM (midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource::tenType, Status.e8AudioMuteTelephoneSource.enType)));

   SourceTypeConverter* pSourceConverter = SourceTypeConverter::getInstance();
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pSourceConverter);
   tenInternalSource Source = pSourceConverter->getIntSource(
         (midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource::tenType) Status.e8AudioMuteTelephoneSource.enType);

   VolumeSourceData IncomingVolumeSourceData;
   IncomingVolumeSourceData.vSetToDefault();
   IncomingVolumeSourceData.m_Source = Source;
   IncomingVolumeSourceData.m_Resource.setResource(m_Resource);
   IncomingVolumeSourceData.m_Channel = m_Channel;


   ETG_TRACE_USR3(("PhoneTypeHandler::vOnPhoneTypeStatus: delivering message with Source_Type->%d, Resource->%d, Channel->%d",
         Source, m_Resource, m_Channel));

   if (AUD_INT_SRC_UNDEFINED != IncomingVolumeSourceData.m_Source)
   {
     deliverMessage(IncomingVolumeSourceData);
   }
   else
   {
     ETG_TRACE_USR3(("PhoneTypeHandler::vOnPhoneTypeStatus: source undefined, message not delivered"));
   }
}
*/

tVoid PhoneTypeHandler::deliverTTFisMessage(tU32 size, tPCUChar pData)const
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pData);
   ETG_TRACE_USR4(("Incoming TTFis Command: PhoneTypeHandler: Data=0x%02x",ETG_LIST_LEN(size), ETG_LIST_PTR_T8(pData)));

   VolumeSourceData Data;
   Data.vSetToDefault();
   Data.m_Resource.setResource((midw_fi_tcl_e8_ResourceNo::tenType) pData[2]);
   Data.m_Channel = (midw_fi_tcl_e8_AudioChannel::tenType) pData[3];
   Data.m_Source  = (tenInternalSource) pData[4];

   deliverMessage(Data);
}

tVoid PhoneTypeHandler::vHandle_ActivePhoneDeviceStatus(tU8 PhoneType)
{
  ETG_TRACE_USR4(("vHandle_DeviceList_Status, PhoneType : %d", PhoneType));
  SourceTypeConverter* pSourceConverter = SourceTypeConverter::getInstance();
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pSourceConverter);
    tenInternalSource Source = pSourceConverter->getIntSource((tenInternalPhoneTypes)PhoneType);

    VolumeSourceData IncomingVolumeSourceData;
    IncomingVolumeSourceData.vSetToDefault();
    IncomingVolumeSourceData.m_Source = Source;
    IncomingVolumeSourceData.m_Resource.setResource(m_Resource);
    IncomingVolumeSourceData.m_Channel = m_Channel;


    ETG_TRACE_USR3(("PhoneTypeHandler::vOnPhoneTypeStatus: delivering message with Source_Type->%d, Resource->%d, Channel->%d",
        IncomingVolumeSourceData.m_Source, m_Resource, m_Channel));

    if (AUD_INT_SRC_UNDEFINED != IncomingVolumeSourceData.m_Source)
    {
      deliverMessage(IncomingVolumeSourceData);
    }
    else
    {
      ETG_TRACE_USR3(("PhoneTypeHandler::vOnPhoneTypeStatus: source undefined, message not delivered"));
    }
}
