/**
 * @file EngineSoundHandlerIVI.h
 * @brief In A-IVI there are two options - 1) ESE Generated by Head Unit(i.e. ADR3) 2)ESE from Premium II Ext Amp
 * This class specifies the interfaces for these Generators
 * There should be seperate implementations to communicate with differnent generators.
 * @author prm4kor
 * @copyright (c) 2016 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ESEGENERATORIF_H_
#define ESEGENERATORIF_H_

#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "InternalComponentCommunication/Messages/Diag/ID_CCA_GetDiagResult.h"

class EseGeneratorIf
{
public:
   virtual ~EseGeneratorIf() {};
   /**
    * @brief Start up activities
    *
    * @param[in] u8EseSoundType     Active MEX- DriveMode ESE Sound type
    * @param[in] u8EseVolume        Active MEX- DriveMode ESE volume
    * @param[in] u8RSoundOnOff      RSound On/Off status
    * @param[in] u8RSoundType       Active RSound type
    * @param[in] u8RSoundVolume     Active RSound volume
    * @return void
    */
   virtual tBool bStartUp(tU8 u8EseSoundType, tU8 u8EseVolume, tU8 u8RSoundOnOff, tU8 u8RSoundType, tU8 u8RSoundVolume) = 0;
   /**
    * @brief Send ESE On or Off
    *
    * @param[in] bOn TRUE to ON, FASLE to OFF
    * @return void
    */
   virtual tVoid vSendESEOnOff(tBool bOn) = 0;

   /**
    * @brief Get ESE On/Off status from ESE Generator
    *
    * @param[in] bOn TRUE to ON, FASLE to OFF
    * @return void
    */
   virtual tVoid vRequestESEOnOffStatus() = 0;

   /**
    * @brief New sound type selected
    *
    * @param[in] u8SoundType New sound type
    * @param[in] u8Volume Volume for the new sound type
    * @return void
    */
   virtual tVoid vSendESESoundType(tU8 u8SoundType, tU8 u8Volume) = 0;

   /**
    * @brief volume updated
    *
    * @param[in] u8Volume Volume for the new sound type
    * @return void
    */
   virtual tVoid vSendESEVolume(tU8 u8Volume) = 0;

   /**
    * @brief New R-Sound sound type selected
    *
    * @param[in] u8SoundType New sound type
    * @param[in] u8Volume Last R-Sound volume selected
    * @return void
    */
   virtual tVoid vSendRSoundType(tU8 u8SoundType, tU8 u8Volume) = 0;

   /**
    * @brief volume updated for R-Sound
    *
    * @param[in] Send R-Sound volume
    * @return void
    */
   virtual tVoid vSendRSoundVolume(tU8 u8Volume) = 0;

   /**
    * @brief Get volume status from ESE Generator
    *
    * @param[in] Send R-Sound volume
    * @return void
    */
   virtual tVoid vRequestESEVolumeStatus() = 0;

   /**
    * @brief Confirmation that the data is sent over INC/CAN (mainly for the ADR interface)
    *
    * @return void
    */
   virtual tVoid vDataCon() = 0;

   /**
    * @brief Special function to load ESE configuration data to ESE-Lib. Required for Tuning Service
    * This will be implemented by ADR3 interface, not really required for Ext Amp interface
    *
    * @return void
    */
   virtual tVoid vLoadESEParameter(tU8* pu8Data, tU32 u32Size) = 0;
};
#endif //ESEGENERATORIF_H_
