/**
 * @file EngineSoundHandlerIVI.cpp
 * @brief Implement the interface to External amplifier to send the ESE related commands
 * @author prm4kor
 * @copyright (c) 2016 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>
#include "fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_ENGINESOUND
#include "trcGenProj/Header/EseGeneratorExtAmp.cpp.trc.h"
#endif

#include "EseGeneratorExtAmp.h"
#include "EngineSoundConfigIVI.h"
#include "vd_adr3Msg_If.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3Settings.h"
#include "InternalComponentCommunication/Messages/settings/IDSettings.h"
#include "InternalComponentCommunication/Messages/BOSE_Amp/ID_BOSE_Amplifier_ConnectionStatus.h"

#define MAKE_RSOUND_VOL(volume) (volume+ENGINESOUND_VOLUME_HIGH)

EseGeneratorExtAmp::EseGeneratorExtAmp():
                     IF_MessageObserver<PO_MessageConfig::enID>("Engine Sound ExtAmp Observer"),
                     m_u8EseSoundTypeReq(ENGINESOUND_SOUNDTYPE_NEUTRAL),
                     m_u8EseSoundVolumeReq(ENGINESOUND_VOLUME_OFF)
{
   ETG_TRACE_USR4(("EseGeneratorExtAmp interface created"));
   InternalCommunicationAdapter::getInstance()-> POMessages->AddObserver(this, PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus);
}

EseGeneratorExtAmp::~EseGeneratorExtAmp()
{
   InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
}

tBool EseGeneratorExtAmp::bStartUp(tU8 u8EseSoundType, tU8 u8EseVolume, tU8 u8RSoundOnOff, tU8 u8RSoundType, tU8 u8RSoundVolume)
{
   m_u8EseSoundTypeReq   =  u8EseSoundType;
   m_u8EseSoundVolumeReq = (tU8)(m_u8EseSoundTypeReq == ENGINESOUND_SOUNDTYPE_NEUTRAL) ? ((tU8)(ENGINESOUND_VOLUME_OFF)) : u8EseVolume;//for neutral sound type, send volume step as OFF

   if(RSOUND_ONOFF_ON == u8RSoundOnOff)
   {
      m_u8EseSoundTypeReq   = u8RSoundType;
      m_u8EseSoundVolumeReq = (tU8) ((u8RSoundVolume != 0) ? (MAKE_RSOUND_VOL(u8RSoundVolume)) : ENGINESOUND_VOLUME_OFF);//if vol step is 0, send volume value as OFF
   }

   vSendSettingMessage(EN_AUDIO_SETTINGS_ESE_SOUNDTYPE,(tS16)m_u8EseSoundTypeReq);
   vSendSettingMessage(EN_AUDIO_SETTINGS_ESE_SOUNDVOLUME,(tS16)m_u8EseSoundVolumeReq);

   return TRUE;
}

tVoid EseGeneratorExtAmp::vSendESEOnOff(tBool bOn)
{
   (tVoid)bOn;
}

tVoid EseGeneratorExtAmp::vRequestESEOnOffStatus()
{
}

tVoid EseGeneratorExtAmp::vSendESESoundType(tU8 u8SoundType, tU8 u8Volume)
{
   m_u8EseSoundTypeReq     = u8SoundType;
   m_u8EseSoundVolumeReq = (tU8)(m_u8EseSoundTypeReq == ENGINESOUND_SOUNDTYPE_NEUTRAL) ?((tU8)(ENGINESOUND_VOLUME_OFF)) : u8Volume;//for neutral sound type, send volume step as OFF

   vSendSettingMessage(EN_AUDIO_SETTINGS_ESE_SOUNDTYPE,(tS16)u8SoundType);
   vSendSettingMessage(EN_AUDIO_SETTINGS_ESE_SOUNDVOLUME,(tS16)m_u8EseSoundVolumeReq);
}

tVoid EseGeneratorExtAmp::vSendESEVolume(tU8 u8Volume)
{
   m_u8EseSoundVolumeReq   = u8Volume;

   vSendSettingMessage(EN_AUDIO_SETTINGS_ESE_SOUNDVOLUME,(tS16)u8Volume);
}

tVoid EseGeneratorExtAmp::vSendRSoundType(tU8 u8SoundType, tU8 u8Volume)
{
   m_u8EseSoundTypeReq     = u8SoundType;
   m_u8EseSoundVolumeReq   = (tU8) ((u8Volume != 0) ? (MAKE_RSOUND_VOL(u8Volume)) : ENGINESOUND_VOLUME_OFF);//if vol step is 0, send volume value as OFF

   vSendSettingMessage(EN_AUDIO_SETTINGS_ESE_SOUNDTYPE,(tS16)u8SoundType);
   vSendSettingMessage(EN_AUDIO_SETTINGS_ESE_SOUNDVOLUME,(tS16)(m_u8EseSoundVolumeReq));
}

tVoid EseGeneratorExtAmp::vSendRSoundVolume(tU8 u8Volume)
{
   m_u8EseSoundVolumeReq   = (tU8) ((u8Volume != 0) ? (MAKE_RSOUND_VOL(u8Volume)) : ENGINESOUND_VOLUME_OFF);//if vol step is 0, send volume value as OFF

   vSendSettingMessage(EN_AUDIO_SETTINGS_ESE_SOUNDVOLUME,(tS16)(m_u8EseSoundVolumeReq));
}

tVoid EseGeneratorExtAmp::vRequestESEVolumeStatus()
{
}

tVoid EseGeneratorExtAmp::vLoadESEParameter(tU8* pu8Data, tU32 u32Size)
{
   (tVoid)pu8Data;
   (tVoid)u32Size;
}

tVoid EseGeneratorExtAmp::vDataCon()
{
}

tVoid EseGeneratorExtAmp::vSendSettingMessage(tU8 u8SettingType, tS16 s16Value)
{
   MSG_Settings oEseSettings(EN_AUDIO_SOURCE_STREAM_MAIN, (tenSettingType)u8SettingType, s16Value);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oEseSettings);
}

void EseGeneratorExtAmp::MessageNotification(PO_MessageConfig::enID MsgId)
{
   if(PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus == MsgId)
   {
     const ID_BOSE_Amplifier_ConnectionStatus* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_BOSE_Amplifier_ConnectionStatus>(MsgId);
     if(pMsg)
     {
       if(pMsg->connectionstate) //Preimum2 MCAN Bose amplifier configuration
       {
         vSendSettingMessage(EN_AUDIO_SETTINGS_ESE_SOUNDTYPE,(tS16)m_u8EseSoundTypeReq);
         vSendSettingMessage(EN_AUDIO_SETTINGS_ESE_SOUNDVOLUME,(tS16)m_u8EseSoundVolumeReq);
       }
     }
   }
}
