/**
 * @file EngineSoundHandlerIVI.h
 * @brief Implementation of interface EseGeneratorIf for ADR3
 * @author prm4kor
 * @copyright (c) 2016 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ESEGENERATORADR_H_
#define ESEGENERATORADR_H_

#include "EseGeneratorIf.h"
#include "EngineSoundConfigIVI.h"
#include "EngineSoundMsgQueue.h"
#include "EseHardCodedData.h"

class EseGeneratorAdr : public EseGeneratorIf, public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
   EseGeneratorAdr();
   ~EseGeneratorAdr();

   //post office related functions
   void MessageNotification(PO_MessageConfig::enID MsgId);
   void vAddObserver();
   tBool bStartUp(tU8 u8EseSoundType, tU8 u8EseVolume, tU8 u8RSoundOnOff, tU8 u8RSoundType, tU8 u8RSoundVolume);

   tVoid vSendESEOnOff(tBool bOn);
   tVoid vRequestESEOnOffStatus();
   tVoid vSendESESoundType(tU8 u8SoundType, tU8 u8Volume);
   tVoid vSendESEVolume(tU8 u8Volume);
   tVoid vSendRSoundType(tU8 u8SoundType, tU8 u8Volume);
   tVoid vSendRSoundVolume(tU8 u8Volume);
   tVoid vRequestESEVolumeStatus();
   tVoid vDataCon();
   tVoid vLoadESEParameter(tU8* pu8Data, tU32 u32Size);

private:
   EngineSoundMsgQueue* m_pMsgQueue;

   tU8 m_DatapoolData[ENGINE_SOUND_DATA_SIZE_BYTES];
   tU8 m_u8ReqMexSoundType; //Last MEX ESE Sound type requested from HMI (not necessarily the last one downloaded to ADR3)
   tU8 m_u8ActiveSoundType; //Last sound type downloaded to ADR3 -> Can be Mex/RSound -> Also depends on volume level (for MEX)

   tU8 m_u8DatapoolReadStatus;
   tBool m_bESEVersionCheckStatus;
   tS16 m_s16VolumeOffset;
   //vector for storing version map values
   std::vector <tESEVersionMap> ESEVersionMapValuesVector;

   tVoid vSendVolumeOffset(tS16 s16Volume);
   tVoid vUpdateEseSettings(tU8 u8Soundtype, tU8 u8Volume);
   tU8* getDataPtr(tU8 u8SoundType);
   tVoid vStartupNotification();
   tVoid vFileNotification(tU8 fileId, tU32 fileVersion, tU32 checksum);
   tVoid vRequestFileInfo();
   tBool bCompareVersion(tU32 u32ESELibVersion);
};
#endif //ESEGENERATORADR_H_
