/**
 * @file EngineSoundHandlerIVI.h
 * @author pau4kor
 * @copyright (c) 2016 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ENGINESOUNDHANDLER_IVI_H_
#define ENGINESOUNDHANDLER_IVI_H_

#include "fc_audiomanager_main.h"
#include "EngineSoundConfigIVI.h"
#include "EngineSoundModel.h"
#include "EseGeneratorIf.h"
#include "aud_sinkmanager/vd_adr3/vd_adr3Message_Data.h"
#include "fc_audiomanager_service_Audio_Function.h"

class EngineSoundHandlerIVI: public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
  static EngineSoundHandlerIVI* getInstance();
  ~EngineSoundHandlerIVI();

  void vHandleTTFisCmd(tU32 size, tPCUChar pcu8Data);
  tBool bStartup(fc_audiomanager_tclApp* poMainAppl);
  void MessageNotification(PO_MessageConfig::enID MsgId);
  tVoid vOnLoadSettings();

  void vAdrReady(enMsgType msgType);

  tBool bGetStatusMessage(tU16 u16FunctionId, amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg) const;
  tBool bProcessSet(tU16 u16FunctionID, fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);

   //Interfaces for the Tuning tool
   tVoid vSendESEOnOff(tBool bOn);
   tVoid vRequestESEOnOffStatus();
   tVoid vSendRSoundVolume(tU8 u8Volume);
   tVoid vRequestESEVolumeStatus();
   void vLoadESEParameter(tU8* pu8Data, tU32 u32Size);

private:
  EngineSoundHandlerIVI();
  EngineSoundHandlerIVI(const EngineSoundHandlerIVI&);              // Prohibit use of copy constructor    (Rule of three)
  EngineSoundHandlerIVI& operator =(const EngineSoundHandlerIVI&);  // Prohibit use of assignment operator (Rule of three)

   tVoid vReadKDSConfigurations();

  tBool bSetESESoundType(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);
  tBool bSetESEVolumeLevel(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetESEDriveMode(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);

   tBool bSetRSoundOnOff(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetRSoundType(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetRSoundVolume(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetRSoundActivation(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);

   tBool bSendESESoundTypeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
   tBool bSendESEVolumeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
   tBool bSendESEDriveModeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;

   tBool bSendRSoundOnOffStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
   tBool bSendRSoundTypeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
   tBool bSendRSoundVolumeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
   tBool bSendRSoundActivationStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;

  fc_audiomanager_tclApp        *m_poMainAppl;

   //Properties related to KDS configurations
   tU8 m_u8EseActivation;
   tU8 m_u8OutputInformation;
   tU8 m_u8EseHMI;
   tU8 m_u8EseSupport;

   EseGeneratorIf* m_pEseGeneratorIf;
   EngineSoundModel m_oEseModel;

   //for Diaglog
   IF_DiagResultHandler* m_poResultHandler;
   tVoid vSendTestResultToDiaglog();
};

#endif //ENGINESOUNDHANDLER_IVI_H_
