/**
 * @file fcaudiomanager_Speaker_Diagnosis.h
 * @author CM-AI wie1hi
 * @copyright (c) 2014 Robert Bosch Car Multimedia GmbH
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef FCAUDIOMANAGER_SPEAKER_DIAGNOSIS_H_
#define FCAUDIOMANAGER_SPEAKER_DIAGNOSIS_H_

//#define OSAL_S_IMPORT_INTERFACE_GENERIC
//#include "osal_if.h"

//#define SYSTEM_S_IMPORT_INTERFACE_QUEUE
//#include <stl_pif.h>



#include <queue>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "InternalCommunicationAdapter.h"
//#include "../InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_VolumeStatus.h"
//#include "../InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_Volume.h"
//#include "../InternalComponentCommunication/Messages/Diag/IDNotifyDiagResult.h"
#include "../fc_audiomanager_service_Audio_Function.h"


class SpeakerDiagnosisResultList
{
public:
   tenErrorSite enErrorSite;
   std::vector<std::pair<tenErrorCode, tenErrorValue> > DetailList;
};


class fc_audiomanager_tclSpeaker_Diagnosis
      : public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
   /**
    * Get results of last diagnosis speaker measurement
    *
    * @param[out] outMeasurementResult pointer to target variable
    */
   tVoid GetTestResult(midw_mascffi_tclMsgReadMeasurementResultStatus *outMeasurementResult);
   tVoid SetDiagMode(midw_fi_tcl_e8_DiagMode::tenType modeDC, midw_fi_tcl_e8_DiagMode::tenType modeAC);
   tVoid SetDiagMode(tenSpeakerModeDC modeDC, tenSpeakerModeAC modeAC);

   tVoid deliverTTFisMessage (tU32 size, tPCUChar pData);
   void vStartDiagTest(tU8 uSpeakerModeDC = EN_AUDIO_DIAG_DC_OFF, tU8 enSpeakerModeAC= EN_AUDIO_DIAG_AC_OFF, tU8 enSpeakerModePERM = EN_AUDIO_DIAG_PERM_CONTINUOUS_QUALIFIED);
   void vOnAbortDiagTest();
   void vSetDiagTestStatus(tenDiagnosisStatus enDiagnosisStatus);
   void vCheckDiagStatus();

   // constructor/destructor
   fc_audiomanager_tclSpeaker_Diagnosis(fc_audiomanager_tclService_Audio_Function* poService);
   virtual ~fc_audiomanager_tclSpeaker_Diagnosis();

   // PostOffice
   virtual void MessageNotification(PO_MessageConfig::enID MsgId);
   void vAddObserver();

   InternalCommunicationAdapter* pPO; // Pointer for post office access

   // Conversion
   static tenSpeakerModeDC                 speakerModeFi2ADR_DC(midw_fi_tcl_e8_DiagMode::tenType fiMode);
   static tenSpeakerModeAC                 speakerModeFi2ADR_AC(midw_fi_tcl_e8_DiagMode::tenType fiMode);
   static midw_fi_tcl_e8_DiagMode::tenType speakerModeADR2Fi_DC(tenSpeakerModeDC adrMode);
   static midw_fi_tcl_e8_DiagMode::tenType speakerModeADR2Fi_AC(tenSpeakerModeAC adrMode);

private:
   fc_audiomanager_tclSpeaker_Diagnosis(tVoid);
   fc_audiomanager_tclService_Audio_Function *m_poAudioService;
   midw_mascffi_tclMsgReadMeasurementResultStatus mReadMeasurementResultStatus;
   midw_fi_tcl_e8_DiagMode mDiagModeDC;
   midw_fi_tcl_e8_DiagMode mDiagModeAC;

   static tBool bStartDiagTest;
   tU8 m_u8SoundSystemconfig;
   static midw_fi_tcl_e8_Aud_DataId::tenType SiteADRToFi(tenErrorSite adrErrorSite);
   void vHandleSoundSystemConfig(PO_MessageConfig::enID MsgId);
};

#endif /* FCAUDIOMANAGER_SPEAKER_DIAGNOSIS_H_ */
