/*******************************************************************************
* FILE:          fc_audiomanager_DiaglogClientHandler_Temp.cpp
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   ClientHandler for the Diaglog service of the Diagnosis
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 27.09.12  | SoftTec Gaidatzi-Lken  | Inital version
*******************************************************************************/

/*******************************************************************************
                        Includes
*******************************************************************************/

#include "InternalCommunicationAdapter.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/ADR3DiagType.h"
#include "../InternalComponentCommunication/Messages/Diag/IDGetDiagResult.h"
#include "../InternalComponentCommunication/Messages/Diag/IDNotifyDiagResult.h"
#include "../fc_audiomanager_service_Audio_Function.h"
#include "fc_audiomanager_DiaglogClientHandler_Temp.h"
#include "fc_audiomanager_trace.h"
#include "aud_sinkmgr_Gpio_If.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_AUDIO_DIAGNOSIS
#include "trcGenProj/Header/fc_audiomanager_DiaglogClientHandler_Temp.cpp.trc.h"
#endif

/*******************************************************************************
                  Specific defines for this component
*******************************************************************************/


/*******************************************************************************
                  Methods of class
*******************************************************************************/


/*******************************************************************************
**  FUNCTION:
*   fc_audiomanager_tclDiaglogClientHandler_Amplifier();
*   Constructor
*******************************************************************************/
fc_audiomanager_tclDiaglogClientHandler_Amplifier::fc_audiomanager_tclDiaglogClientHandler_Amplifier(
   fc_audiomanager_tclApp* poMainAppl)
   : IF_MessageObserver<PO_MessageConfig::enID>("fc_audiomanager_tclDiaglogClientHandler_Amplifier")
{
    //s16TimerSecCnt = 0;
    m_poMainAppl = poMainAppl;

    bSendNextTestResult_AmpTemp = TRUE;
    enLastAmpTempResult = 1; //Test is passed

    poResultHandler = NULL;

    // register for diagnosis request and result
    if (InternalCommunicationAdapter::POMessages)
    {
       InternalCommunicationAdapter::POMessages->AddObserver(this, PO_MessageConfig::ID_CCA_GetDiagResult);
       //InternalCommunicationAdapter::POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyDiagResult);
    }

    ETG_TRACE_USR1(("fc_audiomanager_tclDiaglogClientHandler_Amplifier established"));

    /*
    DiagnosisResult (0xF91)
    DiagnosisResultList
        DiagnosisErrorSide Amplifier_Device
        DiagnosisErrorCode THERMAL_WARNING
*/

}


/*******************************************************************************
** FUNCTION:   virtual ~fc_audiomanager_tclClientHandler_diaglogTemp();
*  Destructor
*******************************************************************************/
fc_audiomanager_tclDiaglogClientHandler_Amplifier
      ::~fc_audiomanager_tclDiaglogClientHandler_Amplifier(tVoid)
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);

   poResultHandler = NULL;
   m_poMainAppl = NULL;
}


/*******************************************************************************
** FUNCTION:   virtual tVoid vOnServiceAvailable();
*******************************************************************************/
/* virtual */ void fc_audiomanager_tclDiaglogClientHandler_Amplifier :: MessageNotification(PO_MessageConfig::enID enMsgID)
{
   ETG_TRACE_USR3(("MessageNotification received for MsgID %u", enMsgID))

   switch (enMsgID)
   {
      case PO_MessageConfig::ID_CCA_GetDiagResult:
      {
         // request DTC / ITC from Amplifier and ADR3
         const ID_CCA_GetDiagResult* poMsg
            = InternalCommunicationAdapter::POMessages->QueryMessage<ID_CCA_GetDiagResult>(enMsgID);
         if (NULL == poMsg)
         {
            ETG_TRACE_FATAL(("MessageNotification - could not retrieve message pointer for ID_CCA_GetDiagResult"))
            return;
         }
         poResultHandler = &(poMsg->roResultHandler);

         //only at the beginning of the application if the service is available has to send the TestResult to the diagnosis
         if (bSendNextTestResult_AmpTemp)
         {
            ETG_TRACE_USR3(( "bSendNextTestResult_AmpTemp = TRUE "));
            //Send the GetDiagResult Message to vd_adr3
            fc_audiomanager_tclService_Audio_Function* poAudioFunction = m_poMainAppl -> pGetAudioFunctionptr();
            NORMAL_M_ASSERT(poAudioFunction != OSAL_NULL);
            if (poAudioFunction != OSAL_NULL)
            {
               poAudioFunction -> vRequestDiagResult(EN_AUDIO_DIAG_AMPLIFIER);
            }
         }
      }
      break;

      default:
      {
         ETG_TRACE_FATAL(("MessageNotification - unexpected MsgID %u received", enMsgID))
      }
      break;
   }
}


/*******************************************************************************
*                  Specific functions of this application
*******************************************************************************/

/*******************************************************************************
** FUNCTION:   tVoid vSaveTestResult();
* Save the Test Results to the CCA Msg for later sending to Diaglog
*******************************************************************************/

tVoid fc_audiomanager_tclDiaglogClientHandler_Amplifier::vSaveTestResult(tU16 u16TroubleCode, tS16 sResult)
{
   tTestResult oTestData;

   oTestData.u16ID = u16TroubleCode;

   if (1 == sResult)
   {
      oTestData.enResult = EN_PASSED;
      ETG_TRACE_USR3(("vSaveTestResult():=> Diagnosis Test Result = PASSED"));

   }
   else if (0 == sResult)
   {
      oTestData.enResult = EN_FAILED;
      ETG_TRACE_USR3(("vSaveTestResult():=> Diagnosis Test Result = FAILED"));
   }
   else if (-1 == sResult)
   {
      oTestData.enResult = EN_NORESULT;
      ETG_TRACE_USR3(("vSaveTestResult():=> Diagnosis Test Result = NO RESULT"));
   }

   //add the testData to the TestResultList
   oFiTestResultObject.push_back(oTestData);
}

/*******************************************************************************
** FUNCTION:   tVoid vSendTestResultToDiaglog();
* Send all the Test Results to Diaglog (1 CCA Msg for all results together)  (Method of this application)
*******************************************************************************/

tVoid fc_audiomanager_tclDiaglogClientHandler_Amplifier::vSendTestResultToDiaglog(tVoid)
{
   if (NULL == poResultHandler)
   {
      ETG_TRACE_FATAL(("DiagLog result handler not set"))
      return;
   }

   ETG_TRACE_USR3(("vSendTestResultToDiaglog - sending %u results", oFiTestResultObject.size()))
   if (oFiTestResultObject.size())
   {
      poResultHandler->vSaveDiagResult(oFiTestResultObject);
      oFiTestResultObject.clear();
   }
}


/*******************************************************************************
 *                  Amplifier Temperature functions
 *******************************************************************************/

/*******************************************************************************
* FUNCTION:   vSend_AmpTempResultToDiaglog(tenErrorSite enErrorSite, tenErrorCode enErrorCode, tenErrorValue enErrorValue)
*******************************************************************************/


tVoid fc_audiomanager_tclDiaglogClientHandler_Amplifier::vSend_AmpTempResultToDiaglog(tenErrorSite enErrorSite, tenErrorCode enErrorCode, tenErrorValue enErrorValue) const
{
    #ifdef VDL_ITC_HEATCTRL_WARNING_TEMPERATURE_AMPLIFIER
  tU16 u16TroubleCode = VDL_ITC_HEATCTRL_WARNING_TEMPERATURE_AMPLIFIER;

    tS16 sResult = 1; //Test is passed

    ETG_TRACE_USR3(("send_diagResultToDiaglog received enErrorSite: 0x%4x.", enErrorSite));
    ETG_TRACE_USR3(("send_diagResultToDiaglog received enErrorCode: 0x%4x.", enErrorCode));
  ETG_TRACE_USR3(("send_diagResultToDiaglog received enErrorValue: 0x%4x.", enErrorValue));

    if (enErrorSite != EN_AUDIO_DIAG_AMPLIFIER)
    {
        ETG_TRACE_ERR(("send_diagResultToDiaglog received wrong enErrorSite: 0x%4x.", enErrorSite));
        sResult = -1; //No Result for this Test
    }

    if (enErrorCode == EN_AUDIO_DIAG_ERR_THERMAL_WARNING)
    {
        sResult = 0; //Test is failed (Amplifier is too warm)
    }
    else if (enErrorCode == EN_AUDIO_DIAG_NO_ERROR)
    {
       ; //tS16 sResult = 1; //Test is passed
    }
    else
    {
        sResult = -1; //No Result for this Test
    }

    if ((sResult != enLastAmpTempResult) || bSendNextTestResult_AmpTemp)
    {
if(bSendNextTestResult_AmpTemp)
ETG_TRACE_USR3(( "bSendNextTestResult_AmpTemp = TRUE "));

        vSaveTestResult(u16TroubleCode, sResult);
        vSendTestResultToDiaglog();

        enLastAmpTempResult = sResult;

        if (bSendNextTestResult_AmpTemp)
        {
            bSendNextTestResult_AmpTemp = FALSE;
ETG_TRACE_USR3(( "bSendNextTestResult_AmpTemp = FALSE "));
        }

    }
  #endif

    ETG_TRACE_USR3(("---enErrorSite = %x ",enErrorSite));
    ETG_TRACE_USR3(("---enErrorCode = %x ",enErrorCode));
  ETG_TRACE_USR3(("---enErrorValue = %x ",enErrorValue));
}

