/*******************************************************************************
* FILE:          fc_audiomanager_DiaglibHandler_ExtAmpControlLine.h
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Implementation of a IOControl listener.
* This handler implements the Linear Mode of the Diagnosis.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 18.04.13  | SoftTec Gaidatzi-Lken  | Inital version
*******************************************************************************/

// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++
#ifndef FC_AUDIOMANAGER_DIAGLIBHANDLER_EXTAMPCONTROLLINE_H
#define FC_AUDIOMANAGER_DIAGLIBHANDLER_EXTAMPCONTROLLINE_H


// +++ Adjust class prefix +++
class fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine: public diaglib::tclIoControlListenerIF
{
public:
   // +++ Depending on the type of listener you need the associated interface to send responses +++
   fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine(diaglib::tclServiceDiaglib*   pDiaglibService);
   virtual ~fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine();

   // +++ Place the virtual listener functions here. These depend on the listener you implement +++
   /***************************************************************************
    * RoutineControl methods
    ***************************************************************************/
  virtual tU32 vOnIoControl (
                               tU32 u32IoControlId,
                               diaglib::tenIoControlAction enActionId,
                               const diaglib::tclParameterVector& oParameterVector,
                               diaglib::tContext MsgContext
                             );
   virtual tU32 vOnIoControlFreeze (
                                     tU32 u32IoControlId,
                                     diaglib::tContext MsgContext
                                   );

   virtual tU32 vOnIoControlUnfreeze (
                                        tU32 u32IoControlId,
                                        diaglib::tContext MsgContext
                                      );

private:
  diaglib::tclServiceDiaglib*  mpDiaglibService;

  fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine();//lint !e1704 Info 1704 , eliminating lint warnings
};
#endif // FC_AUDIOMANAGER_DIAGLIBHANDLER_EXTAMPCONTROLLINE_H
