/*******************************************************************************
* FILE:          fc_audiomanager_DiaglibHandler_ExtAmpControlLine.cpp
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Implementation of a IOControl listener.
* This handler implements the External Amplifier Control Line of the Diagnosis.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 18.04.13  | SoftTec Gaidatzi-Lken  | Inital version
*******************************************************************************/


// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_IO_CONTROL
#include "diaglib_if.h"

#include "fc_audiomanager_DiaglibHandler_ExtAmpControlLine.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/DiagControlLineType.h"
#include "../../PostOffice/PostOffice.hpp"
#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../InternalComponentCommunication/Messages/Diag/IDDiagControlLine.h"


#include "fc_audiomanager_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_AUDIO_DIAGNOSIS
#include "trcGenProj/Header/fc_audiomanager_DiaglibHandler_ExtAmpControlLine.cpp.trc.h"
#endif



/*******************************************************************************
**  FUNCTION:
*   fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine(
*                                    diaglib::tclServiceDiaglib* pDiaglibService)
*                                    : mpDiaglibService(pDiaglibService)
*   Constructor
*******************************************************************************/

fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine(
                                      diaglib::tclServiceDiaglib* pDiaglibService)
                                        : mpDiaglibService(pDiaglibService)
{
#ifdef IOCONTROLID_AUDIO_EXT_AMPLIFIER
   if(mpDiaglibService != NULL)
   {
      mpDiaglibService->poGetIoCtrl()->vRegisterListener(IOCONTROLID_AUDIO_EXT_AMPLIFIER, this);
      ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine => vRegisterListener(IOCONTROLID_AUDIO_EXT_AMPLIFIER) "));
   }
   else
   {
      ETG_TRACE_FATAL(( "fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine constructor: diaglib pointer is NULL" ));
      FATAL_M_ASSERT_ALWAYS();
   }

#endif
}



/*******************************************************************************
**  FUNCTION:
*   ~fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine()
*   Destructor
*******************************************************************************/
fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::~fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine()
{
   mpDiaglibService = NULL;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControl(tU32 u32IoControlId, diaglib::tenIoControlAction enActionId,
*                 const diaglib::tclParameterVector& oParameterVector,diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for set Phantom Voltage request
*******************************************************************************/
tU32 fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControl (
                                                             tU32 u32IoControlId,
                                                             diaglib::tenIoControlAction enActionId,
                                                             const diaglib::tclParameterVector& oParameterVector,
                                                             diaglib::tContext MsgContext
                                                           )
{
   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControl entered"));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_NOT_OK;

   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( enActionId );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( MsgContext );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( oParameterVector )
   // check for expected Routine ID

#ifdef IOCONTROLID_AUDIO_EXT_AMPLIFIER
   switch(u32IoControlId)
   {

   case IOCONTROLID_AUDIO_EXT_AMPLIFIER:
      {
         ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControl => IOCONTROLID_AUDIO_EXT_AMPLIFIER"));

         // create object for response
         diaglib::tclParameterVector oTmpVec;

         // answer beginn

         if(diaglib::bCheckParameterSignature(oParameterVector,
                                              IOCONTROLID_AUDIO_EXT_AMPLIFIER_SET_LEN,
                                              IOCONTROLID_AUDIO_EXT_AMPLIFIER_SET_PARAM1) == FALSE)
         {
            ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControl => ERROR: bCheckParameterSignature FAILED"));
            oCtrlResult = diaglib::EN_IO_CONTROL_NOT_OK; // Control failed

            diaglib::trParameter paramaError;
            paramaError.enType         = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
            paramaError.u8Value        = diaglib::EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE;
            oTmpVec.push_back(paramaError);
         }// if(diaglib::bCheckParameterSignature(oParamVector, ...
         else
         {
             // get Data
             tBool bControlLine = oParameterVector[IOCONTROLID_AUDIO_EXT_AMPLIFIER_SET_u8SendAudioExt_ControlLine].u8Value; //1=enable, 0=dissable

             //Send the DiagExtAmpControlLine Message to all fc_audimanager subcomponents
             //ID_DiagExtAmpControlLine DiagExtAmpControlLineMsg(tenDiagExtAmpControlLinePhase(EN_ExtAmpControlLine_SET));
             if (bControlLine)//1=enable
             {
                 ID_DiagControlLine DiagControlLineMsg(EN_CONTROLLINE_SET_ON);

                 ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControl => DeliverMsg(ID_DiagExtAmpControlLine(EN_CONTROLLINE_SET_ON)) is sent"));
                 InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&DiagControlLineMsg);
             }
             else //0=dissable
             {
                 ID_DiagControlLine DiagControlLineMsg(EN_CONTROLLINE_SET_OFF);

                 ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControl => bMode is dissable, DeliverMsg(ID_DiagExtAmpControlLine(EN_CONTROLLINE_SET_OFF)) is sent"));
                 InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&DiagControlLineMsg);
             }


             oCtrlResult = diaglib::EN_IO_CONTROL_OK; // data valid
             diaglib::trParameter paramaStatus;
             paramaStatus.enType         = static_cast<diaglib::tenParameterType>(IOCONTROLID_AUDIO_EXT_AMPLIFIER_RESULT_PARAM1);
             paramaStatus.u8Value        = bControlLine;
             oTmpVec.push_back(paramaStatus);

         }



         // send message back to diagnosis
         if(mpDiaglibService != OSAL_NULL)
         {
            if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlMethodResult( oCtrlResult,
                                                                                 enActionId,
                                                                                 oTmpVec,
                                                                                 MsgContext) )
            {
               u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
               ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControl => bSendIoCtrlMethodResult successfull"));
            }// if(TRUE == mpDiaglibService->poGetIoCtrl()
            else
            {
               u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
               ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControl => ERROR : bSendRoutineCtrlMethodResult failed"));
            }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
         }// if(mpDiaglibService != OSAL_NULL)
         else
         {
            u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
            ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControl => ERROR : mpDiaglibService == OSAL_NULL"));
         }// else // if(mpDiaglibService != OSAL_NULL)
         break;

      }// case IOCONTROLID_AUDIO_EXT_AMPLIFIER:

      default:
      {
         break;
      }// default:
   }// switch(u32IoControlId)
#endif
   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControl(%x)",u32Return));
   ETG_TRACE_USR3(("---oCtrlResult = %d ",oCtrlResult));
   ETG_TRACE_USR3(("---u32IoControlId = %d ",u32IoControlId));

   return u32Return;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControlFreeze ( tU32 u32IoControlId, diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for Freeze the State before the Diagnosis Request
*                (not implemented in the diagnosis)
*******************************************************************************/
tU32 fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControlFreeze (
                                              tU32 u32IoControlId,
                                              diaglib::tContext MsgContext
                                            )
{
  (void)u32IoControlId;
   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControlFreeze"));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_OK;

   //Send the DiagControlLine Message to all fc_audimanager subcomponents
   ID_DiagControlLine DiagControlLineMsg(EN_CONTROLLINE_FREEZE);

   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControl => DeliverMsg(ID_DiagControlLine(EN_CONTROLLINE_FREEZE)) is sent"));
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&DiagControlLineMsg);

   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlFreezeResult( oCtrlResult,
                                                                           MsgContext) )
      {

         u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
         ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControlFreeze => bSendIoCtrlFreezeResult successfull"));

      }// if(TRUE == mpDiaglibService->poGetIoCtrl()
      else
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControlFreeze => ERROR : bSendRoutineCtrlMethodResult failed"));
      }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
   }// if(mpDiaglibService != OSAL_NULL)
   else
   {
      u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
      ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControlFreeze => ERROR : mpDiaglibService == OSAL_NULL"));
   }// else // if(mpDiaglibService != OSAL_NULL)

   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControlFreeze(%x)",u32Return));

   return u32Return;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControlUnfreeze ( tU32 u32IoControlId, diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for Unfreeze the State before the Diagnosis Request
*
*******************************************************************************/
tU32 fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControlUnfreeze (
                                              tU32 u32IoControlId,
                                              diaglib::tContext MsgContext
                                            )
{
  (void)u32IoControlId;
   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControlUnfreeze"));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_OK;

   //Send the DiagExtAmpControlLine Message to all fc_audimanager subcomponents
   ID_DiagControlLine DiagControlLineMsg(EN_CONTROLLINE_UNFREEZE);

   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControl => DeliverMsg(ID_DiagExtAmpControlLine(EN_CONTROLLINE_UNFREEZE)) is sent"));
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&DiagControlLineMsg);

   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlUnfreezeResult( oCtrlResult,
                                                                             MsgContext) )
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
         ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControlUnfreeze => bSendIoCtrlFreezeResult successfull"));

      }// if(TRUE == mpDiaglibService->poGetIoCtrl()
      else
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControlUnfreeze => ERROR : bSendRoutineCtrlMethodResult failed"));
      }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
   }// if(mpDiaglibService != OSAL_NULL)
   else
   {
      u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
      ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControlUnfreeze => ERROR : mpDiaglibService == OSAL_NULL"));
   }// else // if(mpDiaglibService != OSAL_NULL)

   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine::vOnIoControlUnfreeze(%x)",u32Return));
   return u32Return;

}


