/*******************************************************************************
* FILE:          fc_audiomanager_DiaglibHandler_DefSet.cpp
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Implementation of a system set listener.
* This handler sets the audio values used for IncreaseDecrease audio
* back to default on a DefSet request.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 27.09.12  | SoftTec Gaidatzi-Lken  | Inital version
*******************************************************************************/

// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++
// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_SYSTEM_SET
#include "diaglib_if.h"

#include "fc_audiomanager_DiaglibHandler_DefSet.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/DiagDefSetType.h"
#include "../../PostOffice/PostOffice.hpp"
#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../InternalComponentCommunication/Messages/Diag/IDDiagDefSet.h"

#include "fc_audiomanager_trace.h"

/* Needed for Trace */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_AUDIO_DIAGNOSIS
#include "trcGenProj/Header/fc_audiomanager_DiaglibHandler_DefSet.cpp.trc.h"
#endif


/*******************************************************************************
**  FUNCTION: fc_audiomanager_tclDiaglibHandler_DefSet();
*   Constructor
*******************************************************************************/
fc_audiomanager_tclDiaglibHandler_DefSet::fc_audiomanager_tclDiaglibHandler_DefSet(diaglib::tclServiceDiaglib* pDiaglibService)
                                                                                    : mpDiaglibService(pDiaglibService)
{
#ifdef SYSSETID_AUDIO_MANAGER
   if(mpDiaglibService != NULL)
   {
      ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_DefSet => vRegisterListener(SYSSETID_AUDIO_MANAGER) "));
      /*
      mpDiaglibService->poGetSysSet()->vRegisterListener(SYSSETID_ALL_COMP, this);
      mpDiaglibService->poGetSysSet()->vRegisterListener(SYSSETID_GROUP_HMI_RESTORE_VEHICLE_SETTING, this);
      mpDiaglibService->poGetSysSet()->vRegisterListener(SYSSETID_GROUP_HMI_CLEAR_ALL_PRIVATE_DATA, this);
      */
      mpDiaglibService->poGetSysSet()->vRegisterListener(SYSSETID_AUDIO_MANAGER, this);
   }
   else
   {
      ETG_TRACE_FATAL(( "fc_audiomanager_tclDiaglibHandler_DefSet constructor: diaglib pointer is NULL" ));
      FATAL_M_ASSERT_ALWAYS();
   }
#endif
}


/*******************************************************************************
** FUNCTION: virtual ~fc_audiomanager_tclDiaglibHandler_DefSet();
*  Destructor
*******************************************************************************/
fc_audiomanager_tclDiaglibHandler_DefSet::~fc_audiomanager_tclDiaglibHandler_DefSet()
{
   mpDiaglibService = NULL;
}


/*******************************************************************************
** FUNCTION: vOnSystemSet ( tU32 u32SystemSetID,
*                           diaglib::tenSystemSetType u32SystemSetType,
*                           diaglib::tContext MsgContext
*                         )
*******************************************************************************/
tU32 fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet   (
                                                 tU32 u32SystemSetID,
                                                 diaglib::tenSystemSetType u32SystemSetType,
                                                 diaglib::tContext MsgContext
                                               )
{
   ETG_TRACE_USR3(("--> fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet entered"));
   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
   diaglib::tclParameterVector oTmpVec;
   tBool bResponse = TRUE;

   tenDiagDefSetType enDiagDefSetType = EN_DEFSET_TEF;
   tenDiagDefSetPhase enDiagDefSetPhase = EN_DEFSET_SET;

   // +++ Set values back to default, then send positive response +++
#ifdef SYSSETID_AUDIO_MANAGER
   switch(u32SystemSetID)
   {
       /*
      case SYSSETID_ALL_COMP:
      {
         // supported by Default Settings
         ETG_TRACE_COMP_THR(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => SYSSETID_ALL_COMP"));
         break;
      }
      case SYSSETID_GROUP_HMI_CLEAR_ALL_PRIVATE_DATA:
      {
         // not supported by Default Settings
         ETG_TRACE_COMP_THR(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => SYSSETID_GROUP_HMI_CLEAR_ALL_PRIVATE_DATA"));
         break;
      }
      case SYSSETID_GROUP_HMI_RESTORE_VEHICLE_SETTING:
      {
         // supported by Default Settings
         ETG_TRACE_COMP_THR(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => SYSSETID_GROUP_HMI_RESTORE_VEHICLE_SETTING"));
         break;
      }
      */

 case SYSSETID_AUDIO_MANAGER: // Audio Component: supported by Default Settings
      {
         ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => SYSSETID_AUDIO_MANAGER is received"));
         switch(u32SystemSetType)
         {
            case diaglib::EN_TYPE_DEFAULT_TEF: //Fertigungsdiagnose (default setting delivery) Set back All Parameter
            {
               ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => EN_TYPE_DEFAULT_TEF is received"));
               enDiagDefSetType = EN_DEFSET_TEF;
               break;
            }// case EN_TYPE_DEFAULT_TEF:

            case diaglib::EN_TYPE_DEFAULT_HMI: //default setting user, only the personal setting have to be clear
			#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)
			case diaglib::EN_TYPE_DEFAULT_CUSTOMER:
			#endif
            {
               ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => EN_TYPE_DEFAULT_HMI is received"));
               enDiagDefSetType = EN_DEFSET_HMI;
               break;
            }

            case diaglib::EN_TYPE_CODING: //Configuration update
            {
               ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => EN_TYPE_CODING is received"));
               enDiagDefSetType = EN_DEFSET_CODING;
               break;
            }// case EN_TYPE_CODING:

            //All User Management related cases added to send a positive response always.
            case diaglib::EN_TYPE_UM_SWITCH_USER:
            case diaglib::EN_TYPE_UM_RESET_ALL:
            case diaglib::EN_TYPE_UM_RESET_USER:
            case diaglib::EN_TYPE_UM_RESET_BANK:
            case diaglib::EN_TYPE_UM_SWITCH_BANK:
            case diaglib::EN_TYPE_UM_SAVE_BANK:
            {
                ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => EN_TYPE_UM_SWITCH_USER is received"));
                enDiagDefSetType = EN_USER_CHANGE;
              break;
            }

            default:
            {
               ETG_TRACE_ERR(("!!! fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => ERROR: not supportet Systemset request"));
               bResponse = FALSE;

               diaglib::trParameter paramError;
               paramError.enType         = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
               paramError.u8Value        = diaglib::EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE;
               oTmpVec.push_back(paramError);
               break;
            }
         }// switch(u32SystemSetType)
         break;
      }// case SYSSETID_AUDIO_MANAGER:

      default:
      {
         ETG_TRACE_ERR(("!!! fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => ERROR: not supportet ID"));
         bResponse = FALSE;

         diaglib::trParameter paramError;
         paramError.enType         = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
         paramError.u8Value        = diaglib::EN_ERROR_ID_NOT_SUPPORTED;
         oTmpVec.push_back(paramError);
         break;
      }
   }// switch(u32SystemSetID)
#endif
#ifdef SYSSETID_AUDIO_MANAGER
   if (bResponse) {
       //Send the DiagDefSet Message to all fc_audimanager subcomponents
       ID_DiagDefSet DiagDefSetMsg(enDiagDefSetType, enDiagDefSetPhase);
       InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&DiagDefSetMsg);
       ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => DeliverMsg(ID_DiagDefSet(EN_DEFSET_SET)) is sent"));
   }
#endif

   ETG_TRACE_USR3(("---enDiagDefSetType = %x ",enDiagDefSetType));
   ETG_TRACE_USR3(("---enDiagDefSetPhase = %x ",enDiagDefSetPhase));

   ETG_TRACE_USR3(("---u32SystemSetID = %d ",u32SystemSetID));
   ETG_TRACE_USR3(("---u32SystemSetType = %d ",u32SystemSetType));
   // send Data back to Server
   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetSysSet()->bSendSystemSetResult(  (bResponse ? diaglib::EN_SYSTEMSET_OK : diaglib::EN_SYSTEMSET_NOT_OK),
                                                                         oTmpVec,
                                                                         MsgContext) )
      {
         ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => bSendSystemSetResult successfull"));
      }
      else
      {
         ETG_TRACE_ERR(("!!! fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => ERROR : bSendSystemSetResult failed"));
      }
   }
   else
   {
      ETG_TRACE_ERR(("!!! fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => ERROR : mpDiaglibService == OSAL_NULL"));
   }

   ETG_TRACE_USR3(("<-- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet end (returnvalue %x)",u32Return));

   return u32Return;
}




/*******************************************************************************
** FUNCTION: vOnSystemSetPrepare ( tU32 u32SystemSetID,
*                                  diaglib::tenSystemSetType u32SystemSetType,
*                                  diaglib::tContext MsgContext
*                                 )
*******************************************************************************/
tU32 fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare   (
                                                   tU32 u32SystemSetID,
                                                   diaglib::tenSystemSetType u32SystemSetType,
                                                   diaglib::tContext MsgContext
                                                )
{
   tBool bResponse = TRUE;
   diaglib::tclParameterVector oTmpVec;
   tenDiagDefSetType enDiagDefSetType = EN_DEFSET_TEF;
   tenDiagDefSetPhase enDiagDefSetPhase = EN_DEFSET_PREPARE;

   ETG_TRACE_USR3(("--> fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare entered"));
   // +++ Stop access to values that need default setting, then send positive response +++
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );


   switch(u32SystemSetType)
   {
      case diaglib::EN_TYPE_DEFAULT_TEF: //Fertigungsdiagnose (default setting delivery) Set back All Parameter
      {
         ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare => EN_TYPE_DEFAULT_TEF is received"));
         enDiagDefSetType = EN_DEFSET_TEF;
         break;
      }// case EN_TYPE_DEFAULT_TEF:

      case diaglib::EN_TYPE_DEFAULT_HMI: //default setting user, only the personal setting have to be clear
	  #if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)
	  case diaglib::EN_TYPE_DEFAULT_CUSTOMER:
	  #endif
      {
         ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare => EN_TYPE_DEFAULT_HMI is received"));
         enDiagDefSetType = EN_DEFSET_HMI;
         break;
      }

      case diaglib::EN_TYPE_CODING: //Configuration update
      {
         ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare => EN_TYPE_CODING is received"));
         enDiagDefSetType = EN_DEFSET_CODING;
         break;
      }// case EN_TYPE_CODING:

      //All User Management related cases added to send a positive response always.
      case diaglib::EN_TYPE_UM_SWITCH_USER:
      case diaglib::EN_TYPE_UM_RESET_ALL:
      case diaglib::EN_TYPE_UM_RESET_USER:
      case diaglib::EN_TYPE_UM_RESET_BANK:
      case diaglib::EN_TYPE_UM_SWITCH_BANK:
      case diaglib::EN_TYPE_UM_SAVE_BANK:
      {
          ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => EN_TYPE_UM_SWITCH_USER is received"));
          enDiagDefSetType = EN_USER_CHANGE;
        break;
      }

      default:
      {
         ETG_TRACE_ERR(("!!! fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare => ERROR: not supportet Systemset request"));
         diaglib::trParameter paramError;
         paramError.enType         = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
         paramError.u8Value        = diaglib::EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE;
         oTmpVec.push_back(paramError);
         bResponse = FALSE;
         break;
      }
   }// switch(u32SystemSetType)


   if (bResponse)
   {
       //Send the DiagDefSet Message to all fc_audimanager subcomponents
       ID_DiagDefSet DiagDefSetMsg(enDiagDefSetType, enDiagDefSetPhase);
       InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&DiagDefSetMsg);
       ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare => DeliverMsg(ID_DiagDefSet(EN_DEFSET_PREPARE)) is sent"));
   }


   /*
      Response can be one of the following:
      EN_SYSTEMSET_OK            -> Empty error vector

      Actually the diaglib already checks if ID is supported, so we don't need
      to do it here again.
   */

   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetSysSet()->bSendSystemSetResult( (bResponse ? diaglib::EN_SYSTEMSET_OK : diaglib::EN_SYSTEMSET_NOT_OK),
                                                    oTmpVec,
                                                    MsgContext) )
      {
         // +++ Trace info +++
        ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare => bSendSystemSetResult succesfull"));
      }
      else
      {
         // +++ Trace error +++
        ETG_TRACE_ERR(("!!! fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare => bSendSystemSetResult failed"));
      }
   }
   else
   {
      // +++ Trace error +++
       ETG_TRACE_ERR(("!!! fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare => ERROR : mpDiaglibService == OSAL_NULL"));
   }
   ETG_TRACE_USR3(("<-- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare end"));
   return diaglib::U32_DIAGLIB_RETURN_OK;
}



/*******************************************************************************
** FUNCTION: vOnSystemSetCheck ( tU32 u32SystemSetID,
*                                diaglib::tenSystemSetType u32SystemSetType,
*                                diaglib::tContext MsgContext
*                              )
*******************************************************************************/
tU32 fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetCheck (
                                                   tU32 u32SystemSetID,
                                                   diaglib::tenSystemSetType u32SystemSetType,
                                                   diaglib::tContext MsgContext
                                                 )
{
   ETG_TRACE_USR3(("--> fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetCheck entered"));
   // +++ Check if all values are set to default. +++
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );
   tBool bResponse = TRUE;
   ETG_TRACE_USR4((" bResponse: %d", bResponse));
   /*
      Response can be one of the following:
      EN_SYSTEMSET_OK            -> Empty error vector
      EN_SYSTEMSET_NOT_OK        -> List of wrong values

      diaglib already checks if ID is supported, so we don't need
      to do it here again.
   */
   diaglib::tclParameterVector oTmpVec;

   if(mpDiaglibService != OSAL_NULL)
   {
   //bresponse is always true,taking true branch
      if(TRUE == mpDiaglibService->poGetSysSet()->bSendSystemSetCheckResult( diaglib::EN_SYSTEMSET_OK ,oTmpVec,MsgContext) )
      {
         // +++ Trace info +++
        ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetCheck => bSendSystemSetCheckResult succesfull"));
      }
      else
      {
         // +++ Trace error +++
        ETG_TRACE_ERR(("!!! fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetCheck => bSendSystemSetCheckResult failed"));
      }
   }
   else
   {
      // +++ Trace error +++
       ETG_TRACE_ERR(("!!! fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetCheck => ERROR : mpDiaglibService == OSAL_NULL"));
   }
   ETG_TRACE_USR3(("<-- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetCheck end"));
   return diaglib::U32_DIAGLIB_RETURN_OK;
}



/*******************************************************************************
** FUNCTION: vOnSystemSetFinished ( tU32 u32SystemSetID,
*                                   diaglib::tenSystemSetType u32SystemSetType,
*                                   diaglib::tContext MsgContext
*                                 )
*******************************************************************************/
tU32 fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetFinished   (
                                                   tU32 u32SystemSetID,
                                                   diaglib::tenSystemSetType u32SystemSetType,
                                                   diaglib::tContext MsgContext
                                                 )
{
   tBool bResponse = TRUE;
   tenDiagDefSetType enDiagDefSetType = EN_DEFSET_TEF ;

   tenDiagDefSetPhase enDiagDefSetPhase = EN_DEFSET_FINISH;

   ETG_TRACE_USR3(("--> fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetFinished entered"));
   // +++ Reallow access to values that needed default setting, then send positive response +++
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );

   /*
      Respond does not contain any data and is just an acknowledgement.
   */

   switch(u32SystemSetType)
   {
      case diaglib::EN_TYPE_DEFAULT_TEF: //Fertigungsdiagnose (default setting delivery) Set back All Parameter
      {
         ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare => EN_TYPE_DEFAULT_TEF is received"));
         enDiagDefSetType = EN_DEFSET_TEF;
         break;
      }// case EN_TYPE_DEFAULT_TEF:

      case diaglib::EN_TYPE_DEFAULT_HMI: //default setting user, only the personal setting have to be clear
	  #if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)
	  case diaglib::EN_TYPE_DEFAULT_CUSTOMER:
	  #endif
      {
         ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare => EN_TYPE_DEFAULT_HMI is received"));
         enDiagDefSetType = EN_DEFSET_HMI;
         break;
      }

      case diaglib::EN_TYPE_CODING: //Configuration update
      {
         ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare => EN_TYPE_CODING is received"));
         enDiagDefSetType = EN_DEFSET_CODING;
         break;
      }// case EN_TYPE_CODING:

      //All User Management related cases added to send a positive response always.
      case diaglib::EN_TYPE_UM_SWITCH_USER:
      case diaglib::EN_TYPE_UM_RESET_ALL:
      case diaglib::EN_TYPE_UM_RESET_USER:
      case diaglib::EN_TYPE_UM_RESET_BANK:
      case diaglib::EN_TYPE_UM_SWITCH_BANK:
      case diaglib::EN_TYPE_UM_SAVE_BANK:
      {
          ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSet => EN_TYPE_UM_SWITCH_USER is received"));
          enDiagDefSetType = EN_USER_CHANGE;
        break;
      }

      default:
      {
         ETG_TRACE_ERR(("!!! fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetPrepare => ERROR: not supportet Systemset request"));
         bResponse = FALSE;
         break;
      }
   }// switch(u32SystemSetType)


   if (bResponse)
   {
       //Send the DiagDefSet Message to all fc_audimanager subcomponents
       ID_DiagDefSet DiagDefSetMsg(enDiagDefSetType, enDiagDefSetPhase);
       InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&DiagDefSetMsg);
       ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetFinished => DeliverMsg(ID_DiagDefSet(EN_DEFSET_FINISH)) is sent"));
   }


   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetSysSet()->bAcknowledgeSystemSetFinished(MsgContext))
      {
         // +++ Trace info +++
        ETG_TRACE_USR3(("--- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetFinished => bAcknowledgeSystemSetFinished succesfull"));
      }
      else
      {
         // +++ Trace error +++
        ETG_TRACE_ERR(("!!! fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetFinished => bAcknowledgeSystemSetFinished failed"));
     }
   }
   else
   {
      // +++ Trace error +++
    ETG_TRACE_ERR(("!!! fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetFinished => ERROR : mpDiaglibService == OSAL_NULL"));
   }

   ETG_TRACE_USR3(("<-- fc_audiomanager_tclDiaglibHandler_DefSet::vOnSystemSetFinished end"));
   return diaglib::U32_DIAGLIB_RETURN_OK;
}


