/*******************************************************************************
* FILE:          fc_audiomanager_DiaglibHandler_Buzzer.h
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Implementation of a IOControl listener.
* This handler implements the Buzzer Control via the Diagnosis.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 02.03.18  | STC2HI                  | Inital version
*******************************************************************************/

// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++
#ifndef FC_AUDIOMANAGER_DIAGLIBHANDLER_BUZZER_H
#define FC_AUDIOMANAGER_DIAGLIBHANDLER_BUZZER_H


// +++ Adjust class prefix +++
class fc_audiomanager_tclDiaglibHandler_Buzzer: public diaglib::tclIoControlListenerIF
{
public:
   // +++ Depending on the type of listener you need the associated interface to send responses +++
   fc_audiomanager_tclDiaglibHandler_Buzzer(diaglib::tclServiceDiaglib*   pDiaglibService);
   virtual ~fc_audiomanager_tclDiaglibHandler_Buzzer();

   // +++ Place the virtual listener functions here. These depend on the listener you implement +++
   /***************************************************************************
    * RoutineControl methods
    ***************************************************************************/
  virtual tU32 vOnIoControl (
                               tU32 u32IoControlId,
                               diaglib::tenIoControlAction enActionId,
                               const diaglib::tclParameterVector& oParameterVector,
                               diaglib::tContext MsgContext
                             );
   virtual tU32 vOnIoControlFreeze (
                                     tU32 u32IoControlId,
                                     diaglib::tContext MsgContext
                                   );

   virtual tU32 vOnIoControlUnfreeze (
                                        tU32 u32IoControlId,
                                        diaglib::tContext MsgContext
                                      );

private:
  diaglib::tclServiceDiaglib*  mpDiaglibService;

  fc_audiomanager_tclDiaglibHandler_Buzzer();
};
#endif // FC_AUDIOMANAGER_DIAGLIBHANDLER_BUZZER_H
