/*******************************************************************************
* FILE:          fc_audiomanager_DiaglibHandler_AudioGain.cpp
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Implementation of a IOControl listener.
* This handler sets the Volume steps from the current Source.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 27.09.12  | SoftTec Gaidatzi-Lken  | Inital version
*******************************************************************************/

// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++

// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_IO_CONTROL
#include "diaglib_if.h"

#include "fc_audiomanager_DiaglibHandler_AudioSetting.h"
#include "../../PostOffice/PostOffice.hpp"
#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../InternalComponentCommunication/Messages/Diag/IDDiagAudioGain.h"
#include "../InternalComponentCommunication/Messages/Diag/ID_SetDiagFader.h"
#include "../InternalComponentCommunication/Messages/Diag/ID_SetDiagBalance.h"
#include "../InternalComponentCommunication/Messages/settings/IDSettings.h"

#include "fc_audiomanager_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_AUDIO_DIAGNOSIS
#include "trcGenProj/Header/fc_audiomanager_DiaglibHandler_AudioSetting.cpp.trc.h"
#endif



/*******************************************************************************
**  FUNCTION:
*   fc_audiomanager_DiaglibHandler_AudioSettings(
*                                    diaglib::tclServiceDiaglib* pDiaglibService)
*                                    : mpDiaglibService(pDiaglibService)
*   Constructor
*******************************************************************************/

fc_audiomanager_DiaglibHandler_AudioSettings::fc_audiomanager_DiaglibHandler_AudioSettings(
                                      diaglib::tclServiceDiaglib* pDiaglibService)
                                        : mpDiaglibService(pDiaglibService)
{
   if(mpDiaglibService != NULL)
   {
#if defined (IOCONTROLID_AUDIO_FADER)
    mpDiaglibService->poGetIoCtrl()->vRegisterListener(IOCONTROLID_AUDIO_FADER, this);
      ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings => vRegisterListener(IOCONTROLID_AUDIO_FADER) "));
#endif
#if defined(IOCONTROLID_AUDIO_BALANCE)
    mpDiaglibService->poGetIoCtrl()->vRegisterListener(IOCONTROLID_AUDIO_BALANCE, this);
      ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings => vRegisterListener(IOCONTROLID_AUDIO_BALANCE) "));
#endif
   }
   else
   {
      ETG_TRACE_FATAL(( "fc_audiomanager_DiaglibHandler_AudioSettings constructor: diaglib pointer is NULL" ));
      FATAL_M_ASSERT_ALWAYS();
   }


}



/*******************************************************************************
**  FUNCTION:
*   ~fc_audiomanager_DiaglibHandler_AudioSettings()
*   Destructor
*******************************************************************************/
fc_audiomanager_DiaglibHandler_AudioSettings::~fc_audiomanager_DiaglibHandler_AudioSettings()
{
   mpDiaglibService = NULL;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControl(tU32 u32IoControlId, diaglib::tenIoControlAction enActionId,
*                 const diaglib::tclParameterVector& oParameterVector,diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for set Phantom Voltage request
*******************************************************************************/
tU32 fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl (
                                                             tU32 u32IoControlId,
                                                             diaglib::tenIoControlAction enActionId,
                                                             const diaglib::tclParameterVector& oParameterVector,
                                                             diaglib::tContext MsgContext
                                                           )
{
   ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl received"));
   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_NOT_OK;

   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( enActionId );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( MsgContext );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( oParameterVector )

#if defined(IOCONTROLID_AUDIO_FADER) || defined (IOCONTROLID_AUDIO_BALANCE)
   // check for expected Routine ID
   switch(u32IoControlId)
   {
#if defined(IOCONTROLID_AUDIO_FADER)
    case IOCONTROLID_AUDIO_FADER:
      {
         ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl => IOCONTROLID_AUDIO_FADER is received"));

         // create object for response
         diaglib::tclParameterVector oFaderVec;

         // answer beginn

         if(diaglib::bCheckParameterSignature(oParameterVector,
                                              IOCONTROLID_AUDIO_FADER_SET_LEN,
                                              IOCONTROLID_AUDIO_FADER_SET_PARAM1) == FALSE)
         {
            ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl => ERROR: bCheckParameterSignature FAILED"));
            oCtrlResult = diaglib::EN_IO_CONTROL_NOT_OK; // Control failed

            diaglib::trParameter paramaError;
            paramaError.enType         = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
            paramaError.u8Value        = diaglib::EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE;
            oFaderVec.push_back(paramaError);
         }// if(diaglib::bCheckParameterSignature(oParamVector, ...
         else
         {
             // get Data
             tS8 s8Fader = (tS8)(oParameterVector[IOCONTROLID_AUDIO_FADER_RESULT_u8Fader].u8Value);


             //Send the DiagAudioGain Message to Volume fc_audimanager subcomponent
             ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl => DeliverMsg(s8Fader = %d) is sent", s8Fader));
             //send PO message
       ID_SetDiagFader oSettingsFader(s8Fader);
       InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsFader);
             oCtrlResult = diaglib::EN_IO_CONTROL_OK; // data valid
             diaglib::trParameter paramaStatus;
             paramaStatus.enType         = static_cast<diaglib::tenParameterType>(IOCONTROLID_AUDIO_FADER_RESULT_PARAM1);
             paramaStatus.s8Value        = s8Fader;
             oFaderVec.push_back(paramaStatus);
         }



         // send message back to diagnosis
         if(mpDiaglibService != OSAL_NULL)
         {
            if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlMethodResult( oCtrlResult,
                                                                                 enActionId,
                                                                                 oFaderVec,
                                                                                 MsgContext) )
            {
               u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
               ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl => bSendIoCtrlMethodResult successfull"));
            }// if(TRUE == mpDiaglibService->poGetIoCtrl()
            else
            {
               u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
               ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl => ERROR : bSendRoutineCtrlMethodResult failed"));
            }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
         }// if(mpDiaglibService != OSAL_NULL)
         else
         {
            u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
            ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl => ERROR : mpDiaglibService == OSAL_NULL"));
         }// else // if(mpDiaglibService != OSAL_NULL)
         break;

      }// case IOCONTROLID_AUDIO_FADER:
#endif
#if defined(IOCONTROLID_AUDIO_BALANCE)
     case IOCONTROLID_AUDIO_BALANCE:
      {
         ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl => IOCONTROLID_AUDIO_BALANCE is received"));

         // create object for response
         diaglib::tclParameterVector oBalanceVec;

         // answer beginn

         if(diaglib::bCheckParameterSignature(oParameterVector,
                                              IOCONTROLID_AUDIO_BALANCE_SET_LEN,
                                              IOCONTROLID_AUDIO_BALANCE_SET_PARAM1) == FALSE)
         {
            ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl => ERROR: bCheckParameterSignature FAILED"));
            oCtrlResult = diaglib::EN_IO_CONTROL_NOT_OK; // Control failed

            diaglib::trParameter paramaError;
            paramaError.enType         = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
            paramaError.u8Value        = diaglib::EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE;
            oBalanceVec.push_back(paramaError);
         }// if(diaglib::bCheckParameterSignature(oParamVector, ...
         else
         {
             // get Data
             tS8 s8Balance = (tS8)(oParameterVector[IOCONTROLID_AUDIO_BALANCE_RESULT_u8Balance].u8Value);


             //Send the DiagAudioGain Message to Volume fc_audimanager subcomponent
             ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl => DeliverMsg(s8Balance = %d) is sent", s8Balance));
             //send PO message
       ID_SetDiagBalance oSettingsBalance(s8Balance);
             InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsBalance);
             oCtrlResult = diaglib::EN_IO_CONTROL_OK; // data valid
             diaglib::trParameter paramaStatus;
             paramaStatus.enType         = static_cast<diaglib::tenParameterType>(IOCONTROLID_AUDIO_BALANCE_RESULT_PARAM1);
             paramaStatus.s8Value        = s8Balance;
             oBalanceVec.push_back(paramaStatus);
         }



         // send message back to diagnosis
         if(mpDiaglibService != OSAL_NULL)
         {
            if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlMethodResult( oCtrlResult,
                                                                                 enActionId,
                                                                                 oBalanceVec,
                                                                                 MsgContext) )
            {
               u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
               ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl => bSendIoCtrlMethodResult successfull"));
            }// if(TRUE == mpDiaglibService->poGetIoCtrl()
            else
            {
               u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
               ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl => ERROR : bSendRoutineCtrlMethodResult failed"));
            }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
         }// if(mpDiaglibService != OSAL_NULL)
         else
         {
            u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
            ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl => ERROR : mpDiaglibService == OSAL_NULL"));
         }// else // if(mpDiaglibService != OSAL_NULL)
         break;

      }// case IOCONTROLID_AUDIO_FADER:
#endif
      default:
      {
         break;
      }// default:
   }
#endif
   ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControl(%x)",u32Return));
   ETG_TRACE_USR3(("---oCtrlResult = %d ",oCtrlResult));

   ETG_TRACE_USR3(("---u32IoControlId = %d ",u32IoControlId));

   return u32Return;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControlFreeze ( tU32 u32IoControlId, diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for Freeze the State before the Diagnosis Request
*                (not implemented in the diagnosis)
*******************************************************************************/
tU32 fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControlFreeze (
                                              tU32 u32IoControlId,
                                              diaglib::tContext MsgContext
                                            )
{
  (void)u32IoControlId;
   ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControlFreeze is received"));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_OK;

   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlFreezeResult( oCtrlResult,
                                                                           MsgContext) )
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
         ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControlFreeze => bSendIoCtrlFreezeResult successfull"));
      }// if(TRUE == mpDiaglibService->poGetIoCtrl()
      else
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControlFreeze => ERROR : bSendRoutineCtrlMethodResult failed"));
      }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
   }// if(mpDiaglibService != OSAL_NULL)
   else
   {
      u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
      ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControlFreeze => ERROR : mpDiaglibService == OSAL_NULL"));
   }// else // if(mpDiaglibService != OSAL_NULL)

   ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControlFreeze(%x)",u32Return));

   return u32Return;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControlUnfreeze ( tU32 u32IoControlId, diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for Unfreeze the State before the Diagnosis Request
*                (not implemented in the diagnosis)
*******************************************************************************/
tU32 fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControlUnfreeze (
                                              tU32 u32IoControlId,
                                              diaglib::tContext MsgContext
                                            )
{
  (void)u32IoControlId;
   ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControlUnfreeze is received"));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_OK;

   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlUnfreezeResult( oCtrlResult,
                                                                             MsgContext) )
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
         ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControlUnfreeze => bSendIoCtrlFreezeResult successfull"));
      }// if(TRUE == mpDiaglibService->poGetIoCtrl()
      else
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControlUnfreeze => ERROR : bSendRoutineCtrlMethodResult failed"));
      }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
   }// if(mpDiaglibService != OSAL_NULL)
   else
   {
      u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
      ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControlUnfreeze => ERROR : mpDiaglibService == OSAL_NULL"));
   }// else // if(mpDiaglibService != OSAL_NULL)

   ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_AudioSettings::vOnIoControlUnfreeze(%x)",u32Return));
   return u32Return;

}


