/*******************************************************************************
* FILE:          fc_audiomanager_DiaglibHandler_AudioGain.h
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Implementation of a IOControl listener.
* This handler sets the Volume values.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 27.09.12  | SoftTec Gaidatzi-Lken  | Inital version
*******************************************************************************/

// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++
#ifndef FC_AUDIOMANAGER_DIAGLIBHANDLER_AUDIOGAIN_H
#define FC_AUDIOMANAGER_DIAGLIBHANDLER_AUDIOGAIN_H


/**
 * Message are received by implementing ListenerInterfaces and registering
 * them with diagnosis library. This demo shows two ways to achieve this.
 * SystemSets are handled in this class. For RoutineControl we create an
 * extra classe that handles requests for two different routines.
 */
// +++ Adjust class prefix +++
class fc_audiomanager_tclDiaglibHandler_AudioGain: public diaglib::tclIoControlListenerIF
{
public:
   // +++ Depending on the type of listener you need the associated interface to send responses +++
   fc_audiomanager_tclDiaglibHandler_AudioGain(diaglib::tclServiceDiaglib*   pDiaglibService);
   virtual ~fc_audiomanager_tclDiaglibHandler_AudioGain();

   // +++ Place the virtual listener functions here. These depend on the listener you implement +++
   /***************************************************************************
    * RoutineControl methods
    ***************************************************************************/
  virtual tU32 vOnIoControl (
                               tU32 u32IoControlId,
                               diaglib::tenIoControlAction enActionId,
                               const diaglib::tclParameterVector& oParameterVector,
                               diaglib::tContext MsgContext
                             );
   virtual tU32 vOnIoControlFreeze (
                                     tU32 u32IoControlId,
                                     diaglib::tContext MsgContext
                                   );

   virtual tU32 vOnIoControlUnfreeze (
                                        tU32 u32IoControlId,
                                        diaglib::tContext MsgContext
                                      );

private:
  diaglib::tclServiceDiaglib*  mpDiaglibService;

  fc_audiomanager_tclDiaglibHandler_AudioGain();//lint !e1704 Info 1704 , eliminating lint warnings
};
#endif // FC_AUDIOMANAGER_DIAGLIBHANDLER_AUDIOGAIN_H
