/*******************************************************************************
* FILE:          fc_audiomanager_DiaglibHandler_AudioGain.cpp
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Implementation of a IOControl listener.
* This handler sets the Volume steps from the current Source.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 27.09.12  | SoftTec Gaidatzi-Lken  | Inital version
*******************************************************************************/

// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++

// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_IO_CONTROL
#include "diaglib_if.h"

#include "fc_audiomanager_DiaglibHandler_AudioGain.h"
#include "../../PostOffice/PostOffice.hpp"
#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../InternalComponentCommunication/Messages/Diag/IDDiagAudioGain.h"

#include "fc_audiomanager_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_AUDIO_DIAGNOSIS
#include "trcGenProj/Header/fc_audiomanager_DiaglibHandler_AudioGain.cpp.trc.h"
#endif



/*******************************************************************************
**  FUNCTION:
*   fc_audiomanager_tclDiaglibHandler_AudioGain(
*                                    diaglib::tclServiceDiaglib* pDiaglibService)
*                                    : mpDiaglibService(pDiaglibService)
*   Constructor
*******************************************************************************/

fc_audiomanager_tclDiaglibHandler_AudioGain::fc_audiomanager_tclDiaglibHandler_AudioGain(
                                      diaglib::tclServiceDiaglib* pDiaglibService)
                                        : mpDiaglibService(pDiaglibService)
{
#ifdef IOCONTROLID_AUDIO_GAIN
   if(mpDiaglibService != NULL)
   {
      mpDiaglibService->poGetIoCtrl()->vRegisterListener(IOCONTROLID_AUDIO_GAIN, this);
      ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_AudioGain => vRegisterListener(IOCONTROLID_AUDIO_GAIN) "));
   }
   else
   {
      ETG_TRACE_FATAL(( "fc_audiomanager_tclDiaglibHandler_AudioGain constructor: diaglib pointer is NULL" ));
      FATAL_M_ASSERT_ALWAYS();
   }

#endif
}



/*******************************************************************************
**  FUNCTION:
*   ~fc_audiomanager_tclDiaglibHandler_AudioGain()
*   Destructor
*******************************************************************************/
fc_audiomanager_tclDiaglibHandler_AudioGain::~fc_audiomanager_tclDiaglibHandler_AudioGain()
{
   mpDiaglibService = NULL;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControl(tU32 u32IoControlId, diaglib::tenIoControlAction enActionId,
*                 const diaglib::tclParameterVector& oParameterVector,diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for set Phantom Voltage request
*******************************************************************************/
tU32 fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControl (
                                                             tU32 u32IoControlId,
                                                             diaglib::tenIoControlAction enActionId,
                                                             const diaglib::tclParameterVector& oParameterVector,
                                                             diaglib::tContext MsgContext
                                                           )
{
   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_NOT_OK;

   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( enActionId );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( MsgContext );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( oParameterVector )
   // check for expected Routine ID
#ifdef IOCONTROLID_AUDIO_GAIN
   switch(u32IoControlId)
   {

      case IOCONTROLID_AUDIO_GAIN:
      {
         ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControl => IOCONTROLID_AUDIO_GAIN is received"));

         // create object for response
         diaglib::tclParameterVector oTmpVec;

         // answer beginn

         if(diaglib::bCheckParameterSignature(oParameterVector,
                                              IOCONTROLID_AUDIO_GAIN_SET_LEN,
                                              IOCONTROLID_AUDIO_GAIN_SET_PARAM1) == FALSE)
         {
            ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControl => ERROR: bCheckParameterSignature FAILED"));
            oCtrlResult = diaglib::EN_IO_CONTROL_NOT_OK; // Control failed

            diaglib::trParameter paramaError;
            paramaError.enType         = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
            paramaError.u8Value        = diaglib::EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE;
            oTmpVec.push_back(paramaError);
         }// if(diaglib::bCheckParameterSignature(oParamVector, ...
         else
         {
             // get Data
             tS8 s8Gain = (tS8)(oParameterVector[IOCONTROLID_AUDIO_GAIN_SET_u8Gain].u8Value);


             //Send the DiagAudioGain Message to Volume fc_audimanager subcomponent
             ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControl => DeliverMsg(ID_DiagAudioGain(s8Gain = %d)) is sent", s8Gain));
             ID_DiagAudioGain DiagAudioGainMsg(s8Gain);
             InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&DiagAudioGainMsg);

             oCtrlResult = diaglib::EN_IO_CONTROL_OK; // data valid
             diaglib::trParameter paramaStatus;
             paramaStatus.enType         = static_cast<diaglib::tenParameterType>(IOCONTROLID_AUDIO_GAIN_RESULT_PARAM1);
             paramaStatus.s8Value        = s8Gain;
             oTmpVec.push_back(paramaStatus);
         }



         // send message back to diagnosis
         if(mpDiaglibService != OSAL_NULL)
         {
            if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlMethodResult( oCtrlResult,
                                                                                 enActionId,
                                                                                 oTmpVec,
                                                                                 MsgContext) )
            {
               u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
               ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControl => bSendIoCtrlMethodResult successfull"));
            }// if(TRUE == mpDiaglibService->poGetIoCtrl()
            else
            {
               u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
               ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControl => ERROR : bSendRoutineCtrlMethodResult failed"));
            }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
         }// if(mpDiaglibService != OSAL_NULL)
         else
         {
            u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
            ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControl => ERROR : mpDiaglibService == OSAL_NULL"));
         }// else // if(mpDiaglibService != OSAL_NULL)
         break;

      }// case IOCONTROLID_AUDIO_GAIN:

      default:
      {
         break;
      }// default:
   }
#endif// switch(u32IoControlId)

   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControl(%x)",u32Return));
   ETG_TRACE_USR3(("---oCtrlResult = %d ",oCtrlResult));

   ETG_TRACE_USR3(("---u32IoControlId = %d ",u32IoControlId));

   return u32Return;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControlFreeze ( tU32 u32IoControlId, diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for Freeze the State before the Diagnosis Request
*                (not implemented in the diagnosis)
*******************************************************************************/
tU32 fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControlFreeze (
                                              tU32 u32IoControlId,
                                              diaglib::tContext MsgContext
                                            )
{
  (void)u32IoControlId;
   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControlFreeze is received"));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_OK;

   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlFreezeResult( oCtrlResult,
                                                                           MsgContext) )
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
         ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControlFreeze => bSendIoCtrlFreezeResult successfull"));
      }// if(TRUE == mpDiaglibService->poGetIoCtrl()
      else
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControlFreeze => ERROR : bSendRoutineCtrlMethodResult failed"));
      }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
   }// if(mpDiaglibService != OSAL_NULL)
   else
   {
      u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
      ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControlFreeze => ERROR : mpDiaglibService == OSAL_NULL"));
   }// else // if(mpDiaglibService != OSAL_NULL)

   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControlFreeze(%x)",u32Return));

   return u32Return;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControlUnfreeze ( tU32 u32IoControlId, diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for Unfreeze the State before the Diagnosis Request
*                (not implemented in the diagnosis)
*******************************************************************************/
tU32 fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControlUnfreeze (
                                              tU32 u32IoControlId,
                                              diaglib::tContext MsgContext
                                            )
{
  (void)u32IoControlId;
   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControlUnfreeze is received"));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_OK;

   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlUnfreezeResult( oCtrlResult,
                                                                             MsgContext) )
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
         ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControlUnfreeze => bSendIoCtrlFreezeResult successfull"));
      }// if(TRUE == mpDiaglibService->poGetIoCtrl()
      else
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControlUnfreeze => ERROR : bSendRoutineCtrlMethodResult failed"));
      }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
   }// if(mpDiaglibService != OSAL_NULL)
   else
   {
      u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
      ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControlUnfreeze => ERROR : mpDiaglibService == OSAL_NULL"));
   }// else // if(mpDiaglibService != OSAL_NULL)

   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_AudioGain::vOnIoControlUnfreeze(%x)",u32Return));
   return u32Return;

}


