/*******************************************************************************
* FILE:          fc_audiomanager_DiaglibHandler_ActiveSink.cpp
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Implementation of a IOControl listener.
* This handler sets the Volume steps from the current Source.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 1.7.16  | pmh7kor          | Inital version
*******************************************************************************/

// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++

// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_IO_CONTROL
#include "diaglib_if.h"

#include "fc_audiomanager_DiaglibHandler_ActiveSink.h"
#include "../../PostOffice/PostOffice.hpp"
#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../InternalComponentCommunication/Messages/Diag/ID_DiagActiveSink.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/DiagActiveSinkType.h"

#include "fc_audiomanager_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_AUDIO_DIAGNOSIS
#include "trcGenProj/Header/fc_audiomanager_DiaglibHandler_ActiveSink.cpp.trc.h"
#endif


//Macros as defined in dia_IAudioSource.h
#define EN_AUDIO_SINK_SPEAKER 4
#define EN_AUDIO_SOUNDSYSTEM_SPEAKER 2
//------------------------------------------------------------------------------


/*******************************************************************************
**  FUNCTION:
*   fc_audiomanager_DiaglibHandler_ActiveSink(
*                                    diaglib::tclServiceDiaglib* pDiaglibService)
*                                    : mpDiaglibService(pDiaglibService)
*   Constructor
*******************************************************************************/

fc_audiomanager_DiaglibHandler_ActiveSink::fc_audiomanager_DiaglibHandler_ActiveSink(
                                      diaglib::tclServiceDiaglib* pDiaglibService)
                                        : mpDiaglibService(pDiaglibService)
{
#ifdef IOCONTROLID_AUDIO_ACTIVE_SINK
   if(mpDiaglibService != NULL)
   {
      mpDiaglibService->poGetIoCtrl()->vRegisterListener(IOCONTROLID_AUDIO_ACTIVE_SINK, this);
      ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_ActiveSink => vRegisterListener(IOCONTROLID_AUDIO_ACTIVE_SINK) "));
   }
   else
   {
      ETG_TRACE_FATAL(( "fc_audiomanager_DiaglibHandler_ActiveSink constructor: diaglib pointer is NULL" ));
      NORMAL_M_ASSERT_ALWAYS();
   }

#endif
}



/*******************************************************************************
**  FUNCTION:
*   ~fc_audiomanager_DiaglibHandler_ActiveSink()
*   Destructor
*******************************************************************************/
fc_audiomanager_DiaglibHandler_ActiveSink::~fc_audiomanager_DiaglibHandler_ActiveSink()
{
   mpDiaglibService = NULL;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControl(tU32 u32IoControlId, diaglib::tenIoControlAction enActionId,
*                 const diaglib::tclParameterVector& oParameterVector,diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for set Phantom Voltage request
*******************************************************************************/
tU32 fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControl (
                                                             tU32 u32IoControlId,
                                                             diaglib::tenIoControlAction enActionId,
                                                             const diaglib::tclParameterVector& oParameterVector,
                                                             diaglib::tContext MsgContext
                                                           )
{
   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_NOT_OK;

   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( enActionId );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( MsgContext );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( oParameterVector )
   // check for expected Routine ID
#ifdef IOCONTROLID_AUDIO_ACTIVE_SINK
   switch(u32IoControlId)
   {

      case IOCONTROLID_AUDIO_ACTIVE_SINK:
      {
         ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControl => IOCONTROLID_AUDIO_ACTIVE_SINK is received"));

         // create object for response
         diaglib::tclParameterVector oTmpVec;

         // answer beginn

         if(diaglib::bCheckParameterSignature(oParameterVector,
                                              IOCONTROLID_AUDIO_ACTIVE_SINK_SET_LEN,
                                              IOCONTROLID_AUDIO_ACTIVE_SINK_SET_PARAM1,IOCONTROLID_AUDIO_ACTIVE_SINK_SET_PARAM2) == FALSE)
         {
            ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControl => ERROR: bCheckParameterSignature FAILED"));
            oCtrlResult = diaglib::EN_IO_CONTROL_NOT_OK; // Control failed

            diaglib::trParameter paramaError;
            paramaError.enType         = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
            paramaError.u8Value        = diaglib::EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE;
            oTmpVec.push_back(paramaError);
         }// if(diaglib::bCheckParameterSignature(oParamVector, ...
         else
         {
             // get Data
             tU8 u8Sink = (tU8) oParameterVector[IOCONTROLID_AUDIO_ACTIVE_SINK_SET_u8Sink].u8Value;
       tU8 u8SoundSystem = (tU8) oParameterVector[IOCONTROLID_AUDIO_ACTIVE_SINK_SET_u8SoundSystem].u8Value;
       ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControl, received sink value = %x, Sound System = %x",u8Sink,u8SoundSystem));

         if((u8Sink == EN_AUDIO_SINK_SPEAKER) && (u8SoundSystem == EN_AUDIO_SOUNDSYSTEM_SPEAKER)) // Audio sink is active when 0x00 is sent via diagnosis command. If sink sent is 0x01 to 0xff, it is considered as invalid.
         {
         ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControl => DeliverMsg(ID_DiagActiveSink(EN_ACTIVESINK_SET)) is sent"));
         ID_DiagActiveSink DiagAudioActiveSink(EN_ACTIVESINK_SET);
         InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&DiagAudioActiveSink);
         }

       oCtrlResult = diaglib::EN_IO_CONTROL_OK; // data valid
             diaglib::trParameter paramStatus;
             paramStatus.enType         = static_cast<diaglib::tenParameterType>(IOCONTROLID_AUDIO_ACTIVE_SINK_RESULT_PARAM1);
             paramStatus.u8Value        = u8Sink;
             oTmpVec.push_back(paramStatus);

       paramStatus.enType         = static_cast<diaglib::tenParameterType>(IOCONTROLID_AUDIO_ACTIVE_SINK_RESULT_PARAM2);
             paramStatus.u8Value        = u8SoundSystem;
             oTmpVec.push_back(paramStatus);
         }



         // send message back to diagnosis
         if(mpDiaglibService != OSAL_NULL)
         {
            if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlMethodResult( oCtrlResult,
                                                                                 enActionId,
                                                                                 oTmpVec,
                                                                                 MsgContext) )
            {
               u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
               ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControl => bSendIoCtrlMethodResult successfull"));
            }// if(TRUE == mpDiaglibService->poGetIoCtrl()
            else
            {
               u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
               ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControl => ERROR : bSendRoutineCtrlMethodResult failed"));
            }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
         }// if(mpDiaglibService != OSAL_NULL)
         else
         {
            u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
            ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControl => ERROR : mpDiaglibService == OSAL_NULL"));
         }// else // if(mpDiaglibService != OSAL_NULL)
         break;

      }// case IOCONTROLID_AUDIO_ACTIVE_SINK:

      default:
      {
         break;
      }// default:
   }
#endif// switch(u32IoControlId)

   ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControl(%x)",u32Return));
   ETG_TRACE_USR3(("---oCtrlResult = %d ",oCtrlResult));

   ETG_TRACE_USR3(("---u32IoControlId = %d ",u32IoControlId));

   return u32Return;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControlFreeze ( tU32 u32IoControlId, diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for Freeze the State before the Diagnosis Request
*                (not implemented in the diagnosis)
*******************************************************************************/
tU32 fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControlFreeze (
                                              tU32 u32IoControlId,
                                              diaglib::tContext MsgContext
                                            )
{
  (void)u32IoControlId;
   ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControlFreeze is received"));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_OK;

   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlFreezeResult( oCtrlResult,
                                                                           MsgContext) )
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
         ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControlFreeze => bSendIoCtrlFreezeResult successfull"));
      }// if(TRUE == mpDiaglibService->poGetIoCtrl()
      else
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControlFreeze => ERROR : bSendRoutineCtrlMethodResult failed"));
      }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
   }// if(mpDiaglibService != OSAL_NULL)
   else
   {
      u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
      ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControlFreeze => ERROR : mpDiaglibService == OSAL_NULL"));
   }// else // if(mpDiaglibService != OSAL_NULL)

   ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControlFreeze(%x)",u32Return));

   return u32Return;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControlUnfreeze ( tU32 u32IoControlId, diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for Unfreeze the State before the Diagnosis Request
*                (not implemented in the diagnosis)
*******************************************************************************/
tU32 fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControlUnfreeze (
                                              tU32 u32IoControlId,
                                              diaglib::tContext MsgContext
                                            )
{
  (void)u32IoControlId;
   ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControlUnfreeze is received"));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_OK;

   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlUnfreezeResult( oCtrlResult,
                                                                             MsgContext) )
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
         ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControlUnfreeze => bSendIoCtrlFreezeResult successfull"));
      }// if(TRUE == mpDiaglibService->poGetIoCtrl()
      else
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControlUnfreeze => ERROR : bSendRoutineCtrlMethodResult failed"));
      }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
   }// if(mpDiaglibService != OSAL_NULL)
   else
   {
      u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
      ETG_TRACE_ERR(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControlUnfreeze => ERROR : mpDiaglibService == OSAL_NULL"));
   }// else // if(mpDiaglibService != OSAL_NULL)

   ETG_TRACE_USR3(("fc_audiomanager_DiaglibHandler_ActiveSink::vOnIoControlUnfreeze(%x)",u32Return));
   return u32Return;

}


