/*******************************************************************************
* FILE:          fc_audiomanager_Microphone.h
* PROJECT:
* SW-COMPONENT:  fc_audiomanager microphone diagnosis
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Microphone diagnosis.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                      | Modification
* 02.02.15  | SoftTec Gaidatzi-Lken      | Inital version
*******************************************************************************/

#ifndef fc_audiomanager_Microphone_H_
#define fc_audiomanager_Microphone_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/



/******************************************************************************/
/*                                                                            */
/* FORWARD DECLARATION                                                        */
/*                                                                            */
/******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

enum tenMicState
{
    MIC_STATE_NORMAL = 0x00,
    MIC_STATE_OPEN = 0x01,
    MIC_STATE_SHORT_TO_GROUND = 0x02,
    MIC_STATE_SHORT_TO_BATTERY = 0x03,
    MIC_STATE_UNKNOWN = 0x04,
    MIC_STATE_NOT_IMPLEMENTED = 0xff
};


enum tenMicDetection
{
    MIC_DET_ABSENT = 0x0,
    MIC_DET_PRESENT = 0x1,
    MIC_DET_UNKNOWN = 0x2,
    MIC_DET_NOT_IMPLEMENTED = 0xff
};

typedef struct
{
    tBool           MicValid;
    tenMicState     MicState;
    tU32            MicCurrent;
    tenMicDetection MicDetection;
}tsMicData;


/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_audiomanager_tclMicrophone
{
public:
   fc_audiomanager_tclMicrophone();
   virtual ~fc_audiomanager_tclMicrophone();

   tsMicData *tenGetMicData(tU8 u8MicNr);

   tsMicData *tenGetMicDataSUZ(tU8 u8MicNr);
   tsMicData *tenGetMicDataPSA(tU8 u8MicNr);
   tsMicData *tenGetMicDataAIVI(tU8 u8MicNr);
   tsMicData *tenGetMicDataCAF(tU8 u8MicNr);
   tsMicData *tenGetMicDataJAC(tU8 u8MicNr);

   tenMicDetection tenGetMicDetection(tU8 u8MicNr)const;
   tenMicDetection tenGetMicDetectionSUZ(tU8 u8MicNr)const;
   tenMicDetection tenGetMicDetectionPSA(tU8 u8MicNr)const;
   tenMicDetection tenGetMicDetectionJAC(tU8 u8MicNr)const;

   tsMicData tsMicDataElem;

private:
   tS32 s32GetMicVoltage(tU8 u8MicNr)const;
   //tS32 s32GetMicCurrentSUZ(tU8 u8MicNr)const;

   tS32 getADCmVoltage(tU8 u8MicNr)const;
   tS8  s8GetGPIOState(OSAL_enGpioPins GPIO_ID)const;

};

#endif /* fc_audiomanager_Microphone_H_ */
