
/*******************************************************************************
* FILE:          fc_audiomanager_DiaglogClientHandler_Microphone.cpp
* PROJECT:
* SW-COMPONENT:  Microphone Diagnosis in the FC_Audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   ClientHandler for the diaglog service of the Diagnosis
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                      | Modification
* 28.07.15  | CM-AI Wilhelmi, Erik        | Connected to diaglog handler of fc_audiomanager
* 02.02.15  | SoftTec Gaidatzi-Lken      | Inital version
*******************************************************************************/

/*******************************************************************************
                        Includes
*******************************************************************************/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include <ahl_if.h>

/* Include Diagnostics FI interface */
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_SERVICEINFO
#include <midw_fi_if.h>

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#include "fc_audiomanager_DiaglogClientHandler_Microphone.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#include "fc_audiomanager_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_MIC_DIAGNOSIS
#include "trcGenProj/Header/fc_audiomanager_DiaglogClientHandler_Microphone.cpp.trc.h"
#endif


/*******************************************************************************
                  Specific defines for this component
*******************************************************************************/
// Local defines for the wanted version of the CCX_DMSVR_FI


/*******************************************************************************
                  Message map for FunctionIDs to be handled
*******************************************************************************/

/* Message map for FunctionIds (FIDs) which are handled by this clienthandler */


/*******************************************************************************
                  Methods of class
*******************************************************************************/

/*******************************************************************************
**  FUNCTION:
*   fc_audiomanager_tclDiaglogClientHandler_Microphone(fc_streamrouter_tclApp* pMainAppl);
*   Constructor
*******************************************************************************/
fc_audiomanager_tclDiaglogClientHandler_Microphone::fc_audiomanager_tclDiaglogClientHandler_Microphone(
   fc_audiomanager_tclMicrophone_Diagnosis* pMainMicDiagApp)
   : IF_MessageObserver<PO_MessageConfig::enID>("fc_audiomanager_tclDiaglogClientHandler_Microphone")
{
    ETG_TRACE_USR4(("fc_audiomanager_tclDiaglogClientHandler_Microphone(): ENTERED"));

    m_pPO = InternalCommunicationAdapter::getInstance();
    m_poResultHandler = NULL;
    m_pMainMicDiagApp = NULL; //coverity warning fix
    vAddObserver();
  // Initialization of member variables
  if (pMainMicDiagApp != NULL)
    {
        m_pMainMicDiagApp = pMainMicDiagApp;
    }
  else
    {
    ETG_TRACE_ERR(("fc_audiomanager_tclDiaglogClientHandler_Microphone => ERROR: Microphone Diagnosis App pointer is NULL"));
  }
}

/*******************************************************************************
** FUNCTION:   virtual ~fc_audiomanager_tclDiaglogClientHandler_Microphone();
*  Destructor
*******************************************************************************/
fc_audiomanager_tclDiaglogClientHandler_Microphone
      ::~fc_audiomanager_tclDiaglogClientHandler_Microphone(tVoid)
{
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);

    m_pMainMicDiagApp = NULL;
    m_pPO = NULL;
    m_poResultHandler = NULL;
}

/********************************************************************************
 *    vAddObserver()
 *******************************************************************************/
void fc_audiomanager_tclDiaglogClientHandler_Microphone::vAddObserver()
{
   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglogClientHandler_Microphone::vAddObserver"));

   if(m_pPO != NULL)
   {
      m_pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_CCA_GetDiagResult);
   }
   else
   {
      ETG_TRACE_FATAL(( "vAddObserver: InternalCommunicationAdapter Instance pointer is NULL" ));
      FATAL_M_ASSERT_ALWAYS();
   }
}


/********************************************************************************
 *    MessageNotification(PO_MessageConfig::enID MsgId)
 *******************************************************************************/
void fc_audiomanager_tclDiaglogClientHandler_Microphone::MessageNotification(PO_MessageConfig::enID MsgId)
{
   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglogClientHandler_Microphone::MessageNotification(%i) entered. ", ETG_CENUM(PO_MessageConfig::enID, MsgId)));
   switch(MsgId)
   {
   case PO_MessageConfig::ID_CCA_GetDiagResult:
      {
         ETG_TRACE_USR4(("fc_audiomanager_tclDiaglogClientHandler_Microphone::MessageNotification: ID_CCA_GetDiagResult"));
         // request
         const ID_CCA_GetDiagResult* poMsg
            = InternalCommunicationAdapter::POMessages->QueryMessage<ID_CCA_GetDiagResult>(MsgId);
         if (NULL == poMsg)
         {
            ETG_TRACE_FATAL(("MessageNotification - could not retrieve message pointer for ID_CCA_GetDiagResult"));
            return;
         }
         m_poResultHandler = &(poMsg->roResultHandler);

         if (m_oFiTestResultObject.size() == 0)//Results are not yet calculated
         {

             if (poMsg -> roRequestedITCs.empty())
             {
                ETG_TRACE_USR4(("Requested List is empty -> Sending all available results"));
                //calculate the testresult for Mic1 diagnostic
                vCalculateDTCResult(ITC_MIC1_OPEN);
                vCalculateDTCResult(ITC_MIC1_SHORT_GND);
                vCalculateDTCResult(ITC_MIC1_SHORT_BAT);

                //calculate the testresult for Mic2 diagnostic
    #if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)
        if(m_pMainMicDiagApp->ptsGetMicDataListElem(2)->MicValid)
    #endif
        {
                vCalculateDTCResult(ITC_MIC2_OPEN);
                vCalculateDTCResult(ITC_MIC2_SHORT_GND);
                vCalculateDTCResult(ITC_MIC2_SHORT_BAT);
        }

                /* For AIVI project later
                //calculate the testresult for ANC Mic diagnostic
                vCalculateDTCResult(ITC_MIC_ANC1_OPEN);
                vCalculateDTCResult(ITC_MIC_ANC1_SHORT_GND);
                vCalculateDTCResult(ITC_MIC_ANC1_SHORT_BAT);
                */
             }
             else
             {
                ETG_TRACE_USR4(("Requested %d specific results", poMsg -> roRequestedITCs.size()));
                for (tU16 i=0; i < poMsg -> roRequestedITCs.size(); i++)
                {
                   vCalculateDTCResult(poMsg -> roRequestedITCs[i]);
                }
             }

         }//Results are just calculated but not sended because of not yet comming of MessageNotification message

         vSendTestResultToDiaglog(); // Send result if already available
       break;
     }
   default:
      break;
   }
}


/*******************************************************************************
                  Handler functions for FI messages
*******************************************************************************/

/*******************************************************************************
** FUNCTION:   vHandle_savetestresult_methodresult(amt_tclServiceData* poMessage)
*******************************************************************************/

/*******************************************************************************
** FUNCTION:   vHandle_sendnexttestresult_status(..) property
*******************************************************************************/

/*******************************************************************************
                  Specific functions of this application
*******************************************************************************/


/*******************************************************************************
** FUNCTION:   tVoid vAdaptDiaglogMicStatus();
* Adapt the mic results, call the calculate function for the appropriate microphone
*******************************************************************************/



tVoid fc_audiomanager_tclDiaglogClientHandler_Microphone::vAdaptDiaglogMicStatus(tU8 MicNr)
{

    if (1 == MicNr)
    {
        vCalculateDTCResult(ITC_MIC1_OPEN);
        vCalculateDTCResult(ITC_MIC1_SHORT_GND);
        vCalculateDTCResult(ITC_MIC1_SHORT_BAT);
    }
    else if (2 == MicNr)
    {
        vCalculateDTCResult(ITC_MIC2_OPEN);
        vCalculateDTCResult(ITC_MIC2_SHORT_GND);
        vCalculateDTCResult(ITC_MIC2_SHORT_BAT);
    }
 /*
    else if (3 == MicNr)
    {
        vCalculateDTCResult(ITC_MIC_ANC1_OPEN);
        vCalculateDTCResult(ITC_MIC_ANC1_SHORT_GND);
        vCalculateDTCResult(ITC_MIC_ANC1_SHORT_BAT);
    }
*/
}


/*******************************************************************************
** FUNCTION:   tVoid vCalculateDTCResult();
* Calculate the result of Mic and call the vSaveTestResult function
*******************************************************************************/

tVoid fc_audiomanager_tclDiaglogClientHandler_Microphone::vCalculateDTCResult(tU16 u16TroubleCode)
{
    tenTestResult tResult = EN_PASSED;
    tsMicData *ptsMicDataElem;

    if (m_pMainMicDiagApp == NULL)
    {
        ETG_TRACE_FATAL(( "vCalculateDTCResult: m_pMainMicDiagApp Pointer is NULL" ));
        return;
    }


    switch (u16TroubleCode)
    {
        case ITC_MIC1_OPEN:
        case ITC_MIC1_SHORT_GND:
        case ITC_MIC1_SHORT_BAT:

            ptsMicDataElem = m_pMainMicDiagApp->ptsGetMicDataListElem(1);

            if (ptsMicDataElem->MicValid == FALSE) // The Microphone 1 is not configured
            {
                ETG_TRACE_USR4(("vCalculateDTCResult():=> Diagnosis Test Result = MIC1 is not configured"));
                return;
            }
      if (ptsMicDataElem->MicState == MIC_STATE_UNKNOWN) // The Microphone 1 state UNKNOWN
            {
                ETG_TRACE_USR4(("vCalculateDTCResult():=> Diagnosis Test Result = MIC1 MIC_STATE_UNKNOWN"));
                tResult = EN_NORESULT;
            }

            if ((u16TroubleCode == ITC_MIC1_OPEN) && (ptsMicDataElem->MicState == MIC_STATE_OPEN))
            {
        ETG_TRACE_USR4(("vCalculateDTCResult():=> Diagnosis Test OPEN for MIC 1"));
                tResult = EN_FAILED;
                break;
            }

            if ((u16TroubleCode == ITC_MIC1_SHORT_GND) && (ptsMicDataElem->MicState == MIC_STATE_SHORT_TO_GROUND))
            {
        ETG_TRACE_USR4(("vCalculateDTCResult():=> Diagnosis Test SHORT TO GROUND for MIC 1"));
                tResult = EN_FAILED;
                break;
            }

            if ((u16TroubleCode == ITC_MIC1_SHORT_BAT) && (ptsMicDataElem->MicState == MIC_STATE_SHORT_TO_BATTERY))
            {
        ETG_TRACE_USR4(("vCalculateDTCResult():=> Diagnosis Test SHORT TO BATTERY for MIC 1"));
                tResult = EN_FAILED;
            }

        break;

        case ITC_MIC2_OPEN:
        case ITC_MIC2_SHORT_GND:
        case ITC_MIC2_SHORT_BAT:

            ptsMicDataElem = m_pMainMicDiagApp->ptsGetMicDataListElem(2);

            if (ptsMicDataElem->MicValid == FALSE) // The Microphone 2 is not configured
            {
                ETG_TRACE_USR4(("vCalculateDTCResult():=> Diagnosis Test Result = MIC2 is not configured"));
                return;
            }
      if (ptsMicDataElem->MicState == MIC_STATE_UNKNOWN) // The Microphone 2 state UNKNOWN
            {
                ETG_TRACE_USR4(("vCalculateDTCResult():=> Diagnosis Test Result = MIC2 MIC_STATE_UNKNOWN"));
                tResult = EN_NORESULT;
            }

            if ((u16TroubleCode == ITC_MIC2_OPEN) && (ptsMicDataElem->MicState == MIC_STATE_OPEN))
            {
        ETG_TRACE_USR4(("vCalculateDTCResult():=> Diagnosis Test OPEN for MIC 2"));
                tResult = EN_FAILED;
                break;
            }

            if ((u16TroubleCode == ITC_MIC2_SHORT_GND) && (ptsMicDataElem->MicState == MIC_STATE_SHORT_TO_GROUND))
            {
        ETG_TRACE_USR4(("vCalculateDTCResult():=> Diagnosis Test SHORT TO GROUND for MIC 2"));
                tResult = EN_FAILED;
                break;
            }

            if ((u16TroubleCode == ITC_MIC2_SHORT_BAT) && (ptsMicDataElem->MicState == MIC_STATE_SHORT_TO_BATTERY))
            {
        ETG_TRACE_USR4(("vCalculateDTCResult():=> Diagnosis Test SHORT TO BATTERY for MIC 2"));
                tResult = EN_FAILED;
            }

        break;
/*
        case ITC_MIC_ANC1_OPEN:
        case ITC_MIC_ANC1_SHORT_GND:
        case ITC_MIC_ANC1_SHORT_BAT:

            ptsMicDataElem = m_pMainMicDiagApp->ptsGetMicDataListElem(3);

            if (ptsMicDataElem->MicValid == FALSE) // The ANC Microphone 1 is not configured
            {
                ETG_TRACE_USR4(("vCalculateDTCResult():=> Diagnosis Test Result = ANC MIC is not configured"));
                return;
            }

            if (u16TroubleCode == ITC_MIC_ANC1_OPEN)
            {
                ETG_TRACE_USR4(("vCalculateDTCResult():=> Diagnosis Test OPEN for ANC MIC"));
            }else if (u16TroubleCode == ITC_MIC_ANC1_SHORT_GND)
            {
                ETG_TRACE_USR4(("vCalculateDTCResult():=> Diagnosis Test SHORT TO GROUND for ANC MIC"));
            }else if (u16TroubleCode == ITC_MIC_ANC1_SHORT_BAT)
            {
                ETG_TRACE_USR4(("vCalculateDTCResult():=> Diagnosis Test SHORT TO BATTERY for ANC MIC"));
            }

            if ((u16TroubleCode == ITC_MIC_ANC1_OPEN) && (ptsMicDataElem->MicState == MIC_STATE_OPEN))
            {
                bResult = FALSE;
                break;
            }

            if ((u16TroubleCode == ITC_MIC_ANC1_SHORT_GND) && (ptsMicDataElem->MicState == MIC_STATE_SHORT_TO_GROUND))
            {
                bResult = FALSE;
                break;
            }

            if ((u16TroubleCode == ITC_MIC_ANC1_SHORT_BAT) && (ptsMicDataElem->MicState == MIC_STATE_SHORT_TO_BATTERY))
            {
                bResult = FALSE;
            }

        break;
*/
        default:
           ETG_TRACE_ERR(("vCalculateDTCResult(): Received unknown trouble code %d (0x%x)", u16TroubleCode, u16TroubleCode));
       return;
    }

    vSaveTestResult(u16TroubleCode, tResult);
}


/*******************************************************************************
** FUNCTION:   tVoid vSaveTestResult();
* Save the Test Results to the CCA Msg for later sending to Diaglog
*******************************************************************************/

tVoid fc_audiomanager_tclDiaglogClientHandler_Microphone::vSaveTestResult(tU16 u16TroubleCode, tenTestResult tResult)
{
   tTestResult oTestData;
  // Set the parameters of the FI data object

  oTestData.u16ID = u16TroubleCode;

    oTestData.enResult = tResult;
    ETG_TRACE_USR4(("vSaveTestResult():=> TroubleCode:%i, Diagnosis Test Result = %d", u16TroubleCode,tResult));


  //add the testData to the TestResultList
   m_oFiTestResultObject.push_back(oTestData);
}



/*******************************************************************************
** FUNCTION:   tVoid vSendTestResultToDiaglog();
* Send all the Test Results to Diaglog (1 CCA Msg for all results together)  (Method of this application)
*******************************************************************************/

tVoid fc_audiomanager_tclDiaglogClientHandler_Microphone::vSendTestResultToDiaglog()
{

  if (m_oFiTestResultObject.size() > 0)
  {
        if (m_poResultHandler != NULL)
        {
            ETG_TRACE_USR3(("vSendTestResultToDiaglog - sending %u results to result handler", m_oFiTestResultObject.size()));
            m_poResultHandler->vSaveDiagResult(m_oFiTestResultObject);
        }
        else
        {
            ETG_TRACE_ERR(("DiagLog result handler not set"));
        }

        m_oFiTestResultObject.clear();
  }
  else
  {
    ETG_TRACE_USR4(("vSendTestResultToDiaglog() - NO Testresult to send to diaglog"));
  }
}


