/*
 * BoosterDiaglogHandler.h
 *
 *  Created on: Oct 18, 2017
 *      Author: rjk2kor
 */
#ifndef FC_AUDIOMANAGER_BOOSTER_DIAGLOG_HANDLER_H_
#define FC_AUDIOMANAGER_BOOSTER_DIAGLOG_HANDLER_H_

#include "MessageConfig.h"
#include "InternalCommunicationAdapter.h"
#include "Messages/Diag/ID_CCA_GetDiagResult.h"
#include <vector>

 /**
 * This class is responsible for interfacing with Diaglog
 */
class BoosterDiaglogHandler:public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
  BoosterDiaglogHandler();
  virtual ~BoosterDiaglogHandler();
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);//Message notification function from post office

private:
  IF_DiagResultHandler* m_poResultHandler;
  tU16   m_u16LastTroubleCode;
  tS16   m_s16LastTestResult;
  tBool  m_bForceSendNextResult;
  std::vector<tTestResult>  m_testresultlist;
  tVoid vSaveTestResult(tU16 u16TroubleCode, tS16 s16Result);//Helper function to update the test result list
  tVoid vTrySendTestResulttoDiaglog();//Helper function to send test result to diaglog
 };




 #endif //FC_AUDIOMANAGER_BOOSTER_DIAGLOG_HANDLER_H_

