/*
 * BoosterDiaglogHandler.cpp
 *
 *  Created on: Oct 19, 2017
 *      Author: rjk2kor
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>   // implicitly links generic osal_if.h

#include "fc_audiomanager_main.h"
#include "fc_audiomanager_trace.h"
#include "fc_audiomanager_trace_macros.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUD_SINKMGR_APPLICATION
#include "trcGenProj/Header/BoosterDiaglogHandler.cpp.trc.h"
#endif

#include "../../PostOffice/PostOffice.hpp"
#include "InternalComponentCommunication/Messages/booster/IDNotifyBoosterTestResult.h"
#include "fc_audiomanager_main.h"

#include "BoosterDiaglogHandler.h"


/******************************************************************************/
/* constructor                                                                */
/******************************************************************************/
BoosterDiaglogHandler::BoosterDiaglogHandler()
: IF_MessageObserver<PO_MessageConfig::enID>("BoosterDiaglogHandler")
,m_poResultHandler(NULL)
,m_u16LastTroubleCode(0)
,m_s16LastTestResult(0)
,m_bForceSendNextResult(TRUE)//WE should always send first test result
,m_testresultlist()
{
  //Register for Booster test result
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::IDNotifyBoosterTestResult);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_CCA_GetDiagResult);

}

/**
 * Destructor
 */
BoosterDiaglogHandler::~BoosterDiaglogHandler()
{
  //Clear reference to result handler
  m_poResultHandler = NULL;
  //Deregister observer
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
}


/******************************************************************************/
//  MessageNotification()
/******************************************************************************/
tVoid BoosterDiaglogHandler::MessageNotification(PO_MessageConfig::enID MsgId)
{
  switch(MsgId)
  {
  case PO_MessageConfig::IDNotifyBoosterTestResult:
  {
    ETG_TRACE_USR4(("::Booster Diaglog::  MessageNotification: IDNotifyBoosterTestResult"));
    // Obtaining the Message from PostOffice handler
    const IDNotifyBoosterTestResult*     pMsg = InternalCommunicationAdapter::POMessages->QueryMessage<IDNotifyBoosterTestResult>(MsgId);
        if (NULL == pMsg)
        {
           NORMAL_M_ASSERT_ALWAYS();
           return;
        }
    vSaveTestResult(pMsg->m_u16TroubleCode,pMsg->m_s16Result);
    break;
  }
  case PO_MessageConfig::ID_CCA_GetDiagResult:
    {
        ETG_TRACE_USR4(("::Booster Diaglog::  MessageNotification: ID_CCA_GetDiagResult"));
        // request
        const ID_CCA_GetDiagResult* poMsg = InternalCommunicationAdapter::POMessages->QueryMessage<ID_CCA_GetDiagResult>(MsgId);
        if (NULL == poMsg)
        {
           NORMAL_M_ASSERT_ALWAYS();
           return;
        }
        m_poResultHandler = &(poMsg->roResultHandler);
    //Send available results to diaglog
        vTrySendTestResulttoDiaglog();
    //Send next test result to Diaglog
    m_bForceSendNextResult = TRUE;
    break;
  }
  default:
  {
    ETG_TRACE_ERR(("::Booster Diaglog:: !!! Unhandled message !!!"));
  }
  break;
  }
}
/**
* vSaveTestResult Function implementation
*  - Compare the received result with the previous received result and will update diaglog only when results are different
*/
tVoid BoosterDiaglogHandler::vSaveTestResult(tU16 u16TroubleCode, tS16 s16Result)
{
  ETG_TRACE_USR4(("::Booster Diaglog:: Save Test Result received. Trouble Code=%d, Result=%d, ForceSend=%d",u16TroubleCode,s16Result,m_bForceSendNextResult));
  //Check if we have to force send the test result
  if(FALSE == m_bForceSendNextResult)
  {
    if((u16TroubleCode == m_u16LastTroubleCode) && (s16Result == m_s16LastTestResult))
    {
      ETG_TRACE_USR4(("::Booster Diaglog:: No Change in Test Result."));
      return;
    }
  }

  //Clear the force send flag
  m_bForceSendNextResult = FALSE;

  //Update buffers
  m_u16LastTroubleCode = u16TroubleCode;
  m_s16LastTestResult = s16Result;

  //updates latest result for same troublecode
  std::vector<tTestResult> ::iterator itr;
   if (m_testresultlist.size()>0)
  {
    for (itr = m_testresultlist.begin(); itr < m_testresultlist.end(); itr++)
    {
      if (itr->u16ID == u16TroubleCode)
      {
        ETG_TRACE_USR4(("updating new result for the same troublecode"));
        itr->enResult = (tenTestResult)s16Result;
        vTrySendTestResulttoDiaglog();
        return;
      }
    }
  }

  //Add the data to test result list
  tTestResult oTestData;
  oTestData.u16ID = u16TroubleCode;
  oTestData.enResult = (tenTestResult)s16Result;

  m_testresultlist.push_back(oTestData);
  //Try sending the test result to diaglog
  vTrySendTestResulttoDiaglog();
}

tVoid BoosterDiaglogHandler::vTrySendTestResulttoDiaglog()
{
  //1. Check if result handler is available.
  if(m_poResultHandler == NULL)
  {
    ETG_TRACE_USR4(("::Booster Diaglog:: Diaglog Result Handler not available. Test result buffered"));
    return;
  }

  //2. Check if the list is not empty
  if(m_testresultlist.empty())
  {
    ETG_TRACE_USR4(("::Booster Diaglog:: No Results to send."));
    return;
  }

  //3. Clear test result list after send.
  m_poResultHandler->vSaveDiagResult(m_testresultlist);
  m_testresultlist.clear();
  ETG_TRACE_USR4(("::Booster Diaglog:: Test results updated to Diaglog"));
}



