/*
 * Booster.h
 *
 *  Created on: Aug 29, 2017
 *      Author: rjk2kor
 */

#ifndef FC_AUDIOMANAGER_AUD_SINKMANAGER_AUD_SINKMGR_BOOSTER_H_
#define FC_AUDIOMANAGER_AUD_SINKMANAGER_AUD_SINKMGR_BOOSTER_H_

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#include "MessageConfig.h"
#include "InternalCommunicationAdapter.h"
#include "DataTypes/TypeDefines/DiagControlLineType.h"
#include "Messages/Diag/ID_CCA_GetDiagResult.h"

/******************************************************************
* CONFIGURATION MACROS
*******************************************************************/
#define BOOSTER_SUPERVISION_TIMER_START_TIC      (100)   //Timer start tic in milli seconds
#define BOOSTER_SUPERVISION_TIMER_REPEAT_TIC    (1000)   //Timer tic for repeat in milli seconds

#define BOOSTER_RECOVERY_TIMER_START_TIC      (2000)
#define BOOSTER_RECOVERY_TIMER_REPEAT_TIC      (0)

/*******************************************************************
* CLASS DECLARATION
*******************************************************************/
//Feed forward declarations
class fc_audiomanager_tclApp;

#define AUD_BOOSTER_OFF   FALSE
#define AUD_BOOSTER_ON    TRUE


/**
 * Class that implements various booster control features like
 *  - Turn ON/OFF Booster
 *  - Diagnosis of booster pin
 *  - Over Current detection and automatic switch OFF of booster
 */
class Booster:public IF_MessageObserver<PO_MessageConfig::enID>
{
private:
  InternalCommunicationAdapter*   m_pPO; // Pointer for post office access
  tBool              m_Req_BoosterState;///Member variable to hold current state of the booster object -> Reflects requested

  //Internals
  tBool              m_AmpOnPinState;//Variable reflects Actual state of AMP On GPIO Pin
  tBool              m_DiagFreezeActive;//Flag used to check if diagnosis freeze is active on this PIN

  fc_audiomanager_tclApp*     m_poMain;
  aud_async_call_handler*      m_async;//Pointer to async call handler
  OSAL_tTimerHandle         m_hBoosterSupervisionTimer;//Timer handle
  OSAL_tTimerHandle         m_hBoosterRecoveryTimer;//Timer handle


  /** Member funcitons **/
  tBool   bPerformTest();//Function that implemnets the test
  tBool   bSetBoosterControlLine(tBool bState);
  tVoid   vHandleDiagControlLineFreeze(tenDiagControlLinePhase ePhase);
  tS8   s8GetDiagPinState() const;//Helper function to get the diagpin state

  /** Helper functions for starting and stopping booster line supervision **/
  tBool  bStartBoosterLineSupervision();//Helper function to start timer to perform diagnosis
  tVoid  vStopBoosterLineSupervision();//Helper function to stop diag timer
  /** Helper functions for starting and stopping booster line recovery **/
  tBool  bStartBoosterLineRecovery();//Helper function to start timer to perform diagnosis
  tVoid  vStopBoosterLineRecovery();//Helper function to stop diag timer

  /** Timer callback function **/
  static tVoid vBoosterSupervisionTimerCallback(tVoid* pArg);
  static tVoid vBoosterRecoveryTimerCallback(tVoid* pArg);
public:
  Booster(fc_audiomanager_tclApp* pApp);
  virtual ~Booster();
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);//Message notification function from post office

  tVoid   vPerformAmpOnDiagnosis();  //Helper function that performs diagnosis and sets the state of the booster
  tVoid   vInit();        //Initialize booster
  tVoid  vRecoverBooster();
private:
  //Explicit Privates
  Booster();
  Booster(const Booster&);
};


#endif /* FC_AUDIOMANAGER_AUD_SINKMANAGER_AUD_SINKMGR_BOOSTER_H_ */
