/*
 * beep_player_alsahw.h
 *
 *  Created on: Aug 15, 2016
 *      Author: rjk2kor
 */

#ifndef BEEP_PLAYER_ALSAHW_H_
#define BEEP_PLAYER_ALSAHW_H_

#include <alsa/asoundlib.h>
#include <sndfile.h>

/**
 * Period time and buffer time have to be mentioned in micro seconds
 */
#define BEEP_ALSA_PERIOD_TIME (200000)
#define BEEP_ALSA_BUFFER_TIME (3*BEEP_ALSA_PERIOD_TIME)
#define BEEP_ALSA_DEV_OUTPUT_CHANNELS 1

class beep_player_alsa_device
{
public:
  beep_player_alsa_device();
  virtual ~beep_player_alsa_device();
  //Sets up the hardware based on the file to play
  bool bInitAlsaDev(const char* alsadevname, unsigned int samplerate, unsigned int channels);
  //Helper function invoked to deinitialize hardware
  bool bDeInit();

  snd_pcm_uframes_t uGetPeriodSize(){return m_periodsize;}
  snd_pcm_uframes_t uGetBufferSize(){return m_buffersize;}
  snd_pcm_t* poGetDevHandle() {return m_dev_handle;}
  unsigned int getChannels() {return m_channels;}

private:
  //Set the hardware configuration
  bool bSetHWConfiguration(unsigned int samplerate,unsigned int channels);
  //Set the software configuration
  bool bSetSWConfiguration();
  //Helper to set sample format
  bool bSetSampleFormat(snd_pcm_hw_params_t *hw_params);//You have to negotiate and set format, instead of hardcoding
  //Helper to set sample rate
  bool bSetSrcSampleRate(snd_pcm_hw_params_t *hw_params, unsigned int smplrate);
  //Helper function to enable hardware resampling
  bool bEnableHWResampling(snd_pcm_hw_params_t *hw_params);
  //Helper to set audio format to interleaved
  bool bSetPCMAccessType(snd_pcm_hw_params_t *hw_params);
  //Helper to set channels
  bool bSetChannels(snd_pcm_hw_params_t *hw_params, unsigned int channels);
  //Helper to set the period time in milliseconds
  bool bSetPeriodTime(snd_pcm_hw_params_t *hw_params, unsigned int time_ms);
  //Helper to set the buffer time
  bool bSetBufferTime(snd_pcm_hw_params_t *hw_params, unsigned int time_ms);
  //Helper to set period time
  //Private member to hold alsa device handle
  snd_pcm_t * m_dev_handle;
  snd_pcm_uframes_t m_periodsize;
  unsigned int m_channels;
  snd_pcm_uframes_t m_buffersize;


  bool bWrap(int, const char* str);
};


#endif /* BEEP_PLAYER_ALSAHW_H_ */
