/*******************************************************************************
 *
 * FILE:          beep_player_backend_IF.h
 *
 * SW-COMPONENT:  Beep file player application
 *
 * DESCRIPTION:   Beep file player backend interface description
 *
 * AUTHOR:        pmh7kor
 *
 * COPYRIGHT:    (c) 2016 RBEI, Bangalore
 *
 *******************************************************************************/

#ifndef BEEP_PLAYER_BACKEND_IF_H_INCLUDE_
#define BEEP_PLAYER_BACKEND_IF_H_INCLUDE_

#include "Beep_playback_status_IF.h"

class beep_player_backend_IF
{
public:
  beep_player_backend_IF(){}
  virtual ~beep_player_backend_IF(){}

  //Initialize player... once at startup
  virtual bool     bInitializePlayer()=0;
  //Function to be used to play single files
  virtual bool    bPrepare(const char *p_filePath, const char *p_deviceName, bool bRepeat ,unsigned int recurrence)=0;
  //Function to update file during an active playback. If not supported or error encountered, return error
  virtual bool     bUpdateActiveFile(const char* active_file)=0;
  //Function to update recurrence during an acitve playback
  virtual bool     bUpdateRecurrence(int recurrence)=0;
  //Tears down the current playback setup, frees resources
  virtual void     vTearDown()=0;
  //Deinitialize player .. once at shutdown
  virtual bool     bDeinitPlayer()=0;

  //-----------------------------PLAYBACK CONTROL FUNCTIONS---------------------
  //To start playing
  virtual bool     bPlay()=0;
  //To stop playing
  virtual bool     bStop(beep_player_stop_mode eMode)=0;
};

#endif
