/*******************************************************************************
 *
 * FILE:          Beep_playback_status_IF.h
 *
 * SW-COMPONENT:  Beep file player application
 *
 * DESCRIPTION:   Beep Playback status Interface
 *
 * AUTHOR:        pmh7kor
 *
 * COPYRIGHT:    (c) 2015 RBEI, Bangalore
 *
 *******************************************************************************/
#ifndef _BEEP_PLAYBACK_STATUS_IF_
#define _BEEP_PLAYBACK_STATUS_IF_


/**
 * Enumeration for different stop modes
 */
enum beep_player_stop_mode
{
  STOP_IMMEDIATELY, //Stop immediately -> Not supported
  STOP_AFTER_PLAYING_BUFFER, //Stop after current buffer is finished
  STOP_AFTER_EOF,//Stop after End of file is reached
  STOP_MAX
};

enum beep_player_error
{
  BP_ERR_NO_ERROR=0,
  BP_ERR_EOF_REACHED=1,
  BP_ERR_WRITE_FAILED=2,
  BP_ERR_UNKNOWN=3,
  BP_ERR_ERR_MAX
};

class Beep_playback_status_IF
{
public:
  virtual void vOnPlaybackStatus(tU8 u8Sts) = 0;
  virtual ~Beep_playback_status_IF(){}

};

#endif
