/*******************************************************************************
 *
 * FILE:          Beep_PrioHandler.h
 *
 * SW-COMPONENT:  Beep
 *
 * DESCRIPTION:   Beep Priority handling
 *
 * AUTHOR:        Vaijayanti Vadiraj
 *
 * COPYRIGHT:    (c) 2012 RBEI
 *
 *******************************************************************************/
/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

#ifndef BEEPPRIORITYHANDLER_H_
#define BEEPPRIORITYHANDLER_H_

#include "BeepData.h"
#include "Macro.h"
#include "BeepPrioHandler_IF.h"

//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include <stl_pif.h>



#include <vector>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


using namespace std;

class Beep_Main;
class BeepPrioConf;
class BeepNotification_IF;

#define MAX_BEEP_QUEUESIZE 30

class Beep_PrioHandler: public BeepPrioHandler_IF
{
  static Beep_PrioHandler* Beep_PrioHandlerInstance;
public:
  friend class PrioHandlerTest;
  friend class MainTest;
  Beep_PrioHandler(BeepNotification_IF* pBeepNotification_IF,vector <BeepPrioConf*>& rfPrioConfTable);

  static Beep_PrioHandler* getInstance();

  virtual tU8 u8SetRequest(tU8,  BeepNotification_IF* beep, BeepParameter_IF* beep_param, tU8*);
  virtual tU8 getSizeOfQueue(void) const;
  virtual void ClearRequest(tU8);
  virtual void vIdleBeep(tU8, tU8);
  void vSetBeepNotification_IF(BeepNotification_IF* pBeep_Main);
  bool blCheckMaxQueueSize(void);
  bool bCheckForReject(tU8 beepName);
  bool bCheckForUniqueReject(tU8 beepName);
  void bCheckForRemove(tU8 beepName);
  bool bcheckForTempStop(tU8 beepName);
  void vInsertWithPrio(tU8 newBeepName, BeepData* bd);
  bool bCheckForInsertOrReplaceBeep(tU8 beepName,BeepData* bd);
  virtual void vClearQueue(void);
  virtual void vPlayBeepIfQueueNotEmpty();
  void vInit(void);
  bool blCheckForBeepInQueue(tU8 beepName);
  tU8  u8GetPrioHandlerState(void) const;
  tU8  u8GetBeepName(tU8 listIndex);
  void removeFromQueue(tU8 beepId);
  bool bCheckForStopImmediately(tU8 beepName);
  bool bCheckDoNotPutInQueue(tU8 newBeepName);
  virtual void PrintBeepsInTheQueue(void);

  virtual  ~Beep_PrioHandler();

private:

  tU8 aud_BeepPrio_ubNextBeepID;
  tU8 aud_BeepPrio_ubState;
  vector <BeepPrioConf*>& BeepPrioConfTable;
  vector <BeepData> lstBeepControlData;
  BeepNotification_IF* poBeepNotification;


};
#endif /* BEEPPRIORITYHANDLER_H_ */

