#ifndef BEEP_DATA_H
#define BEEP_DATA_H

#include "../Beep_defines.h"
#include "../BeepNotification_IF.h"
#include "../BeepParameter_IF.h"

//#define SYSTEM_S_IMPORT_INTERFACE_STRING
//#include <stl_pif.h>


#include <string>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"




using namespace std;

class BeepNotification_IF;
class BeepParameter_IF;

class BeepData
{
public:
  BeepData();
  /**
   * COMMON BEEP PARAMETERS
   */
  tU8 ubBeepName;
  tU8 ubBeepID;
  tenBeepPrioState tenState;
  tU32  u32BeepToken;

  //New parameters added to the existing ones
  tU8    m_u8Source;//Source to be used to generate the beep
  tS16    m_s16VolumeStep;//Volume Step. Will be used in actuator tests
  tS16  m_s16Gain;//Volume gain in dB to be used to generate beep

  //Sound system type is not handled here, latest value will be requested from beep_main always

  /**
   * Beep Volume offsets
   */
  BeepControlData::ChVolOff  m_channeloffsets;
  /**
   * DATA SPECIFIC TO BEEPS GENERATED BY IMX
   */
  string m_filepath;
  /**
   * DATA SPECIFIC TO BEEPS GENERATED BY ADR3
   */
  BeepControlData::BeepPara m_beepparam;
  BeepControlData::ChimePara m_chimeparam;
  /**
   * POINTER TO NOTIFICATION AND PARAMETER INTERFACES
   */
  BeepNotification_IF* poBeepNotification_IF;
  BeepParameter_IF* poBeepParameter_IF;

  bool m_bIsValid;//Validity flag will be set to true only when extended data is loaded
  //Function to get extended data
  bool bGetExtendedData();
};

#endif
