/*******************************************************************************
 *
 * FILE:          Beep_Defines.h
 *
 * SW-COMPONENT:  Beep Defines
 *
 * PROJECT:
 *
 * DESCRIPTION:   Global defines for Beep
 *
 * AUTHOR:       Ramesh Babu .K
 *
 * COPYRIGHT:    (c) 2012 RBEI, Bangalore
 *
 *******************************************************************************/

#ifndef _BEEP_DEFINES_H_
#define _BEEP_DEFINES_H_

#include "../ExternItf/CCA/FI_Message/FI_Includes.h"
#include "Config/beep_prj_defines.h"

#define ADR_DB_RESOLUTION      4   //(1/4 DB)
#define CHANNEL_MUTE (-120*ADR_DB_RESOLUTION)   //-120 dB

//#define BEEP_COUNT   EN_AUDIO_BEEP_ACTUATOR_DIAGNOSIS

/* States for Notification */
enum
{
  BEEP_STOPPED,
  BEEP_START_IP,
  BEEP_STARTED,
  BEEP_REJECTED,
  BEEP_STOP_IP,
  BEEP_QUEUED,
  BEEP_UNIQUE_REJECTED,
  AUD_SIG_TONE_TERMINATING,
  BEEP_STATE_UNDEFINED
};

/* Defines for Beep controller events*/
enum BeepControlEvent
{
  EN_NEW_BEEP_REQUEST,
  EN_STOP_BEEP,
  EN_NOTIFY_MUTE,
  EN_NOTIFY_DEMUTE,
  EN_NOTIFY_BEEP_STATE,
  EN_BEEP_CHECK_ADRSTATUS
};

/* internal states of beep */
enum BeepControlState
{
  BEEP_STATE_INIT,
  BEEP_STATE_OFF,
  BEEP_STATE_MUTE_IP,
  BEEP_STATE_DEMUTE_IP,
  BEEP_STATE_VOL_READY,
  BEEP_STATE_ON,
  BEEP_STATE_STOP_IP
};

enum tenBeepStopType
{
  BEEP_STOP_IMMEDIATE = 1,
  BEEP_STOP,
  BEEP_STOP_UNDEFINED = 255
};

//Defines for Beep source
enum tenBeepSource
{
  BEEP_SRC_SOUNDGENERATOR1 = 0x20,
  BEEP_SRC_SOUNDGENERATOR2,
  BEEP_SRC_SAMPLEPLAYER
};

enum
{
  TESTTONE_HMI = 1,
  TESTTONE_DIAGNOSIS
};

enum tenBeepPrioState
{
  AUD_BEEPPRIOSTATE_OFF = 0,
  AUD_BEEPPRIOSTATE_ON = 1,
  AUD_BEEPPRIOSTATE_TMPOFF = 3
};

enum
{
  TRIANGULAR = 1,
  SINUSOIDAL = 4,
  BEEP_GST_PLAYER
};

/**
 * Class to hold the configuration data for Beeps from IMX
 */
enum
{
  BEEP_VOL_TYPE_SYSTEM_DEFAULT = 0,
  BEEP_VOL_TYPE_USER_SPECIFIC = 1
};


enum tenAdasRecurrenceType
{
  DISCONTINUOUS = 0,
  CONTINUOUS
};

enum tenAdasVolumeLevel
{
  VOLUME_LEVEL_0 = 0x0,
  VOLUME_LEVEL_1,
  VOLUME_LEVEL_2,
  VOLUME_LEVEL_3,
  VOLUME_LEVEL_4,
  VOLUME_LEVEL_5
};

enum tenAdasVolLevelOffset
{
  VOLOFFSET_LVL0 = -120,
  VOLOFFSET_LVL1 = -8,
  VOLOFFSET_LVL2 = -4,
  VOLOFFSET_LVL3 = 0,
  VOLOFFSET_LVL4 = 4,
  VOLOFFSET_LVL5 = 8
};

enum tenPSMSlotDisplay
{
  No_DISPLAY = 0x0,
  LEFT_DISPLAY = 0x01,
  RIGHT_DISPLAY = 0x02,
  LEFT_RIGHT_DISPLAY = 0x03
};

enum tenHFPScanningSide
{
  NO_SCANNING_SIDE = 0x0,
  LEFT_SIDE = 0x01,
  RIGHT_SIDE = 0x02,
  SIDE_UNAVAILABLE = 0x03
};
enum tenAdasBeepType
{
  BIP = 0x1,
  CORDE,
  SONAR
};


enum tenAdasObstacleZoneSoundType
{
   EN_OBSTACLEZONE_NoSound     = 0,
   EN_OBSTACLEZONE_FrontLeft   = 1,
   EN_OBSTACLEZONE_FrontCenter = 2,
   EN_OBSTACLEZONE_FrontRight  = 3,
   EN_OBSTACLEZONE_RearLeft    = 4,
   EN_OBSTACLEZONE_RearCenter  = 5,
   EN_OBSTACLEZONE_RearRight   = 6
};

enum tenADAS_UPA_Config
{
  UPA_AUDIO_NOT_PRESENT    = 0x00,
  UPA_AUDIO_WITHOUT_SETTINGS  = 0x01,
  UPA_AUDIO_WITH_SETTINGS    = 0x02
};
enum tenRCTA_Config
{
   RCTA_AUDIO_NOT_PRESENT    = 0x00,
   RCTA_AUDIO_PRESENT    = 0x01
};

enum ten_UPA_Status_DisplayRequest
{
MANOEUVERING_MODE=0x00,
FRONT_ACTIVATED = 0x02,
REAR_ACTIVATED  = 0x04,
FRONT_AND_REAR_ACTIVATED=0x06
};


enum ten_RCTA_Collision_Alert
{
LOW_COLLISION_RISK  = 0x00,
HIGH_COLLISION_RISK  = 0x01
};
enum ten_RCTA_Alert
{
NO_ALERT  = 0x00,
RCTA_ALERT_RF= 0x01,
RCTA_ALERT_LF = 0x02,
RCTA_ALERT_RF_LF
};


enum tenADAS_LDW_Config
{
  LDW_NOT_PRESENT = 0x00,
  LDW_PRESENT = 0x01,
  LDW_HAPTIC = 0x02
};

enum tenADAS_HFP_Config
{
  HFP_NOT_PRESENT    = 0x00,
  HFP_PRESENT      = 0x01,
  HFPB_PRESENT    = 0x02,
  APK_PRESENT      = 0x03
};

enum tenADAS_PSM_Config
{
  PSM_NOT_PRESENT    = 0x00,
  PSM_PRESENT      = 0x01 // to be checked in new diagnostics alliance pdf
};

enum tenADAS_SR_Config
{
  SR_NOT_PRESENT = 0x00,
  SR_PRESENT = 0x01
};

enum tenADAS_AutoRecordStatus
{
  NO_AUTO_RECORD_REQUEST = 0x00,
  AUTO_RECORD_IN_PROGRESS = 0x01,
  AUTO_RECORD_END = 0x02
};

enum tenADAS_CustomerRecordStatus
{
  NO_CUST_RECORD_REQUEST = 0x00,
  CUST_RECORD_IN_PROGRESS = 0x01,
  CUST_RECORD_STOPPED = 0x02,
  CUST_RECORD_END = 0x03
};


enum tenADAS_LDWSoundAlertStatus
{
  NO_LANE_DEPARTURE = 0x00,
  LANE_DEPARTURE_ON_RIGHT = 0x01,
  LANE_DEPARTURE_ON_LEFT = 0x02,
  NOT_USED = 0x03
};


enum tenConfigAudioSpeakers
{
  REAR_ONLY = 0x00,
  REAR_AND_FRONT = 0x01
};

#define VOLOFFSET_RESOLUTION 4
#define OEM_TYPE_NISSAN       0x06
#define OEM_TYPE_RENAULT      0x08
#define OEM_TYPE_INFINITI     0x16
#define OEM_TYPE_MITSUBISHI      0x17

#define RECURRENCE_PERIOD_MAX    (100)
/**
 * Class to hold the configuration data for Beeps from IMX
 */
class BeepFile_Config
{
public:
  tU8 VolumeType;
  tS16 Volume;

  BeepFile_Config(tU8 voltype,tS16 volume):VolumeType(voltype),Volume(volume){}
  BeepFile_Config(const BeepFile_Config& pMsg) :VolumeType(pMsg.VolumeType),Volume(pMsg.Volume){}
};

#endif //_BEEP_DEFINES_H_
