
/*******************************************************************************
*
* FILE:          Beep_Volumeoffsets.h
*
* SW-COMPONENT:  Beep volumeoffsets application
*
* PROJECT:
*
* DESCRIPTION:   Beep volume offsets Class.
*
* AUTHOR:       pmh7kor
*
* COPYRIGHT:    (c) 2016 RBEI, Bangalore
*
*******************************************************************************/
#ifndef _BEEP_VOLUMEOFFSETS_H_
#define _BEEP_VOLUMEOFFSETS_H_

#include "MessageConfig.h"
#include "InternalCommunicationAdapter.h"



#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#include "csm_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
#define MIDW_COMMON_S_IMPORT_INTERFACE_CSM   // CSM_C_PROJECT_RN_AIVI will be enabled to test this ADAS feature for IVI
#include "midw_common_if.h"
#endif




#include "fc_audiomanager_service_Audio_Function.h"

//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#define SYSTEM_S_IMPORT_INTERFACE_ITERATOR
//#define SYSTEM_S_IMPORT_INTERFACE_MAP
//#include <stl_pif.h>




#include <map>
#include <vector>
#include <iterator>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"





#include "../InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeOffsetData.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/ADR3DiagType.h"
#include "Beep_defines.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/PowerState.h"
#include "../InternalComponentCommunication/Messages/power/ID_AudioState.h"
using namespace std;

#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
class CSMInterfaceClient;
class CSMInterface;
#endif
class fc_audiomanager_tclService_Audio_Function;
class fc_audiomanager_tclApp;

#define AUDIOAVAILABLE 0
#define AUDIOUNAVAILABLE 1
#define AUDIO_AVIALIBILITY_UNDEFINED 255

/* class to contain channel Id and Channel Offset*/
class channelData
{
public:
  tU8 m_channelId;
  tS16 m_channelOffset;

  channelData(tU8 tchannelId) : m_channelId(tchannelId)
  {
    m_channelOffset = CHANNEL_MUTE;
  }

  tVoid vSetoffset(tS16 toffset)
  {
    m_channelOffset = toffset;
  }

  tS16 Getoffset()
  {
    return m_channelOffset;
  }
  bool operator==(const channelData& rhs) const
  {
    return (m_channelId == rhs.m_channelId);
  }
};

/* class which has vector of channelData objects */
class channelremapoffsetList
{
public:
  vector<channelData> m_channelData;
  channelremapoffsetList() {}
  channelremapoffsetList(tU8 ch1, tU8 ch2, tU8 ch3, tU8 ch4)
  {
    m_channelData.push_back((channelData)ch1),
    m_channelData.push_back((channelData)ch2);
    m_channelData.push_back((channelData)ch3);
    m_channelData.push_back((channelData)ch4);
  }

  /* function to set volume offset in a channel when there is no error in the channel */
  tVoid vRemapchannelOffsetonError(map<tU8, tU8>& ErrorStatusMap, tS16 ChannelOffset)
  {
    vector<channelData>::iterator it;

    for (it = m_channelData.begin(); it != m_channelData.end(); it++)
    {
      if ((ErrorStatusMap[it->m_channelId] == EN_AUDIO_DIAG_ERRVAL_NO_ERROR) || (ErrorStatusMap[it->m_channelId] == EN_AUDIO_DIAG_ERRVAL_UNDEF))
      {
        (*it).vSetoffset(ChannelOffset);
        break;
      }
    }
  }

  /* function to get volume offset from channel Data vector for a channelId */
  tS16 sGetchannelOffset(tU8 channelId)
  {
    vector<channelData>::iterator it = std::find(m_channelData.begin(), m_channelData.end(), channelId);

    if (it != m_channelData.end())
    {
      return (*it).Getoffset();
    }
    return CHANNEL_MUTE;
  }
};

/* class which contains Error code and Error Value */
class ErrorData
{
public:
  tU8 m_ErrorCode;
  tU8 m_ErrorValue;
  ErrorData(tU8 tErrorCode) : m_ErrorCode(tErrorCode)
  {
    m_ErrorValue = EN_AUDIO_DIAG_ERRVAL_NO_ERROR;
  }

  tVoid vSetErrorValue(tU8 ErrorValue)
  {
    m_ErrorValue = ErrorValue;
  }

  tU8 u8GetErrorValue()
  {
    return m_ErrorValue;
  }

  bool operator==(const ErrorData& rhs) const
  {
    return (m_ErrorCode == rhs.m_ErrorCode);
  }
};

/* class with vector of Error data objects */
class ErrorCodeValueList
{
public:
  vector<ErrorData> m_ErrorCodeVctr;
  ErrorCodeValueList(){}
  ErrorCodeValueList(tU8 Ec1, tU8 Ec2, tU8 Ec3, tU8 Ec4, tU8 Ec5, tU8 Ec6)
  {
    m_ErrorCodeVctr.push_back((ErrorData)Ec1);
    m_ErrorCodeVctr.push_back((ErrorData)Ec2);
    m_ErrorCodeVctr.push_back((ErrorData)Ec3);
    m_ErrorCodeVctr.push_back((ErrorData)Ec4);
    m_ErrorCodeVctr.push_back((ErrorData)Ec5);
    m_ErrorCodeVctr.push_back((ErrorData)Ec6);
  }

  /* Function to set Error value for a particular Error code */
  tVoid vSetErrorCodenValue(tU8 ErrorCode,tU8 ErrorValue)
  {
    vector<ErrorData>::iterator it = std::find(m_ErrorCodeVctr.begin(), m_ErrorCodeVctr.end(), ErrorCode);

    if (it != m_ErrorCodeVctr.end())
    {
      (*it).vSetErrorValue(ErrorValue);
    }
  }


  /* Function to get Error value when atleast one Error is found for any Error Code*/
  tU8 u8GetErrorValue()
  {
    vector<ErrorData>::iterator it;

    for (it = m_ErrorCodeVctr.begin(); it != m_ErrorCodeVctr.end(); it++)
    {
            if ((it->m_ErrorValue != EN_AUDIO_DIAG_ERRVAL_NO_ERROR) && (it->m_ErrorValue != EN_AUDIO_DIAG_ERRVAL_UNDEF))
      {
        return (*it).u8GetErrorValue();
      }

    }
    return EN_AUDIO_DIAG_ERRVAL_NO_ERROR;
  }
};


class Beep_VolumeOffsets : public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
  Beep_VolumeOffsets();
  Beep_VolumeOffsets(fc_audiomanager_tclApp* poMainAppl);
  ~Beep_VolumeOffsets();

  tVoid vRemapVolumeOffsets(VolumeOffsetData&);
  tVoid vRemapChanneloffset(tU8, tS16);
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);
  tVoid vUpdateErrorSiteCodeMap(tU8 ErrorSite,tU8 ErrorCode, tU8 ErrorValue);
private:
  fc_audiomanager_tclService_Audio_Function *m_poAudio_Function;
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
    CSMInterface* _poMyCSMInterface;
#endif
    tenAudioState m_enAudioState;
  tU8 m_soundConfig;
  map<tU8, tU8> m_channelErrorStatusMap; // to store Error status for corresponding channel
  map<tU8, ErrorCodeValueList> m_ErrorSiteCodeMap; // to store Error code and value for each channel

  map<tU8, channelremapoffsetList> m_ChannelOffsetMap; // to store channel Id, channel Offset against each Channel Id

  tVoid vInitChannelOffsetMap();
  tVoid VInitErrorSiteCodeMap();
  tS16 sGetFinalVolumeOffsets(tU8 channelId);


  tVoid vUpdateChannelErrorStatusMap(tU8 ErrorSite);
    bool GetChannelErrorStatus();
    void WriteToCanSignal (bool DiagTestPerformed ,tenAudioState m_enAudioState);
    void vSendCsmBroadcastSignal(tU8 pabData, tU8 u8Len, tU32 u32CsmSignal, tU8 u8TxType);
    bool IsDiagtestPerformed();

  tU8 tu8AudioAvailibility;



};

#endif
