/*******************************************************************************
 *
 * FILE:          Beep_Main.h
 *
 * SW-COMPONENT:  Beep Main application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Beep Main Class.
 *
 * AUTHOR:       Ramesh Babu .K
 *
 * COPYRIGHT:    (c) 2012 RBEI, Bangalore
 *
 *******************************************************************************/

#ifndef _BEEP_MAIN_H_
#define _BEEP_MAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "../ExternItf/CCA/aud_CCAMsg.h"
#include "BeepController_IF.h"
#include "BeepParameter_IF.h"
#include "BeepNotification_IF.h"
#include "Beep_defines.h"
#include "MessageConfig.h"
#include "InternalCommunicationAdapter.h"
#include "Beep_DataStore.h"

#include "../../LoopBack/aud_loopback_if.h"

#include "util/Macro.h"
// Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION_DEMO
#include "ahl_if.h"

#define MAX_BEEPS_SUPPORTED    EN_AUDIO_BEEP_ACTUATOR_HMI
#define FC_AUDIO_SOURCE_STREAM_BEEP  EN_AUDIO_SOURCE_STREAM_MIX3


class Beep_Actuator;
class fc_audiomanager_tclApp;
class fc_audiomanager_tclService_Audio_Function;
class StreamMute_IF;
class BeepPrioHandler_IF;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
//class Beep_CSMSignalInterface;
class Beep_Adas;
class fc_audiomanager_tclclienthandler_Buzzer;
#endif


class Beep_Main :public IF_MessageObserver<PO_MessageConfig::enID>, public BeepNotification_IF, public BeepParameter_IF
{
public:
  Beep_Main(void);
  Beep_Main(fc_audiomanager_tclApp* poMainAppl, fc_audiomanager_tclService_Audio_Function* m_poAudio_Func);
  virtual ~Beep_Main(tVoid);

  /**************************************************************************
   *  methods.
   **************************************************************************/
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);

  virtual tVoid setBeep(tU8 BeepType);
  virtual tVoid setBeepFile(const std::string File_Path,const BeepFile_Config& Config,const tU32& u32token);
  virtual tVoid GetSignalTonePara(tU8 tUBeepName, BeepControlData::BeepPara *BeepParameter);
  virtual tVoid GetSignalChimePara(tU8 tUBeepName, BeepControlData::ChimePara *ChimeParameter);
  virtual tS16 GetBeepVolume(tU8 tUBeepName);
  virtual tU32 GetRequestToken();
  virtual tS16 GetIncrementalVolumeStep()
  {
    return 0; // Beep Volume is always constant. Thus, returning 0.
  }
  virtual tVoid GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff  *VolOffsets);

  virtual tVoid NotifyBeepState(tU8 tUBeepName,tU8 tBeepID, tU8 tBeepState, tU32 u32ResponseToken);
  virtual tU8 GetBeepSource(tU8 tUBeepName);
  tBool bSendCCAStatusMessage(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg ) const;
  virtual std::string GetBeepFilePath(tU8 tUBeepName);
  virtual tBool bIsBeepIdValid(tU8 tUBeepName);
  virtual tU8 GetSoundSystemConfig();

  virtual tU16 GetRecurrencePeriod(tU8 /*tBeepName*/)
  {
    return 100; // recurrence period to be used only for UPA obstacle sounds
  }
  virtual bool bIsAdasSoundActive(tU8 /*tBeepName*/)
  {
    return false;   //to be used only for ADAS sounds
  }

  virtual tVoid SetAdasNotificationPointer(tU8 /*tBeepName*/)
  {
  // to be used only for ADAS
  }

  virtual tVoid SetBeepIdnStatus(tU8 /*tBeepName*/, tU8 /*tBeepId*/)
  {
    // to be used only for ADAS
  }
  virtual tVoid u8UpdateBeepMainData(tU8 tBeepName);
  static tU8 u8GetOEMType();

  fc_audiomanager_tclApp *m_poMainAppInstance;
  BeepPrioHandler_IF  *m_poBeepPrioHandler;
    StreamMute_IF* m_pStreamMute;
    Beep_Actuator *m_poBeepActuator;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
  tVoid vSendBeepRequestToBuzzer(tU8 tBeepName);
  Beep_Adas* m_poBeepAdas;
  fc_audiomanager_tclclienthandler_Buzzer* m_BuzzerclientHandler;
#endif
    fc_audiomanager_tclService_Audio_Function *m_poAudio_Function;
  beep_datastore  BeepData;

    tU8 u8BeepName;
    tU8 u8BeepState;
  tU8 m_u8SoundSystemconfig;
   tU8 u8AmpConnectionState;

  //Internal data to hold the data of the requested beep.
  BeepControlData::ChimePara m_req_beep_ChimePara;
  BeepControlData::BeepPara  m_req_beep_BeepPara;
  std::string         m_req_beep_path;
  tS16             m_req_beep_volume;
  tU32             m_req_beep_token;
  tU32             m_rsp_beep_token;

private:
  aud_CCAMsg m_CCATransport;
  tVoid GetBeepVolumeOffsetsPSA(tU8 tUBeepName, BeepControlData::ChVolOff  *VolOffsets);
  tVoid GetBeepVolumeOffsetsNormal(tU8 tUBeepName, BeepControlData::ChVolOff  *VolOffsets);

  tVoid vResetInternalData();
  tBool bUpdateInternalData(const BeepFile_Config* ptrConfig=NULL, tU32 token=0);

};



#endif //_BEEP_MAIN_H_

