/*******************************************************************************
 *
 * FILE:          Beep_Controller.h
 *
 * SW-COMPONENT:  Beep application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Beep Controller Class.
 *
 * AUTHOR:       Ramesh Babu .K
 *
 * COPYRIGHT:    (c) 2012 RBEI, Bangalore
 *
 *******************************************************************************/
#ifndef _BEEP_CONTROLLER_H_
#define _BEEP_CONTROLLER_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"
#include "dp_generic_if.h"

#include "../InternalComponentCommunication/DataTypes/TypeDefines/VolumeModeDefines.h"
#include "../mute/stream/StreamMuteNotify_IF.h"
#include "../ExternItf/CCA/FI_Message/FI_Includes.h"
#include "../InternalComponentCommunication/MessageConfig.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/EDTypeDefines.h"
#include "../InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeOffsetData.h"
#include "Priority/BeepData.h"
#include "BeepController_IF.h"
#include "Beep_playback_status_IF.h"
#include "Beep_defines.h"
#include "Beep_Main.h"

#include "../InternalComponentCommunication/Messages/BOSE_Amp/ID_SetActiveStream.h"
#include "../InternalComponentCommunication/Messages/BOSE_Amp/ID_BOSE_Amplifier_ConnectionStatus.h"
//#include "../vd_amp_Msg/MCANBose/vd_amp_MCANBose_MasterAmplifier_Defines.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/ADR3StreamType.h"

#define FC_AUDIOMANAGER_TIMER_BEEP_FIRST_TICK 1000
#define FC_AUDIOMANAGER_TIMER_BEEP_TICK_INTERVAL 0

class Beep_Main;
class BeepPrioHandler_IF;
class BeepParameter_IF;
class BeepNotification_IF;
class BeepData;
class StreamMute_IF;
class fc_audiomanager_tclApp;
class Beep_file_Player;
class Beep_VolumeOffsets;
class Beep_Controller : public StreamMuteNotify_IF, public IF_MessageObserver<PO_MessageConfig::enID>, public Beep_playback_status_IF,public BeepController_IF
{
public:
  friend class MainTest;
  Beep_Controller(void);
  Beep_Controller(BeepPrioHandler_IF* pBeep_PrioHander, StreamMute_IF* m_pStreamMute, fc_audiomanager_tclApp* poMainAppl, Beep_Main*);
  virtual ~Beep_Controller();

  virtual void StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink=1);
  //virtual tVoid NotifySignalToneStatus(tU8 tSignalToneType, tU8 tSignalToneStatus){};

  virtual tVoid StartBeep(BeepData oBeepData);
  virtual tVoid IdleBeep(/*tU8 tUBeepName, */tU8 tStopType);
//  tVoid MuteDemuteBeepStream(tU8 tmuteaction);
  tVoid MuteDemuteStream(tU8 tmuteaction, tU8 tStream);
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);

  tVoid SetSignalTone(tVoid) const;
  tVoid SetSignalToneParam(tVoid);
  tVoid SetSignalChimeParam(tVoid);

  tVoid SetAndTriggerBeep(tVoid);
  //tVoid NotifyChimeGeneratorState(tU8 tBeepID, tU8 tState);
  tVoid SetBeepSource(tVoid);
  //tVoid SetBeepVolumeMode(tVoid);
  //tVoid SetBeepVolumeMode(tU8 tVolMode);
  tenVolumeMode GetBeepVolumeMode(tVoid) const;
  tVoid SetBeepVolumeMode(tenVolumeMode tVolMode, midw_fi_tcl_e8_AudioChannel::tenType Channel) const;
  tVoid CheckAndMuteOtherStreams(tVoid);
  tVoid CheckAndDemuteOtherStreams(tVoid);
  tBool IsMuteBeepStreamNeeded(tVoid) const;
  tVoid SetSourceAndVolume(tVoid);
  tVoid vResetStateMachineAndClearRequest();

  tVoid SetChannelOffsets(tVoid);
  tVoid SetBeepVolume(tVoid);
    tS16 s16GetBeepOffset(tU8 beeplevel) const;
  tS16 s16GetBeepOffset_Kds(tU8 beeplevel_Kds) const;
   tVoid NotifyBeepStatus(tVoid);
    tVoid ExecuteStateMachine(tU8 tEvent);
    tVoid CheckMuteBeepStream(tVoid) const;
    virtual tVoid DoMuteBeepStream(tVoid);

    virtual tVoid SetBeepLocation(tVoid);
  virtual tVoid UpdateBeepVolume(tVoid);
    tVoid StopRunningBeep(tVoid) const;
    tVoid vMuteSignalToneGenerator(tU8 u8Generator) const;

  tVoid MuteOtherStreams(tVoid);
  tVoid DemuteOtherStreams(tVoid);


    tVoid vTriggerNextEnvelopeforIPABeep(tVoid);
  virtual void vOnPlaybackStatus(tU8 sts);//Playback status updates from beep player
private:
   bool m_pdcStatus;
   tU8 u8BeepName;
   tU8 u8BeepId;
   tU8 u8BeepControlState;
   tU8 u8BeepSource;
   tU8 u8NewBeepSource;
   tU8 u8BeepSourceSelected;
   tU8 u8BeepStreamDeMuted;
   //tU8 BeepStreamMuteState;
  tU8 u8muteRegId;
  tU8 u8SignalToneStatus;
  tU8 u8BeepStopType;
  tU8 m_playerstatus;
  tBool bSystemMuteActive;
  tenStream enActiveStreamId;
  tU8 u8AmpConnectionState;
  //VolumeModeHandler* m_VolumeModeHandler;
  StreamMute_IF* pStreamMute;
  BeepNotification_IF* pBeepNotification_IF;
  BeepParameter_IF* pBeepParameter_IF;
  BeepPrioHandler_IF* poBeep_PrioHander;
  fc_audiomanager_tclApp* m_poMainAppl;
  Beep_Main*        m_pBeepMain;
  Beep_file_Player*    m_player;

  BeepData         m_beepdata;
  Beep_VolumeOffsets* m_beepVolOffsets;

  tVoid vHandleChimeParameterSignalStatus();
  tBool isActuatorTestActivated () const;
  tU8   u8GetBeepStatus();
  tVoid vHandleBeepStateOff(tU8 tEvent);
  tVoid vHandleBeepStateMuteIP(tU8 tEvent);
  tVoid vHandleBeepStateDeMuteIP(tU8 tEvent);
  tVoid vHandleBeepStateVolReady(tU8 tEvent);
  tVoid vHandleBeepStateOn(tU8 tEvent);
  tVoid vHandleBeepStateStopIP(tU8 tEvent);
  tVoid vHandleBeepStateInit(tU8 tEvent);
  tVoid vSetIputGainOffset_Normal(VolumeOffsetData&,BeepControlData::ChVolOff&,tU8) const;
  tVoid vSetIputGainOffset_PSA(VolumeOffsetData&,BeepControlData::ChVolOff&,tU8) const;
  tVoid vSetADASIputGainOffset(VolumeOffsetData&,BeepControlData::ChVolOff&) const;
//  IDNotifySignalToneObserver* m_IDNotifySignalToneObserver;
};
#endif // _BEEP_CONTROLLER_H_

