/*******************************************************************************
 *
 * FILE:          Beep_CSMSignalInterface.h
 *
 * SW-COMPONENT:  Beep CSM Signal Interface application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Beep CSM Signal Interface Class.
 *
 * AUTHOR:       pmh7kor
 *
 * COPYRIGHT:    (c) 2016 RBEI, Bangalore
 *
 *******************************************************************************/
#ifndef _BEEP_CSM_INTERFACE_H_
#define _BEEP_CSM_INTERFACE_H_


#include <sys/types.h>
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#include "csm_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
#define MIDW_COMMON_S_IMPORT_INTERFACE_CSM   // CSM_C_PROJECT_RN_AIVI will be enabled to test this ADAS feature for IVI
#include "midw_common_if.h"
#endif

#include "../fc_audiomanager_trace_input.h"


#include "../LoopBack/aud_loopback_if.h"
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "ADAS_UPASound.h"
#include "ADAS_HFPSound.h"
#include "ADAS_PSMSound.h"
#include "ADAS_SRSound.h"
#include "ADAS_SRSound.h"
#include "ADAS_LDWSound.h"
#include "ADAS_RCTASound.h"

#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
class CSMInterface;
#endif
//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------



class Beep_CSMSignalInterface
{

public:
  Beep_CSMSignalInterface();
  Beep_CSMSignalInterface( Beep_Main* poBeepMainAppl,Beep_Adas* poBeepAdas);
    ~Beep_CSMSignalInterface();
  tVoid vForceSignalRead();
  tVoid vResetAdasData();
protected:

private:
  tVoid vRegisterCSMSignalsForAdas();

  tVoid vOnInit(tVoid);
  tVoid vRxSignal_UPA_ActivationSound(tU32 u32SignalId);
  tVoid vRxSignal_UPA_ErrorSound(tU32 u32SignalId);
    tVoid vRxSignal_UPA_ObstacleZoneSound(tU32 u32SignalId);
  tVoid vRxSignal_UPA_RecurrencePeriod(tU32 u32SignalId);
  tVoid vRxSignal_UPA_RecurrenceType(tU32 u32SignalId);

  tVoid vRxSignal_HFP_SoundRequest(tU32 u32SignalId);
  tVoid vRxSignal_LDW_SoundAlert(tU32 u32SignalId);
  tVoid vRxSignal_PSMSoundRequest(tU32 u32SignalId);
  tVoid vRxSignal_SRAutomaticRecordStatus(tU32 u32SignalId);
  tVoid vRxSignal_SRCustomerRecordStatus(tU32 u32SignalId);

  tVoid vRxSignal_SlotLeftSuitableForDisplay(tU32 u32SignalId);
  tVoid vRxSignal_SlotRightSuitableForDisplay(tU32 u32SignalId);
  tVoid vRxSignal_HFPScanningSide(tU32 u32SignalId);
  tVoid vRxSignal_UPA_Status_DisplayRequest(tU32 tu32SignalId);
  tVoid vRxSignal_CTA_AlertStatus(tU32 tu32SignalId);
  tVoid vRxSignal_CTA_CollisionRiskAlert(tU32 tu32SignalId);
  tVoid vRxSignal_HFP_MapContentDisplay(tU32 tu32SignalId);
  typedef std::map<tU32, tU8> _CSMSignalMap; //parameters are signal Id, Signal Value
  _CSMSignalMap m_CSMSignalMap;


  static tVoid vSignalIndCallback( tVoid* /*pHandle*/,tU32 tu32SignalId, tU32 u32SignalStatus);

  void bSignalIndASyncCall(tU32 u32SignalId,tU32 u32SignalStatus);

  Beep_Main* m_poBeepMainAppl;
    static Beep_CSMSignalInterface *_poThisInterface;

  tBool bReadCANdata(tU32 tu32SignalId,tU8* dataBuffer);
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
  CSMInterface* _poMyCSMInterface;
#endif
  ADAS_UPASound* m_poUPASound;
  ADAS_HFPSound* m_poHFPSound;
  ADAS_PSMSound* m_poPSMSound;
  ADAS_SRSound* m_poSRSound;
  ADAS_LDWSound* m_poLDWSound;
  ADAS_RCTASound* m_poRCTASound;
  aud_async_call_handler*  m_asynccall;
};

#endif // _BEEP_CSM_INTERFACE_H_
