/*******************************************************************************
 *
 * FILE:          Beep_CSMSignalInterface.cpp
 *
 * SW-COMPONENT:  Beep CSM Signal Interface application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Beep CSM Signal Interface Class.
 *
 * AUTHOR:       pmh7kor
 *
 * COPYRIGHT:    (c) 2016 RBEI, Bangalore
 *
 *******************************************************************************/


/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include "Beep_Main.h"
#include "../fc_audiomanager_trace.h"
#include "Beep_CSMSignalInterface.h"
#include "Beep_Adas.h"
#include "Beep_defines.h"
#include "../fc_audiomanager_main.h"
#include "../fc_audiomanager_service_Audio_Function.h"

#include "../aud_sinkmanager/vd_adr3/vd_adr3Msg_If.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#ifndef ET_TRACE_INFO_ON // reference to define ET_TRACE_INFO_ON because of lint Info 750
// Info 750: prio2: local macro 'ET_TRACE_INFO_ON' not referenced
// (this lint error is related to the ETG framework and can't be solved within vd_rvc)
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_BEEP
#include "trcGenProj/Header/Beep_CSMSignalInterface.cpp.trc.h"
#endif


Beep_CSMSignalInterface *Beep_CSMSignalInterface::_poThisInterface = NULL;

/******************************************************************************/
/* FUNCTION     Beep_CSMSignalInterface()                                     */
/******************************************************************************/
/**
*  \brief       default constructor - should not be used
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
Beep_CSMSignalInterface::Beep_CSMSignalInterface()
{

  ETG_TRACE_USR4(("Beep_CSMSignalInterface() called"));
  m_poBeepMainAppl = OSAL_NULL;
    // store pointer to myself for access in callbacks
    _poThisInterface = this;
     m_asynccall = NULL;    //You are not supposed to use default constructor
   m_poUPASound = NULL;
   m_poHFPSound = NULL;
   m_poPSMSound = NULL;
   m_poSRSound = NULL;
   m_poLDWSound = NULL;
   m_poRCTASound=NULL;
    #ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
   _poMyCSMInterface=NULL;
   #endif
    NORMAL_M_ASSERT_ALWAYS();
}

/******************************************************************************/
/* FUNCTION     Beep_CSMSignalInterface()                                     */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       Beep_Main* poBeepMainAppl: main - object of this application
*  \return      none
*/
/******************************************************************************/

Beep_CSMSignalInterface::Beep_CSMSignalInterface( Beep_Main* poBeepMainAppl,Beep_Adas* poBeepAdas)
{
  ETG_TRACE_USR4(("Beep_CSMSignalInterface(Beep_Main*) called"));
  m_poBeepMainAppl = poBeepMainAppl;

    // store pointer to myself for access in callbacks
    _poThisInterface = this;
  m_asynccall = m_poBeepMainAppl->m_poMainAppInstance->poAsyncCall();
  m_poUPASound = new ADAS_UPASound(poBeepAdas);
  m_poHFPSound = new ADAS_HFPSound(poBeepAdas);
  m_poPSMSound = new ADAS_PSMSound(poBeepAdas);
  m_poSRSound  = new ADAS_SRSound(poBeepAdas);
  m_poLDWSound = new ADAS_LDWSound(poBeepAdas);
  m_poRCTASound= new ADAS_RCTASound(poBeepAdas);
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
  _poMyCSMInterface = new CSMInterface();

  //Storing default values for the signals in MAP
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_UPA_SoundActivationBeep,0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_UPA_SoundErrorBeep,0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_UPA_SoundObstacleZone,0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_UPA_SoundObstacleDiscontnious,0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_UPA_SoundObstacleContinious,0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_HFP_SoundRequest,0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_LDW_SoundAlert,0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_PSM_SoundRequest,0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_SR_AutomaticRecordStatus,0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_SR_CustomerRecordStatus,0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_SlotLeftSuitableForDisplay,0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_SlotRightSuitableForDisplay, 0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_ScanningSide, 0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_UPA_Status_DisplayRequest, 0xFF));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_CTA_AlertStatus, 0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_CTA_CollisionRiskAlert, 0));
  //No parking sound reactivation fix
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_HFP_MapContentDisplay, 0));
 // m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_CTA_StatusDisplay, 0));

#endif
  vOnInit();
}



/*******************************************************************************
 *
 * FUNCTION: Beep_Adas::vOnInit(tVoid)
 *******************************************************************************/

tVoid Beep_CSMSignalInterface::vOnInit(tVoid)
{
     ETG_TRACE_USR4(("Beep_CSMSignalInterface::vOnInit() entered."));
   if(!(m_poBeepMainAppl->m_poAudio_Function->bCheckFaderAvailability()==PREMIUM_AMP2))
    // register for CSM Signals
  { vRegisterCSMSignalsForAdas();
      vForceSignalRead();
    }

}

/*******************************************************************************
 *
 * FUNCTION: Beep_Adas::vResetAdasData(tVoid)
 * Resets all data members to default
 *******************************************************************************/
tVoid Beep_CSMSignalInterface::vResetAdasData()
{
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poUPASound);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poHFPSound);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poPSMSound);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poSRSound);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poLDWSound);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poRCTASound);

#if !defined (LSIM)

#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM

  std::map<tU32, tU8>:: iterator it = m_CSMSignalMap.begin();

  for(;it != m_CSMSignalMap.end(); ++it)
  {
    if(it->first == CSM_C_ASIG_RX_UPA_Status_DisplayRequest)
     {
        it->second = 0xFF;
      }
    else {
    it->second = 0; //setting signal values to defaults
    }
  }
  m_poUPASound->vResetUPAData();
  m_poHFPSound->vResetHFPData();
  m_poPSMSound->vResetPSMData();
  m_poSRSound->vResetSRData();
  m_poLDWSound->vResetLDWData();
  m_poRCTASound->vResetRCTAData();

#endif
#endif

}

/******************************************************************************/
/* FUNCTION     ~Beep_CSMSignalInterface()                                    */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
Beep_CSMSignalInterface::~Beep_CSMSignalInterface()
{
  ETG_TRACE_USR4(("~Beep_CSMSignalInterface() called"));
  m_poBeepMainAppl = NULL;
  m_asynccall = NULL;
  if (_poThisInterface != NULL)
  {
    delete _poThisInterface;
    _poThisInterface = NULL;
  }

  if(m_poUPASound != NULL)
  {
    delete m_poUPASound;
    m_poUPASound = NULL;
  }

  if(m_poHFPSound != NULL)
  {
    delete m_poHFPSound;
    m_poHFPSound = NULL;
  }
  if(m_poPSMSound != NULL)
  {
    delete m_poPSMSound;
    m_poPSMSound = NULL;
  }

  if (m_poSRSound != NULL)
  {
    delete m_poSRSound;
    m_poSRSound = NULL;
  }

  if (m_poLDWSound != NULL)
  {
    delete m_poLDWSound;
    m_poLDWSound = NULL;
  }
  if (m_poRCTASound != NULL)
    {
      delete m_poRCTASound;
      m_poRCTASound = NULL;
    }


#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
  if(_poMyCSMInterface != NULL)
  {
    delete _poMyCSMInterface;
    _poMyCSMInterface = NULL;
  }
#endif
}

/******************************************************************************/
/* FUNCTION     vRegisterCSMSignalsForAdas                                   */
/******************************************************************************/
/**
*  \brief       registers the necessary CAN signals for the Sonar functionality
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid Beep_CSMSignalInterface::vRegisterCSMSignalsForAdas()
{
#if !defined (LSIM)

#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM

  ETG_TRACE_USR4((" Beep_CSMSignalInterface::vRegisterCSMSignalsForAdas(), Callback registration for ADAS CAN Signals"));
  tU32 u32CsmHandle;
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_poMyCSMInterface);
  std::map<tU32, tU8>:: const_iterator it;

  for(it = m_CSMSignalMap.begin(); it != m_CSMSignalMap.end(); ++it )
  {
    //Register for the CAN signal call backs
      if(_poMyCSMInterface->CSM_lSignalCallbackInit((tVoid*)&u32CsmHandle,it->first, vSignalIndCallback) < CSM_C_NO_ERROR)
    {
      ETG_TRACE_FATAL(("!!!!! E R R O R in registering call back for signal"));
    }
  }
#endif
#endif

}

/*******************************************************************************
 *
 * FUNCTION: Beep_CSMSignalInterface::vSignalIndCallback(tVoid*,tU32 u32SignalId, tU32 u32SignalStatus)
 *******************************************************************************/
tVoid Beep_CSMSignalInterface::vSignalIndCallback(tVoid*/*pHandle*/,tU32 u32SignalId, tU32 u32SignalStatus)
{
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vSignalIndCallback() called"));
  //_poThisInterface->m_asynccall->vCall(_poThisInterface,&Beep_CSMSignalInterface::bSignalIndASyncCall,u32SignalStatus);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_poThisInterface);
  _poThisInterface->bSignalIndASyncCall(u32SignalId, u32SignalStatus);

}

/*******************************************************************************
 *
 * FUNCTION: Beep_CSMSignalInterface::vSignalIndCallback(tU32 u32SignalId, tU32 u32SignalStatus)
 *******************************************************************************/

tVoid Beep_CSMSignalInterface::bSignalIndASyncCall(tU32 u32SignalId, tU32 u32SignalStatus)
{
  (void)u32SignalStatus; // to avoid lint
#if !defined (LSIM)
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::bSignalIndASyncCall() called"));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_asynccall);

  switch(u32SignalId)
  {
  case CSM_C_ASIG_RX_UPA_SoundActivationBeep:
     ETG_TRACE_USR4(("CSM_C_ASIG_RX_UPA_SoundActivationBeep"));
    m_asynccall->vCall<Beep_CSMSignalInterface,tU32>(_poThisInterface,&Beep_CSMSignalInterface::vRxSignal_UPA_ActivationSound,u32SignalId);
    break;
  case CSM_C_ASIG_RX_UPA_SoundErrorBeep:
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_UPA_SoundErrorBeep"));
    m_asynccall->vCall<Beep_CSMSignalInterface,tU32>(_poThisInterface,&Beep_CSMSignalInterface::vRxSignal_UPA_ErrorSound,u32SignalId);
    break;
  case CSM_C_ASIG_RX_UPA_SoundObstacleZone:
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_UPA_SoundObstacleZone"));
    m_asynccall->vCall<Beep_CSMSignalInterface,tU32>(_poThisInterface,&Beep_CSMSignalInterface::vRxSignal_UPA_ObstacleZoneSound,u32SignalId);
    break;
  case CSM_C_ASIG_RX_UPA_SoundObstacleDiscontnious:
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_UPA_SoundObstacleDiscontnious"));
    m_asynccall->vCall<Beep_CSMSignalInterface,tU32>(_poThisInterface,&Beep_CSMSignalInterface::vRxSignal_UPA_RecurrencePeriod,u32SignalId);
    break;
  case CSM_C_ASIG_RX_UPA_SoundObstacleContinious:
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_UPA_SoundObstacleContinious"));
    m_asynccall->vCall<Beep_CSMSignalInterface,tU32>(_poThisInterface,&Beep_CSMSignalInterface::vRxSignal_UPA_RecurrenceType,u32SignalId);
    break;
  case CSM_C_ASIG_RX_HFP_SoundRequest:
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_HFP_SoundRequest"));
    m_asynccall->vCall<Beep_CSMSignalInterface,tU32>(_poThisInterface,&Beep_CSMSignalInterface::vRxSignal_HFP_SoundRequest,u32SignalId);
    break;
  case CSM_C_ASIG_RX_LDW_SoundAlert:
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_LDW_SoundAlert"));
    m_asynccall->vCall<Beep_CSMSignalInterface,tU32>(_poThisInterface,&Beep_CSMSignalInterface::vRxSignal_LDW_SoundAlert,u32SignalId);
    break;
  case CSM_C_ASIG_RX_PSM_SoundRequest:
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_PSM_SoundRequest"));
    m_asynccall->vCall<Beep_CSMSignalInterface,tU32>(_poThisInterface,&Beep_CSMSignalInterface::vRxSignal_PSMSoundRequest,u32SignalId);
    break;
  case CSM_C_ASIG_RX_SR_AutomaticRecordStatus:
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_SR_AutomaticRecordStatus"));
    m_asynccall->vCall<Beep_CSMSignalInterface,tU32>(_poThisInterface,&Beep_CSMSignalInterface::vRxSignal_SRAutomaticRecordStatus,u32SignalId);
    break;
  case CSM_C_ASIG_RX_SR_CustomerRecordStatus:
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_SR_CustomerRecordStatus"));
    m_asynccall->vCall<Beep_CSMSignalInterface,tU32>(_poThisInterface,&Beep_CSMSignalInterface::vRxSignal_SRCustomerRecordStatus,u32SignalId);
    break;
  case CSM_C_ASIG_RX_SlotLeftSuitableForDisplay:
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_SlotLeftSuitableForDisplay"));
    m_asynccall->vCall<Beep_CSMSignalInterface, tU32>(_poThisInterface, &Beep_CSMSignalInterface::vRxSignal_SlotLeftSuitableForDisplay, u32SignalId);
    break;
  case CSM_C_ASIG_RX_SlotRightSuitableForDisplay:
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_SlotRightSuitableForDisplay"));
    m_asynccall->vCall<Beep_CSMSignalInterface, tU32>(_poThisInterface, &Beep_CSMSignalInterface::vRxSignal_SlotRightSuitableForDisplay, u32SignalId);
    break;
  case CSM_C_ASIG_RX_ScanningSide:
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_ScanningSide"));
    m_asynccall->vCall<Beep_CSMSignalInterface, tU32>(_poThisInterface, &Beep_CSMSignalInterface::vRxSignal_HFPScanningSide, u32SignalId);
    break;
  case CSM_C_ASIG_RX_UPA_Status_DisplayRequest :
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_UPA_Status_DisplayRequest"));
    m_asynccall->vCall<Beep_CSMSignalInterface, tU32>(_poThisInterface, &Beep_CSMSignalInterface::vRxSignal_UPA_Status_DisplayRequest, u32SignalId);
  break;
  case CSM_C_ASIG_RX_CTA_AlertStatus :
  ETG_TRACE_USR4(("CSM_C_ASIG_RX_CTA_AlertStatus"));
  m_asynccall->vCall<Beep_CSMSignalInterface, tU32>(_poThisInterface, &Beep_CSMSignalInterface::vRxSignal_CTA_AlertStatus, u32SignalId);
  break;
  case CSM_C_ASIG_RX_CTA_CollisionRiskAlert:
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_CTA_CollisionRiskAlert"));
  m_asynccall->vCall<Beep_CSMSignalInterface, tU32>(_poThisInterface, &Beep_CSMSignalInterface::vRxSignal_CTA_CollisionRiskAlert, u32SignalId);
  break;
  case CSM_C_ASIG_RX_HFP_MapContentDisplay:
    ETG_TRACE_USR4(("CSM_C_ASIG_RX_HFP_MapContentDisplay"));
   m_asynccall->vCall<Beep_CSMSignalInterface, tU32>(_poThisInterface, &Beep_CSMSignalInterface::vRxSignal_HFP_MapContentDisplay, u32SignalId);
   break;
  default:
    break;
  }
#else
  (tVoid)u32SignalId;
#endif
#endif
}

/*******************************************************************************
 *
 * FUNCTION: Beep_CSMSignalInterface::vRxSignal_UPA_ActivationSound(tU32 tu32SignalId)
 *******************************************************************************/
tVoid Beep_CSMSignalInterface::vRxSignal_UPA_ActivationSound(tU32 tu32SignalId)
{
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_UPA_ActivationSound() called"));
   tU8 au8Data_ReadBuffer = 0;
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poUPASound);
  if(bReadCANdata(tu32SignalId,&au8Data_ReadBuffer) && au8Data_ReadBuffer)
    m_poUPASound->vSetandTriggerAdasActivationSound(au8Data_ReadBuffer);
  ETG_TRACE_USR4(("Beep_CSMSignalInterface:: UPA Activation Status : %x",au8Data_ReadBuffer));
}

/*******************************************************************************
 *
 * FUNCTION: Beep_CSMSignalInterface::vRxSignal_UPA_ErrorSound(tU32 tu32SignalId)
 *******************************************************************************/

tVoid Beep_CSMSignalInterface::vRxSignal_UPA_ErrorSound(tU32 tu32SignalId)
{
   ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_UPA_ErrorSound called"));

   tU8 au8Data_ReadBuffer = 0;
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poUPASound);
  if(bReadCANdata(tu32SignalId,&au8Data_ReadBuffer) && au8Data_ReadBuffer)
    m_poUPASound->vSetandTriggerAdasErrorSound(au8Data_ReadBuffer);
  ETG_TRACE_USR4(("Beep_CSMSignalInterface:: UPA Error Sound status : %x",au8Data_ReadBuffer));
}

/*******************************************************************************
 *
 * FUNCTION: Beep_CSMSignalInterface::vRxSignal_UPA_ObstacleZoneSound(tU32 tu32SignalId)
 *******************************************************************************/

tVoid Beep_CSMSignalInterface::vRxSignal_UPA_ObstacleZoneSound(tU32 tu32SignalId)
{
  tU8 au8Data_ReadBuffer = 0;
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_UPA_ObstacleZoneSound() called"));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poUPASound);
  if(bReadCANdata(tu32SignalId,&au8Data_ReadBuffer))
  {
    m_poUPASound->vSetandTriggerUPAObstacleSound(au8Data_ReadBuffer);
  }
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::Received  obstacle ZoneType from CAN: %x",ETG_ENUM(ObstacleZoneType,au8Data_ReadBuffer)));
}


/*******************************************************************************
 *
 * FUNCTION: Beep_CSMSignalInterface::vRxSignal_UPA_RecurrencePeriod(tU32 tu32SignalId)
 *******************************************************************************/

tVoid Beep_CSMSignalInterface::vRxSignal_UPA_RecurrencePeriod(tU32 tu32SignalId)
{
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_UPA_RecurrencePeriod() called"));
  tU8 au8Data_ReadBuffer = 0;
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poUPASound);
   if(bReadCANdata(tu32SignalId,&au8Data_ReadBuffer))
    m_poUPASound->vSetUPAObstacleZoneRecurrencePeriod(au8Data_ReadBuffer);

  ETG_TRACE_USR4(("Beep_CSMSignalInterface:: Received Recurrence Period from CAN : %x",au8Data_ReadBuffer));
}

/*******************************************************************************
 *
 * FUNCTION: Beep_CSMSignalInterface::vRxSignal_UPA_RecurrenceType(tU32 tu32SignalId)
 *******************************************************************************/
tVoid Beep_CSMSignalInterface::vRxSignal_UPA_RecurrenceType(tU32 tu32SignalId)
{
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_UPA_RecurrenceType() called"));

  tU8 au8Data_ReadBuffer = 0;
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poUPASound);
   if(bReadCANdata(tu32SignalId,&au8Data_ReadBuffer))
    m_poUPASound->vSetUPAObstacleZoneRecurrenceType(au8Data_ReadBuffer); // recurrencetype = 0 for dicontinuous, 1 = continuous

  ETG_TRACE_USR4(("Beep_CSMSignalInterface:: Received Recurrence Type from CAN : %x",au8Data_ReadBuffer));
}

/*******************************************************************************
 *
 * FUNCTION: Beep_CSMSignalInterface::vRxSignal_HFP_SoundRequest(tU32 tu32SignalId)
 *******************************************************************************/

tVoid Beep_CSMSignalInterface::vRxSignal_HFP_SoundRequest(tU32 u32SignalId)
{
  tU8 au8Data_ReadBuffer = 0;
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_HFP_SoundRequest() called"));
  if(bReadCANdata(u32SignalId,&au8Data_ReadBuffer))
  {
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poHFPSound);
    if(au8Data_ReadBuffer == 0)
      m_poHFPSound->vTriggerStopBeep();
    else
      m_poHFPSound->vSetandTriggerHFPSound(au8Data_ReadBuffer);
  }
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::Received  HFP SoundRequest from CAN: %x",au8Data_ReadBuffer));
}

/*******************************************************************************
 *
 * FUNCTION: Beep_CSMSignalInterface::vRxSignal_LDW_SoundAlert(tU32 tu32SignalId)
 *******************************************************************************/
tVoid Beep_CSMSignalInterface::vRxSignal_LDW_SoundAlert(tU32 u32SignalId)
{
  tU8 au8Data_ReadBuffer = 0;
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_LDW_SoundAlert() called"));
  if (bReadCANdata(u32SignalId, &au8Data_ReadBuffer))
  {
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poLDWSound);
    if (au8Data_ReadBuffer == NO_LANE_DEPARTURE)
      m_poLDWSound->vTriggerStopBeep(EN_AUDIO_BEEP_LDW_SOUND_ALERT);
    else if ((au8Data_ReadBuffer == LANE_DEPARTURE_ON_RIGHT) || (au8Data_ReadBuffer == LANE_DEPARTURE_ON_LEFT))
      m_poLDWSound->vSetandTriggerLDWAlertSound(au8Data_ReadBuffer);
    else
    {
      // nothing to be done
    }
  }
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::Received  LDW SoundRequest from CAN: %x", au8Data_ReadBuffer));
}

/*******************************************************************************
 *
 * FUNCTION: Beep_CSMSignalInterface::vRxSignal_UPA_RecurrenceType(tU32 tu32SignalId)
 *******************************************************************************/

tVoid Beep_CSMSignalInterface::vRxSignal_PSMSoundRequest(tU32 u32SignalId)
{
  tU8 au8Data_ReadBuffer = 0;
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_PSMSoundRequest() called"));
  if(bReadCANdata(u32SignalId,&au8Data_ReadBuffer))
  {
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poPSMSound);
    if(au8Data_ReadBuffer == 0)
      m_poPSMSound->vTriggerStopBeep(EN_AUDIO_BEEP_PSM_PHASE1);
    else
      m_poPSMSound->vSetandTriggerPSMSound(au8Data_ReadBuffer);
  }
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::Received  PSM SoundRequest from CAN: %x",au8Data_ReadBuffer));
}

/*******************************************************************************
 *
 * FUNCTION: Beep_CSMSignalInterface::vRxSignal_SRAutomaticRecordStatus(tU32 tu32SignalId)
 *******************************************************************************/
tVoid Beep_CSMSignalInterface::vRxSignal_SRAutomaticRecordStatus(tU32 u32SignalId)
{
  tU8 au8Data_ReadBuffer = 0;
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_SRAutomaticRecordStatus() called"));
  if (bReadCANdata(u32SignalId, &au8Data_ReadBuffer))
  {
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poSRSound);
    if (au8Data_ReadBuffer == NO_AUTO_RECORD_REQUEST)
      m_poSRSound->vTriggerStopBeep(EN_AUDIO_BEEP_AUTOMATIC_SR);
    else
      m_poSRSound->vSetandTriggerAutoSRSound(au8Data_ReadBuffer);
  }
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::Received  Auto SR SoundRequest from CAN: %x", au8Data_ReadBuffer));
}

/*******************************************************************************
 *
 * FUNCTION: Beep_CSMSignalInterface::vRxSignal_SRCustomerRecordStatus(tU32 tu32SignalId)
 *******************************************************************************/
tVoid Beep_CSMSignalInterface::vRxSignal_SRCustomerRecordStatus(tU32 u32SignalId)
{
  tU8 au8Data_ReadBuffer = 0;
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_SRCustomerRecordStatus() called"));
  if (bReadCANdata(u32SignalId, &au8Data_ReadBuffer))
  {
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poSRSound);
    if (au8Data_ReadBuffer == NO_CUST_RECORD_REQUEST)
      m_poSRSound->vTriggerStopBeep(EN_AUDIO_BEEP_USER_SR_PHASE1);
    else
      m_poSRSound->vSetandTriggerCustomerSRSound(au8Data_ReadBuffer);
  }
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::Received  Customer SR SoundRequest from CAN: %x", au8Data_ReadBuffer));
}


/*******************************************************************************
*
* FUNCTION: Beep_CSMSignalInterface::vRxSignal_SlotLeftSuitableForDisplay(tU32 tu32SignalId)
*******************************************************************************/
tVoid Beep_CSMSignalInterface::vRxSignal_SlotLeftSuitableForDisplay(tU32 tu32SignalId)
{
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_SlotLeftSuitableForDisplay() called"));
  tU8 au8Data_ReadBuffer = 0;

  if (bReadCANdata(tu32SignalId, &au8Data_ReadBuffer))
  {
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poPSMSound);
    m_poPSMSound->vSetLeftSlotSuitableDisplay(au8Data_ReadBuffer);
  }

  ETG_TRACE_USR4(("Beep_CSMSignalInterface:: PSM left Slot Suitable for Display : %x", au8Data_ReadBuffer));
}
/*******************************************************************************
*
* FUNCTION: Beep_CSMSignalInterface::vRxSignal_SlotRightSuitableForDisplay(tU32 tu32SignalId)
*******************************************************************************/
tVoid Beep_CSMSignalInterface::vRxSignal_SlotRightSuitableForDisplay(tU32 tu32SignalId)
{
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_SlotRightSuitableForDisplay() called"));
  tU8 au8Data_ReadBuffer = 0;

  if (bReadCANdata(tu32SignalId, &au8Data_ReadBuffer))
  {
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poPSMSound);
    m_poPSMSound->vSetRightSlotSuitableDisplay(au8Data_ReadBuffer);
  }

  ETG_TRACE_USR4(("Beep_CSMSignalInterface:: PSM Right Slot Suitable for Display : %x", au8Data_ReadBuffer));
}

/*******************************************************************************
*
* FUNCTION: Beep_CSMSignalInterface::vRxSignal_HFPScanningSide(tU32 tu32SignalId)
*******************************************************************************/
tVoid Beep_CSMSignalInterface::vRxSignal_HFPScanningSide(tU32 tu32SignalId)
{
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_HFPScanningSide() called"));
  tU8 au8Data_ReadBuffer = 0;

  if (bReadCANdata(tu32SignalId, &au8Data_ReadBuffer))
  {
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poHFPSound);
    m_poHFPSound->vSetScanningSideForHFP(au8Data_ReadBuffer);
  }

  ETG_TRACE_USR4(("Beep_CSMSignalInterface:: HFP Scanning Side : %x", au8Data_ReadBuffer));
}

/*******************************************************************************
*
* FUNCTION: Beep_CSMSignalInterface::vRxSignal_UPA_Status_DisplayRequest(tU32 tu32SignalId)
*******************************************************************************/

tVoid Beep_CSMSignalInterface::vRxSignal_UPA_Status_DisplayRequest(tU32 tu32SignalId)
{
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_UPA_Status_DisplayRequest called"));
    tU8 au8Data_ReadBuffer = 0xFF;

    if (bReadCANdata(tu32SignalId, &au8Data_ReadBuffer))
      {
        AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poUPASound);
        m_poUPASound->vSetUPA_Status_DisplayRequest(au8Data_ReadBuffer);

      }

      ETG_TRACE_USR4(("Beep_CSMSignalInterface:: UPA Status_DisplayRequest: %x", au8Data_ReadBuffer));

}



tVoid Beep_CSMSignalInterface::vRxSignal_CTA_AlertStatus(tU32 tu32SignalId)
{
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_CTA_AlertStatus() called"));
      tU8 au8Data_ReadBuffer = 0;

      if (bReadCANdata(tu32SignalId, &au8Data_ReadBuffer))
        {
          AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poRCTASound);
          m_poRCTASound->vSetCTA_AlertStatus(au8Data_ReadBuffer);
        }

        ETG_TRACE_USR4(("Beep_CSMSignalInterface:: CTA_AlertStatus: %x", au8Data_ReadBuffer));
}

tVoid Beep_CSMSignalInterface::vRxSignal_CTA_CollisionRiskAlert(tU32 tu32SignalId)
{
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_CTA_CollisionRiskAlert() called"));
      tU8 au8Data_ReadBuffer = 0;

      if (bReadCANdata(tu32SignalId, &au8Data_ReadBuffer))
        {
          AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poRCTASound);
          m_poRCTASound->vSetCTA_CollisionRiskAlert(au8Data_ReadBuffer);
        }

        ETG_TRACE_USR4(("Beep_CSMSignalInterface:: CTA_CollisionRiskAlert: %x", au8Data_ReadBuffer));
}

tVoid Beep_CSMSignalInterface::vRxSignal_HFP_MapContentDisplay(tU32 tu32SignalId)
{
   ETG_TRACE_USR4(("Beep_CSMSignalInterface::vRxSignal_HFP_MapContentDisplay() called"));
        tU8 au8Data_ReadBuffer = 0;

        if (bReadCANdata(tu32SignalId, &au8Data_ReadBuffer))
          {
            AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poHFPSound);
            m_poHFPSound->vTriggerHFP_Display(au8Data_ReadBuffer);
          }
          ETG_TRACE_USR4(("Beep_CSMSignalInterface:: HFP_MapContentDisplay: %x", au8Data_ReadBuffer));
}
/*******************************************************************************
 *
 * FUNCTION: Beep_CSMSignalInterface::vForceSignalRead()
 *******************************************************************************/

  tVoid Beep_CSMSignalInterface::vForceSignalRead()
  {
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
    ETG_TRACE_USR4(("Beep_CSMSignalInterface:: vForceSignalRead() called"));

    vRxSignal_UPA_RecurrencePeriod(CSM_C_ASIG_RX_UPA_SoundObstacleDiscontnious);
    vRxSignal_UPA_RecurrenceType(CSM_C_ASIG_RX_UPA_SoundObstacleContinious);

    vRxSignal_UPA_ErrorSound(CSM_C_ASIG_RX_UPA_SoundErrorBeep);
    vRxSignal_UPA_ActivationSound(CSM_C_ASIG_RX_UPA_SoundActivationBeep);

    vRxSignal_UPA_ObstacleZoneSound(CSM_C_ASIG_RX_UPA_SoundObstacleZone);
    vRxSignal_HFPScanningSide(CSM_C_ASIG_RX_ScanningSide);
    vRxSignal_SlotLeftSuitableForDisplay(CSM_C_ASIG_RX_SlotLeftSuitableForDisplay);
    vRxSignal_SlotRightSuitableForDisplay(CSM_C_ASIG_RX_SlotRightSuitableForDisplay);
    vRxSignal_HFP_SoundRequest(CSM_C_ASIG_RX_HFP_SoundRequest);
    vRxSignal_PSMSoundRequest(CSM_C_ASIG_RX_PSM_SoundRequest);
    vRxSignal_LDW_SoundAlert(CSM_C_ASIG_RX_LDW_SoundAlert);
    vRxSignal_SRAutomaticRecordStatus(CSM_C_ASIG_RX_SR_AutomaticRecordStatus);
    vRxSignal_SRCustomerRecordStatus(CSM_C_ASIG_RX_SR_CustomerRecordStatus);
    vRxSignal_UPA_Status_DisplayRequest(CSM_C_ASIG_RX_UPA_Status_DisplayRequest);
    vRxSignal_CTA_AlertStatus(CSM_C_ASIG_RX_CTA_AlertStatus);
    vRxSignal_CTA_CollisionRiskAlert(CSM_C_ASIG_RX_CTA_CollisionRiskAlert);
    vRxSignal_HFP_MapContentDisplay(CSM_C_ASIG_RX_HFP_MapContentDisplay);
#endif
 }

 /*******************************************************************************
 *
 * FUNCTION: Beep_CSMSignalInterface::bReadCANdata()
 *******************************************************************************/

tBool Beep_CSMSignalInterface::bReadCANdata(tU32 tu32SignalId,tU8* dataBuffer)
{
#if !defined (LSIM)
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::bReadCANdata() called"));

    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;
  std::map<tU32, tU8>:: iterator it = m_CSMSignalMap.find(tu32SignalId);

  AUD_POINTER_CHECK_CALL(_poMyCSMInterface);
  if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, tu32SignalId,dataBuffer,1,&u32StatusRead))
    {
        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

  //AUD_POINTER_CHECK_CALL(m_poBeepMainAppl);
  AUD_POINTER_CHECK_CALL(m_poUPASound);
  AUD_POINTER_CHECK_CALL(m_poHFPSound);
  AUD_POINTER_CHECK_CALL(m_poPSMSound);
  AUD_POINTER_CHECK_CALL(m_poSRSound);
  AUD_POINTER_CHECK_CALL(m_poLDWSound);
  AUD_POINTER_CHECK_CALL(m_poRCTASound);

  if(u32StatusRead & CSM_C_SIGNAL_TIMEOUT)
  {
  ETG_TRACE_USR4(("Beep_CSMSignalInterface::bReadCANdata()  CSM_C_SIGNAL_TIMEOUT "));
    m_poUPASound->vTriggerStopBeep();
    m_poHFPSound->vTriggerStopBeep();
    m_poPSMSound->vTriggerStopBeep();
    m_poSRSound->vTriggerStopBeep();
    m_poLDWSound->vTriggerStopBeep();
    m_poRCTASound->vTriggerStopBeep();
  }
  else if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED)))
  {

    if (it != m_CSMSignalMap.end())
    {
      if(it->second != *dataBuffer){
        it->second = *dataBuffer;
        bChanged = TRUE;
      }
    }
    }
  return bChanged;
#else
  (tVoid)tu32SignalId;
  *dataBuffer = 0;
#endif
#endif
  return FALSE;

}
