/*******************************************************************************
 *
 * FILE:          Beep_Controller_IF.h
 *
 * SW-COMPONENT:  Beep application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Beep Controller Interface.
 *
 * AUTHOR:       Ramesh Babu .K
 *
 * COPYRIGHT:    (c) 2012 RBEI, Bangalore
 *
 *******************************************************************************/
#ifndef BEEPCONTROLLER_IF_H
#define BEEPCONTROLLER_IF_H

class BeepData;

class BeepControlData
{
public:

  typedef struct
  {
      tS16 LF;
      tS16 RF;
      tS16 LR;
      tS16 RR;
      tS16 CE;
      tS16 SUB;
    tU16 RampLin;
    tU16 RampDB;
  } ChVolOff;

  typedef struct
  {
    tU8 BeepId;
    tU16 Freq;
    tS16 Gain;
  }BeepPara;

  typedef struct
  {
    tU16 Pulses;
    tU16 AttackTime;
    tU16 AttackTimeLog;
    tU16 AttackTimeLin;
    tU16 ReleaseTime;
    tU16 ReleaseTimeLog;
    tU16 ReleaseTimeLin;
    tU8  SignalToneAction;
  }ChimePara;
};

class BeepController_IF
{
public:
  virtual tVoid StartBeep(BeepData oBeepData) = 0;
  virtual tVoid IdleBeep(tU8 tStopType) = 0;
  virtual tVoid SetBeepLocation(tVoid) = 0;
  virtual tVoid DoMuteBeepStream(tVoid)=0;
  virtual tVoid UpdateBeepVolume(tVoid)=0;
  virtual ~BeepController_IF(){};
  virtual tVoid MuteOtherStreams(tVoid)=0;
  virtual tVoid DemuteOtherStreams(tVoid)=0;
};
#endif
