/*******************************************************************************
*
* FILE:          ADAS_UPASound.h
*
* SW-COMPONENT:  Beep Adas application
*
* PROJECT:
*
* DESCRIPTION:   Beep Adas Class.
*
* AUTHOR:       pmh7kor
*
* COPYRIGHT:    (c) 2016 RBEI, Bangalore
*
*******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_BEEP
#include "trcGenProj/Header/ADAS_UPASound.cpp.trc.h"
#endif
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#include "../fc_audiomanager_service_Audio_Function.h"
#include "ADAS_UPASound.h"
#include "Beep_defines.h"
#include "../fc_audiomanager_trace.h"
#include "../InternalComponentCommunication/Messages/Beep/IDCCAStartADASBeep.h"
#include "../InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CANAttenuation.h"
#include "../InternalComponentCommunication/Messages/Beep/ID_NotifyParkAssistVolume.h"
#include "InternalComponentCommunication/Messages/Beep/ID_ADASSoundCollection.h"
#include "InternalComponentCommunication/Messages/Beep/IDCCAUPATempMute.h"
#include "../InternalComponentCommunication/Messages/Diag/IDDiagDefSet.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/DiagDefSetType.h"
#include "../aud_sinkmanager/vd_adr3/vd_adr3Msg_If.h"

#include "../InternalComponentCommunication/Messages/BOSE_Amp/ID_SonarInfo.h"
#include "vd_amp_Msg/MCANBose/vd_amp_MCANBose_MasterAmplifier_Defines.h"
#include "../InternalComponentCommunication/Messages/BOSE_Amp/ID_BOSE_Amplifier_ConnectionStatus.h"
#include "fc_audiomanager_main.h"

ADAS_UPASound *ADAS_UPASound:: _poThisInterface = NULL;
#define NOTDEFINED 0xFF

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
ADAS_UPASound::ADAS_UPASound(void): IF_MessageObserver<PO_MessageConfig::enID>("ADAS_UPASound Constructor")
{
  vResetUPAData();
  _poThisInterface = NULL;
  m_poBeepAdasInstance = NULL;
  m_poAudio_Function = NULL;
  m_hUPASettingSndTimer = OSAL_C_INVALID_HANDLE;
  m_asynccall = NULL;
  pAudUsrDpIf   = NULL;
  m_UPA_Status_DisplayRequest= NOTDEFINED;
}
/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::ADAS_UPASound()
*
* DESCRIPTION: Constructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
ADAS_UPASound::ADAS_UPASound(Beep_Adas* poAdasInstance): IF_MessageObserver<PO_MessageConfig::enID>("ADAS_UPASound")
{
  ETG_TRACE_USR2(("ADAS_UPASound::ADAS_UPASound() constructor called"));
  vResetUPAData();
  m_hUPASettingSndTimer = OSAL_C_INVALID_HANDLE;
  _poThisInterface = this;
  m_poBeepAdasInstance = poAdasInstance;



  m_UPA_Status_DisplayRequest=NOTDEFINED;
  m_poAudio_Function = poAdasInstance->m_poAudio_Function;
  m_asynccall = fc_audiomanager_tclApp::theServer()->poAsyncCall();
  pAudUsrDpIf   = AudioUserDpIfSelect::pGetAudUsrDpIf();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_asynccall);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAStart_ADASBeep);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_CANAttenuation);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagDefSet);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::IDCCAUPATempMute);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyParkAssistVolume);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_ADASSoundCollection);
  vInitUPASettingSndTimer();

}
/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::~vResetUPAData()
* Resets the Data members to defaults
*******************************************************************************/
tVoid ADAS_UPASound::vResetUPAData()
{
  ETG_TRACE_USR2(("ADAS_UPASound::vResetUPAData()"));
  u8AmpConnectionState = AMP_NOT_CONNECTED;
  m_u8ObstacleZone = (tU8)EN_OBSTACLEZONE_NoSound;
  m_u8AdasUPARecurrenceType = DISCONTINUOUS; //default
  m_u8AdasUPARecurrenceFrequency = 0;
  m_bAdasUPAErrorSoundStatus = FALSE;
  m_bAdasUPAActivationSoundStatus = FALSE;
  m_bAdasUPAObstacleSoundStatus = FALSE;
  m_bAdasUPASettingSound = FALSE;
  m_bCANAttenuationStatus = FALSE;
  m_bUPASettingSndTmrRunning = FALSE;
}
/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::~ADAS_UPASound()
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
ADAS_UPASound::~ADAS_UPASound()
{
  ETG_TRACE_USR4(("~ADAS_UPASound() entered."));
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  m_poBeepAdasInstance = NULL;
  m_poAudio_Function = NULL;
  if (_poThisInterface != NULL)
  {
    delete _poThisInterface;
    _poThisInterface = NULL;
  }

  vStopUPASettingSndTimer(AUD_BEEP_TIMER_ID_ADASUPA_SETTINGSOUND); // to stop timer on shut down if running and clear timer status
  if (m_hUPASettingSndTimer != OSAL_C_INVALID_HANDLE)
  {
    tS32 s32OsalError = OSAL_s32TimerDelete(m_hUPASettingSndTimer);

    NORMAL_M_ASSERT(s32OsalError == OSAL_OK);

    m_hUPASettingSndTimer = OSAL_C_INVALID_HANDLE;
  }
}


/********************************************************************************
* vInitUPASettingSndTimer().
*******************************************************************************/
tVoid ADAS_UPASound::vInitUPASettingSndTimer(tVoid)
{
  tS32 s32OsalError = OSAL_ERROR;
  ETG_TRACE_USR4(("ADAS_UPASound::vInitUPASettingSndTimer() entered."));
  /* create ADR supervision timer */
  s32OsalError = OSAL_s32TimerCreate((OSAL_tpfCallback)vUPASettingSndTimerCallback, (tPVoid)this, &m_hUPASettingSndTimer);

  if (s32OsalError == OSAL_OK){
    ETG_TRACE_USR4(("ADAS_UPASound::vInitUPASettingSndTimer() Timer created successfully."));
  }
  else
    ETG_TRACE_ERR(("ADAS_UPASound:: Error in creating Timer"));
}




/********************************************************************************
* vStartUPASettingSndTimer().
*******************************************************************************/
tVoid ADAS_UPASound::vStartUPASettingSndTimer(tU16 uwTimerID, tU16 uwTimeMs)
{
  tS32 s32RetVal = OSAL_ERROR;
  ETG_TRACE_USR4((" ADAS_UPASound::vStartUPASettingSndTimer uwTimerID = 0x%x, uwTimeMs = %u ", uwTimerID, uwTimeMs));
  if (uwTimerID == AUD_BEEP_TIMER_ID_ADASUPA_SETTINGSOUND)
    s32RetVal = OSAL_s32TimerSetTime(m_hUPASettingSndTimer, (tU32)uwTimeMs, 0);

  if (s32RetVal == OSAL_OK)
  {
    ETG_TRACE_USR4((" ADAS_UPASound::Timer started successfully,s32RetVal = 0x%x", s32RetVal));
    m_bUPASettingSndTmrRunning = TRUE;
  }
  else
    ETG_TRACE_ERR(("ADAS_UPASound:: Error in Starting Timer"));
}
/********************************************************************************
* vStopUPASettingSndTimer().
*******************************************************************************/
tVoid ADAS_UPASound::vStopUPASettingSndTimer(tU16 uwTimerID)
{
  tS32 s32RetVal = OSAL_ERROR;
  ETG_TRACE_USR4((" ADAS_UPASound::vStopUPASettingSndTimer uwTimerID = 0x%x ", uwTimerID));
  if ((uwTimerID == AUD_BEEP_TIMER_ID_ADASUPA_SETTINGSOUND) && (m_bUPASettingSndTmrRunning))
  {
    s32RetVal = OSAL_s32TimerSetTime(m_hUPASettingSndTimer, 0, 0);
    if (s32RetVal == OSAL_OK)
    {
      m_bUPASettingSndTmrRunning = FALSE;
      ETG_TRACE_USR4(("ADAS_UPASound::Timer Stopped Successfully, s32RetVal = 0x%x", s32RetVal));
    }
  }
  else
    ETG_TRACE_ERR(("ADAS_UPASound::Invalid Timer ID to Stop"));
}



/********************************************************************************
* vUPASettingSndTimerCallback( )
*******************************************************************************/
tVoid ADAS_UPASound::vUPASettingSndTimerCallback(tVoid* pArg){
  ETG_TRACE_USR2(("ADAS_UPASound::vUPASettingSndTimerCallback() called"));
  ((ADAS_UPASound*)pArg)->m_bUPASettingSndTmrRunning = FALSE; // timer expired, so resetting
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_poThisInterface);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_poThisInterface->m_asynccall);

  _poThisInterface->m_asynccall->vCall<ADAS_UPASound,tU8>(_poThisInterface, &ADAS_UPASound::vTriggerStopBeep,EN_AUDIO_BEEP_UPA_SETTING_SND);
}

/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::MessageNotification(PO_MessageConfig::enID MsgId)
*******************************************************************************/

// This function is called by post office on new incoming messages.
void ADAS_UPASound::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR2(("ADAS_UPASound::MessageNotification() called MsgId = %d",MsgId));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance->m_poBeepController);
  switch(MsgId)
  {
  case (PO_MessageConfig::ID_CCAStart_ADASBeep):
    {
      const ID_CCAStart_ADASBeep* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_CCAStart_ADASBeep>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);

      if(!(bIsSonarConfiguredAvailable() || bIsUPAConfiguredAvailable()))
      {
        ETG_TRACE_USR2((" UPA or sonar not configured, Not triggering UPA/Sonar Sound"));
        break;
      }
      if ((pMsg->m_u8BeepType == EN_AUDIO_BEEP_STOP_ADAS_SETTING_SND) && m_bAdasUPASettingSound) // when stop setting sound is received and setting sound is running,beep priorities will stop immediately
      {
        m_poBeepAdasInstance->setAdasBeep(pMsg->m_u8BeepType, this);
        vClearAdasSoundStatus(EN_AUDIO_BEEP_UPA_SETTING_SND);
      }
      else if ((pMsg->m_u8BeepType >= EN_AUDIO_BEEP_UPA_ERROR_SND) && (pMsg->m_u8BeepType <= EN_AUDIO_BEEP_UPA_SETTING_SND))
      {
        if((pMsg->m_u8BeepType == EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE)&&(m_bAdasUPAObstacleSoundStatus))
        {
          ETG_TRACE_USR2(("ID_CCAStart_ADASBeep received: %d,%d,%d", pMsg->m_u8BeepType,pMsg->m_u8RecurrenceType,pMsg->m_u8ChannelZone));

          m_u8ObstacleZone = pMsg->m_u8ChannelZone;
          if((pMsg->m_u8ChannelZone == EN_OBSTACLEZONE_NoSound))
            vTriggerStopBeep(EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE);
          else
            m_poBeepAdasInstance->m_poBeepController->SetBeepLocation();

        }
        else
        {
          if((pMsg->m_u8BeepType == EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE))
          {
            m_u8AdasUPARecurrenceType = pMsg->m_u8RecurrenceType;
            m_u8ObstacleZone = pMsg->m_u8ChannelZone;
          }
           if(bIsParkAssistlevelValid())
            m_poBeepAdasInstance->setAdasBeep(pMsg->m_u8BeepType, this);
        }
      }
      else{}
      break;
    }
  case (PO_MessageConfig::ID_CANAttenuation):
    {
      const ID_CANAttenuation* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_CANAttenuation>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
      ETG_TRACE_USR2(("ID_CANAttenuation received: %d", pMsg->m_bAttenuationCommand));
      m_bCANAttenuationStatus = pMsg->m_bAttenuationCommand;
      if(bIsAdasSoundActive())
        m_poBeepAdasInstance->m_poBeepController->UpdateBeepVolume();
      break;
    }
  case PO_MessageConfig::ID_DiagDefSet:
    {
      // Obtaining the Diag DefSet
      const ID_DiagDefSet* pMsgDefSet = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_DiagDefSet>(MsgId);
      ETG_TRACE_USR4(("DefSet received Type = %x, Phase =%x", pMsgDefSet->enDiagDefSetType, pMsgDefSet->enDiagDefSetPhase));
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsgDefSet);
      tenDiagDefSetType enDefSetType = pMsgDefSet->enDiagDefSetType;
      tenDiagDefSetPhase enDefSetPhase = pMsgDefSet->enDiagDefSetPhase;
      if (((enDefSetType == EN_DEFSET_HMI) || (enDefSetType == EN_DEFSET_TEF)) && (enDefSetPhase == EN_DEFSET_FINISH))
      {
        if(!(bIsUPAConfiguredAvailable() || bIsSonarConfiguredAvailable()))
          vTriggerStopBeep();
      }
      break;
    }
  case (PO_MessageConfig::ID_NotifyParkAssistVolume) :
    {
      const ID_NotifyParkAssistVolume* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_NotifyParkAssistVolume>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
      ETG_TRACE_USR2(("ID_NotifyParkAssistVolume received : %d", pMsg->m_volume));
      tS32 s32Res = 0;
    dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
      s32Res = odpParkAssitVol.s32SetData(pMsg->m_volume);
      ETG_TRACE_USR4(("Persistent Memory storage Result for park assist volume = %x", s32Res));


      if(pMsg->m_volume == VOLUME_LEVEL_0)
      {   m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_PARK_ASSIST_MUTE,/*_poThisInterface*/this);
          vTriggerStopBeep();
          break;
      }
      if(!m_bAdasUPAObstacleSoundStatus)
      {
      //    // triggering obstacle sound if exists and  park assist vol is set to non zero from Zero
          vTriggerNewObstacleZoneSound();
      }
      //volume will be updated from Beep_Adas
      if (m_bAdasUPASettingSound) //restarting 3sec timer on Park assist volume change
        vStartUPASettingSndTimer(AUD_BEEP_TIMER_ID_ADASUPA_SETTINGSOUND, AUD_BEEP_TIMER_ADASUPA_SETTINGSOUND_INTERVAL);
      break;
    }
  case (PO_MessageConfig::IDCCAUPATempMute):
    {
      const IDCCAUPATempMute* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<IDCCAUPATempMute>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
      ETG_TRACE_USR2(("IDCCAUPATempMute received : %d", pMsg->m_UPATempMute));
      ETG_TRACE_USR2(("m_bAdasUPAObstacleSoundStatus received : %d",m_bAdasUPAObstacleSoundStatus));
      if(m_bAdasUPAObstacleSoundStatus)
      {
        if(pMsg->m_UPATempMute)
        {m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_UPA_TEMP_MUTE,/*_poThisInterface*/this);
          vTriggerStopBeep();
        }
        else
        {
          if(m_poAudio_Function->bIsHFPActive())
          {
            ETG_TRACE_USR2(("m_bAdasUPAObstacleSoundStatus received : %d and HFP is ACTIVE ",m_bAdasUPAObstacleSoundStatus));
            vTriggerNewObstacleZoneSound();
          }
        }
      }
      else // if running beep is stopped by user mute and if obstacle still exists, then trigger new beep
      {
        vTriggerNewObstacleZoneSound();
      }
    }
    break;
  case (PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus):
    {
      const ID_BOSE_Amplifier_ConnectionStatus* pBoseMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_BOSE_Amplifier_ConnectionStatus>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pBoseMsg);
      ETG_TRACE_USR4(("MessageNotification:ID_BOSE_Amplifier_ConnectionStatus, connection state :%d",pBoseMsg->connectionstate));
      u8AmpConnectionState = pBoseMsg->connectionstate;
    ETG_TRACE_USR4(("MessageNotification:Adas status %d",m_bAdasUPAObstacleSoundStatus));
    if((u8AmpConnectionState == AMP_CONNECTED) && m_bAdasUPAObstacleSoundStatus)
      {
       ETG_TRACE_USR4(("ADAS_UPASound::obstacle sound active and amplifier connected"));
       ID_SonarInfo oSonarInfo(m_u8ObstacleZone);
       InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSonarInfo);
     AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
     AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance->m_poBeepController);
     m_poBeepAdasInstance->m_poBeepController->SetBeepLocation();
    }

    }
    break;


  case (PO_MessageConfig::ID_ADASSoundCollection) :
    {
      const ID_ADASSoundCollection* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_ADASSoundCollection>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
      ETG_TRACE_USR2(("ID_ADASSoundCollection received : %d", pMsg->m_SoundType));


      // if new reuest comes when sound is playing
      if (m_bAdasUPASettingSound) //restarting 3sec timer on Park assist volume change
        vStartUPASettingSndTimer(AUD_BEEP_TIMER_ID_ADASUPA_SETTINGSOUND, AUD_BEEP_TIMER_ADASUPA_SETTINGSOUND_INTERVAL);

      break;
    }
  default:
    break;
  }
}

/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff *VolOffsets)
*
* DESCRIPTION: Interface function to get volume offsets for Beep
*
* PARAMETER: tU8 tUBeepName
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid ADAS_UPASound::GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff *VolOffsets)
{
   ETG_TRACE_USR4(("ADAS_UPASound::GetBeepVolumeOffsets()  BeepName:%d", tUBeepName));

   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poAudio_Function);
     tS16 ts16UPAEOLLevelOffset=0;





  #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
      if(m_poAudio_Function->bIsBoseAmpConnected() && ((m_poBeepAdasInstance->m_poBeepMainAppl->u8GetOEMType() == OEM_TYPE_INFINITI) || (m_poBeepAdasInstance->m_poBeepMainAppl->u8GetOEMType() == OEM_TYPE_NISSAN))) //Bose MCAN Amplifier configured, creating clienthandler of buzzer
         GetUPAEOLLevelOffset(ts16UPAEOLLevelOffset);
    #endif



  VolOffsets->LF       =  CHANNEL_MUTE;
  VolOffsets->RF       =  CHANNEL_MUTE;
  VolOffsets->LR       =  CHANNEL_MUTE;
  VolOffsets->RR       =  CHANNEL_MUTE;
  VolOffsets->RampLin  =   0x08;   //Very Fast Mute for UPA beeps, need to be checked
  VolOffsets->RampDB   =  0x320; //Very Fast Mute for UPA beeps, need to be checked
  VolOffsets->CE       =  CHANNEL_MUTE;
  VolOffsets->SUB      =  CHANNEL_MUTE;

  switch(tUBeepName)
  {
  case EN_AUDIO_BEEP_UPA_ERROR_SND:
  case EN_AUDIO_BEEP_UPA_ACTIVATION_SND:

    {
      ETG_TRACE_USR4(("GetBeepVolumeOffsets, UPA Activation/error Sound/UPA setting sound"));
      VolOffsets->LF       =  0;
      VolOffsets->RF       =  0;
    }
    break;
  case EN_AUDIO_BEEP_UPA_SETTING_SND:
    {
      //VolOffsets->LF       =  0;
      //VolOffsets->RF       =  0;
      VolOffsets->LR       =  0;
      VolOffsets->RR       =  0;
    }
    break;
  case EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE:
    if(m_u8ObstacleZone != EN_OBSTACLEZONE_NoSound)
    {
      ETG_TRACE_USR4(("GetBeepVolumeOffsets, UPA Obstacle zone Sound"));

      //Check if the Init Id received from thte configuratio matvches the variant from the datapool.
      if((u8AmpConnectionState == AMP_CONNECTED))
      {
        VolOffsets->LF       =  CHANNEL_MUTE;
        VolOffsets->RF       =  CHANNEL_MUTE;

        VolOffsets->LR       = ts16UPAEOLLevelOffset;
        VolOffsets->RR       =  CHANNEL_MUTE;
      }
      else
      {
        switch(m_u8ObstacleZone)
        {
        case EN_OBSTACLEZONE_FrontLeft:
          VolOffsets->LF       =  0;
          break;
        case EN_OBSTACLEZONE_FrontCenter:
          VolOffsets->LF       =  0;
          VolOffsets->RF       =  0;
          break;
        case EN_OBSTACLEZONE_FrontRight:
          VolOffsets->RF       =  0;
          break;
        case EN_OBSTACLEZONE_RearLeft:
          VolOffsets->LR       =  0;
          break;
        case EN_OBSTACLEZONE_RearCenter:
          VolOffsets->LR       =  0;
          VolOffsets->RR       =  0;
          break;
        case EN_OBSTACLEZONE_RearRight:
          VolOffsets->RR       =  0;
          break;
        default:
          break;
        }
      }
    }
    break;
  default:
    break;
  }
  ETG_TRACE_USR4(("GetBeepVolumeOffsets() : VolOffsets->LF : %d, VolOffsets->RF : %d, VolOffsets->LR :  %d, VolOffsets->RR : %d",VolOffsets->LF, VolOffsets->RF,VolOffsets->LR,VolOffsets->RR));
}


/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::GetRecurrencePeriod()
*******************************************************************************/
tU16 ADAS_UPASound::GetRecurrencePeriod(tU8 tUBeepName)
{
  ETG_TRACE_USR4(("ADAS_UPASound::GetRecurrencePeriod() called for Beep = %d, m_u8AdasUPARecurrenceType : %d, m_u8AdasUPARecurrenceFrequency : %d",tUBeepName, m_u8AdasUPARecurrenceType,m_u8AdasUPARecurrenceFrequency));
  if (tUBeepName == EN_AUDIO_BEEP_UPA_SETTING_SND)
    return RECURRENCE_PERIOD_MAX*2/6;
  else if(tUBeepName == EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE)
  {
    if(CONTINUOUS == m_u8AdasUPARecurrenceType) // for continuous sound, sending MAX recurrence period to play complete tone
      return RECURRENCE_PERIOD_MAX;
    return m_u8AdasUPARecurrenceFrequency;
  }
  else
    return RECURRENCE_PERIOD_MAX;
}
/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::bSetandTriggerAdasActivationSound(tU8 tUPAActivationSound)
*******************************************************************************/

void ADAS_UPASound::vSetandTriggerAdasActivationSound(tU8 tUPAActivationSound)
{
  tBool Ret = (bIsUPAConfiguredAvailable()||bIsSonarConfiguredAvailable()) && bIsParkAssistlevelValid();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  if(Ret &&  tUPAActivationSound && (bIs_UPA_Status_DisplayRequest_state_valid()))
  {
    ETG_TRACE_USR4(("ADAS_UPASound::bSetandTriggerAdasActivationSound() called"));
    m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_UPA_ACTIVATION_SND,/*_poThisInterface*/this);

  }
  else
    ETG_TRACE_USR4(("ADAS_LDWSound:: Cannot trigger UPA Activation Sound"));
}
/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::bSetandTriggerAdasErrorSound(tU8 tUPAErrorSound)
*******************************************************************************/

void ADAS_UPASound::vSetandTriggerAdasErrorSound(tU8 tUPAErrorSound)
{
  tBool Ret = ((bIsUPAConfiguredAvailable()||bIsSonarConfiguredAvailable()) && bIsParkAssistlevelValid()) && (!bIsUPAUserMuteActive());
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  if(Ret && tUPAErrorSound &&(bIs_UPA_Status_DisplayRequest_state_valid()))
  {
    ETG_TRACE_USR4(("ADAS_UPASound::bSetandTriggerAdasErrorSound() called "));
    m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_UPA_ERROR_SND,/*_poThisInterface*/this);

  }
  else
    ETG_TRACE_USR4(("ADAS_LDWSound:: Cannot trigger UPA Error Sound"));
}
/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::bSetandTriggerUPAObstacleSound(tU8 tUPAObstacleSound)
*******************************************************************************/

void ADAS_UPASound::vSetandTriggerUPAObstacleSound(tU8 tUPAObstacleSound)
{

  tBool Ret =  ((bIsUPAConfiguredAvailable()||bIsSonarConfiguredAvailable()));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance->m_poBeepController);
  m_u8ObstacleZone = tUPAObstacleSound;
  ETG_TRACE_USR2(("ADAS_UPASound::bSetandTriggerUPAObstacleSound(), tUPAObstacleSound = %d, Ret = %d",tUPAObstacleSound,Ret));
  if(tUPAObstacleSound == EN_OBSTACLEZONE_NoSound)
    vTriggerStopBeep(EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE);
  else if(Ret && (tUPAObstacleSound > EN_OBSTACLEZONE_NoSound) && bIsParkAssistlevelValid() && (!bIsUPAUserMuteActive())&& (bIs_UPA_Status_DisplayRequest_state_valid()))
  {
    ETG_TRACE_USR4(("ADAS_UPASound::bSetandTriggerUPAObstacleSound() called"));

    if(m_bAdasUPAObstacleSoundStatus)
    {
      ETG_TRACE_USR4(("ADAS_UPASound:: UPA Sound is already active"));
      if((m_u8AdasUPARecurrenceType == DISCONTINUOUS) && (!m_u8AdasUPARecurrenceFrequency))
      {
        ETG_TRACE_USR4(("ADAS_UPASound:: Recurrence frequency is zero, Discontinuous sound cant be triggered"));
        //m_poBeepAdasInstance->StopAdasBeep();
        vTriggerStopBeep(EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE);
      }
      else
      {
        ID_SonarInfo oSonarInfo(m_u8ObstacleZone);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSonarInfo);
        m_poBeepAdasInstance->m_poBeepController->SetBeepLocation(); //update beeplocation to set recurrence period , if obstacle sound is already running
      }
    }
    else // if upa not active
    {
      vTriggerNewObstacleZoneSound();
    }

  }
  else
    ETG_TRACE_USR4(("ADAS_UPASound:: Cannot trigger UPA Obstacle zone Sound"));
}
/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::vTriggerNewObstacleZoneSound()
*******************************************************************************/
tVoid ADAS_UPASound::vTriggerNewObstacleZoneSound()
{
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  if((m_u8ObstacleZone != EN_OBSTACLEZONE_NoSound) && bIsParkAssistlevelValid() && !bIsUPAUserMuteActive()  && (bIs_UPA_Status_DisplayRequest_state_valid()))
  {
    ETG_TRACE_USR4(("ADAS_UPASound::vTriggerNewObstacleZoneSound()"));
    if(m_u8AdasUPARecurrenceType == DISCONTINUOUS)
    {
      ETG_TRACE_USR4(("ADAS_UPASound::UPA Sound not active, m_u8AdasUPARecurrenceType : %d, m_u8AdasUPARecurrenceFrequency :%d", m_u8AdasUPARecurrenceType,m_u8AdasUPARecurrenceFrequency));
      if (m_u8AdasUPARecurrenceFrequency != 0) //trigger only if recuurence frequency is non zero
        m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE,this);
    }
    else
      m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE,this);
  }
}

/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::vUpdateUPAActivationFilePath(tU8 soundType)
*******************************************************************************/

std::string ADAS_UPASound::sGetUPAActivationFile(tU8 soundType)
{
  ETG_TRACE_USR4(("vUpdateUPAActivationFilePath() called, soundType = %d,m_bAdasUPAActivationSoundStatus = %d",soundType,m_bAdasUPAActivationSoundStatus));
  std::string sfileName;
  switch(soundType)
  {
  case BIP:
   if(((Beep_Main::u8GetOEMType() == OEM_TYPE_INFINITI) || (Beep_Main::u8GetOEMType() == OEM_TYPE_NISSAN) || (Beep_Main::u8GetOEMType() == OEM_TYPE_MITSUBISHI) ))
  {
   sfileName = "Nissan_BIP_activ_44100.wav";
  }
  else
  {
    sfileName = "BIP_activ_44100.wav";
  }
    break;
  case CORDE:
    sfileName = "CORDE_activ_44100.wav";
    break;
  case SONAR:
    sfileName = "SONAR_activ_44100.wav";
    break;
  default:
    ETG_TRACE_ERR(("Sound Collection is out of Range and No valid sound file is found"));
    break;
  }
  return sfileName;
}

/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::vUpdateUPAErrorFilePath(tU8 soundType)s
*******************************************************************************/

std::string ADAS_UPASound::sGetUPAErrorFile(tU8 soundType)
{
  ETG_TRACE_USR4(("vUpdateUPAErrorFilePath() called, soundType = %d, m_bAdasUPAErrorSoundStatus = %d",soundType,m_bAdasUPAErrorSoundStatus));

  std::string sfileName;
  //m_bAdasUPAErrorSoundStatus = TRUE;
  switch(soundType)
  {
  case BIP:
  if(((Beep_Main::u8GetOEMType() == OEM_TYPE_INFINITI) || (Beep_Main::u8GetOEMType() == OEM_TYPE_NISSAN) || (Beep_Main::u8GetOEMType() == OEM_TYPE_MITSUBISHI)))
  {
   sfileName = "Nissan_BIP_error_06sec_44100.wav";
  }
  else
  {
    sfileName = "BIP_erreur_06sec_44100.wav";
  }
    break;
  case CORDE:
    sfileName = "CORDE_erreur_06sec_44100.wav";
    break;
  case SONAR:
    sfileName = "SONAR_erreur_06sec_44100.wav";
    break;
  default:
    ETG_TRACE_ERR(("Sound Collection is out of Range and No valid sound file is found"));
    break;
  }
  return sfileName;
}
/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::bSetUPAObstacleZoneRecurrencePeriod(tU8 tUPARecurrencePeriod)
*******************************************************************************/

void ADAS_UPASound::vSetUPAObstacleZoneRecurrencePeriod(tU8 tUPARecurrencePeriod)
{

  tBool Ret = (bIsUPAConfiguredAvailable()||bIsSonarConfiguredAvailable());
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance->m_poBeepController);
  if(Ret )
  {
    ETG_TRACE_USR4(("ADAS_UPASound::bSetUPAObstacleZoneRecurrencePeriod() called,tUPARecurrencePeriod : %d",tUPARecurrencePeriod));
    if(tUPARecurrencePeriod == 0)
    {
      m_u8AdasUPARecurrenceFrequency = 0;
    }
    else //recurrence fre recevied from CAN is with 0.1 resolution, so if CAN value is 10, it is 1Hz
      m_u8AdasUPARecurrenceFrequency = tU8((2*1000)/tUPARecurrencePeriod); //2/RF *100; giving % of samples to be played as input to beep_file_player, if RP <= 2 , all samples will be played.
    // Till 2 Hz, all the samples should be played, after 2Hz, no. of samples will reduce.
    ETG_TRACE_USR4(("ADAS_UPASound:: m_u8AdasUPARecurrenceFrequency is %d", m_u8AdasUPARecurrenceFrequency));
    if(m_bAdasUPAObstacleSoundStatus && (m_u8AdasUPARecurrenceType == DISCONTINUOUS))
    {
      if(m_u8AdasUPARecurrenceFrequency == 0) // stop beep if active and recurrence period is 0;
      {
        ETG_TRACE_USR4(("ADAS_UPASound:: m_u8AdasUPARecurrenceFrequency is %d", m_u8AdasUPARecurrenceFrequency));
        vTriggerStopBeep(EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE);
      }
      else
      {
        //update beeplocation to set recurrence period , if obstacle sound is already running
        m_poBeepAdasInstance->m_poBeepController->SetBeepLocation();
      }
    }
    else //to trigger the discontinuous obstacle sound if exists on changing the recurrence period to non zero
    {
      tBool bRet = ((m_u8ObstacleZone != EN_OBSTACLEZONE_NoSound) && (m_u8AdasUPARecurrenceType == DISCONTINUOUS) && (m_u8AdasUPARecurrenceFrequency != 0) && bIsParkAssistlevelValid() && !bIsUPAUserMuteActive() && ((bIs_UPA_Status_DisplayRequest_state_valid())));
      if(bRet)
        m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE,this);

    }

  }
}


/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::bSetUPAObstacleZoneRecurrencePeriod(tU8 tUPARecurrenceType)
*******************************************************************************/
void ADAS_UPASound::vSetUPAObstacleZoneRecurrenceType(tU8 tUPARecurrenceType)
{

  tBool Ret =  (bIsUPAConfiguredAvailable()||bIsSonarConfiguredAvailable());
  if(Ret)
  {
    ETG_TRACE_USR4(("ADAS_UPASound::bSetUPAObstacleZoneRecurrenceType() called "));
    m_u8AdasUPARecurrenceType = tUPARecurrenceType;
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance->m_poBeepController);

    if(m_bAdasUPAObstacleSoundStatus)
    {
      if((m_u8AdasUPARecurrenceType == DISCONTINUOUS)&& (m_u8AdasUPARecurrenceFrequency == 0)) // stop beep if active and recurrence period is 0;
      {
        ETG_TRACE_USR4(("ADAS_UPASound:: m_u8AdasUPARecurrenceFrequency is %d", m_u8AdasUPARecurrenceFrequency));
        vTriggerStopBeep(EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE);
      }
      else
      {
        //update beeplocation to set recurrence period
        m_poBeepAdasInstance->m_poBeepController->SetBeepLocation();
      }
    }
    else //trigger obstacle sound if exists on receiving new recurrence type
      vTriggerNewObstacleZoneSound();
  }
}



/*******************************************************************************
*
* FUNCTION:  ADAS_UPASound::GetImxBeepData(tU8 tUBeepName)

*******************************************************************************/
std::string ADAS_UPASound::GetBeepFilePath(tU8 tUBeepName)
{
  tU8 AdasUPASndtype = 0;
  tS32 s32Res = 0;
  s32Res =  pAudUsrDpIf->s32GetUPASoundtype(AdasUPASndtype);
  ETG_TRACE_USR4(("s32Res : %d",s32Res));

    std::string fileName;
  switch(tUBeepName)
  {
  case EN_AUDIO_BEEP_UPA_ACTIVATION_SND:
    fileName = sGetUPAActivationFile(AdasUPASndtype);
    break;
  case EN_AUDIO_BEEP_UPA_ERROR_SND:
    fileName = sGetUPAErrorFile(AdasUPASndtype);
    break;
  case EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE:
    fileName = sGetUPAObstacleZoneFile(AdasUPASndtype);
    break;
  case EN_AUDIO_BEEP_UPA_SETTING_SND:
    fileName = sGetUPASettingSound(AdasUPASndtype);
    break;
  default:
    break;

  }
  ETG_TRACE_USR4(("ADAS_UPASound::GetBeepFilePath, beep path is :%s ",fileName.c_str()));
  return fileName;
}

/*******************************************************************************
*
* FUNCTION:  ADAS_UPASound::sGetUPAObstacleZoneFile(tU8 soundType)

*******************************************************************************/
std::string ADAS_UPASound::sGetUPAObstacleZoneFile(tU8 soundType)
{
  if(m_u8AdasUPARecurrenceType == DISCONTINUOUS)
  {
    return (sGetUPADiscontObstacleZoneSound(soundType));
  }
  else
  {
    return (sGetUPAContObstacleZoneSound(soundType));
  }
}
/*******************************************************************************
*
* FUNCTION:  ADAS_UPASound::sGetUPASettingSound(tU8 soundType)

*******************************************************************************/
std::string ADAS_UPASound::sGetUPASettingSound(tU8 soundType)
{
  std::string sfileName;
  switch(soundType)
  {
  case BIP:
    if(((Beep_Main::u8GetOEMType() == OEM_TYPE_INFINITI) || (Beep_Main::u8GetOEMType() == OEM_TYPE_NISSAN) || (Beep_Main::u8GetOEMType() == OEM_TYPE_MITSUBISHI)))
  {
    sfileName = "Nissan_BIP_rear_short_44100.wav";
  }
  else
  {
    sfileName = "BIP_rear_short_44100.wav";
  }
    break;
  case CORDE:
    sfileName = "CORDE_rear_short_44100.wav";
    break;
  case SONAR:
    sfileName = "SONAR_rear_short_44100.wav";
    break;
  default:
    ETG_TRACE_ERR(("Sound Collection is out of Range and No valid sound file is found"));
    break;
  }
  return sfileName;
}
/*******************************************************************************
*
* FUNCTION:  ADAS_UPASound::GetBeepVolume(tU8 tUBeepName)

*******************************************************************************/

tS16 ADAS_UPASound::GetBeepVolume(tU8 /*tUBeepName*/)
{
  tS16 VolumeDB;
  ETG_TRACE_USR4(("ADAS_UPASound::GetBeepVolume"));
  AUD_POINTER_CHECK_CALL(m_poBeepAdasInstance);
  if(m_bCANAttenuationStatus == TRUE)
  {
    //sending the cluster sound value by which beep has to be played
    VolumeDB = tS16((tS16)VOLOFFSET_RESOLUTION * m_poBeepAdasInstance->s16GetDBValue(m_poBeepAdasInstance->GetClusterSoundLvlForAttenuation()));
  }
  else
  {
    return GetBeepVolume_withoutCANAttenuation();
  }

  if(VolumeDB< (-480) )
  {
    return -480;
  }
  else{

    return VolumeDB;
  }

 }
 /*******************************************************************************
*
* FUNCTION:  ADAS_UPASound::GetBeepVolume(tU8 tUBeepName)

*******************************************************************************/
 //function added to get volume level without Clustersondlevel for attenuation
 tS16 ADAS_UPASound::GetBeepVolume_withoutCANAttenuation(tU8 tUBeepName)
 {
    tS16 VolumeDB;
  ETG_TRACE_USR4(("ADAS_UPASound::GetBeepVolume_withoutCANAttenuation"));
  AUD_POINTER_CHECK_CALL(m_poBeepAdasInstance);
  tS16 ts16UPAEOLLevelOffset=0;

  {
      tS16 s16UPAObsoluteLevelOffset = -23 * VOLOFFSET_RESOLUTION; //base offset level
      tS32 OEM_type= m_poBeepAdasInstance->m_poBeepMainAppl->u8GetOEMType();

      if(OEM_type==OEM_TYPE_NISSAN || OEM_type==OEM_TYPE_INFINITI )
      {
          #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
          if((m_poBeepAdasInstance->m_poBeepMainAppl->u8AmpConnectionState == AMP_CONNECTED))
          {
               s16UPAObsoluteLevelOffset = -18 * VOLOFFSET_RESOLUTION; //base offset level
          }
          #endif
      }


    //ADAS EOL offset
    GetUPAEOLLevelOffset(ts16UPAEOLLevelOffset);


    //Park assist Volume Offset

    tU8 u8ParkAssistVol = 0;
    dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
    odpParkAssitVol.s32GetData(u8ParkAssistVol);

    tS16 s16ParkAssistVolumeLevelOffset = m_poBeepAdasInstance->s16GetAdasVolumeOffset(u8ParkAssistVol);

    VolumeDB = tS16(ts16UPAEOLLevelOffset + s16UPAObsoluteLevelOffset + s16ParkAssistVolumeLevelOffset);

   if(OEM_type==OEM_TYPE_NISSAN || OEM_type==OEM_TYPE_INFINITI )
      {
          #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
          if((m_poBeepAdasInstance->m_poBeepMainAppl->u8AmpConnectionState == AMP_CONNECTED))
          {

               if((VolumeDB >  -18* VOLOFFSET_RESOLUTION))
               {
                 VolumeDB = -18* VOLOFFSET_RESOLUTION;
         }
          }
          #endif
      }

  }
  (void)tUBeepName;

  if(VolumeDB< (-480) )
  {
    return -480;
  }
  else{

    return VolumeDB;
  }


  }

/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::bIsUPAConfiguredAvailable()
*******************************************************************************/

tBool ADAS_UPASound::bIsUPAConfiguredAvailable()
{
  tU8 u8UPAConfig = UPA_AUDIO_NOT_PRESENT;

  //read item from the KDS key's bytes- stream
  if((DP_S32_NO_ERR == DP_s32GetConfigItem("HMIConfig","ADASUPAAudio", &u8UPAConfig, 1)))
  {
    ETG_TRACE_USR4((" ADASUPAAudio value configured in EOL: %d",u8UPAConfig));
  }
  else
  {
    ETG_TRACE_ERR(("Error in reading EOL Parameter,returning UPA Config as NOT Present "));
  }
  if(UPA_AUDIO_NOT_PRESENT != u8UPAConfig)
    return TRUE;

  return FALSE;
}

/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::bIsSonarConfiguredAvailable()
*******************************************************************************/
tBool ADAS_UPASound::bIsSonarConfiguredAvailable()
{
  tU8 u8SonarConfig = 0; //not available if 0 , 1 if available

  //read item from the KDS key's bytes- stream
  if((DP_S32_NO_ERR == DP_s32GetConfigItem("CameraSystem","SonarSystemAvailability", &u8SonarConfig, 1)))
  {
    ETG_TRACE_USR4((" SonarSystemAvailability value configured in EOL: %d",u8SonarConfig));
  }
  else
  {
    ETG_TRACE_ERR(("Error in reading EOL Parameter,returning Sonar system availability as NOT Present "));
  }
  if(0 != u8SonarConfig)
    return TRUE;

  return FALSE;
}




/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::bIsParkAssistlevelValid()
*******************************************************************************/
tBool ADAS_UPASound::bIsParkAssistlevelValid()
{
  tU8 u8ParkAssistVol = (tU8)midw_fi_tcl_e8_ADAS_ParkAssist_Volume::FI_EN_ADAS_PA_VOL_NO_SOUND;
  dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
  odpParkAssitVol.s32GetData(u8ParkAssistVol);

  ETG_TRACE_USR4(("ADAS_UPASound::bIsParkAssistlevelValid() called ,u8ParkAssistVol :%d", u8ParkAssistVol));

  if(VOLUME_LEVEL_0 < u8ParkAssistVol)
    return TRUE;
  return FALSE;
}
/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::bIsParkAssistlevelValid()
*******************************************************************************/

tBool ADAS_UPASound::bIsUPAUserMuteActive()
{
  ETG_TRACE_USR4(("ADAS_UPASound::bIsUPAUserMuteActive() called"));
  AUD_POINTER_CHECK_CALL(m_poAudio_Function);
  return (m_poAudio_Function->bIsUPAUserMuteActive()); // if 1, usermute active
}

/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::sGetUPADiscontObstacleZoneSound(tU8 soundType)
*******************************************************************************/

std::string ADAS_UPASound::sGetUPADiscontObstacleZoneSound(tU8 soundType)
{
  ETG_TRACE_USR4(("ADAS_UPASound::sGetUPADiscontObstacleZoneSound() called,soundType = %d, m_u8ObstacleZone = %d",soundType,m_u8ObstacleZone));
  std::string sfileName;
  switch(soundType)
  {
  case BIP:
    {
    if(((Beep_Main::u8GetOEMType() == OEM_TYPE_INFINITI) || (Beep_Main::u8GetOEMType() == OEM_TYPE_NISSAN) || (Beep_Main::u8GetOEMType() == OEM_TYPE_MITSUBISHI)))
    {
      if((m_u8ObstacleZone >= EN_OBSTACLEZONE_FrontLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_FrontRight))
      sfileName = "Nissan_BIP_front_short_44100.wav";

      else if((m_u8ObstacleZone >= EN_OBSTACLEZONE_RearLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_RearRight))
        sfileName = "Nissan_BIP_rear_short_44100.wav";
    }
    else{
    if((m_u8ObstacleZone >= EN_OBSTACLEZONE_FrontLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_FrontRight))
         sfileName = "BIP_front_short_44100.wav";

    else if((m_u8ObstacleZone >= EN_OBSTACLEZONE_RearLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_RearRight))
      sfileName = "BIP_rear_short_44100.wav";
      }
    }
    break;

  case CORDE:
    {
      if((m_u8ObstacleZone >= EN_OBSTACLEZONE_FrontLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_FrontRight))
        sfileName = "CORDE_front_short_44100.wav";

      else if((m_u8ObstacleZone >= EN_OBSTACLEZONE_RearLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_RearRight))
        sfileName = "CORDE_rear_short_44100.wav";
    }
    break;
  case SONAR:
    {
      if((m_u8ObstacleZone >= EN_OBSTACLEZONE_FrontLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_FrontRight))
        sfileName = "SONAR_front_short_44100.wav";

      else if((m_u8ObstacleZone >= EN_OBSTACLEZONE_RearLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_RearRight))
        sfileName = "SONAR_rear_short_44100.wav";
      break;
    }
  default:
    ETG_TRACE_ERR(("Sound Collection is out of Range and No valid sound file is found"));
    break;
  }
  return sfileName;
}
/*******************************************************************************
*
* FUNCTION: ADAS_UPASound::sGetUPAContObstacleZoneSound(tU8 soundType)
*******************************************************************************/


std::string ADAS_UPASound::sGetUPAContObstacleZoneSound(tU8 soundType)
{
  ETG_TRACE_USR4(("ADAS_UPASound::sGetUPAContObstacleZoneSound() called,soundType = %d,m_u8ObstacleZone = %d",soundType,m_u8ObstacleZone));
  std::string sfileName;
  switch(soundType)
  {
  case BIP:
    {
    if(((Beep_Main::u8GetOEMType() == OEM_TYPE_INFINITI) || (Beep_Main::u8GetOEMType() == OEM_TYPE_NISSAN) || (Beep_Main::u8GetOEMType() == OEM_TYPE_MITSUBISHI)))
    {
      if((m_u8ObstacleZone >= EN_OBSTACLEZONE_FrontLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_FrontRight))
      sfileName = "Nissan_BIP_front_long_44100.wav";

      else if((m_u8ObstacleZone >= EN_OBSTACLEZONE_RearLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_RearRight))
      sfileName = "Nissan_BIP_rear_long_44100.wav";
    }
    else{
      if((m_u8ObstacleZone >= EN_OBSTACLEZONE_FrontLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_FrontRight))
      sfileName = "BIP_front_long_44100.wav";

      else if((m_u8ObstacleZone >= EN_OBSTACLEZONE_RearLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_RearRight))
      sfileName = "BIP_rear_long_44100.wav";
    }
    }
    break;

  case CORDE:
    {
      if((m_u8ObstacleZone >= EN_OBSTACLEZONE_FrontLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_FrontRight))
        sfileName = "CORDE_front_long_44100.wav";

      else if((m_u8ObstacleZone >= EN_OBSTACLEZONE_RearLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_RearRight))
        sfileName = "CORDE_rear_long_44100.wav";
    }
    break;
  case SONAR:
    {
      if((m_u8ObstacleZone >= EN_OBSTACLEZONE_FrontLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_FrontRight))
        sfileName = "SONAR_front_long_44100.wav";

      else if((m_u8ObstacleZone >= EN_OBSTACLEZONE_RearLeft) && (m_u8ObstacleZone <= EN_OBSTACLEZONE_RearRight))
        sfileName = "SONAR_rear_long_44100.wav";
      break;
    }
  default:
    ETG_TRACE_ERR(("Sound Collection is out of Range and No valid sound file is found"))
      break;
  }
  return sfileName;
}
/*******************************************************************************
*
* FUNCTION:  ADAS_UPASound::vTriggerStopBeep()

*******************************************************************************/

tVoid ADAS_UPASound::vTriggerStopBeep(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_UPASound::vTriggerStopBeep() called : %d",tBeepName));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);

  if((u8AmpConnectionState == AMP_CONNECTED)&& m_bAdasUPAObstacleSoundStatus)
  {
    ID_SonarInfo oSonarInfo(EN_OBSTACLEZONE_NoSound);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSonarInfo);
  }
  if (bIsAdasSoundActive(tBeepName))
    m_poBeepAdasInstance->StopAdasBeep(tBeepName);
}

/*******************************************************************************
*
* FUNCTION:  ADAS_UPASound::vClearAdasSoundStatus()

*******************************************************************************/
tVoid ADAS_UPASound::vClearAdasSoundStatus(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_UPASound::vClearAdasSoundStatus() called"));
  switch(tBeepName)
  {
  case EN_AUDIO_BEEP_UPA_ERROR_SND:
    if(m_bAdasUPAErrorSoundStatus)
      m_bAdasUPAErrorSoundStatus = FALSE;
    break;
  case EN_AUDIO_BEEP_UPA_ACTIVATION_SND:
    if(m_bAdasUPAActivationSoundStatus)
      m_bAdasUPAActivationSoundStatus = FALSE;
    break;
  case EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE:
    if(m_bAdasUPAObstacleSoundStatus)
      m_bAdasUPAObstacleSoundStatus = FALSE;
    vTriggerNewObstacleZoneSound(); //to be triggered if obstacle zone exists after no_sound which stops upa
    break;
  case EN_AUDIO_BEEP_UPA_SETTING_SND:
    if (m_bAdasUPASettingSound)
    {
      m_bAdasUPASettingSound = FALSE;
      vStopUPASettingSndTimer(AUD_BEEP_TIMER_ID_ADASUPA_SETTINGSOUND); //stopping timer when Beep has to be stopped.
    }
    break;
  default:
    break;

  }
}

/*******************************************************************************
*
* FUNCTION:  ADAS_UPASound::bIsAdasSoundActive()

*******************************************************************************/

bool ADAS_UPASound::bIsAdasSoundActive(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_UPASound::bIsAdasSoundActive : %d",tBeepName));
  switch(tBeepName)
  {
  case EN_AUDIO_BEEP_UPA_ERROR_SND:
    return m_bAdasUPAErrorSoundStatus;
  case EN_AUDIO_BEEP_UPA_ACTIVATION_SND:
    return m_bAdasUPAActivationSoundStatus;
    break;
  case EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE:
    return m_bAdasUPAObstacleSoundStatus;
    break;
  case EN_AUDIO_BEEP_UPA_SETTING_SND:
    return m_bAdasUPASettingSound;
  default:
    return (m_bAdasUPAErrorSoundStatus || m_bAdasUPAActivationSoundStatus || m_bAdasUPAObstacleSoundStatus || m_bAdasUPASettingSound);
  }
  return false;
}

/*******************************************************************************
*
* FUNCTION:  ADAS_UPASound::SetAdasSoundStatus()

*******************************************************************************/

tVoid ADAS_UPASound::SetAdasSoundStatus(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_UPASound::SetAdasSoundStatus() called for Beep : %d, u8AmpConnectionState: %d ", tBeepName, u8AmpConnectionState));
  switch(tBeepName)
  {
  case EN_AUDIO_BEEP_UPA_ERROR_SND:
    m_bAdasUPAErrorSoundStatus = TRUE;
    break;
  case EN_AUDIO_BEEP_UPA_ACTIVATION_SND:
    m_bAdasUPAActivationSoundStatus = TRUE;
    break;
  case EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE:
    m_bAdasUPAObstacleSoundStatus = TRUE;
    break;
  case EN_AUDIO_BEEP_UPA_SETTING_SND:
    //starting UPA setting sound timer here, since this case will execute only when there is a UPA setting sound request
    vStartUPASettingSndTimer(AUD_BEEP_TIMER_ID_ADASUPA_SETTINGSOUND, AUD_BEEP_TIMER_ADASUPA_SETTINGSOUND_INTERVAL);
    m_bAdasUPASettingSound = TRUE;
    break;
  default:
    break;

  }

  if((u8AmpConnectionState == AMP_CONNECTED) && m_bAdasUPAObstacleSoundStatus)
  {
    ETG_TRACE_USR4(("ADAS_UPASound::obstacle sound active and amplifier connected"));
    ID_SonarInfo oSonarInfo(m_u8ObstacleZone);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSonarInfo);
  }
}
/*******************************************************************************
*
* FUNCTION:  ADAS_UPASound::vSetUPA_SystemSate()
* Description : The function is called from beep csminterface to which updates about UPA system state via CAN signal.
*
*
*******************************************************************************/


tVoid ADAS_UPASound::vSetUPA_Status_DisplayRequest(tU8 Status_DisplayRequest)
{
   ETG_TRACE_USR4(("ADAS_UPASound::vSetUPA_Status_DisplayRequest called   Status_DisplayRequest : %d ", Status_DisplayRequest));

  m_UPA_Status_DisplayRequest=Status_DisplayRequest;

  if(!(bIs_UPA_Status_DisplayRequest_state_valid()))
  {

    if(m_bAdasUPAErrorSoundStatus)
    {
      vTriggerStopBeep(EN_AUDIO_BEEP_UPA_ERROR_SND);
    }
    if(m_bAdasUPAActivationSoundStatus)
    {
      vTriggerStopBeep(EN_AUDIO_BEEP_UPA_ACTIVATION_SND);
      }
       if(m_bAdasUPAObstacleSoundStatus)
    {
      vTriggerStopBeep(EN_AUDIO_BEEP_UPA_OBSTACLE_ZONE);
    }
    if(m_bAdasUPASettingSound)
    {
      vTriggerStopBeep(EN_AUDIO_BEEP_UPA_SETTING_SND);
    }


  }
  else
  {
    vTriggerNewObstacleZoneSound();
  }


}

/*******************************************************************************
*
* FUNCTION:  ADAS_UPASound::bIs_UPA_Status_DisplayRequest_state_valid()
* Description : The function is called to check condition satisfies to play beep.
*
*
*******************************************************************************/


tBool ADAS_UPASound::bIs_UPA_Status_DisplayRequest_state_valid()
{
  bool b_UPA_Status_DisplayRequest=false;
   if((m_UPA_Status_DisplayRequest==FRONT_ACTIVATED)||(m_UPA_Status_DisplayRequest==REAR_ACTIVATED)||(m_UPA_Status_DisplayRequest==FRONT_AND_REAR_ACTIVATED)||(m_UPA_Status_DisplayRequest==MANOEUVERING_MODE))
   {
     b_UPA_Status_DisplayRequest= true;
   }

   ETG_TRACE_USR4(("ADAS_UPASound::bIs_UPA_Status_DisplayRequest_state_valid() m_UPA_Status_DisplayRequest : %d  and hence returning  : %d ", m_UPA_Status_DisplayRequest,b_UPA_Status_DisplayRequest));
  return b_UPA_Status_DisplayRequest;
}

/*******************************************************************************
*
* FUNCTION:  ADAS_UPASound::GetUPAEOLLevelOffset( tS16& ts16UPAEOLLevelOffset)
* Description : The function is for read EOL  Volume offset from KDS
*
*
*******************************************************************************/

tVoid ADAS_UPASound::GetUPAEOLLevelOffset( tS16& ts16UPAEOLLevelOffset)
 {
  tU8 u8UPAEOLLevelOffset=0;

    if((DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig","ParkingAidsUPAGain", &u8UPAEOLLevelOffset, 1)))
    {
      ETG_TRACE_USR4((" ADAS_UPA_EOL Offset level: %d",u8UPAEOLLevelOffset));

    }
    else
    {
      ETG_TRACE_ERR(("Error in reading EOL Parameter"));
    return;
    }
    //ParkingAidsUPAGain is a 5-bit value in CANoe MSB bits of Byte6, so converting it to 8-bit value and shifting it by 3 bits to check if 5th bit is set or not for sign
    if ((u8UPAEOLLevelOffset << 3) & (0x80))
    {
      ts16UPAEOLLevelOffset = tS16(((tS16)u8UPAEOLLevelOffset + 0xFFE0) * (tS16)VOLOFFSET_RESOLUTION);
    }
    else
      ts16UPAEOLLevelOffset =tS16 ((tS16)(u8UPAEOLLevelOffset)* (tS16)VOLOFFSET_RESOLUTION);

    ETG_TRACE_USR4(("Getu8UPAEOLLevelOffset   ADAS_UPA EOL offset : %x", ts16UPAEOLLevelOffset));



 }




