/*******************************************************************************
*
* FILE:          ADAS_SRSound.h
*
* SW-COMPONENT:  Beep Adas application
*
* PROJECT:
*
* DESCRIPTION:   ADAS HFP Sound Class.
*
* AUTHOR:       pmh7kor
*
* COPYRIGHT:    (c) 2016 RBEI, Bangalore
*
*******************************************************************************/

#ifndef _ADAS_SR_H_
#define _ADAS_SR_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "../ExternItf/CCA/aud_CCAMsg.h"
#include "AdasNotification_IF.h"
#include "MessageConfig.h"
#include "InternalCommunicationAdapter.h"
#include "Beep_Adas.h"
#include "config/dp/AudioUserDpIfSelect.h"

class ADAS_SRSound : public IF_MessageObserver<PO_MessageConfig::enID>, public AdasNotification_IF
{
public:
  ADAS_SRSound(void);
  ADAS_SRSound(Beep_Adas* poAdasInstance);
  virtual ~ADAS_SRSound();

  virtual std::string GetBeepFilePath(tU8 tUBeepName);
  virtual tS16 GetBeepVolume(tU8 tUBeepName);
  virtual tS16 GetBeepVolume_withoutCANAttenuation(tU8 tUBeepName=0);
  virtual tVoid GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff  *VolOffsets);
  //virtual tU8 GetBeepSource(tU8 tUBeepName);
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);

  void vSetandTriggerAutoSRSound(tU8 tSRSound);
  void vSetandTriggerCustomerSRSound(tU8 tSRSound);

  tVoid vTriggerStopBeep(tU8 tBeepName=0);
  virtual bool bIsAdasSoundActive(tU8 tBeepName=0);
  virtual tVoid SetAdasSoundStatus(tU8 tBeepName);
  tVoid vClearAdasSoundStatus(tU8 tBeepName);
  virtual tU16 GetRecurrencePeriod(tU8 tBeepName);
  tVoid vResetSRData();
private:
  Beep_Adas* m_poBeepAdasInstance;
  AudioUserDpIf*    pAudUsrDpIf;

  fc_audiomanager_tclService_Audio_Function *m_poAudio_Function;
  bool m_bSRAutoSoundStatus;
  bool m_bSRUserSoundStatus;
  //std::string sGetUPAActivationFile(tU8 soundType);

  tBool bIsSRConfiguredAvailable();
  tBool bIsParkAssistlevelValid();
  tBool bIsSRSoundNotificationActive();


};


#endif
