/*******************************************************************************
*
* FILE:          ADAS_SRSound.h
*
* SW-COMPONENT:  Beep Adas application
*
* PROJECT:
*
* DESCRIPTION:   Beep Adas Class.
*
* AUTHOR:       pmh7kor
*
* COPYRIGHT:    (c) 2016 RBEI, Bangalore
*
*******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_BEEP
#include "trcGenProj/Header/ADAS_SRSound.cpp.trc.h"
#endif
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#include "../fc_audiomanager_service_Audio_Function.h"
#include "ADAS_SRSound.h"
#include "Beep_defines.h"
#include "../fc_audiomanager_trace.h"
#include "../InternalComponentCommunication/Messages/Beep/IDCCAStartADASBeep.h"
#include "../InternalComponentCommunication/Messages/Diag/IDDiagDefSet.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/DiagDefSetType.h"
#include "../InternalComponentCommunication/Messages/settings/IDSettings.h"

#include "../aud_sinkmanager/vd_adr3/vd_adr3Msg_If.h"

#include "../../InternalComponentCommunication/DataTypes/TypeDefines/ADR3Settings.h"

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
ADAS_SRSound::ADAS_SRSound(void) : IF_MessageObserver<PO_MessageConfig::enID>("ADAS_SRSound Constructor")
{
  ETG_TRACE_USR2(("ADAS_SRSound::ADAS_SRSound() constructor called"));
  m_poBeepAdasInstance = NULL;
  m_poAudio_Function = NULL;
  pAudUsrDpIf   =NULL;
  vResetSRData();
}
/*******************************************************************************
*
* FUNCTION: ADAS_SRSound::ADAS_SRSound()
*
* DESCRIPTION: Constructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
ADAS_SRSound::ADAS_SRSound(Beep_Adas* poAdasInstance) : IF_MessageObserver<PO_MessageConfig::enID>("ADAS_SRSound Constructor")
{
  ETG_TRACE_USR2(("ADAS_SRSound::ADAS_SRSound(Beep_Adas*) constructor called"));
  m_poBeepAdasInstance = poAdasInstance;
  m_poAudio_Function = poAdasInstance->m_poAudio_Function;
  pAudUsrDpIf   = AudioUserDpIfSelect::pGetAudUsrDpIf();
  vResetSRData();
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAStart_ADASBeep);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagDefSet);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_Settings);
}
/*******************************************************************************
*
* FUNCTION: ADAS_SRSound::~ADAS_SRSound()
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
ADAS_SRSound::~ADAS_SRSound()
{
  ETG_TRACE_USR4(("~ADAS_SRSound() entered."));
  m_poBeepAdasInstance = NULL;
  m_poAudio_Function = NULL;
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
}



/*******************************************************************************
*
* FUNCTION: ADAS_SRSound::vResetSRData()
* Resets the flags to defaults
*******************************************************************************/
tVoid ADAS_SRSound::vResetSRData()
{
  ETG_TRACE_USR4(("vResetSRData"));
    m_bSRAutoSoundStatus = false;
  m_bSRUserSoundStatus = false;
}
/*******************************************************************************
*
* FUNCTION: ADAS_SRSound::GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff *VolOffsets)
*
* DESCRIPTION: Interface function to get volume offsets for Beep
*
* PARAMETER: tU8 tUBeepName
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid ADAS_SRSound::GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff *VolOffsets)
{
  ETG_TRACE_USR4(("ADAS_SRSound::GetBeepVolumeOffsets()  BeepName:%d", tUBeepName));

  VolOffsets->LF = 0;
  VolOffsets->RF = 0;
  VolOffsets->LR = CHANNEL_MUTE;
  VolOffsets->RR = CHANNEL_MUTE;
  VolOffsets->RampLin = 0x08;   //Very Fast Mute for UPA beeps, need to be checked
  VolOffsets->RampDB = 0x320; //Very Fast Mute for UPA beeps, need to be checked


  VolOffsets->CE = CHANNEL_MUTE;
  VolOffsets->SUB = CHANNEL_MUTE;
}

/*******************************************************************************
*
* FUNCTION: ADAS_SRSound::vSetandTriggerAutoSRSound(tU8 tUPAErrorSound)
*******************************************************************************/

void ADAS_SRSound::vSetandTriggerAutoSRSound(tU8 tSRSound)
{
  tBool Ret = (bIsSRConfiguredAvailable() && bIsParkAssistlevelValid() && bIsSRSoundNotificationActive());
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  if (Ret)
  {
    ETG_TRACE_USR4(("ADAS_SRSound::vSetandTriggerAutoSRSound() called "));
    if ((tSRSound == AUTO_RECORD_IN_PROGRESS) || (tSRSound == AUTO_RECORD_END))
      m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_AUTOMATIC_SR,/*_poThisInterface*/this);
  }
  else
    ETG_TRACE_USR4(("ADAS_SRSound:: Cannot trigger Automatice SR Sound"));
}
/*******************************************************************************
*
* FUNCTION: ADAS_SRSound::vSetandTriggerAutoSRSound(tU8 tUPAErrorSound)
*******************************************************************************/
void ADAS_SRSound::vSetandTriggerCustomerSRSound(tU8 tSRSound)
{

  tBool Ret = (bIsSRConfiguredAvailable() && bIsParkAssistlevelValid());
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  if (Ret)
  {
    ETG_TRACE_USR4(("ADAS_SRSound::vSetandTriggerCustomerSRSound() called "));
    if ((tSRSound == CUST_RECORD_IN_PROGRESS) || (tSRSound == CUST_RECORD_STOPPED) || (tSRSound == CUST_RECORD_END))
      m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_USER_SR_PHASE1,/*_poThisInterface*/this);
  }
  else
    ETG_TRACE_USR4(("ADAS_SRSound:: Cannot trigger customer SR Sound"));
}

/*******************************************************************************
*
* FUNCTION: ADAS_SRSound::GetRecurrencePeriod()
*******************************************************************************/
tU16 ADAS_SRSound::GetRecurrencePeriod(tU8 /*tBeepName*/)
{
  return RECURRENCE_PERIOD_MAX; // will not be used for HFP
}

/*******************************************************************************
*
* FUNCTION:  ADAS_SRSound::GetBeepFilePath(tU8 tUBeepName)

*******************************************************************************/
std::string ADAS_SRSound::GetBeepFilePath(tU8 /*tUBeepName*/)
{
  //HFP is an ADR Beep, so no Beep file for it
  return std::string();
}

/*******************************************************************************
*
* FUNCTION:  ADAS_SRSound::GetBeepVolume(tU8 tUBeepName)

*******************************************************************************/

tS16 ADAS_SRSound::GetBeepVolume(tU8 /*tUBeepName*/)
{
  //tS16 VolumeDB;
  //ETG_TRACE_USR4(("ADAS_SRSound::GetBeepVolume"));
  //AUD_POINTER_CHECK_CALL(m_poBeepAdasInstance);

  //tS16 s16SRObsoluteLevelOffset = -23 * VOLOFFSET_RESOLUTION; //base offset level
  //tU8 u8SREOLLevelOffset = 0; //EOL Offset Level

  //if ((DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig", "ParkingAidsPSMGain", &u8SREOLLevelOffset, 1))) // to be checked since no SR gain configuration available in soundvolumeconfig
  //{
  //  ETG_TRACE_USR4((" ADAS_SR_EOL Offset level: %d", u8SREOLLevelOffset));
  //}
  //else
  //{
  //  ETG_TRACE_ERR(("Error in reading EOL Parameter"));
  //}
  //tS16 ts16SREOLLevelOffset = (tS16)(u8SREOLLevelOffset)* (tS16)VOLOFFSET_RESOLUTION;

  ////Park assist Volume Offset

  //tU8 u8ParkAssistVol = 0;
  //dp_tclAudioManagerDPAdas_ParkAssitVol odpParkAssitVol;
  //odpParkAssitVol.s32GetData(u8ParkAssistVol);

  //tS16 s16ParkAssistVolumeLevelOffset = m_poBeepAdasInstance->s16GetAdasVolumeOffset(u8ParkAssistVol);

  //VolumeDB = (ts16SREOLLevelOffset + s16SRObsoluteLevelOffset + s16ParkAssistVolumeLevelOffset);

  return (-50*4); // for SR sound to be of 150mv as per the update from Karsten
};
/*******************************************************************************
*
* FUNCTION:  ADAS_SRSound::GetBeepVolume_withoutCANAttenuation(tU8 tUBeepName)

*******************************************************************************/

tS16 ADAS_SRSound::GetBeepVolume_withoutCANAttenuation(tU8 tUBeepName)
{
  (void)tUBeepName;
  return (-50*4);

}
/*******************************************************************************
*
* FUNCTION: ADAS_SRSound::bIsHFPConfiguredAvailable()
*******************************************************************************/

tBool ADAS_SRSound::bIsSRConfiguredAvailable()
{
  tU8 u8SRConfig = SR_NOT_PRESENT;

  //read item from the KDS key's bytes- stream
  if ((DP_S32_NO_ERR == DP_s32GetConfigItem("HMIConfig", "ADASSR", &u8SRConfig, 1)))
  {
    ETG_TRACE_USR4((" ADASSR value configured in EOL: %d", u8SRConfig));
  }
  else
  {
    ETG_TRACE_ERR(("Error in reading EOL Parameter,returning SR Config as NOT Present "));
  }

  if (SR_NOT_PRESENT != u8SRConfig)
    return TRUE;

  return FALSE;
}


/*******************************************************************************
*
* FUNCTION: ADAS_SRSound::bIsParkAssistlevelValid()
*******************************************************************************/
tBool ADAS_SRSound::bIsParkAssistlevelValid()
{
  tU8 u8ParkAssistVol = 0;
  dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
  odpParkAssitVol.s32GetData(u8ParkAssistVol);

  ETG_TRACE_USR4(("ADAS_SRSound::bIsParkAssistlevelValid() called ,u8ParkAssistVol :%d", u8ParkAssistVol));

  if (VOLUME_LEVEL_0 < u8ParkAssistVol)
    return TRUE;
  return FALSE;
}


/*******************************************************************************
*
* FUNCTION: ADAS_SRSound::bIsSRSoundMuted()
*******************************************************************************/
tBool ADAS_SRSound::bIsSRSoundNotificationActive()
{
  tBool u8SRSound = FALSE;
  tS32 s32Res = 0;
  s32Res =  pAudUsrDpIf->s32GetSRSoundState(u8SRSound);
  ETG_TRACE_USR4(("s32Res : %d",s32Res));

  ETG_TRACE_USR4(("ADAS_SRSound::bIsSRSoundNotificationActive() called ,u8SRSound :%d", u8SRSound));

  if (u8SRSound == TRUE)
    return TRUE;
  return FALSE;
}


/*******************************************************************************
*
* FUNCTION:  ADAS_SRSound::vTriggerStopBeep()

*******************************************************************************/


tVoid ADAS_SRSound::vTriggerStopBeep(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_SRSound::vTriggerStopBeep() called : %d",tBeepName));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  if (bIsAdasSoundActive(tBeepName))
    m_poBeepAdasInstance->StopAdasBeep(tBeepName);
}

/*******************************************************************************
*
* FUNCTION:  ADAS_SRSound::vClearAdasSoundStatus()

*******************************************************************************/
tVoid ADAS_SRSound::vClearAdasSoundStatus(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_SRSound::vClearAdasSoundStatus() called"));
  if(tBeepName == EN_AUDIO_BEEP_AUTOMATIC_SR)
    m_bSRAutoSoundStatus = false;
  else if(tBeepName ==  EN_AUDIO_BEEP_USER_SR_PHASE1)
    m_bSRUserSoundStatus = false;
  else
  {}
}

/*******************************************************************************
*
* FUNCTION:  ADAS_SRSound::bIsAdasSoundActive()

*******************************************************************************/

bool ADAS_SRSound::bIsAdasSoundActive(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_SRSound::bIsAdasSoundActive(),tBeepName :%d",tBeepName));
    return ((tBeepName == EN_AUDIO_BEEP_USER_SR_PHASE1)?m_bSRUserSoundStatus:((tBeepName == EN_AUDIO_BEEP_AUTOMATIC_SR)?m_bSRAutoSoundStatus:(m_bSRUserSoundStatus||m_bSRAutoSoundStatus)));
}

/*******************************************************************************
*
* FUNCTION:  ADAS_SRSound::SetAdasSoundStatus()

*******************************************************************************/
void ADAS_SRSound::SetAdasSoundStatus(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_SRSound::SetAdasSoundStatus() called : tBeepName :%d",tBeepName));
  if(tBeepName ==  EN_AUDIO_BEEP_USER_SR_PHASE1)
    m_bSRUserSoundStatus = true;
  else if(tBeepName ==  EN_AUDIO_BEEP_AUTOMATIC_SR)
    m_bSRAutoSoundStatus = true;
  else
  {}
}


/*******************************************************************************
*
* FUNCTION: ADAS_SRSound::MessageNotification(PO_MessageConfig::enID MsgId)
*******************************************************************************/
// This function is called by post office on new incoming messages.
void ADAS_SRSound::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR2(("ADAS_SRSound::MessageNotification() called MsgId = %d", MsgId));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance->m_poBeepController);
  switch (MsgId)
  {
  case (PO_MessageConfig::ID_CCAStart_ADASBeep) :
  {
    ETG_TRACE_USR2(("ID_CCAStart_ADASBeep received "));
    const ID_CCAStart_ADASBeep* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_CCAStart_ADASBeep>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);

    if (pMsg->m_u8BeepType == EN_AUDIO_BEEP_AUTOMATIC_SR)
      vSetandTriggerAutoSRSound(AUTO_RECORD_IN_PROGRESS);
    else if(pMsg->m_u8BeepType == EN_AUDIO_BEEP_USER_SR_PHASE1)
      vSetandTriggerCustomerSRSound(CUST_RECORD_IN_PROGRESS);
    else{}
      //m_poBeepAdasInstance->setAdasBeep(pMsg->m_u8BeepType, this);
    break;
  }
  case PO_MessageConfig::ID_DiagDefSet:
  {
    // Obtaining the Diag DefSet
    const ID_DiagDefSet* pMsgDefSet = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_DiagDefSet>(MsgId);
    ETG_TRACE_USR4(("DefSet received Type = %x, Phase =%x", pMsgDefSet->enDiagDefSetType, pMsgDefSet->enDiagDefSetPhase));
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsgDefSet);
    tenDiagDefSetType enDefSetType = pMsgDefSet->enDiagDefSetType;
    tenDiagDefSetPhase enDefSetPhase = pMsgDefSet->enDiagDefSetPhase;
    if (((enDefSetType == EN_DEFSET_HMI) || (enDefSetType == EN_DEFSET_TEF)) && (enDefSetPhase == EN_DEFSET_FINISH))
    {
      if (!bIsSRConfiguredAvailable())
        vTriggerStopBeep();
    }
    break;
  }

  case PO_MessageConfig::ID_Settings:
  {   const MSG_Settings*     pMsg =  InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<MSG_Settings>(MsgId);

      if(pMsg->enSettingType==EN_AUDIO_SETTINGS_SR_SOUNDACTIVATION_STATE)
      {
      ETG_TRACE_USR4(("ID_Settings for SR_SOUNDACTIVATION_STATE  received : %d", pMsg->s16Steps));
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pAudUsrDpIf);
      tS32 s32Res;
      s32Res= tS32(pAudUsrDpIf->s32SetSRSoundState( tU8(pMsg->s16Steps)));
      ETG_TRACE_USR4(("s32Res : %d",s32Res));
      }
  }
  default:
    break;
  }
}
