/*******************************************************************************
 *
 * FILE:          ADAS_RCTASound.h
 *
 * SW-COMPONENT:  Beep Adas application
 *
 * PROJECT:
 *
 * DESCRIPTION:   ADAS RCTA Sound Class.
 *
 * AUTHOR:       ahd9kor
 *
 * COPYRIGHT:    (c) 2018 RBEI, Bangalore
 *
 *******************************************************************************/
#ifndef _ADAS_RCTA_H_
#define _ADAS_RCTA_H_
#include "../ExternItf/CCA/aud_CCAMsg.h"
#include "AdasNotification_IF.h"
#include "MessageConfig.h"
#include "InternalCommunicationAdapter.h"
#include "Beep_Adas.h"
#include "../../LoopBack/aud_loopback_if.h"
#include "../fc_audiomanager_service_Audio_Function.h"

#define NOTDEFINED 0xFF
#define AMPLIFIER_CONNECTED 0x01

class ADAS_RCTASound :public IF_MessageObserver<PO_MessageConfig::enID>, public AdasNotification_IF
{

public:
  ADAS_RCTASound();
  ADAS_RCTASound(Beep_Adas* poAdasInstance);



  void vSetCTA_AlertStatus(tU8 RCTA_AlertState);
  void vSetCTA_CollisionRiskAlert(tU8 RCTA_AlertState);
  void vTriggerRCTASound();
  bool bIsRCTAConfigureAvailable();
  virtual std::string GetBeepFilePath(tU8 tUBeepName);
  virtual tS16 GetBeepVolume(tU8 tUBeepName);
  virtual tS16 GetBeepVolume_withoutCANAttenuation(tU8 tUBeepName=0);
  virtual tVoid GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff  *VolOffsets);
  virtual bool bIsAdasSoundActive(tU8 tBeepName=0);
  virtual tVoid vClearAdasSoundStatus(tU8 tBeepName);
  virtual tVoid SetAdasSoundStatus(tU8 tBeepName);
  virtual tU16 GetRecurrencePeriod(tU8 tBeepName);
  virtual void MessageNotification(PO_MessageConfig::enID MsgId) ;
  void vTriggerStopBeep(tU8 tBeepName=0);
  void vResetRCTAData();


  ~ADAS_RCTASound();


private:
  fc_audiomanager_tclService_Audio_Function *m_poAudio_Function;
  Beep_Adas* m_poBeepAdasInstance;
  tU8 m_RCTA_AlertState;
  tU8 m_vSetCTA_CollisionRiskAlert;
  bool m_RCTASoundStatus;
  bool m_bCANAttenuationStatus;
  AudioUserDpIf*    pAudUsrDpIf;
};

#endif
