/*******************************************************************************
 *
 * FILE:          ADAS_RCTASound.cpp
 *
 * SW-COMPONENT:  Beep Adas application
 *
 * PROJECT:
 *
 * DESCRIPTION:   ADAS RCTA Sound Class.
 *
 * AUTHOR:       ahd9kor
 *
 * COPYRIGHT:    (c) 2018 RBEI, Bangalore
 *
 *******************************************************************************/


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

//Po Message include
#include "InternalComponentCommunication/Messages/Beep/ID_NotifyParkAssistVolume.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CANAttenuation.h"
#include "InternalComponentCommunication/Messages/Beep/IDCCAUPATempMute.h"
#include "InternalComponentCommunication/Messages/Diag/IDDiagDefSet.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/DiagDefSetType.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_BEEP
#include "trcGenProj/Header/ADAS_RCTASound.cpp.trc.h"
#endif
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

//#include "../fc_audiomanager_service_Audio_Function.h"
#include "ADAS_RCTASound.h"
#include "Beep_defines.h"


#define NOTDEFINED 0xFF
#define AMPLIFIER_CONNECTED 0x01

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/


/*******************************************************************************
*
* FUNCTION: ADAS_RCTASound::ADAS_RCTASound()
*
* DESCRIPTION: Constructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
ADAS_RCTASound::ADAS_RCTASound() :IF_MessageObserver<PO_MessageConfig::enID>("ADAS_RCTASound Constructor")
{

  m_poBeepAdasInstance = NULL;
  m_RCTA_AlertState = NO_ALERT;
  m_vSetCTA_CollisionRiskAlert = NOTDEFINED;
  m_RCTASoundStatus = false;
  m_bCANAttenuationStatus = false;
  pAudUsrDpIf = NULL;
  m_poAudio_Function = NULL;
}
/*******************************************************************************
*
* FUNCTION: ADAS_RCTASound::ADAS_RCTASound()
*
* DESCRIPTION: Constructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/

ADAS_RCTASound::ADAS_RCTASound(Beep_Adas* poAdasInstance) :IF_MessageObserver<PO_MessageConfig::enID>("ADAS_RCTASound Constructor")
{

  m_RCTA_AlertState=NO_ALERT;
  m_vSetCTA_CollisionRiskAlert=NOTDEFINED;
  m_RCTASoundStatus=false;
  m_bCANAttenuationStatus=false;
  pAudUsrDpIf   = AudioUserDpIfSelect::pGetAudUsrDpIf();
  m_poAudio_Function = NULL;
  m_poBeepAdasInstance = NULL;
 if(poAdasInstance)
  {
      m_poBeepAdasInstance=poAdasInstance;
      m_poAudio_Function = poAdasInstance->m_poAudio_Function;
  }
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance());
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance()->POMessages);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyParkAssistVolume);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_CANAttenuation);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagDefSet);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::IDCCAUPATempMute);
}
ADAS_RCTASound::~ADAS_RCTASound()
{
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance());
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance()->POMessages);
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  m_poBeepAdasInstance=NULL;
  pAudUsrDpIf=NULL;

}

/*******************************************************************************
*
* FUNCTION: ADAS_RCTASound::MessageNotification(PO_MessageConfig::enID MsgId)
*******************************************************************************/
void ADAS_RCTASound::MessageNotification(PO_MessageConfig::enID MsgId)
{

  ETG_TRACE_USR2(("ADAS_RCTASound::MessageNotification() called MsgId = %d",MsgId));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance->m_poBeepController);
  switch(MsgId)
  {
  case (PO_MessageConfig::ID_NotifyParkAssistVolume) :
      {
    const ID_NotifyParkAssistVolume* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_NotifyParkAssistVolume>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
    ETG_TRACE_USR2(("ID_NotifyParkAssistVolume received : %d", pMsg->m_volume));
    if(pMsg->m_volume == VOLUME_LEVEL_0 )
    {
      if(m_RCTASoundStatus)
      { m_poBeepAdasInstance->StopAdasBeep(EN_AUDIO_BEEP_RCTA_SND);
      }
      break;
    }

    if(m_RCTASoundStatus==0)
    {
      ETG_TRACE_USR2(("Check:: No beeps playing  , Check and trigger rcta since" ));
      vTriggerRCTASound();
    }

    break;
      }
  case (PO_MessageConfig::ID_CANAttenuation):
    {
    const ID_CANAttenuation* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_CANAttenuation>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
    ETG_TRACE_USR2(("ID_CANAttenuation received: %d", pMsg->m_bAttenuationCommand));
    m_bCANAttenuationStatus = pMsg->m_bAttenuationCommand;
    if(bIsAdasSoundActive(EN_AUDIO_BEEP_RCTA_SND))
      m_poBeepAdasInstance->m_poBeepController->UpdateBeepVolume();
    break;
    }

case PO_MessageConfig::ID_DiagDefSet:
  {
    // Obtaining the Diag DefSet
    const ID_DiagDefSet* pMsgDefSet = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_DiagDefSet>(MsgId);
    ETG_TRACE_USR4(("DefSet received Type = %x, Phase =%x", pMsgDefSet->enDiagDefSetType, pMsgDefSet->enDiagDefSetPhase));
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsgDefSet);
    tenDiagDefSetType enDefSetType = pMsgDefSet->enDiagDefSetType;
    tenDiagDefSetPhase enDefSetPhase = pMsgDefSet->enDiagDefSetPhase;
    if (((enDefSetType == EN_DEFSET_HMI) || (enDefSetType == EN_DEFSET_TEF)) && (enDefSetPhase == EN_DEFSET_FINISH))
    {
      if(!bIsRCTAConfigureAvailable())
        {

        if (bIsAdasSoundActive(EN_AUDIO_BEEP_RCTA_SND))
          m_poBeepAdasInstance->StopAdasBeep(EN_AUDIO_BEEP_RCTA_SND);
      }
    }
    break;
  }

case (PO_MessageConfig::IDCCAUPATempMute):
  {
    const IDCCAUPATempMute* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<IDCCAUPATempMute>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poAudio_Function);
    ETG_TRACE_USR2(("IDCCAUPATempMute received : %d", pMsg->m_UPATempMute));
    if(m_RCTASoundStatus)
    {
      if(pMsg->m_UPATempMute)
      {
        m_poBeepAdasInstance->StopAdasBeep(EN_AUDIO_BEEP_RCTA_SND);
      }
      else
      {
        if(m_poAudio_Function->bIsHFPActive())
                  {
                    ETG_TRACE_USR2(("ADAS_RCTASound received : %d and HFP is ACTIVE ",m_RCTASoundStatus));
                     vTriggerRCTASound();
                  }
      }
    }
    else // if running beep is stopped by user mute and if obstacle still exists, then trigger new beep
    {
      vTriggerRCTASound();
    }

    break;
  }



default: break;
    }
}

/*******************************************************************************
*
* FUNCTION:  ADAS_RCTASound::vSetCTA_AlertStatus(tU8 RCTA_AlertState)
*******************************************************************************/
void ADAS_RCTASound::vSetCTA_AlertStatus(tU8 RCTA_AlertState)
{
  ETG_TRACE_USR4(("ADAS_RCTASound::vSetCTA_AlertStatus() called : %d ",RCTA_AlertState));
    m_RCTA_AlertState=RCTA_AlertState;
   if(m_RCTASoundStatus)
     {
     m_poBeepAdasInstance->m_poBeepController->SetBeepLocation();
     }
   else
   {
     vTriggerRCTASound();
   }
}
void ADAS_RCTASound::vSetCTA_CollisionRiskAlert(tU8 RCTA_CollisionRiskAlert)
{
  ETG_TRACE_USR4(("ADAS_RCTASound::vSetCTA_CollisionRiskAlert() called : %d ",RCTA_CollisionRiskAlert));
  m_vSetCTA_CollisionRiskAlert=RCTA_CollisionRiskAlert;
  vTriggerRCTASound();

}



/*******************************************************************************
*
* FUNCTION:  ADAS_RCTASound::vTriggerRCTASound()
*******************************************************************************/

void ADAS_RCTASound::vTriggerRCTASound()
{
  ETG_TRACE_USR4(("ADAS_RCTASound::vTriggerRCTASound() called"));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  tU8 ParkAssitVol=0;
  tS32 s32Res = 0;
  dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
  s32Res =odpParkAssitVol.s32GetData(ParkAssitVol);
  ETG_TRACE_USR4(("Persistent Memory storage Result for park assist volume = %x", s32Res));
  ETG_TRACE_USR4(("park assist volume = %d",ParkAssitVol));
  if((m_RCTA_AlertState!=NO_ALERT) && (m_vSetCTA_CollisionRiskAlert==HIGH_COLLISION_RISK) && bIsRCTAConfigureAvailable() && ( ParkAssitVol > VOLUME_LEVEL_0))
  {
    ETG_TRACE_USR4(("ADAS_UPASound::bSetandTriggerAdasActivationSound() called"));
    m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_RCTA_SND,/*_poThisInterface*/this);
  }else
  {
    m_poBeepAdasInstance->StopAdasBeep(EN_AUDIO_BEEP_RCTA_SND);
  }

}

/*******************************************************************************
*
* FUNCTION:  ADAS_RCTASound::GetBeepFilePath(tU8 tUBeepName)
*******************************************************************************/


std::string  ADAS_RCTASound::GetBeepFilePath(tU8 /*tUBeepName*/)
{
   tU8 soundType = 0;
   tS32 s32Res = 0;
   s32Res =  pAudUsrDpIf->s32GetUPASoundtype(soundType);
   ETG_TRACE_USR4(("s32Res : %d",s32Res));
   std::string sfileName;
   switch(soundType)
  {
  case BIP:
    sfileName = "BIP_front_long_44100.wav";
    break;
  case CORDE:
    sfileName = "CORDE_front_long_44100.wav";
    break;
  case SONAR:
    sfileName = "SONAR_front_long_44100.wav";
    break;
  default:
    ETG_TRACE_ERR(("Sound Collection is out of Range and No valid sound file is found"));
    break;
  }
  return sfileName;
}


/*******************************************************************************
*
* FUNCTION:  ADAS_RCTASound::GetBeepVolume(tU8 tUBeepName)
*******************************************************************************/

tS16 ADAS_RCTASound::GetBeepVolume(tU8 /*tUBeepName*/)
{
    tS16 VolumeDB;
    ETG_TRACE_USR4(("ADAS_UPASound::GetBeepVolume"));
    AUD_POINTER_CHECK_CALL(m_poBeepAdasInstance);
    if(m_bCANAttenuationStatus == TRUE)
    {
      //sending the cluster sound value by which beep has to be played
      VolumeDB = (tS16) (VOLOFFSET_RESOLUTION * m_poBeepAdasInstance->s16GetDBValue(m_poBeepAdasInstance->GetClusterSoundLvlForAttenuation()));
    }
    else
    {
      VolumeDB=GetBeepVolume_withoutCANAttenuation();

    }
    return VolumeDB;
}
/*******************************************************************************
*
* FUNCTION:  ADAS_RCTASound::GetBeepVolume(tU8 tUBeepName)
*******************************************************************************/
//Funtion used to return volume with out Cluster attenuation , when CAN attenuation is active
tS16 ADAS_RCTASound::GetBeepVolume_withoutCANAttenuation(tU8 /*tUBeepName*/)
{
    tS16 VolumeDB;
    ETG_TRACE_USR4(("ADAS_UPASound::GetBeepVolume"));
    AUD_POINTER_CHECK_CALL(m_poBeepAdasInstance);
    tS16 ts16UPAEOLLevelOffset;

        tS16 s16UPAObsoluteLevelOffset = -23 * VOLOFFSET_RESOLUTION; //base offset level
        tS32 OEM_type= m_poBeepAdasInstance->m_poBeepMainAppl->u8GetOEMType();

        if(OEM_type == OEM_TYPE_NISSAN || OEM_type == OEM_TYPE_INFINITI )
        {
            #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
            if((m_poBeepAdasInstance->m_poBeepMainAppl->u8AmpConnectionState == AMPLIFIER_CONNECTED))
            {
                 s16UPAObsoluteLevelOffset = -18 * VOLOFFSET_RESOLUTION; //base offset level
            }
            #endif
        }

      tU8 u8UPAEOLLevelOffset = 0; //EOL Offset Level

      if((DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig","ParkingAidsUPAGain", &u8UPAEOLLevelOffset, 1)))
      {
        ETG_TRACE_USR4((" ADAS_UPA_EOL Offset level: %d",u8UPAEOLLevelOffset));
      }
      else
      {
        ETG_TRACE_ERR(("Error in reading EOL Parameter"));
      }

      //ParkingAidsUPAGain is a 5-bit value in CANoe MSB bits of Byte6, so converting it to 8-bit value and shifting it by 3 bits to check if 5th bit is set or not for sign
      if ((u8UPAEOLLevelOffset << 3) & (0x80))
      {
        ts16UPAEOLLevelOffset = tS16(((tS16)u8UPAEOLLevelOffset + 0xFFE0) * (tS16)VOLOFFSET_RESOLUTION);
      }
      else
        ts16UPAEOLLevelOffset = tS16((tS16)(u8UPAEOLLevelOffset)* (tS16)VOLOFFSET_RESOLUTION);

      ETG_TRACE_USR4((" ADAS_UPA EOL offset : %x", ts16UPAEOLLevelOffset));

      //Park assist Volume Offset

      tU8 u8ParkAssistVol = 0;
      dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
      odpParkAssitVol.s32GetData(u8ParkAssistVol);

      tS16 s16ParkAssistVolumeLevelOffset = m_poBeepAdasInstance->s16GetAdasVolumeOffset(u8ParkAssistVol);

      VolumeDB = tS16(ts16UPAEOLLevelOffset + s16UPAObsoluteLevelOffset + s16ParkAssistVolumeLevelOffset);

     if(OEM_type == OEM_TYPE_NISSAN || OEM_type == OEM_TYPE_INFINITI )
        {
            #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
            if((m_poBeepAdasInstance->m_poBeepMainAppl->u8AmpConnectionState == AMPLIFIER_CONNECTED))
            {

                 if((VolumeDB >  -18* VOLOFFSET_RESOLUTION))
                 {
                   VolumeDB = -18* VOLOFFSET_RESOLUTION;
                 }
            }
            #endif
        }


    return VolumeDB;
}

/*******************************************************************************
*
* FUNCTION:  GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff *VolOffsets)
*******************************************************************************/

tVoid ADAS_RCTASound::GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff *VolOffsets)
{
  ETG_TRACE_USR4(("ADAS_RCTASound::GetBeepVolumeOffsets()  BeepName:%d", tUBeepName));

   VolOffsets->LF       =  CHANNEL_MUTE;
   VolOffsets->RF       =  CHANNEL_MUTE;
   VolOffsets->LR       =  CHANNEL_MUTE;
   VolOffsets->RR       =  CHANNEL_MUTE;
   VolOffsets->RampLin  =   0x08;   //Very Fast Mute for UPA beeps, need to be checked
   VolOffsets->RampDB   =  0x320; //Very Fast Mute for UPA beeps, need to be checked
   VolOffsets->CE       =  CHANNEL_MUTE;
   VolOffsets->SUB      =  CHANNEL_MUTE;

   if( m_RCTA_AlertState== RCTA_ALERT_RF_LF)
  {
    VolOffsets->RF       =  0;
    //VolOffsets->CE       =  0;
    VolOffsets->LF       =  0;
  }
  else if(m_RCTA_AlertState ==RCTA_ALERT_RF)
  {
    VolOffsets->RF       =  0;
    // VolOffsets->CE       =  0;
  }
  else if(m_RCTA_AlertState==RCTA_ALERT_LF)
  {
    VolOffsets->LF       =  0;
    // VolOffsets->CE       =  0;
  }else
  {
     // Mute all streams.
   }

}
/*******************************************************************************
*
* FUNCTION:  ADAS_RCTASound::SetAdasSoundStatus(tU8 tBeepName)
*******************************************************************************/

void ADAS_RCTASound::SetAdasSoundStatus(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_RCTASound::SetAdasSoundStatus() called : tBeepName :%d",tBeepName));
  if(tBeepName ==  EN_AUDIO_BEEP_RCTA_SND)
    m_RCTASoundStatus = true;
  else
  {}
}

/*******************************************************************************
*
* FUNCTION:  ADAS_RCTASound::bIsAdasSoundActive(tU8 tBeepName)
*******************************************************************************/
bool ADAS_RCTASound::bIsAdasSoundActive(tU8 tBeepName)
{  (void)tBeepName;
  ETG_TRACE_USR4(("ADAS_RCTASound::bIsAdasSoundActive(),tBeepName :%d",tBeepName));
  return m_RCTASoundStatus;

}
/*******************************************************************************
*
* FUNCTION:  ADAS_RCTASound::vClearAdasSoundStatus(tU8 tBeepName)
*******************************************************************************/
tVoid ADAS_RCTASound::vClearAdasSoundStatus(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_RCTASound::vClearAdasSoundStatus() called"));
  if(tBeepName == EN_AUDIO_BEEP_RCTA_SND)
    m_RCTASoundStatus = false;
  else
  {}
}

/*******************************************************************************
*
* FUNCTION:  ADAS_RCTASound::vTriggerStopBeep(tU8 tBeepName)
*******************************************************************************/
tVoid ADAS_RCTASound::vTriggerStopBeep(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_RCTASound::vTriggerStopBeep(tU8 tBeepName) called : tBeepName :%d",tBeepName));
  if(!bIsRCTAConfigureAvailable())
  {
    if (bIsAdasSoundActive(EN_AUDIO_BEEP_RCTA_SND))
      m_poBeepAdasInstance->StopAdasBeep(EN_AUDIO_BEEP_RCTA_SND);
  }
  (void)tBeepName;
}
/*******************************************************************************
*
* FUNCTION:  ADAS_RCTASound::vResetRCTAData()
*******************************************************************************/
void ADAS_RCTASound::vResetRCTAData()
{    m_RCTA_AlertState=NOTDEFINED;
  m_vSetCTA_CollisionRiskAlert=NOTDEFINED;
  m_RCTASoundStatus=false;
}


/*******************************************************************************
*
* FUNCTION: ADAS_RCTASound::GetRecurrencePeriod(tU8 tBeepName)
*******************************************************************************/
tU16 ADAS_RCTASound::GetRecurrencePeriod(tU8 tBeepName)
{
  (void)tBeepName;
  return RECURRENCE_PERIOD_MAX; //
}


/*******************************************************************************
*
* FUNCTION: ADAS_RCTASound::bIsRCTAConfigureAvailable()
*******************************************************************************/

bool ADAS_RCTASound::bIsRCTAConfigureAvailable()
{
  tU8 u8RCTAConfig = RCTA_AUDIO_NOT_PRESENT;

  //read item from the KDS key's bytes- stream
  if((DP_S32_NO_ERR == DP_s32GetConfigItem("HMIConfig","CFGADASRCTA", &u8RCTAConfig, 1)))
  {
    ETG_TRACE_USR4((" CFGADASRCTA value configured in EOL: %d",u8RCTAConfig));
  }
  else
  {
    ETG_TRACE_ERR(("Error in reading EOL Parameter,returning RCTA as NOT Present "));
  }
  if(RCTA_AUDIO_NOT_PRESENT != u8RCTAConfig)
    return TRUE;

  return FALSE;
}


