/*******************************************************************************
 *
 * FILE:          ADAS_PSMSound.h
 *
 * SW-COMPONENT:  Beep Adas application
 *
 * PROJECT:
 *
 * DESCRIPTION:   ADAS PSM Sound Class.
 *
 * AUTHOR:       pmh7kor
 *
 * COPYRIGHT:    (c) 2016 RBEI, Bangalore
 *
 *******************************************************************************/

#ifndef _ADAS_PSM_H_
#define _ADAS_PSM_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "../ExternItf/CCA/aud_CCAMsg.h"
#include "AdasNotification_IF.h"
#include "MessageConfig.h"
#include "InternalCommunicationAdapter.h"
#include "Beep_Adas.h"

class ADAS_PSMSound : public IF_MessageObserver<PO_MessageConfig::enID>, public AdasNotification_IF
{
public:
  ADAS_PSMSound(void);
  ADAS_PSMSound(Beep_Adas* poAdasInstance);
  virtual ~ADAS_PSMSound();

  virtual std::string GetBeepFilePath(tU8 tUBeepName);
  virtual tS16 GetBeepVolume(tU8 tUBeepName);
  virtual tS16 GetBeepVolume_withoutCANAttenuation(tU8 tUBeepName=0);
  virtual tVoid GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff  *VolOffsets);
  //virtual tU8 GetBeepSource(tU8 tUBeepName);
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);

  tVoid vSetandTriggerPSMSound(tU8 tPSMSound);
  tVoid vSetLeftSlotSuitableDisplay(tU8 SlotDisplay);
  tVoid vSetRightSlotSuitableDisplay(tU8 SlotDisplay);
  tVoid vTriggerStopBeep(tU8 tBeepName=0);
  virtual bool bIsAdasSoundActive(tU8 tBeepName=0);
  virtual tVoid SetAdasSoundStatus(tU8 tBeepName);
  tVoid vClearAdasSoundStatus(tU8 tBeepName);
  virtual tU16 GetRecurrencePeriod(tU8 tBeepName);
  tVoid vResetPSMData();
private:

  Beep_Adas* m_poBeepAdasInstance;

  fc_audiomanager_tclService_Audio_Function *m_poAudio_Function;
    bool m_bPSMSoundStatus;
  tU8 u8SlotDisplay;
  tBool bIsPSMConfiguredAvailable();
  tBool bIsParkAssistlevelValid();


};


#endif
