/*******************************************************************************
*
* FILE:          ADAS_LDWSound.h
*
* SW-COMPONENT:  Beep Adas application
*
* PROJECT:
*
* DESCRIPTION:   ADAS HFP Sound Class.
*
* AUTHOR:       pmh7kor
*
* COPYRIGHT:    (c) 2016 RBEI, Bangalore
*
*******************************************************************************/

#ifndef _ADAS_LDW_H_
#define _ADAS_LDW_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "../ExternItf/CCA/aud_CCAMsg.h"
#include "AdasNotification_IF.h"
#include "MessageConfig.h"
#include "InternalCommunicationAdapter.h"
#include "Beep_Adas.h"

enum
{
  AUD_BEEP_TIMER_ID_ADASLDW_SETTINGSOUND = 1,
  AUD_BEEP_TIMER_ID_ADASLDW_SPATIALIZATION
};




#define  AUD_BEEP_TIMER_ADASLDW_SPATIALIZATION_INTERVAL 375


//#define AUD_BEEP_TIMER_ADASLDW_SETTINGSOUND_INTERVAL                  3000 // LDW Setting sound should be stopped after 3 secs when it is triggered

class ADAS_LDWSound : public IF_MessageObserver<PO_MessageConfig::enID>, public AdasNotification_IF
{
public:
  ADAS_LDWSound(void);
  ADAS_LDWSound(Beep_Adas* poAdasInstance);
  virtual ~ADAS_LDWSound();

  virtual std::string GetBeepFilePath(tU8 tUBeepName);
  virtual tS16 GetBeepVolume(tU8 tUBeepName);
  virtual tS16 GetBeepVolume_withoutCANAttenuation(tU8 tUBeepName=0);
  virtual tVoid GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff  *VolOffsets);
  //virtual tU8 GetBeepSource(tU8 tUBeepName);
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);

  tVoid vSetandTriggerLDWAlertSound(tU8 tHFPSound);
  tVoid vTriggerStopBeep(tU8 tBeepName=0);
  virtual bool bIsAdasSoundActive(tU8 tBeepName=0);
  virtual tVoid SetAdasSoundStatus(tU8 tBeepName);
  tVoid vClearAdasSoundStatus(tU8 tBeepName);
  virtual tU16 GetRecurrencePeriod(tU8 tBeepName);
  tVoid vResetLDWData();
private:
  static ADAS_LDWSound* _poThisInterface;
  tBool m_bLDWSettingSndTmrRunning;
  tBool m_bLDWSpatializationTmrRunning;
  Beep_Adas* m_poBeepAdasInstance;
  tBool m_bCANAttenuationStatus;
  fc_audiomanager_tclService_Audio_Function *m_poAudio_Function;
  tU8 m_u8DepartureLane;
  bool m_bLDWAlertSoundStatus;
  bool m_bLDWSettingSoundStatus;
  bool newreq;

  OSAL_tTimerHandle m_hLDWSpeakerSettingTimer;
  tU16 timercounter;

  tU16 u16maximum_to_switch;
   static tU8 u8SettingsndTimerCount;
   tVoid vInitLDWSettingSndTimer(tVoid);
   tVoid vStartLDWSettingSndTimer(tU16 uwTimerID, tU16 uwTime);
   tVoid vStopLDWSettingSndTimer(tU16 uwTimerID);

   tVoid vDeleteTimers();
  static tVoid vLDWSpatializationTimerCallback(tVoid* pArg);

  tBool bIsLDWConfiguredAvailable();
  tBool bIsLDWUserVolumeValid();
  tVoid vOnTimerExpiry();

  tVoid vUpdateLDWSettingSndVolOffset(BeepControlData::ChVolOff  *VolOffsets);
  tVoid vUpdateLDWUSerVolume();
  aud_async_call_handler*  m_asynccall;
};


#endif
