/*******************************************************************************
*
* FILE:          ADAS_LDWSound.h
*
* SW-COMPONENT:  Beep Adas application
*
* PROJECT:
*
* DESCRIPTION:   Beep Adas Class.
*
* AUTHOR:       pmh7kor
*
* COPYRIGHT:    (c) 2016 RBEI, Bangalore
*
*******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_BEEP
#include "trcGenProj/Header/ADAS_LDWSound.cpp.trc.h"
#endif
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#include "../fc_audiomanager_service_Audio_Function.h"
#include "ADAS_LDWSound.h"
#include "Beep_defines.h"
#include "../fc_audiomanager_trace.h"

#include "InternalComponentCommunication/Messages/Beep/IDCCAStartADASBeep.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CANAttenuation.h"
#include "InternalComponentCommunication/Messages/Diag/IDDiagDefSet.h"
#include "InternalComponentCommunication/Messages/Beep/ID_ADASBeepActive.h"
#include "InternalComponentCommunication/Messages/Beep/ID_NotifyLDWUserVolume.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/DiagDefSetType.h"
#include "../aud_sinkmanager/vd_adr3/vd_adr3Msg_If.h"

tU8 ADAS_LDWSound::u8SettingsndTimerCount = 0;
ADAS_LDWSound *ADAS_LDWSound::_poThisInterface = NULL;
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
ADAS_LDWSound::ADAS_LDWSound(void) : IF_MessageObserver<PO_MessageConfig::enID>("ADAS_LDWSound Constructor")
    {
  ETG_TRACE_USR2(("ADAS_LDWSound::ADAS_LDWSound() constructor called"));
  _poThisInterface = NULL;
  m_poBeepAdasInstance = NULL;
  m_poAudio_Function = NULL;
  m_hLDWSpeakerSettingTimer = OSAL_C_INVALID_HANDLE;
  vResetLDWData();
  m_asynccall = NULL;
  newreq=false;
  timercounter=0;
  u16maximum_to_switch=8;
    }
/*******************************************************************************
*
* FUNCTION: ADAS_LDWSound::ADAS_LDWSound()
*
* DESCRIPTION: Constructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
ADAS_LDWSound::ADAS_LDWSound(Beep_Adas* poAdasInstance) : IF_MessageObserver<PO_MessageConfig::enID>("ADAS_LDWSound Constructor")
    {
  ETG_TRACE_USR2(("ADAS_LDWSound::ADAS_LDWSound(Beep_Adas*) constructor called"));
  _poThisInterface = this;
  m_poBeepAdasInstance = poAdasInstance;
  m_poAudio_Function = poAdasInstance->m_poAudio_Function;
  vResetLDWData();
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAStart_ADASBeep);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_CANAttenuation);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagDefSet);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyLDWUserVolume);
  m_hLDWSpeakerSettingTimer = OSAL_C_INVALID_HANDLE;
  vInitLDWSettingSndTimer();
  m_asynccall = poAdasInstance->m_poBeepMainAppl->m_poMainAppInstance->poAsyncCall();
  newreq=false;
  timercounter=0;
  u16maximum_to_switch=8;

}
/*******************************************************************************
*
* FUNCTION: ADAS_LDWSound::~ADAS_LDWSound()
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
ADAS_LDWSound::~ADAS_LDWSound()
{
  ETG_TRACE_USR4(("~ADAS_LDWSound() entered."));
  m_poBeepAdasInstance = NULL;
  m_asynccall = NULL;
  m_poAudio_Function = NULL;
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  if (_poThisInterface != NULL)
  {
    delete _poThisInterface;
    _poThisInterface = NULL;
  }
  vStopLDWSettingSndTimer(AUD_BEEP_TIMER_ID_ADASLDW_SETTINGSOUND); // to stop timer on shut down if running and clear timer status
  vStopLDWSettingSndTimer(AUD_BEEP_TIMER_ID_ADASLDW_SPATIALIZATION);
  vDeleteTimers();
}

/*******************************************************************************
*
* FUNCTION: ADAS_HFPSound::~vResetLDWData()
* Resets the flags to defaults
*******************************************************************************/
tVoid ADAS_LDWSound::vResetLDWData()
{
  ETG_TRACE_USR4(("vResetLDWData"));
  m_bLDWAlertSoundStatus = false;
  m_bCANAttenuationStatus = FALSE;
  m_u8DepartureLane = NO_LANE_DEPARTURE;
  m_bLDWSettingSoundStatus = false;
  m_bLDWSettingSndTmrRunning = FALSE;
  m_bLDWSpatializationTmrRunning = FALSE;
}

/*******************************************************************************
*
* FUNCTION: ADAS_LDWSound::vDeleteTimers()
* Resets the flags to defaults
*******************************************************************************/
tVoid ADAS_LDWSound::vDeleteTimers()
{
  ETG_TRACE_USR4(("ADAS_LDWSound::vDeleteTimers"));


  if (m_hLDWSpeakerSettingTimer != OSAL_C_INVALID_HANDLE)
  {
    tS32 s32OsalError = OSAL_s32TimerDelete(m_hLDWSpeakerSettingTimer);

    NORMAL_M_ASSERT(s32OsalError == OSAL_OK);

    m_hLDWSpeakerSettingTimer = OSAL_C_INVALID_HANDLE;
  }
}
/********************************************************************************
* vInitLDWSettingSndTimer().
*******************************************************************************/
tVoid ADAS_LDWSound::vInitLDWSettingSndTimer(tVoid)
{
  tS32 s32OsalError = OSAL_ERROR;


  s32OsalError = OSAL_s32TimerCreate((OSAL_tpfCallback)vLDWSpatializationTimerCallback,(tPVoid)this, &m_hLDWSpeakerSettingTimer);

  if (s32OsalError == OSAL_OK){
    ETG_TRACE_USR4(("ADAS_LDWSound::Spatialization Timer created successfully."));
  }
  else
    ETG_TRACE_ERR(("ADAS_LDWSound:: Error in creating Timer"));

}




/********************************************************************************
* vStartLDWSettingSndTimer().
*******************************************************************************/
tVoid ADAS_LDWSound::vStartLDWSettingSndTimer(tU16 uwTimerID, tU16 uwTimeMs)
{
  tS32 s32RetVal = OSAL_ERROR;
  ETG_TRACE_USR4((" ADAS_LDWSound::vStartLDWSettingSndTimer uwTimerID = 0x%x, uwTimeMs = %u ", uwTimerID, uwTimeMs));
  if (uwTimerID == AUD_BEEP_TIMER_ID_ADASLDW_SPATIALIZATION)
  {
    s32RetVal = OSAL_s32TimerSetTime(m_hLDWSpeakerSettingTimer, (tU32)uwTimeMs, 0);

    if (s32RetVal == OSAL_OK)
    {
      ETG_TRACE_USR4((" ADAS_LDWSound:: Spatialization Timer started successfully,s32RetVal = 0x%x", s32RetVal));
      m_bLDWSpatializationTmrRunning  = TRUE;

    }
    else
      ETG_TRACE_ERR(("ADAS_LDWSound:: Error in Starting Timer"));
  }
  else
  {
    //do nothing
  }
}
/********************************************************************************
* vStopLDWSettingSndTimer().
*******************************************************************************/
tVoid ADAS_LDWSound::vStopLDWSettingSndTimer(tU16 uwTimerID)
{
  tS32 s32RetVal = OSAL_ERROR;
  ETG_TRACE_USR4((" ADAS_LDWSound::vStopLDWSettingSndTimer uwTimerID = 0x%x ", uwTimerID));

  if (uwTimerID == AUD_BEEP_TIMER_ID_ADASLDW_SPATIALIZATION)
  {
    s32RetVal = OSAL_s32TimerSetTime(m_hLDWSpeakerSettingTimer, 0, 0);
    if (s32RetVal == OSAL_OK)
    {
      m_bLDWSpatializationTmrRunning = FALSE;
      ETG_TRACE_USR4(("ADAS_LDWSound:: Spatialization Timer Stopped Successfully, s32RetVal = 0x%x", s32RetVal));
    }
  }
  else
    ETG_TRACE_ERR(("ADAS_LDWSound::Invalid Timer ID to Stop"));
}



/********************************************************************************
 * vLDWSpatializationTimerCallback( )
 *******************************************************************************/
tVoid ADAS_LDWSound::vLDWSpatializationTimerCallback(tVoid* pArg){
  ((ADAS_LDWSound*)pArg)->m_bLDWSpatializationTmrRunning = FALSE;
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_poThisInterface);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_poThisInterface->m_asynccall);

  ETG_TRACE_USR2(("ADAS_LDWSound::vLDWSpatializationTimerCallback Timer expired 350 ms "));
  _poThisInterface->m_asynccall->vCall<ADAS_LDWSound>(_poThisInterface, &ADAS_LDWSound::vOnTimerExpiry);
}
/*******************************************************************************
*
* FUNCTION: ADAS_LDWSound::GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff *VolOffsets)
*
* DESCRIPTION: Interface function to get volume offsets for Beep
*
* PARAMETER: tU8 tUBeepName
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid ADAS_LDWSound::GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff *VolOffsets)
{
  ETG_TRACE_USR4(("ADAS_LDWSound::GetBeepVolumeOffsets()  BeepName:%d", tUBeepName));

  VolOffsets->LF = CHANNEL_MUTE;
  VolOffsets->RF = CHANNEL_MUTE;
  if (tUBeepName == EN_AUDIO_BEEP_LDW_SOUND_ALERT)
  {
    switch (m_u8DepartureLane)
    {
    case LANE_DEPARTURE_ON_LEFT:
      VolOffsets->LF = 0;
      break;
    case LANE_DEPARTURE_ON_RIGHT:
      VolOffsets->RF = 0;
      break;
    default:
      break;
    }
  }
  else
  {
    vUpdateLDWSettingSndVolOffset(VolOffsets);
  }
  // to do change to update offset based on lane departure. if left, to be played on left, if right, to be played on right
  VolOffsets->LR = CHANNEL_MUTE;
  VolOffsets->RR = CHANNEL_MUTE;
  VolOffsets->RampLin = 0x08;   //Very Fast Mute for UPA beeps, need to be checked
  VolOffsets->RampDB = 0x320; //Very Fast Mute for UPA beeps, need to be checked


  VolOffsets->CE = CHANNEL_MUTE;
  VolOffsets->SUB = CHANNEL_MUTE;
}

/*******************************************************************************
*
* FUNCTION: ADAS_LDWSound::vUpdateLDWSettingSndVolOffset(BeepControlData::ChVolOff *VolOffsets)
*
* DESCRIPTION: Interface function to alternatively mute the Left and Right speakers
*
* PARAMETER: BeepControlData::ChVolOff *VolOffsets
*
* RETURNVALUE: tVoid
*
*******************************************************************************/

tVoid ADAS_LDWSound::vUpdateLDWSettingSndVolOffset(BeepControlData::ChVolOff  *VolOffsets)
{
  ETG_TRACE_USR4(("ADAS_LDWSound::vUpdateLDWSettingSndVolOffset(), u8SettingsndTimerCount : %d", u8SettingsndTimerCount));

  {
    if (u8SettingsndTimerCount % 2 == 0)
      VolOffsets->LF = 0;
    else
      VolOffsets->RF = 0;
  }
}

/*******************************************************************************
*
* FUNCTION: ADAS_LDWSound::vSetandTriggerLDWAlertSound(tU8 tUPAErrorSound)
*******************************************************************************/

void ADAS_LDWSound::vSetandTriggerLDWAlertSound(tU8 tLDWSound)
{
  tBool Ret = (bIsLDWConfiguredAvailable() && bIsLDWUserVolumeValid());
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  if (Ret)
  {
    ETG_TRACE_USR4(("ADAS_LDWSound::vSetandTriggerLDWAlertSound() called "));
    if ((tLDWSound == LANE_DEPARTURE_ON_RIGHT) || (tLDWSound == LANE_DEPARTURE_ON_LEFT))
    {
      m_u8DepartureLane = tLDWSound;
      m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_LDW_SOUND_ALERT, this);
    }
  }
  else
    ETG_TRACE_USR4(("ADAS_LDWSound:: Cannot trigger LDW Alert Sound"));
}


/*******************************************************************************
*
* FUNCTION: ADAS_LDWSound::GetRecurrencePeriod()
*******************************************************************************/
tU16 ADAS_LDWSound::GetRecurrencePeriod(tU8 /*tBeepName*/)
{
  return RECURRENCE_PERIOD_MAX; // will not be used for HFP
}

/*******************************************************************************
*
* FUNCTION:  ADAS_LDWSound::GetBeepFilePath(tU8 tUBeepName)

*******************************************************************************/
std::string ADAS_LDWSound::GetBeepFilePath(tU8 /*tUBeepName*/)
{
  std::string sfileName = "LDW_V4_sq14p5Hz_LPF400_800_483ms.wav";
  return sfileName;
}

/*******************************************************************************
*
* FUNCTION:  ADAS_LDWSound::GetBeepVolume(tU8 tUBeepName)

*******************************************************************************/

tS16 ADAS_LDWSound::GetBeepVolume(tU8 /*tUBeepName*/)
{
  tS16 VolumeDB;
  ETG_TRACE_USR4(("ADAS_LDWSound::GetBeepVolume"));
  AUD_POINTER_CHECK_CALL(m_poBeepAdasInstance);
  if (m_bCANAttenuationStatus == TRUE)
  {
    //sending the cluster sound value by which beep has to be played
    VolumeDB = tS16((tS16)VOLOFFSET_RESOLUTION * m_poBeepAdasInstance->s16GetDBValue(m_poBeepAdasInstance->GetClusterSoundLvlForAttenuation()));
  }
  else
  {
    VolumeDB=GetBeepVolume_withoutCANAttenuation();
  }
  return VolumeDB;
}

/*******************************************************************************
*
* FUNCTION:  ADAS_LDWSound::GetBeepVolume(tU8 tUBeepName)

*******************************************************************************/
//function to return volume level with out without clusterVolume level
tS16 ADAS_LDWSound::GetBeepVolume_withoutCANAttenuation(tU8 tUBeepName)
{
  tS16 VolumeDB;
  ETG_TRACE_USR4(("ADAS_LDWSound::GetBeepVolume"));
  AUD_POINTER_CHECK_CALL(m_poBeepAdasInstance);
  tS16 ts16LDWEOLLevelOffset;


    tS16 s16LDWObsoluteLevelOffset = -23 * VOLOFFSET_RESOLUTION; //base offset level
    tU8 u8LDWEOLLevelOffset = 0; //EOL Offset Level

    if ((DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig", "LateralADASLDWGain", &u8LDWEOLLevelOffset, 1))) // to be checked since no SR gain configuration available in soundvolumeconfig
    {
      ETG_TRACE_USR4((" ADAS_LDW_EOL Offset level: %d", u8LDWEOLLevelOffset));
    }
    else
    {
      ETG_TRACE_ERR(("Error in reading EOL Parameter"));
    }
    //LateralADASLDWGain is a 5-bit value in CANoe (MSB bits of Byte6) CANOe->Tools->CANDelaStudio, so converting it to 8-bit value and shifting it by 3 bits to check if 5th bit is set or not for sign
    if ((u8LDWEOLLevelOffset << 3) & (0x80))
    {
      ts16LDWEOLLevelOffset =tS16(((tS16)u8LDWEOLLevelOffset + 0xFFE0) * (tS16)VOLOFFSET_RESOLUTION);
    }
    else
      ts16LDWEOLLevelOffset =tS16 ((tS16)(u8LDWEOLLevelOffset)* (tS16)VOLOFFSET_RESOLUTION);


    ETG_TRACE_USR4((" ADAS_LDW EOL offset : %x", ts16LDWEOLLevelOffset));
    tU8 LDWUserVol = (tU8)midw_fi_tcl_e8_ADAS_LDW_UserVolume::FI_EN_ADAS_LDW_USR_VOL_LEVEL_INVALID;
    dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi odpLDWUserVol;
    odpLDWUserVol.s32GetData(LDWUserVol);

    tS16 ts16SoundlevelStateV2Offset = m_poBeepAdasInstance->s16GetAdasVolumeOffset(LDWUserVol);
    VolumeDB = tS16(ts16LDWEOLLevelOffset + s16LDWObsoluteLevelOffset + ts16SoundlevelStateV2Offset);

  (void)tUBeepName;
  return VolumeDB;

}


/*******************************************************************************
*
* FUNCTION: ADAS_LDWSound::bIsLDWConfiguredAvailable()
*******************************************************************************/

tBool ADAS_LDWSound::bIsLDWConfiguredAvailable()
{
  tU8 u8LDWConfig = LDW_NOT_PRESENT;

  //read item from the KDS key's bytes- stream
  if ((DP_S32_NO_ERR == DP_s32GetConfigItem("HMIConfig", "ADASLDW", &u8LDWConfig, 1)))
  {
    ETG_TRACE_USR4((" ADAS LDW value configured in EOL: %d", u8LDWConfig));
  }
  else
  {
    ETG_TRACE_ERR(("Error in reading EOL Parameter,returning LDW Config as NOT Present "));
  }
  if (LDW_NOT_PRESENT != u8LDWConfig)
    return TRUE;

  return FALSE;
}

/*******************************************************************************
*
* FUNCTION:  ADAS_LDWSound::bIsLDWUserVolumeValid()

*******************************************************************************/

tBool ADAS_LDWSound::bIsLDWUserVolumeValid()
{
  tU8 LDWUserVol = (tU8)midw_fi_tcl_e8_ADAS_LDW_UserVolume::FI_EN_ADAS_LDW_USR_VOL_LEVEL_INVALID;
  dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi odpLDWUserVol;
  odpLDWUserVol.s32GetData(LDWUserVol);

  if ((LDWUserVol > VOLUME_LEVEL_0) && (LDWUserVol <= VOLUME_LEVEL_5))
    return true;
  return false;
}

/*******************************************************************************
*
* FUNCTION:  ADAS_LDWSound::vTriggerStopBeep()

*******************************************************************************/

tVoid ADAS_LDWSound::vTriggerStopBeep(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_LDWSound::vTriggerStopBeep()"));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  if (bIsAdasSoundActive(tBeepName))
    m_poBeepAdasInstance->StopAdasBeep(tBeepName);
}

/*******************************************************************************
*
* FUNCTION:  ADAS_LDWSound::vClearAdasSoundStatus()

*******************************************************************************/
tVoid ADAS_LDWSound::vClearAdasSoundStatus(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_LDWSound::vClearAdasSoundStatus() called"));
  switch(tBeepName)
  {
  case EN_AUDIO_BEEP_UPA_ERROR_SND:
    if (m_bLDWAlertSoundStatus)
      m_bLDWAlertSoundStatus = false;
    break;
  case EN_AUDIO_BEEP_LDW_SETTING_SND:
    if (m_bLDWSettingSoundStatus)
    {
      m_bLDWSettingSoundStatus = false;
      vStopLDWSettingSndTimer(AUD_BEEP_TIMER_ID_ADASLDW_SETTINGSOUND); // to stop timer on shut down if running and clear timer status
      vStopLDWSettingSndTimer(AUD_BEEP_TIMER_ID_ADASLDW_SPATIALIZATION);

      //reset all counters.
      u8SettingsndTimerCount=0;
      timercounter=0;
      u16maximum_to_switch=0;


    }
    break;
  default:
    break;
  }
}

/*******************************************************************************
*
* FUNCTION:  ADAS_LDWSound::bIsAdasSoundActive()

*******************************************************************************/

bool ADAS_LDWSound::bIsAdasSoundActive(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_LDWSound::bIsAdasSoundActive() : %d",tBeepName));
  return ((tBeepName == EN_AUDIO_BEEP_LDW_SOUND_ALERT)?m_bLDWAlertSoundStatus:((tBeepName == EN_AUDIO_BEEP_LDW_SETTING_SND)?m_bLDWSettingSoundStatus:(m_bLDWAlertSoundStatus||m_bLDWSettingSoundStatus)));
}

/*******************************************************************************
*
* FUNCTION:  ADAS_LDWSound::SetAdasSoundStatus()

*******************************************************************************/
void ADAS_LDWSound::SetAdasSoundStatus(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_LDWSound::SetAdasSoundStatus() called"));
  if (tBeepName == EN_AUDIO_BEEP_LDW_SOUND_ALERT)
    m_bLDWAlertSoundStatus = true;
  else if (tBeepName == EN_AUDIO_BEEP_LDW_SETTING_SND)
  {
    m_bLDWSettingSoundStatus = true;
    // Initialise counter.
    u16maximum_to_switch =8;
    timercounter=0;
    vStartLDWSettingSndTimer(AUD_BEEP_TIMER_ID_ADASLDW_SPATIALIZATION, AUD_BEEP_TIMER_ADASLDW_SPATIALIZATION_INTERVAL);
  }
  else
  {

  }

}

/*******************************************************************************
*
* FUNCTION: ADAS_LDWSound::MessageNotification(PO_MessageConfig::enID MsgId)
*******************************************************************************/

// This function is called by post office on new incoming messages.
void ADAS_LDWSound::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR2(("ADAS_LDWSound::MessageNotification() called MsgId = %d", MsgId));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance->m_poBeepController);
  switch (MsgId)
  {
  case (PO_MessageConfig::ID_CCAStart_ADASBeep) :
  {
    ETG_TRACE_USR2(("ID_CCAStart_ADASBeep received"));
    const ID_CCAStart_ADASBeep* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_CCAStart_ADASBeep>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);

    if(!bIsLDWConfiguredAvailable())
    {
      ETG_TRACE_USR2((" LDW not configured, Not triggering LDW Setting Sound"));
      break;
    }
    if ((pMsg->m_u8BeepType == EN_AUDIO_BEEP_LDW_SOUND_ALERT) || (pMsg->m_u8BeepType == EN_AUDIO_BEEP_LDW_SETTING_SND))
      m_poBeepAdasInstance->setAdasBeep(pMsg->m_u8BeepType, this);

    if ((pMsg->m_u8BeepType == EN_AUDIO_BEEP_STOP_ADAS_SETTING_SND) && m_bLDWSettingSoundStatus) // when stop setting sound is received and setting sound is running, beep priorities will stop immediately
    {
      m_poBeepAdasInstance->setAdasBeep(pMsg->m_u8BeepType, this);
      vClearAdasSoundStatus(EN_AUDIO_BEEP_LDW_SETTING_SND);
    }
    break;
  }
  case (PO_MessageConfig::ID_CANAttenuation) :
  {
    const ID_CANAttenuation* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_CANAttenuation>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
    ETG_TRACE_USR2(("ID_CANAttenuation received : %d", pMsg->m_bAttenuationCommand));
    m_bCANAttenuationStatus = pMsg->m_bAttenuationCommand;
    if (bIsAdasSoundActive())
      m_poBeepAdasInstance->m_poBeepController->UpdateBeepVolume();
    break;
  }
  case PO_MessageConfig::ID_DiagDefSet:
  {
    // Obtaining the Diag DefSet
    const ID_DiagDefSet* pMsgDefSet = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_DiagDefSet>(MsgId);
    ETG_TRACE_USR4(("ID_DiagDefSet received Type = %x, Phase =%x", pMsgDefSet->enDiagDefSetType, pMsgDefSet->enDiagDefSetPhase));
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsgDefSet);
    tenDiagDefSetType enDefSetType = pMsgDefSet->enDiagDefSetType;
    tenDiagDefSetPhase enDefSetPhase = pMsgDefSet->enDiagDefSetPhase;
    if (((enDefSetType == EN_DEFSET_HMI) || (enDefSetType == EN_DEFSET_TEF)) && (enDefSetPhase == EN_DEFSET_FINISH))
    {
      if (!bIsLDWConfiguredAvailable())
        vTriggerStopBeep();
      vUpdateLDWUSerVolume();
    }
    break;
  }
  case (PO_MessageConfig::ID_NotifyLDWUserVolume) :
  {
    const ID_NotifyLDWUserVolume* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_NotifyLDWUserVolume>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
    ETG_TRACE_USR2(("ID_NotifyLDWUserVolume received : %d", pMsg->m_volume));

   dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi odpLDWUserVol;
   tS32 s32Res = 0;
     s32Res = odpLDWUserVol.s32SetData( pMsg->m_volume);
     ETG_TRACE_USR4(("Persistent Memory storage Result for odpLDWUserVol = %x", s32Res));


  if(pMsg->m_volume == VOLUME_LEVEL_0)
  {   m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_LDW_TEMP_MUTE,/*_poThisInterface*/this); //if any LDW volume dependant beeps are in Queue.
     if (bIsAdasSoundActive())
     {
       vTriggerStopBeep();
     }
  }
  else
 {
    if (bIsAdasSoundActive())
    {
           tU8 BeepName=0;  //fix compilerwarning
           ID_ADASBeepActive oAdasBeepActive(TRUE,EN_ADAS_BEEPTYPE_UPA,(GetBeepVolume_withoutCANAttenuation(BeepName))/4); // Posting PO message to enable attenuation of main stream
           InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oAdasBeepActive);
      }
 }




    if (bIsAdasSoundActive()) //updating the volume if any LDW beep is active
    {
      m_poBeepAdasInstance->m_poBeepController->UpdateBeepVolume();
      if (m_bLDWSettingSoundStatus) //restarting 3sec timer on LDW UserVolume change
      {
        ETG_TRACE_USR2(("ADAS_LDWSound::MessageNotification ID_NotifyLDWUserVolume increasing play time timercounter : %d ",timercounter ));

        /* If new request comes in first half of 750 ms when beep is playing, extra time is not added.
         * else extra cycle is added.
         *
         */
                newreq =true;
        if(timercounter!=0)
        { if(timercounter %2 == 0 )
        {
          u16maximum_to_switch  = 7;// (timercounter)+ u16maximum_to_switch;
          timercounter =0;
        }
        else{
          u16maximum_to_switch  = 8 ;//u16maximum_to_switch + timercounter+1;
          timercounter =1;
        }
        ETG_TRACE_USR2(("ADAS_LDWSound::MessageNotification ID_NotifyLDWUserVolume increasing play time  u16maximum_to_switch : %d ",u16maximum_to_switch ));

        }
      }
    }
    break;
    }
  default:
    break;
  }
}

/*******************************************************************************
*
* FUNCTION: ADAS_LDWSound::vOnTimerExpiry()
*******************************************************************************/
tVoid ADAS_LDWSound::vOnTimerExpiry()
{
  ETG_TRACE_USR4(("ADAS_LDWSound::vOnTimerExpiry()"));
  if (m_bLDWSettingSoundStatus)
  {


    ETG_TRACE_USR2(("ADAS_LDWSound::vOnTimerExpiry() timercounter : %d ",timercounter ));
    ETG_TRACE_USR2(("ADAS_LDWSound::vOnTimerExpiry()   : %d ",u16maximum_to_switch ));

    /* timercounter increments after every 375 ms , Incase where the volume is upated when setting soud is playing , it shoud further play for 3 more seconds from where it started.
     * And also to handle case where HMI sends multiple requests (HMI issue).
     *
     */
    timercounter++;

    if (u16maximum_to_switch ==timercounter)
    {    // Completed playing time of 3 sec from the last update and stopping beep.
      u16maximum_to_switch=8;
      timercounter=0;
      ETG_TRACE_USR2(("ADAS_LDWSound::vOnTimerExpiry()  u16maximum_to_switch ==0 : %d ",u16maximum_to_switch ));
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_poThisInterface);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_poThisInterface->m_asynccall);
      _poThisInterface->m_asynccall->vCall<ADAS_LDWSound,tU8>(_poThisInterface, &ADAS_LDWSound::vTriggerStopBeep,EN_AUDIO_BEEP_LDW_SETTING_SND);
      return;

    }

    // to change speaker offset afer every 750 ms

    if(timercounter %2==0)
    {
      ETG_TRACE_USR2(("ADAS_LDWSound::vOnTimerExpiry() timercounter mod 2==0: %d ",timercounter ));
      u8SettingsndTimerCount =tU8(u8SettingsndTimerCount + 1); //used to toggle the speakers
      ETG_TRACE_USR4(("ADAS_LDWSound::vOnTimerExpiry() u8SettingsndTimerCount : %d", u8SettingsndTimerCount));
      m_poBeepAdasInstance->m_poBeepController->SetBeepLocation();
    }

    /* newreq is flag set when  there is a new ldw user volume.
     *
     */
    if(newreq)
    {
      if(timercounter %2!=0)
      {
        timercounter=1;
        u16maximum_to_switch=8;
      }else
      {
        timercounter=0;
      }
      newreq=false;
    }

    ETG_TRACE_USR2(("ADAS_LDWSound::vOnTimerExpiry() New timer started with 375 ms %d ",timercounter ));
    vStartLDWSettingSndTimer(AUD_BEEP_TIMER_ID_ADASLDW_SPATIALIZATION, AUD_BEEP_TIMER_ADASLDW_SPATIALIZATION_INTERVAL);


  }

}


/*
 *
 *^^^^^^Logic to switch ldw sound alteratingly:^^^^^^^^^^^
 * The sound is to be played alternatingly in front speakers, and for every new request timer of 3 seconds to be restarted.
 * 3 seconds is divided to 8 slots of 375 ms.
 * If the new request comes within 375ms the cycle is considered. which means 7  more slots to be played.
 * If the new request comes after 375ms , fresh  8 slots to be considered.
 *
 *
 */


/*******************************************************************************
*
* FUNCTION: ADAS_LDWSound::vUpdateLDWUSerVolume()
*******************************************************************************/
tVoid ADAS_LDWSound::vUpdateLDWUSerVolume()
{
  ETG_TRACE_USR4(("ADAS_LDWSound::vUpdateLDWUSerVolume() called"));
  tU8 LDWUserVol = (tU8)midw_fi_tcl_e8_ADAS_LDW_UserVolume::FI_EN_ADAS_LDW_USR_VOL_LEVEL_INVALID;
  if ((DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig", "LateralADASLDWDefaultUserVolume", &LDWUserVol, 1)))
  {
    ETG_TRACE_USR4((" Default LDW User Volume in EOL: %d", LDWUserVol));
    tS32 s32Res = 0;
    dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi odpLDWUserVol;
    s32Res = odpLDWUserVol.s32SetData(LDWUserVol);
    ETG_TRACE_USR4((" s32Res: %d", s32Res));
  }
  else
  {
    ETG_TRACE_ERR(("Error in reading LDW User Volume from EOL, so reading from datapool"));
  }
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poAudio_Function);
  if (m_poAudio_Function->updateClients(MIDW_MASCFFI_C_U16_ADAS_LDW_USERVOLUME) != AIL_EN_N_NO_ERROR)
  {
    ETG_TRACE_ERR(("Defset done, Updating clients about ADAS_LDWUserVOLUME status"));
  }
}

