/*
 * aud_gio_dbus_handler.h
 *
 *  Created on: Apr 5, 2016
 *      Author: rjk2kor
 */

#ifndef AUD_GIO_DBUS_HANDLER_H_
#define AUD_GIO_DBUS_HANDLER_H_

#include <gio/gio.h>
#include <pthread.h>

class aud_gio_dbus_audproc_proxy;
class aud_gio_dbus_ecnr_proxy;
class aud_gio_dbus_bus_watcher;
class fc_audiomanager_tclApp;
/**
* Wrapper class that takes care of initialization of bus name watcher and the proxy objects
*/
class aud_gio_dbus_handler
{
private:
  aud_gio_dbus_bus_watcher*  m_pWatcher;//Pointer to watcher object
  aud_gio_dbus_audproc_proxy* m_audproc_pProxy;//Pointer to Audio process proxy object
  aud_gio_dbus_ecnr_proxy*  m_audEcnr_pProxy;//Pointer to ecnr process proxy object
  GMainLoop*          m_poLoop;//Pointer to g-mainloop
  pthread_t          m_threadid;
  fc_audiomanager_tclApp* m_poMainApplInstance;
public:
  aud_gio_dbus_handler(fc_audiomanager_tclApp* poMainAppl);
  ~aud_gio_dbus_handler();
  /**
  Helper function to initialize
  */
  bool bInit();
  /**
  * Helper function to deinitialize
  */
  void vDeInit();
  /**
  * pthread entry function
  */
  static void* pThreadEntry(void* pvarg);
  /**
  * Helper function to get audio process proxy
  */
  aud_gio_dbus_audproc_proxy* poGetAudioProcProxy()
  {
    return m_audproc_pProxy;
  }
};

#endif /* AUD_GIO_DBUS_HANDLER_H_ */


