/*
 * aud_gio_dbus_handler.cpp
 *
 *  Created on: Apr 5, 2016
 *      Author: rjk2kor
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#include "aud_gio_dbus_handler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUDIOMANAGER_AUDPROCPROXY
#include "trcGenProj/Header/aud_gio_dbus_handler.cpp.trc.h"
#endif
#include "../fc_audiomanager_main.h"

#include "aud_gio_dbus_bus_watcher.h"
#include "aud_gio_dbus_audproc_proxy.h"
#include "aud_gio_dbus_ecnr_proxy.h"
using namespace std;

/**
* Default constructor
*/
aud_gio_dbus_handler::aud_gio_dbus_handler(fc_audiomanager_tclApp* poMainAppl)
:m_pWatcher(NULL)
,m_audproc_pProxy(NULL)
,m_audEcnr_pProxy(NULL)
,m_poLoop(NULL)
,m_threadid(0)
{
  m_poMainApplInstance = poMainAppl;
  ETG_TRACE_USR4(("aud_gio_dbus_handler, Constructor."));
}

/**
* Destructor
*/
aud_gio_dbus_handler::~aud_gio_dbus_handler()
{
  vDeInit();
}
/**
* Helper function to initialize
*/
bool aud_gio_dbus_handler::bInit()
{
  ETG_TRACE_USR4(("aud_gio_dbus_handler::bInit Invoked "));

  //Create a bus watcher object
  if(m_pWatcher == NULL)
  {
    m_pWatcher = new aud_gio_dbus_bus_watcher(G_BUS_TYPE_SYSTEM);
    if(!m_pWatcher)
    {
      ETG_TRACE_ERR(("aud_gio_dbus_handler::bInit OUT OF MEMORY "));
      return false;
    }
  }
  if(m_audproc_pProxy == NULL)
  {
    m_audproc_pProxy = new aud_gio_dbus_audproc_proxy(m_pWatcher,G_BUS_TYPE_SYSTEM);
    if(!m_audproc_pProxy)
    {
      ETG_TRACE_ERR(("aud_gio_dbus_handler::bInit OUT OF MEMORY "));
      return false;
    }
  }

  if (m_audEcnr_pProxy == NULL)
  {
    m_audEcnr_pProxy = new aud_gio_dbus_ecnr_proxy(m_pWatcher, m_poMainApplInstance,G_BUS_TYPE_SYSTEM);
    if (!m_audEcnr_pProxy)
    {
      ETG_TRACE_ERR(("aud_gio_dbus_handler::bInit OUT OF MEMORY "));
      return false;
    }
  }

  if(m_poLoop == NULL)
  {
    m_poLoop = g_main_loop_new(NULL,FALSE);
    if(!m_poLoop)
    {
      ETG_TRACE_ERR(("aud_gio_dbus_handler::bInit OUT OF MEMORY "));
      return false;
    }
  }
  if(m_threadid == 0)
  {
    if(0 == pthread_create(&m_threadid,NULL,aud_gio_dbus_handler::pThreadEntry,this))
    {
      //Thread created successfully
    }
    else
    {
      //Failed to create thread
      ETG_TRACE_ERR(("aud_gio_dbus_handler::bInit FAILED TO CREATE THREAD ! ! ! "));
      m_threadid = 0;
      return false;
    }
  }

  return true;
}

/**
* Helper function to deinitilaize
*/
void aud_gio_dbus_handler::vDeInit()
{
  ETG_TRACE_USR4(("aud_gio_dbus_handler::vDeInit Invoked "));
  //Stop Mainloop First
  if(m_poLoop)
  {
    ETG_TRACE_USR4(("aud_gio_dbus_handler::vDeInit Deinitializing main loop "));
    g_main_loop_quit(m_poLoop);//Stop mainloop
    //Wait for mainloop to stop completely using thread join
    if(m_threadid)
    {
      ETG_TRACE_USR4(("aud_gio_dbus_handler::vDeInit, Waiting for Thread Join "));
      pthread_join(m_threadid,NULL);
      ETG_TRACE_USR4(("aud_gio_dbus_handler::vDeInit, Thread Joined "));
      m_threadid = 0;
    }
    g_main_loop_unref(m_poLoop);//Release reference
    m_poLoop = NULL;
  }
  //Delete Proxy
  if(m_audproc_pProxy)
  {
    ETG_TRACE_USR4(("aud_gio_dbus_handler::vDeInit Deleting audio process Proxy "));
    delete m_audproc_pProxy;
    m_audproc_pProxy = NULL;
  }

  if (m_audEcnr_pProxy)
  {
    ETG_TRACE_USR4(("aud_gio_dbus_handler::vDeInit Deleting ecnr Proxy "));
    delete m_audEcnr_pProxy;
    m_audEcnr_pProxy = NULL;
  }
  //Delete Bus watcher
  if(m_pWatcher)
  {
    ETG_TRACE_USR4(("aud_gio_dbus_handler::vDeInit Deleting Bus Watcher "));
    delete m_pWatcher;
    m_pWatcher = NULL;
  }

  if (m_poMainApplInstance)
  {
    delete m_poMainApplInstance;
    m_poMainApplInstance = NULL;
  }
}
/**
* Thread entry function
*/
void* aud_gio_dbus_handler::pThreadEntry(void* pvarg)
{
  ETG_TRACE_USR4(("aud_gio_dbus_handler::pThreadEntry Worker Thread Started "));
  if(!pvarg)
    return NULL;
  aud_gio_dbus_handler* self = (aud_gio_dbus_handler*)pvarg;
  if(self->m_poLoop)
  {
    g_main_loop_run(self->m_poLoop);
  }
  ETG_TRACE_USR4(("aud_gio_dbus_handler::pThreadEntry Worker Thread Stopped "));
  return NULL;
}

